/*
 * $Id:DefaultRendererElementEditorRuntime.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.mandelbrot.swing.extensions.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

import net.sf.jame.core.swing.palette.PaletteField;
import net.sf.jame.core.swing.palette.PaletteFieldModel;
import net.sf.jame.core.swing.util.GUIFactory;
import net.sf.jame.core.tree.NodeEditor;
import net.sf.jame.core.util.Palette;
import net.sf.jame.mandelbrot.common.RenderedPaletteElementNodeValue;
import net.sf.jame.mandelbrot.swing.extensions.MandelbrotSwingExtensionResources;
import net.sf.jame.mandelbrot.swing.palette.DefaultRenderedPaletteModel;
import net.sf.jame.mandelbrot.swing.palette.RenderedPaletteEditor;
import net.sf.jame.mandelbrot.util.RenderedPalette;
import net.sf.jame.twister.swing.NodeEditorComponent;
import net.sf.jame.twister.swing.editor.extension.EditorExtensionRuntime;

/**
 * @author Andrea Medeghini
 */
public class DefaultRendererElementEditorRuntime extends EditorExtensionRuntime {
	/**
	 * @see net.sf.jame.twister.swing.editor.extension.EditorExtensionRuntime#createEditor(net.sf.jame.core.tree.NodeEditor)
	 */
	@Override
	public NodeEditorComponent createEditor(final NodeEditor nodeEditor) {
		return new EditorComponent(nodeEditor);
	}

	private class EditorComponent extends JPanel implements NodeEditorComponent {
		private static final long serialVersionUID = 1L;
		private final NodeEditor nodeEditor;
		private final PaletteField field;

		/**
		 * @param nodeEditor
		 */
		public EditorComponent(final NodeEditor nodeEditor) {
			this.nodeEditor = nodeEditor;
			setLayout(new FlowLayout(FlowLayout.CENTER));
			final PaletteFieldModel model = new DefaultRenderedPaletteModel(((RenderedPaletteElementNodeValue) nodeEditor.getNodeValue()).getValue());
			field = new PaletteField(model);
			field.setBorder(BorderFactory.createLineBorder(Color.BLACK));
			final Dimension size = new Dimension(200, 40);
			field.setMinimumSize(size);
			field.setMaximumSize(size);
			field.setPreferredSize(size);
			field.addMouseListener(new FieldMouseListener(field, nodeEditor));
			add(GUIFactory.createLabel(nodeEditor.getNodeLabel(), SwingConstants.CENTER));
			this.add(field);
			if (nodeEditor.isNodeEditable()) {
				final JButton button = GUIFactory.createButton(new EditActon(field, nodeEditor), MandelbrotSwingExtensionResources.getInstance().getString("tooltip.editPalette"));
				this.add(button);
			}
		}

		private class FieldMouseListener extends MouseAdapter {
			private final PaletteField field;
			private final NodeEditor nodeEditor;

			public FieldMouseListener(final PaletteField field, final NodeEditor nodeEditor) {
				this.field = field;
				this.nodeEditor = nodeEditor;
			}

			@Override
			public void mouseClicked(final MouseEvent e) {
				final Palette palette = RenderedPaletteEditor.showRenderedPaletteEditor(field, nodeEditor.getNodeLabel(), (RenderedPalette) field.getPalette());
				if (palette != null) {
					field.getModel().setPalette(palette, false);
					nodeEditor.setNodeValue(new RenderedPaletteElementNodeValue((RenderedPalette) palette));
				}
			}
		}

		/**
		 * @see net.sf.jame.twister.swing.NodeEditorComponent#getComponent()
		 */
		public JComponent getComponent() {
			return this;
		}

		/**
		 * @see net.sf.jame.twister.swing.NodeEditorComponent#reloadValue()
		 */
		public void reloadValue() {
			if (nodeEditor.getNodeValue() != null) {
				field.getModel().setPalette(((RenderedPaletteElementNodeValue) nodeEditor.getNodeValue()).getValue(), false);
			}
		}
	}

	private class EditActon extends AbstractAction {
		private static final long serialVersionUID = 1L;
		private final PaletteField field;
		private final NodeEditor nodeEditor;

		/**
		 * @param field
		 * @param nodeEditor
		 */
		public EditActon(final PaletteField field, final NodeEditor nodeEditor) {
			super(MandelbrotSwingExtensionResources.getInstance().getString("action.edit"));
			this.field = field;
			this.nodeEditor = nodeEditor;
		}

		public void actionPerformed(final ActionEvent e) {
			final Palette palette = RenderedPaletteEditor.showRenderedPaletteEditor(field, nodeEditor.getNodeLabel(), (RenderedPalette) field.getPalette());
			if (palette != null) {
				field.getModel().setPalette(palette, false);
				nodeEditor.setNodeValue(new RenderedPaletteElementNodeValue((RenderedPalette) palette));
			}
		}
	}
}
