/*
 * $Id:ColorRendererConfigElementNode.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.mandelbrot.color;

import java.io.Serializable;

import net.sf.jame.core.extension.ConfigurableExtensionReference;
import net.sf.jame.core.tree.Node;
import net.sf.jame.core.tree.NodeEditor;
import net.sf.jame.core.tree.NodeValue;
import net.sf.jame.mandelbrot.MandelbrotResources;
import net.sf.jame.mandelbrot.color.extension.ColorRendererExtensionConfig;
import net.sf.jame.mandelbrot.color.formula.ColorRendererFormulaConfigElement;
import net.sf.jame.mandelbrot.color.formula.ColorRendererFormulaConfigElementNodeValue;
import net.sf.jame.twister.util.ConfigElementNode;
import net.sf.jame.twister.util.ConfigurableExtensionReferenceNode;

/**
 * @author Andrea Medeghini
 */
public class ColorRendererConfigElementNode extends ConfigElementNode<ColorRendererConfigElement> {
	public static final String NODE_ID = ColorRendererConfigElement.CLASS_ID;
	public static final String NODE_CLASS = "node.class.ColorRendererElement";
	private static final String NODE_LABEL = MandelbrotResources.getInstance().getString("node.label.ColorRendererElement");
	private final ColorRendererConfigElement rendererElement;

	/**
	 * @param rendererElement
	 */
	public ColorRendererConfigElementNode(final ColorRendererConfigElement rendererElement) {
		super(ColorRendererConfigElementNode.NODE_ID);
		if (rendererElement == null) {
			throw new IllegalArgumentException("rendererElement is null");
		}
		this.rendererElement = rendererElement;
		if (rendererElement.getReference() != null) {
			setNodeValue(new ColorRendererConfigElementNodeValue(rendererElement));
		}
		setNodeLabel(ColorRendererConfigElementNode.NODE_LABEL);
		setNodeClass(ColorRendererConfigElementNode.NODE_CLASS);
	}

	/**
	 * @see net.sf.jame.twister.util.ConfigElementNode#getConfigElement()
	 */
	@Override
	public ColorRendererConfigElement getConfigElement() {
		return rendererElement;
	}

	protected void createChildNodes(final ColorRendererConfigElementNodeValue value) {
		removeAllChildNodes();
		appendChildNode(new ColorRendererReferenceNode(ColorRendererConfigElementNode.NODE_ID + ".extension", value.getValue()));
	}

	private static class ColorRendererReferenceNode extends ConfigurableExtensionReferenceNode<ColorRendererExtensionConfig> {
		public static final String NODE_CLASS = "node.class.ColorRendererReference";

		/**
		 * @param nodeId
		 * @param filterElement
		 */
		public ColorRendererReferenceNode(final String nodeId, final ColorRendererConfigElement rendererElement) {
			super(nodeId, rendererElement.getExtensionElement());
			setNodeClass(ColorRendererReferenceNode.NODE_CLASS);
		}

		/**
		 * @see net.sf.jame.twister.util.ConfigurableExtensionReferenceNode#createNodeValue(net.sf.jame.core.extension.ConfigurableExtensionReference)
		 */
		@Override
		protected NodeValue<?> createNodeValue(final ConfigurableExtensionReference<ColorRendererExtensionConfig> value) {
			// return new ColorRendererExtensionReferenceNodeValue(value != null ? value.clone() : null);
			return new ColorRendererExtensionReferenceNodeValue(value);
		}
	}

	// private ExtensionReference getReference() {
	// if ((getNodeValue() != null) && (getNodeValue().getValue() != null)) {
	// return ((ColorRendererConfigElementNodeValue) getNodeValue()).getValue().getReference();
	// }
	// return null;
	// }
	/**
	 * @see net.sf.jame.core.tree.DefaultNode#isEditable()
	 */
	@Override
	public boolean isEditable() {
		return true;
	}

	/**
	 * @return the rendererElement
	 */
	public ColorRendererConfigElement getRendererElement() {
		return rendererElement;
	}

	/**
	 * @see net.sf.jame.core.tree.Node#updateChildNodes()
	 */
	@Override
	protected void updateChildNodes() {
		createChildNodes((ColorRendererConfigElementNodeValue) getNodeValue());
	}

	/**
	 * @see net.sf.jame.core.tree.DefaultNode#createNodeEditor()
	 */
	@Override
	protected NodeEditor createNodeEditor() {
		return new RendererNodeEditor(this);
	}

	private static class RendererNodeEditor extends NodeEditor {
		/**
		 * @param node
		 */
		public RendererNodeEditor(final Node node) {
			super(node);
		}

		/**
		 * @see net.sf.jame.core.tree.NodeEditor#createChildNode(net.sf.jame.core.tree.NodeValue)
		 */
		@Override
		protected Node createChildNode(final NodeValue<?> value) {
			return null;
		}

		/**
		 * @see net.sf.jame.core.tree.NodeEditor#createNodeValue(java.io.Serializable)
		 */
		@Override
		public NodeValue<?> createNodeValue(final Serializable value) {
			// return new ColorRendererFormulaConfigElementNodeValue((ColorRendererFormulaConfigElement) value != null ? ((ColorRendererFormulaConfigElement) value).clone() : null);
			return new ColorRendererFormulaConfigElementNodeValue((ColorRendererFormulaConfigElement) value);
		}

		/**
		 * @see net.sf.jame.core.tree.NodeEditor#getNodeValueType()
		 */
		@Override
		public Class<?> getNodeValueType() {
			return ColorRendererFormulaConfigElementNodeValue.class;
		}
	}
}
