/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends FilterInputStream {
    private transient boolean alreadycounting;
    private long bytesRead = 0L;

    public CountingInputStream(InputStream in) {
        super(in);
    }

    public String toString() {
        if (null == this.in) {
            return "closed/" + super.toString();
        }
        return this.in.toString() + "/" + super.toString();
    }

    public synchronized int read() throws IOException {
        boolean wascounting = this.alreadycounting;
        this.alreadycounting = true;
        int i = super.read();
        this.alreadycounting = wascounting;
        if (!this.alreadycounting && i != -1) {
            ++this.bytesRead;
        }
        return i;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        boolean wascounting = this.alreadycounting;
        this.alreadycounting = true;
        int i = super.read(b, off, len);
        this.alreadycounting = wascounting;
        if (-1 != i && !this.alreadycounting) {
            this.bytesRead += (long)i;
        }
        return i;
    }

    public synchronized long getBytesRead() {
        return this.bytesRead;
    }
}

