/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util.pipe.reliable;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.util.pipe.reliable.Outgoing;
import net.jxta.logging.Logging;

public class OutgoingMsgrAdaptor
implements Outgoing {
    private static final transient Logger LOG = Logger.getLogger(OutgoingMsgrAdaptor.class.getName());
    private final Messenger msgr;
    private int timeout;
    private long lastAccessed = 0L;
    private boolean closed = false;

    public OutgoingMsgrAdaptor(Messenger msgr, int timeout) {
        if (msgr == null) {
            throw new IllegalArgumentException("messenger cannot be null");
        }
        this.msgr = msgr;
        this.timeout = timeout;
        this.lastAccessed = TimeUtils.timeNow();
    }

    public String toString() {
        return " lastAccessed=" + Long.toString(this.lastAccessed);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void close() {
        this.closed = true;
    }

    public long getMinIdleReconnectTime() {
        return this.timeout;
    }

    public long getIdleTimeout() {
        return Long.MAX_VALUE;
    }

    public long getMaxRetryAge() {
        return this.timeout == 0 ? Long.MAX_VALUE : (long)this.timeout;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public void setLastAccessed(long time) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Setting lastAccessed to :" + this.lastAccessed);
        }
        this.lastAccessed = time;
    }

    public boolean send(Message msg) throws IOException {
        if (this.closed) {
            throw new IOException("broken connection");
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Sending a Message");
        }
        this.msgr.sendMessageB(msg, null, null);
        return true;
    }
}

