/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.rdv;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.impl.protocol.RdvConfigAdv;
import net.jxta.impl.rendezvous.PeerConnection;
import net.jxta.impl.rendezvous.RdvWalk;
import net.jxta.impl.rendezvous.RdvWalker;
import net.jxta.impl.rendezvous.RendezVousPropagateMessage;
import net.jxta.impl.rendezvous.RendezVousServiceImpl;
import net.jxta.impl.rendezvous.StdRendezVousService;
import net.jxta.impl.rendezvous.limited.LimitedRangeWalk;
import net.jxta.impl.rendezvous.rdv.ClientConnection;
import net.jxta.impl.rendezvous.rendezvousMeter.ClientConnectionMeter;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousMeterBuildSettings;
import net.jxta.impl.rendezvous.rpv.PeerView;
import net.jxta.impl.util.TimeUtils;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.PeerAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RdvPeerRdvService
extends StdRendezVousService {
    private static final Logger LOG = Logger.getLogger(RdvPeerRdvService.class.getName());
    public static final String RDV_WALK_SVC_NAME = "RdvWalkSvcName";
    public static final String RDV_WALK_SVC_PARAM = "RdvWalkSvcParam";
    public static final long GC_INTERVAL = 120000L;
    public static final long DEFAULT_LEASE_DURATION = 1200000L;
    public static final int DEFAULT_MAX_CLIENTS = 200;
    private final long LEASE_DURATION;
    private final int MAX_CLIENTS;
    private final Map<ID, ClientConnection> clients;
    private RdvWalk walk;
    private RdvWalker walker;
    public final PeerView rpv;

    public RdvPeerRdvService(PeerGroup group, RendezVousServiceImpl rdvService) {
        block11: {
            RdvConfigAdv rdvConfigAdv;
            super(group, rdvService);
            this.clients = Collections.synchronizedMap(new HashMap());
            this.walk = null;
            this.walker = null;
            Advertisement adv = null;
            ConfigParams confAdv = group.getConfigAdvertisement();
            if (confAdv != null) {
                try {
                    XMLDocument configDoc = (XMLDocument)confAdv.getServiceParam(rdvService.getAssignedID());
                    if (null != configDoc) {
                        adv = AdvertisementFactory.newAdvertisement(configDoc);
                    }
                }
                catch (NoSuchElementException failed) {
                    // empty catch block
                }
            }
            if (!(adv instanceof RdvConfigAdv)) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Creating new RdvConfigAdv for defaults.");
                }
                rdvConfigAdv = (RdvConfigAdv)AdvertisementFactory.newAdvertisement(RdvConfigAdv.getAdvertisementType());
            } else {
                rdvConfigAdv = (RdvConfigAdv)adv;
            }
            this.MAX_TTL = rdvConfigAdv.getMaxTTL() > 0 ? rdvConfigAdv.getMaxTTL() : 200;
            this.MAX_CLIENTS = rdvConfigAdv.getMaxClients() > 0 ? rdvConfigAdv.getMaxClients() : 200;
            this.LEASE_DURATION = rdvConfigAdv.getLeaseDuration() > 0L ? rdvConfigAdv.getLeaseDuration() : 1200000L;
            try {
                XMLDocument params = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                Object e = params.createElement("Rdv", Boolean.TRUE.toString());
                params.appendChild(e);
                group.getPeerAdvertisement().putServiceParam(rdvService.getAssignedID(), params);
            }
            catch (Exception ohwell) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block11;
                LOG.log(Level.WARNING, "Failed adding service params", ohwell);
            }
        }
        PeerGroup advGroup = group.getParentGroup();
        if (null == advGroup || PeerGroupID.worldPeerGroupID.equals(advGroup.getPeerGroupID())) {
            advGroup = null;
        }
        this.rpv = new PeerView(group, advGroup, rdvService, rdvService.getAssignedID().toString() + group.getPeerGroupID().getUniqueValue().toString());
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("RendezVous Service is initialized for " + group.getPeerGroupID() + " as a Rendezvous peer.");
        }
    }

    @Override
    protected int startApp(String[] argv) {
        super.startApp(argv, new StdRdvRdvProtocolListener());
        this.rpv.start();
        this.walk = new LimitedRangeWalk(this.group, new WalkListener(), this.pName, this.pParam, this.rpv);
        this.walker = this.walk.getWalker();
        this.timer.scheduleAtFixedRate((TimerTask)new GCTask(), 120000L, 120000L);
        if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
            this.rendezvousMeter.startRendezvous();
        }
        this.rdvService.generateEvent(8, this.group.getPeerID());
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("RdvPeerRdvService is started");
        }
        return 0;
    }

    @Override
    public synchronized void stopApp() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.walk.stop();
        this.walk = null;
        this.rpv.stop();
        this.disconnectAllClients();
        this.clients.clear();
        super.stopApp();
        if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
            this.rendezvousMeter.stopRendezvous();
        }
    }

    @Override
    public void connectToRendezVous(EndpointAddress addr, Object hint) {
        throw new UnsupportedOperationException("Not supported by rendezvous");
    }

    @Override
    public void challengeRendezVous(ID peer, long delay) {
        throw new UnsupportedOperationException("Not supported by rendezvous");
    }

    @Override
    public void disconnectFromRendezVous(ID peerId) {
        throw new UnsupportedOperationException("Not supported by rendezvous");
    }

    @Override
    public boolean isConnectedToRendezVous() {
        return false;
    }

    @Override
    public Vector<ID> getConnectedPeerIDs() {
        Vector<ID> result = new Vector<ID>();
        List<Object> allClients = Arrays.asList(this.clients.values().toArray());
        for (Object allClient : allClients) {
            PeerConnection aConnection = (PeerConnection)allClient;
            if (!aConnection.isConnected()) continue;
            result.add(aConnection.getPeerID());
        }
        return result;
    }

    @Override
    public void propagate(Message msg, String serviceName, String serviceParam, int initialTTL) throws IOException {
        RendezVousPropagateMessage propHdr;
        if (this.closed) {
            return;
        }
        msg = msg.clone();
        int useTTL = Math.min(initialTTL, this.MAX_TTL);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Propagating " + msg + "(TTL=" + useTTL + ") to :" + "\n\tsvc name:" + serviceName + "\tsvc params:" + serviceParam);
        }
        if (null != (propHdr = this.updatePropHeader(msg, this.getPropHeader(msg), serviceName, serviceParam, useTTL))) {
            this.walk(msg, "JxtaPropagate", this.PropPName, useTTL);
            this.sendToNetwork(msg, propHdr);
            if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
                this.rendezvousMeter.propagateToGroup();
            }
        }
    }

    @Override
    public void propagateInGroup(Message msg, String serviceName, String serviceParam, int initialTTL) throws IOException {
        RendezVousPropagateMessage propHdr;
        if (this.closed) {
            return;
        }
        msg = msg.clone();
        int useTTL = Math.min(initialTTL, this.MAX_TTL);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Propagating " + msg + "(TTL=" + useTTL + ") in group to :" + "\n\tsvc name:" + serviceName + "\tsvc params:" + serviceParam);
        }
        if (null != (propHdr = this.updatePropHeader(msg, this.getPropHeader(msg), serviceName, serviceParam, useTTL))) {
            this.walk(msg, "JxtaPropagate", this.PropPName, useTTL);
            this.sendToEachConnection(msg, propHdr);
            if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
                this.rendezvousMeter.propagateToGroup();
            }
        }
    }

    @Override
    public PeerConnection getPeerConnection(ID peer) {
        return this.clients.get(peer);
    }

    @Override
    protected PeerConnection[] getPeerConnections() {
        return this.clients.values().toArray(new PeerConnection[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientConnection addClient(PeerAdvertisement padv, long lease) {
        int eventType;
        ClientConnection pConn;
        ClientConnectionMeter clientConnectionMeter = null;
        Map<ID, ClientConnection> map = this.clients;
        synchronized (map) {
            pConn = this.clients.get(padv.getPeerID());
            if (null != pConn) {
                eventType = 3;
            } else {
                eventType = 2;
                pConn = new ClientConnection(this.group, this.rdvService, (ID)padv.getPeerID());
                this.clients.put(padv.getPeerID(), pConn);
            }
        }
        if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousServiceMonitor != null) {
            clientConnectionMeter = this.rendezvousServiceMonitor.getClientConnectionMeter(padv.getPeerID());
        }
        if (2 == eventType) {
            if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && clientConnectionMeter != null) {
                clientConnectionMeter.clientConnectionEstablished(lease);
            }
        } else if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && clientConnectionMeter != null) {
            clientConnectionMeter.clientLeaseRenewed(lease);
        }
        this.rdvService.generateEvent(eventType, padv.getPeerID());
        pConn.connect(padv, lease);
        return pConn;
    }

    private ClientConnection removeClient(PeerConnection pConn, boolean requested) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Disconnecting client " + pConn);
        }
        if (pConn.isConnected()) {
            pConn.setConnected(false);
            this.sendDisconnect(pConn);
        }
        this.rdvService.generateEvent(requested ? 6 : 7, pConn.getPeerID());
        if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousServiceMonitor != null) {
            ClientConnectionMeter clientConnectionMeter = this.rendezvousServiceMonitor.getClientConnectionMeter((PeerID)pConn.getPeerID());
            clientConnectionMeter.clientConnectionDisconnected(requested);
        }
        return this.clients.remove(pConn.getPeerID());
    }

    private void disconnectAllClients() {
        for (Object o : Arrays.asList(this.clients.values().toArray())) {
            ClientConnection pConn = (ClientConnection)o;
            try {
                this.removeClient(pConn, false);
            }
            catch (Exception ez1) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.log(Level.WARNING, "disconnectClient failed for" + pConn, ez1);
            }
        }
    }

    private void processDisconnectRequest(Message msg) {
        PeerAdvertisement adv;
        try {
            MessageElement elem = msg.getMessageElement("jxta", "Disconnect");
            XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(elem);
            adv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(asDoc);
        }
        catch (Exception e) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Could not process disconnect request", e);
            }
            return;
        }
        ClientConnection pConn = this.clients.get(adv.getPeerID());
        if (null != pConn) {
            pConn.setConnected(false);
            this.removeClient(pConn, true);
        }
    }

    private void processLeaseRequest(Message msg) {
        long lease;
        PeerAdvertisement padv;
        block14: {
            try {
                MessageElement elem = msg.getMessageElement("jxta", "Connect");
                XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(elem);
                padv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(asDoc);
                msg.removeMessageElement(elem);
            }
            catch (Exception e) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Cannot retrieve advertisment from lease request", e);
                }
                return;
            }
            try {
                DiscoveryService discovery = this.group.getDiscoveryService();
                if (null != discovery) {
                    discovery.publish(padv, this.LEASE_DURATION * 2L, 0L);
                }
            }
            catch (Exception e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block14;
                LOG.log(Level.WARNING, "Client peer advertisement publish failed", e);
            }
        }
        ClientConnection pConn = this.clients.get(padv.getPeerID());
        if (null != pConn) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Renewing client lease to " + pConn);
            }
            lease = this.LEASE_DURATION;
        } else if (this.clients.size() < this.MAX_CLIENTS) {
            lease = this.LEASE_DURATION;
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Offering new client lease to " + padv.getName() + " [" + padv.getPeerID() + "]");
            }
        } else {
            lease = 0L;
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Max clients exceeded, declining lease request from: " + padv.getName() + " [" + padv.getPeerID() + "]");
            }
        }
        if (lease > 0L) {
            pConn = this.addClient(padv, lease);
            this.sendLease(pConn, lease);
        }
    }

    private boolean sendLease(ClientConnection pConn, long lease) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Sending lease (" + lease + ") to " + pConn.getPeerName());
        }
        Message msg = new Message();
        msg.addMessageElement("jxta", new TextDocumentMessageElement("RdvAdvReply", this.getPeerAdvertisementDoc(), null));
        msg.addMessageElement("jxta", new StringMessageElement("ConnectedPeer", this.group.getPeerID().toString(), null));
        msg.addMessageElement("jxta", new StringMessageElement("ConnectedLease", Long.toString(lease), null));
        return pConn.sendMessage(msg, this.pName, this.pParam);
    }

    @Override
    public void walk(Message msg, String serviceName, String serviceParam, int initialTTL) throws IOException {
        if (this.closed) {
            return;
        }
        msg = msg.clone();
        int useTTL = Math.min(initialTTL, this.MAX_TTL);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Undirected walk of " + msg + "(TTL=" + useTTL + ") to :" + "\n\tsvc name:" + serviceName + "\tsvc params:" + serviceParam);
        }
        msg.replaceMessageElement("jxta", new StringMessageElement(RDV_WALK_SVC_NAME, serviceName, null));
        msg.replaceMessageElement("jxta", new StringMessageElement(RDV_WALK_SVC_PARAM, serviceParam, null));
        try {
            this.walker.walkMessage(null, msg, this.pName, this.pParam, useTTL);
            if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
                this.rendezvousMeter.walk();
            }
        }
        catch (IOException failure) {
            if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
                this.rendezvousMeter.walkFailed();
            }
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Cannot send message with Walker", failure);
            }
            throw failure;
        }
    }

    @Override
    public void walk(Vector<? extends ID> destPeerIDs, Message msg, String serviceName, String serviceParam, int initialTTL) throws IOException {
        if (this.closed) {
            return;
        }
        msg = msg.clone();
        int useTTL = Math.min(initialTTL, this.MAX_TTL);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Directed walk of " + msg + "(TTL=" + useTTL + ") to :" + "\n\tsvc name:" + serviceName + "\tsvc params:" + serviceParam);
        }
        msg.replaceMessageElement("jxta", new StringMessageElement(RDV_WALK_SVC_NAME, serviceName, null));
        msg.replaceMessageElement("jxta", new StringMessageElement(RDV_WALK_SVC_PARAM, serviceParam, null));
        for (ID iD : destPeerIDs) {
            try {
                this.walker.walkMessage((PeerID)iD, msg.clone(), this.pName, this.pParam, useTTL);
            }
            catch (IOException failed) {
                if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
                    this.rendezvousMeter.walkToPeersFailed();
                }
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Cannot send message with Walker to: " + iD, failed);
                }
                IOException failure = new IOException("Cannot send message with Walker to: " + iD);
                failure.initCause(failed);
                throw failure;
            }
        }
        if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
            this.rendezvousMeter.walkToPeers(destPeerIDs.size());
        }
    }

    private class WalkListener
    implements EndpointListener {
        private WalkListener() {
        }

        public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
            String sParam;
            MessageElement serviceME = msg.getMessageElement("jxta", RdvPeerRdvService.RDV_WALK_SVC_NAME);
            if (null == serviceME) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Discarding " + msg + " because its missing service name element");
                }
                return;
            }
            msg.removeMessageElement(serviceME);
            String sName = serviceME.toString();
            MessageElement paramME = msg.getMessageElement("jxta", RdvPeerRdvService.RDV_WALK_SVC_PARAM);
            if (null == paramME) {
                sParam = null;
            } else {
                msg.removeMessageElement(paramME);
                sParam = paramME.toString();
            }
            EndpointAddress realDest = new EndpointAddress(dstAddr, sName, sParam);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Calling local listener for [" + realDest.getServiceName() + " / " + realDest.getServiceParameter() + "] with " + msg);
            }
            ((RdvPeerRdvService)RdvPeerRdvService.this).rdvService.endpoint.processIncomingMessage(msg, srcAddr, realDest);
            if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && RdvPeerRdvService.this.rendezvousMeter != null) {
                RdvPeerRdvService.this.rendezvousMeter.receivedMessageProcessedLocally();
            }
        }
    }

    private class GCTask
    extends TimerTask {
        private GCTask() {
        }

        public void run() {
            block7: {
                try {
                    long gcStart = TimeUtils.timeNow();
                    int gcedClients = 0;
                    List<Object> allClients = Arrays.asList(RdvPeerRdvService.this.clients.values().toArray());
                    for (Object allClient : allClients) {
                        ClientConnection pConn = (ClientConnection)allClient;
                        try {
                            long now = TimeUtils.timeNow();
                            if (pConn.isConnected() && pConn.getLeaseEnd() >= now) continue;
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("GC CLIENT: dropping " + pConn);
                            }
                            pConn.setConnected(false);
                            RdvPeerRdvService.this.removeClient(pConn, false);
                            ++gcedClients;
                        }
                        catch (Exception e) {
                            if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                            LOG.log(Level.WARNING, "GCTask failed for " + pConn, e);
                        }
                    }
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Client GC " + gcedClients + " of " + allClients.size() + " clients completed in " + TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), gcStart) + "ms.");
                    }
                }
                catch (Throwable all) {
                    if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block7;
                    LOG.log(Level.SEVERE, "Uncaught Throwable in thread :" + Thread.currentThread().getName(), all);
                }
            }
        }
    }

    private class StdRdvRdvProtocolListener
    implements StdRendezVousService.StdRdvProtocolListener {
        private StdRdvRdvProtocolListener() {
        }

        public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + RdvPeerRdvService.this.group.getPeerGroupID() + "] processing " + msg);
            }
            if (msg.getMessageElement("jxta", "Connect") != null) {
                RdvPeerRdvService.this.processLeaseRequest(msg);
            }
            if (msg.getMessageElement("jxta", "Disconnect") != null) {
                RdvPeerRdvService.this.processDisconnectRequest(msg);
            }
        }
    }
}

