/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;

public class LimitedRangeRdvMsg {
    private static final transient Logger LOG = Logger.getLogger(LimitedRangeRdvMsg.class.getName());
    private static final String TTL_ELEMENT = "TTL";
    private static final String DIRECTION_ELEMENT = "Dir";
    private static final String SRCPEERID_ELEMENT = "SrcPeerID";
    private static final String SRCSVCNAME_ELEMENT = "SrcSvcName";
    private static final String SRCSVCPARAM_ELEMENT = "SrcSvcParams";
    private int ttl = 0;
    private WalkDirection direction = null;
    private PeerID srcPeerID = null;
    private String srcSvcName = null;
    private String srcSvcParams = null;

    public LimitedRangeRdvMsg() {
    }

    public LimitedRangeRdvMsg(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XMLElement");
        }
        XMLElement doc = (XMLElement)root;
        if (!doc.getName().equals(LimitedRangeRdvMsg.getMessageType())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + " from doc containing a '" + doc.getName() + "'. Should be : " + LimitedRangeRdvMsg.getMessageType());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Unhandled Element: " + elem);
        }
        if (this.getTTL() < 1) {
            throw new IllegalArgumentException("Illegal TTL value.");
        }
        if (null == this.getDirection()) {
            throw new IllegalArgumentException("No Direction specified.");
        }
        if (null == this.getSrcPeerID()) {
            throw new IllegalArgumentException("No source peer id specified.");
        }
        if (null == this.getSrcSvcName()) {
            throw new IllegalArgumentException("No source service name specified.");
        }
    }

    public LimitedRangeRdvMsg clone() {
        try {
            LimitedRangeRdvMsg clone = (LimitedRangeRdvMsg)super.clone();
            clone.setSrcPeerID(this.getSrcPeerID());
            clone.setDirection(this.getDirection());
            clone.setTTL(this.getTTL());
            clone.setSrcSvcName(this.getSrcSvcName());
            clone.setSrcSvcParams(this.getSrcSvcParams());
            return clone;
        }
        catch (CloneNotSupportedException impossible) {
            throw new Error("Object.clone() threw CloneNotSupportedException", impossible);
        }
    }

    public int getTTL() {
        return this.ttl;
    }

    public void setTTL(int ttl) {
        this.ttl = ttl;
    }

    public WalkDirection getDirection() {
        return this.direction;
    }

    public void setDirection(WalkDirection dir) {
        this.direction = dir;
    }

    public String getSrcSvcName() {
        return this.srcSvcName;
    }

    public void setSrcSvcName(String srcSvcName) {
        this.srcSvcName = srcSvcName;
    }

    public String getSrcSvcParams() {
        return this.srcSvcParams;
    }

    public void setSrcSvcParams(String srcSvcParams) {
        this.srcSvcParams = srcSvcParams;
    }

    public ID getSrcPeerID() {
        return this.srcPeerID;
    }

    public void setSrcPeerID(ID srcPeerID) {
        this.srcPeerID = (PeerID)srcPeerID;
    }

    public static String getMessageType() {
        return "jxta:LimitedRangeRdvMessage";
    }

    protected boolean handleElement(XMLElement elem) {
        String value = elem.getTextValue();
        if (null != value && 0 == (value = value.trim()).length()) {
            value = null;
        }
        if (null == value) {
            return false;
        }
        if (elem.getName().equals(TTL_ELEMENT)) {
            this.setTTL(Integer.parseInt(value));
            return true;
        }
        if (elem.getName().equals(DIRECTION_ELEMENT)) {
            int direction = Integer.parseInt(value);
            this.setDirection(WalkDirection.toWalkDirection(direction));
            return true;
        }
        if (elem.getName().equals(SRCPEERID_ELEMENT)) {
            try {
                URI srcURI = new URI(value);
                ID srcID = IDFactory.fromURI(srcURI);
                this.setSrcPeerID(srcID);
            }
            catch (URISyntaxException badID) {
                IllegalArgumentException iae = new IllegalArgumentException("Bad ID in message");
                iae.initCause(badID);
                throw iae;
            }
            return true;
        }
        if (elem.getName().equals(SRCSVCNAME_ELEMENT)) {
            this.setSrcSvcName(value);
            return true;
        }
        if (elem.getName().equals(SRCSVCPARAM_ELEMENT)) {
            this.setSrcSvcParams(value);
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType mediaType) {
        if (this.getTTL() < 1) {
            throw new IllegalStateException("Illegal TTL value.");
        }
        if (null == this.getDirection()) {
            throw new IllegalStateException("No Direction specified.");
        }
        if (null == this.getSrcPeerID()) {
            throw new IllegalStateException("No source peer id specified.");
        }
        if (null == this.getSrcSvcName()) {
            throw new IllegalStateException("No source service name specified.");
        }
        StructuredDocument msg = StructuredDocumentFactory.newStructuredDocument(mediaType, LimitedRangeRdvMsg.getMessageType());
        if (msg instanceof XMLDocument) {
            ((XMLDocument)msg).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        Object e = msg.createElement(TTL_ELEMENT, Integer.toString(this.getTTL()));
        msg.appendChild(e);
        e = msg.createElement(DIRECTION_ELEMENT, Integer.toString(this.getDirection().toProtocolCode()));
        msg.appendChild(e);
        e = msg.createElement(SRCPEERID_ELEMENT, this.getSrcPeerID().toString());
        msg.appendChild(e);
        e = msg.createElement(SRCSVCNAME_ELEMENT, this.getSrcSvcName());
        msg.appendChild(e);
        if (this.getSrcSvcParams() != null) {
            e = msg.createElement(SRCSVCPARAM_ELEMENT, this.getSrcSvcParams());
            msg.appendChild(e);
        }
        return msg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WalkDirection {
        UP(1),
        DOWN(2),
        BOTH(3);

        private final int proto_direction;

        private WalkDirection(int direction) {
            this.proto_direction = direction;
        }

        public static WalkDirection toWalkDirection(int code) {
            switch (code) {
                case 1: {
                    return UP;
                }
                case 2: {
                    return DOWN;
                }
                case 3: {
                    return BOTH;
                }
            }
            throw new IllegalArgumentException("Illegal direction");
        }

        public int toProtocolCode() {
            return this.proto_direction;
        }
    }
}

