/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership.pse;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.impl.membership.pse.KeyStoreManager;
import net.jxta.impl.membership.pse.URIKeyStoreManager;
import net.jxta.logging.Logging;

public class FileKeyStoreManager
implements KeyStoreManager {
    private static final transient Logger LOG = Logger.getLogger(URIKeyStoreManager.class.getName());
    private static final String DEFAULT_KEYSTORE_TYPE = "jks";
    private static final String DEFAULT_KEYSTORE_FILENAME = "jxta_keystore";
    private final String keystore_type;
    private final String keystore_provider;
    private final File keystore_location;

    public FileKeyStoreManager(String type, String provider, File location) throws NoSuchProviderException, KeyStoreException {
        if (null == type) {
            type = DEFAULT_KEYSTORE_TYPE;
            provider = null;
        }
        if (location.isDirectory()) {
            location = new File(location, DEFAULT_KEYSTORE_FILENAME);
        }
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            LOG.config("pse location = " + location);
        }
        this.keystore_type = type;
        this.keystore_provider = provider;
        this.keystore_location = location;
        if (null == this.keystore_provider) {
            KeyStore.getInstance(this.keystore_type);
        } else {
            KeyStore.getInstance(this.keystore_type, this.keystore_provider);
        }
    }

    public boolean isInitialized() {
        return this.isInitialized(null);
    }

    public boolean isInitialized(char[] store_password) {
        try {
            KeyStore store = null == this.keystore_provider ? KeyStore.getInstance(this.keystore_type) : KeyStore.getInstance(this.keystore_type, this.keystore_provider);
            store.load(this.keystore_location.toURI().toURL().openStream(), store_password);
            return true;
        }
        catch (Exception failed) {
            return false;
        }
    }

    public void createKeyStore(char[] store_password) throws KeyStoreException, IOException {
        try {
            KeyStore store = null == this.keystore_provider ? KeyStore.getInstance(this.keystore_type) : KeyStore.getInstance(this.keystore_type, this.keystore_provider);
            store.load(null, store_password);
            this.saveKeyStore(store, store_password);
        }
        catch (NoSuchProviderException failed) {
            KeyStoreException failure = new KeyStoreException("NoSuchProviderException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
        catch (NoSuchAlgorithmException failed) {
            KeyStoreException failure = new KeyStoreException("NoSuchAlgorithmException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
        catch (CertificateException failed) {
            KeyStoreException failure = new KeyStoreException("CertificateException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
    }

    public KeyStore loadKeyStore(char[] password) throws KeyStoreException, IOException {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Loading (" + this.keystore_type + "," + this.keystore_provider + ") store from " + this.keystore_location);
        }
        try {
            KeyStore store = null == this.keystore_provider ? KeyStore.getInstance(this.keystore_type) : KeyStore.getInstance(this.keystore_type, this.keystore_provider);
            store.load(this.keystore_location.toURI().toURL().openStream(), password);
            return store;
        }
        catch (NoSuchAlgorithmException failed) {
            KeyStoreException failure = new KeyStoreException("NoSuchAlgorithmException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
        catch (CertificateException failed) {
            KeyStoreException failure = new KeyStoreException("CertificateException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
        catch (NoSuchProviderException failed) {
            KeyStoreException failure = new KeyStoreException("NoSuchProviderException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
    }

    public void saveKeyStore(KeyStore store, char[] password) throws KeyStoreException, IOException {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Writing " + store + " to " + this.keystore_location);
        }
        try {
            FileOutputStream os = new FileOutputStream(this.keystore_location);
            store.store(os, password);
        }
        catch (NoSuchAlgorithmException failed) {
            KeyStoreException failure = new KeyStoreException("NoSuchAlgorithmException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
        catch (CertificateException failed) {
            KeyStoreException failure = new KeyStoreException("CertificateException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
    }

    public void eraseKeyStore() throws IOException {
        if (!this.keystore_location.isFile() || !this.keystore_location.canWrite()) {
            throw new UnsupportedOperationException("Unable to delete");
        }
        this.keystore_location.delete();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PSE keystore details:  \n");
        sb.append("   Class:  ").append(this.getClass().getName()).append("\n");
        sb.append("   Type:  ").append(this.keystore_type == null ? "<default>" : this.keystore_type).append("\n");
        sb.append("   Provider:  ").append(this.keystore_provider == null ? "<default>" : this.keystore_provider).append("\n");
        sb.append("   Location:  ").append(this.keystore_location == null ? "<default>" : this.keystore_location.toString()).append("\n");
        return sb.toString();
    }
}

