{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit pibo;

interface

uses
  crt,dos,overlay,
  pibtimer,pibasync;

procedure async_receive_with_timeout(secs:integer; var c:integer);
procedure async_stuff(ch:char);
procedure async_find_delay(var one_ms_delay:integer);
procedure async_init(async_buffer_max,async_obuffer_max,
                      async_high_lev1,async_high_lev2,
                      async_low_lev:integer);
function async_carrier_drop:boolean;
function async_line_error(var error_flags:byte):boolean;
function async_ring_detect:boolean;
procedure async_send_break;
procedure async_send_string(s:anystr);
procedure async_send_string_with_delays(s:anystr; char_delay,eos_delay:integer);
function async_percentage_used:real;
function async_peek(nchars:integer):char;
procedure async_setup_port(comport,base_address,irq_line:integer);
procedure async_drain_output_buffer(max_wait_time:integer);
function async_port_address_given(com_port:integer):boolean;
procedure async_flush_output_buffer;
procedure async_close(drop_dtr:boolean);
procedure async_clear_errors;
procedure async_reset_port(comport:integer; baudrate:word; parity:char;
                           wordsize,stopbits:integer );
procedure async_release_buffers;

implementation

{uses pibasync;}

(*----------------------------------------------------------------------*)
(*   Async_Receive_With_TimeOut --- Return char. from buffer with delay *)
(*----------------------------------------------------------------------*)

PROCEDURE Async_Receive_With_Timeout( Secs : INTEGER; VAR C : INTEGER );

(*----------------------------------------------------------------------*)
(*                                                                      *)
(*     Procedure:  Async_Receive_With_Timeout                           *)
(*                                                                      *)
(*     Purpose:    Retrieve character as integer from buffer,           *)
(*                 or return TimeOut if specified delay period          *)
(*                 expires.                                             *)
(*                                                                      *)
(*     Calling Sequence:                                                *)
(*                                                                      *)
(*        Async_Receive_With_Timeout( Secs: INTEGER; VAR C: INTEGER );  *)
(*                                                                      *)
(*           Secs ---  Timeout period in seconds                        *)
(*                     NOTE:  Cannot be longer than 32 seconds!         *)
(*           C     --- ORD(character) (if any) retrieved from buffer;   *)
(*                     set to TimeOut if no character found before      *)
(*                     delay period expires.                            *)
(*                                                                      *)
(*     Calls:  Async_Receive                                            *)
(*                                                                      *)
(*     WATCH OUT!  THIS ROUTINE RETURNS AN INTEGER, NOT A CHARACTER!!!  *)
(*                                                                      *)
(*----------------------------------------------------------------------*)

BEGIN (* Async_Receive_With_Timeout *)

INLINE(
                                  {;}
                                  {;  Check if a character in input comm buffer}
                                  {;}
  $A1/>ASYNC_BUFFER_TAIL/         {         MOV   AX,[>Async_Buffer_Tail]}
  $3B/$06/>ASYNC_BUFFER_HEAD/     {         CMP   AX,[>Async_Buffer_Head]}
  $75/$29/                        {         JNE   Rec1}
                                  {;}
                                  {;  Buffer empty -- begin wait loop.}
                                  {;}
  $8B/$46/<SECS/                  {         MOV   AX,[BP+<Secs]                 ;Get seconds to wait}
  $B9/$0A/$00/                    {         MOV   CX,10                         ;Shift count = 2 ** 10 = 1024}
  $D3/$E0/                        {         SHL   AX,CL                         ;Seconds * 1024 = milleseconds}
  $89/$C1/                        {         MOV   CX,AX                         ;Move to looping register}
                                  {;}
                                  {;  Delay for 1 ms.}
                                  {;}
  $51/                            {Delay:   PUSH  CX                            ;Save milleseconds to go}
  $8B/$0E/>ASYNC_ONEMSDELAY/      {         MOV   CX,[>Async_OneMSDelay]        ;Get delay loop value for 1 ms}
  $E2/$FE/                        {Delay1:  LOOP  Delay1                        ;Tight loop for 1 ms delay}
                                  {;}
                                  {;  Check if any character yet.}
                                  {;}
  $59/                            {         POP   CX                            ;Get back millesecond count}
                                  {;}
  $A1/>ASYNC_BUFFER_TAIL/         {         MOV   AX,[>Async_Buffer_Tail]}
  $3B/$06/>ASYNC_BUFFER_HEAD/     {         CMP   AX,[>Async_Buffer_Head]}
  $75/$0E/                        {         JNE   Rec1}
                                  {;}
                                  {;  Buffer still empty -- decrement elapsed time}
                                  {;}
  $E2/$ED/                        {         LOOP  Delay                         ;Decrement millesecond count and loop}
                                  {;}
                                  {;  Dropped through -- no character arrived in specified interval.}
                                  {;  Return TimeOut as result.}
                                  {;}
  $BB/>TIMEOUT/                   {         MOV   BX,>TimeOut                   ;Pick up timeout value}
  $C4/$7E/<C/                     {         LES   DI,[BP+<C]                    ;Get result character address}
  $26/$89/$1D/                    {    ES:  MOV   [DI],BX                       ;Store timeout value}
  $E9/$3E/$00/                    {         JMP   Return                        ;Return to caller}
                                  {;}
                                  {;  Buffer not empty -- pick up next character.}
                                  {;}
  $C4/$3E/>ASYNC_BUFFER_PTR/      {Rec1:    LES   DI,[>Async_Buffer_Ptr]        ;Pick up buffer address}
  $01/$C7/                        {         ADD   DI,AX                         ;Add character offset}
  $26/$8A/$1D/                    {     ES: MOV   BL,[DI]                       ;Get character from buffer}
                                  {;}
  $30/$FF/                        {         XOR   BH,BH                         ;Clear high-order bits}
  $C4/$7E/<C/                     {         LES   DI,[BP+<C]                    ;Get result address}
  $26/$89/$1D/                    {     ES: MOV   [DI],BX                       ;Store character from buffer}
                                  {;}
  $40/                            {         INC   AX                            ;Increment tail pointer}
  $3B/$06/>ASYNC_BUFFER_SIZE/     {         CMP   AX,[>Async_Buffer_Size]       ;Past end of buffer?}
  $7E/$02/                        {         JLE   Rec2                          ;No -- skip wrapping}
  $31/$C0/                        {         XOR   AX,AX                         ;Yes -- point to start of buffer}
  $A3/>ASYNC_BUFFER_TAIL/         {Rec2:    MOV   [>Async_Buffer_Tail],AX       ;Update tail pointer}
  $FF/$0E/>ASYNC_BUFFER_USED/     {         DEC   Word [>Async_Buffer_Used]     ;Update buffer usage count}
                                  {;}
                                  {; If XOFF previously sent because buffer was too full, and}
                                  {; now buffer is reasonably empty, send XON to get things rolling again.}
                                  {;}
  $F6/$06/>ASYNC_XOFF_SENT/$01/   {         TEST  BYTE [<Async_XOff_Sent],1     ;Check if Xoff sent}
  $74/$16/                        {         JZ    Return                        ;No -- skip.}
                                  {;}
  $A1/>ASYNC_BUFFER_USED/         {         MOV   AX,[>Async_Buffer_Used]       ;Pick up amount of buffer used}
  $3B/$06/>ASYNC_BUFFER_LOW/      {         CMP   AX,[>Async_Buffer_Low]        ;Check if low enough}
  $7F/$0D/                        {         JG    Return                        ;Still too full, skip}
                                  {;}
  $B8/>XON/                       {         MOV   AX,>XON                       ;Push XON onto stack}
  $50/                            {         PUSH  AX}
  $FF/$1E/>ASYNC_SEND_ADDR/       {         CALL  FAR [>Async_Send_Addr]        ;Call output routine}
                                  {;}
  $C6/$06/>ASYNC_XOFF_SENT/$00/   {         MOV   BYTE [>Async_XOff_Sent],0     ;Clear Xoff flag}
                                  {;}
  $80/$26/>ASYNC_LINE_STATUS/$FD);{Return:  AND   Byte [>Async_Line_Status],$FD ;Remove overflow flag}

END   (* Async_Receive_With_Timeout *);

(*----------------------------------------------------------------------*)
(*        Async_Stuff --- Stuff character into receive buffer           *)
(*----------------------------------------------------------------------*)

PROCEDURE Async_Stuff( Ch: CHAR );

(*----------------------------------------------------------------------*)
(*                                                                      *)
(*     Procedure:  Async_Stuff                                          *)
(*                                                                      *)
(*     Purpose:    Stuffs a character into receive buffer               *)
(*                                                                      *)
(*     Calling Sequence:                                                *)
(*                                                                      *)
(*        Async_Stuff( Ch : Char );                                     *)
(*                                                                      *)
(*           Ch --- Character to stuff                                  *)
(*                                                                      *)
(*     Calls:  None                                                     *)
(*                                                                      *)
(*----------------------------------------------------------------------*)

VAR
   New_Head : INTEGER;

BEGIN (* Async_Stuff *)

   Async_Buffer_Ptr^[Async_Buffer_Head] := Ch;
   New_Head                             := SUCC( Async_Buffer_Head ) MOD
                                           SUCC( Async_Buffer_Size );

   IF ( New_Head = Async_Buffer_Tail ) THEN
      Async_Buffer_Overflow := TRUE
   ELSE
      BEGIN
         Async_Buffer_Head := New_Head;
         Async_Buffer_Used := SUCC( Async_Buffer_Used );
         IF ( Async_Buffer_Used > Async_MaxBufferUsed ) THEN
            Async_MaxBufferUsed := Async_Buffer_Used
      END;

END   (* Async_Stuff *);

(*----------------------------------------------------------------------*)
(* Async_Find_Delay  --- Finds delay loop value for 1 millesecond delay *)
(*----------------------------------------------------------------------*)

PROCEDURE Async_Find_Delay( VAR One_MS_Delay : INTEGER );

(*----------------------------------------------------------------------*)
(*                                                                      *)
(*      Procedure: Async_Find_Delay                                     *)
(*                                                                      *)
(*      Purpose:   Finds loop count value to effect 1 ms delay          *)
(*                                                                      *)
(*      Calling Sequence:                                               *)
(*                                                                      *)
(*         Async_Find_Delay( VAR One_MS_Delay : INTEGER );              *)
(*                                                                      *)
(*            One_MS_Delay --- Resulting loop count for 1 ms delay      *)
(*                                                                      *)
(*      Using result:                                                   *)
(*                                                                      *)
(*            Use loop of form:                                         *)
(*                                                                      *)
(*                      MOV    CX,[>One_MS_Delay]                       *)
(*               Delay: LOOP   Delay                                    *)
(*                                                                      *)
(*            to delay for 1 ms.                                        *)
(*                                                                      *)
(*      Remarks:                                                        *)
(*                                                                      *)
(*         This routine watches over the CPU elapsed timer value for    *)
(*         just one timer interval (55 milleseconds).  During that time *)
(*         we run a tight loop and accumulate the ticks.  The result    *)
(*         is the number of ticks required for a 55 ms delay.  The      *)
(*         ticks for a 1 ms delay = ( ticks for 55 ms ) / 55.           *)
(*                                                                      *)
(*         To avoid overflow problems on fast machines, and to ease the *)
(*         worry about storing results at the second timer tick, we     *)
(*         break up the single long tight loop into a series of short   *)
(*         loops inside an outer loop.  We check if the timer has       *)
(*         expired at the end of each inner short loop.  Then the       *)
(*         time for the 55 ms delay is:                                 *)
(*                                                                      *)
(*            Ticks_for_55 := Inner_Ticks * Outer_Ticks;                *)
(*                                                                      *)
(*         and the corresponding 1 ms delay is:                         *)
(*                                                                      *)
(*            Ticks_For_1  := Ticks_For_55 DIV 55;                      *)
(*                                                                      *)
(*         To simplify things, we choose the inner tick value to be     *)
(*         2 x 55 = 110.  Then:                                         *)
(*                                                                      *)
(*            Ticks_For_1  := ( 110 * Outer_Ticks ) / 55;  ==>          *)
(*            Ticks_For_1  := 2 * Outer_Ticks;                          *)
(*                                                                      *)
(*         The CPU timer is located in four bytes at $0000:$46C.        *)
(*         Interrupt $1A also returns these bytes, but using the        *)
(*         interrupt results in an inaccurate loop count value.         *)
(*                                                                      *)
(*         Thanks to Brian Foley and Kim Kokonnen for help with this    *)
(*         problem.                                                     *)
(*                                                                      *)
(*----------------------------------------------------------------------*)

(* STRUCTURED *) CONST
   Hi_Timer         : INTEGER = 0  (* Saves high portion of timer        *);
   Lo_Timer         : INTEGER = 0  (* Saves low portion of timer         *);
   OutCount         : INTEGER = 0  (* Accumulates outer loop counts      *);

BEGIN (* Async_Find_Delay *)

INLINE(
                             {;}
  $31/$C0/                   {          XOR    AX,AX                 ;Clear AX to zero}
  $8E/$C0/                   {          MOV    ES,AX                 ;Allow low-memory access}
                             {;}
  $C7/$06/>OUTCOUNT/$00/$00/ {          MOV    WORD [>OutCount],0    ;Clear outer loop counter}
                             {;}
  $FA/                       {          CLI                          ;No interrupts while reading}
  $26/$8B/$0E/>$46E/         {      ES: MOV    CX,[>$46E]            ;Hi part of CPU timer value}
  $26/$8B/$16/>$46C/         {      ES: MOV    DX,[>$46C]            ;Lo part of CPU timer value}
  $FB/                       {          STI                          ;Interrupts back on}
                             {;}
  $89/$0E/>HI_TIMER/         {          MOV    [>Hi_Timer],CX        ;Save hi part of timer}
  $89/$16/>LO_TIMER/         {          MOV    [>Lo_Timer],DX        ;Save low part of timer}
                             {;}
  $FA/                       {Loop1:    CLI                          ;No interrupts while reading}
                             {;}
  $26/$8B/$0E/>$46E/         {      ES: MOV    CX,[>$46E]            ;Hi part of CPU timer value}
  $26/$8B/$16/>$46C/         {      ES: MOV    DX,[>$46C]            ;Lo part of CPU timer value}
                             {;}
  $FB/                       {          STI                          ;Interrupts back on}
                             {;}
  $89/$C8/                   {          MOV    AX,CX                 ;Save CX and DX for later}
  $89/$D3/                   {          MOV    BX,DX}
                             {;}
  $2B/$06/>HI_TIMER/         {          SUB    AX,[>Hi_Timer]        ;Subtract low order part}
  $1B/$1E/>LO_TIMER/         {          SBB    BX,[>Lo_Timer]        ;Subtract high order part}
                             {;}
  $74/$E6/                   {          JE     Loop1                 ;Continue until non-0 tick difference}
                             {;}
  $89/$0E/>HI_TIMER/         {          MOV    [>Hi_Timer],CX        ;Save hi part}
  $89/$16/>LO_TIMER/         {          MOV    [>Lo_Timer],DX        ;Save low part}
                             {;}
  $B9/$6E/$00/               {Loop2:    MOV    CX,110                ;Run short delay loop.}
  $E2/$FE/                   {Delay:    LOOP   Delay}
                             {;}
  $FA/                       {          CLI                          ;No interrupts while reading}
                             {;}
  $26/$8B/$0E/>$46E/         {      ES: MOV    CX,[>$46E]            ;Hi part of CPU timer value}
  $26/$8B/$16/>$46C/         {      ES: MOV    DX,[>$46C]            ;Lo part of CPU timer value}
                             {;}
  $FB/                       {          STI                          ;Interrupts back on}
                             {;}
  $FF/$06/>OUTCOUNT/         {          INC    WORD [>OutCount]      ;Increment outer loop count}
                             {;}
  $2B/$0E/>HI_TIMER/         {          SUB    CX,[>Hi_Timer]        ;Subtract low order part}
  $1B/$16/>LO_TIMER/         {          SBB    DX,[>Lo_Timer]        ;Subtract high order part}
                             {;}
  $74/$E1/                   {          JE     Loop2                 ;Keep going if next tick not found}
                             {;}
  $A1/>OUTCOUNT/             {          MOV    AX,[>OutCount]        ;Pick up outer loop counter}
  $D1/$E0/                   {          SHL    AX,1                  ;* 2 = ticks for 1 ms delay}
                             {;}
  $C4/$BE/>ONE_MS_DELAY/     {          LES    DI,[BP+>One_MS_Delay] ;Get address of result}
  $26/$89/$05);              {      ES: MOV    [DI],AX               ;Store result}

END   (* Async_Find_Delay *);

(*----------------------------------------------------------------------*)
(*               Async_Init --- Initialize Asynchronous Variables       *)
(*----------------------------------------------------------------------*)

PROCEDURE Async_Init( Async_Buffer_Max  : INTEGER;
                      Async_OBuffer_Max : INTEGER;
                      Async_High_Lev1   : INTEGER;
                      Async_High_Lev2   : INTEGER;
                      Async_Low_Lev     : INTEGER );

(*----------------------------------------------------------------------*)
(*                                                                      *)
(*     Procedure:  Async_Init                                           *)
(*                                                                      *)
(*     Purpose:    Initializes variables                                *)
(*                                                                      *)
(*     Calling Sequence:                                                *)
(*                                                                      *)
(*         Async_Init( Async_Buffer_Max  : INTEGER;                     *)
(*                     Async_OBuffer_Max : INTEGER;                     *)
(*                     Async_High_Lev1   : INTEGER;                     *)
(*                     Async_High_Lev2   : INTEGER;                     *)
(*                     Async_Low_Lev     : INTEGER );                   *)
(*                                                                      *)
(*     Calls:  Async_Find_Delay                                         *)
(*             TurnOffTimeSharing                                       *)
(*             TurnOnTimeSharing                                        *)
(*                                                                      *)
(*----------------------------------------------------------------------*)

VAR
   I: INTEGER;

(*----------------------------------------------------------------------*)

begin
                                   (* No port open yet. *)
  Async_Open_Flag:=FALSE;

                                   (* No XON/XOFF handling yet. *)
  Async_XOFF_Sent:=FALSE;
  Async_XOFF_Received:=FALSE;
  Async_XOFF_Rec_Display:=FALSE;
  Async_XON_Rec_Display:=FALSE;
  Async_Send_XOFF:=FALSE;

                                   (* Set up empty receive buffer *)
  Async_Buffer_Overflow:=FALSE;
  Async_Buffer_Used:=0;
  Async_MaxBufferUsed:=0;
  Async_Buffer_Head:=0;
  Async_Buffer_Tail:=0;
                                   (* Set up empty send buffer. *)
  Async_OBuffer_Overflow:=FALSE;
  Async_OBuffer_Used:=0;
  Async_MaxOBufferUsed:=0;
  Async_OBuffer_Head:=0;
  Async_OBuffer_Tail:=0;
                                   (* Set default wait time for output *)
                                   (* buffer to drain when it fills up. *)
  Async_Output_Delay:=500;

                                   (* No modem or line errors yet. *)
  Async_Line_Status:=0;
  Async_Modem_Status:=0;
  Async_Line_Error_Flags:=0;

                                   (* Get buffer sizes *)

  if (Async_Buffer_Max>0) then Async_Buffer_Size:=Async_Buffer_Max-1
    else Async_Buffer_Size:=4095;

  if (Async_OBuffer_Max>0) then Async_OBuffer_Size:=Async_OBuffer_Max-1
    else Async_OBuffer_Size:=1131;

                                   (* Get receive buffer overflow *)
                                   (* check-points. *)
  if (Async_Low_Lev>0) then Async_Buffer_Low:=Async_Low_Lev
    else Async_Buffer_Low:=Async_Buffer_Size div 4;

  if (Async_High_Lev1>0) then Async_Buffer_High:=Async_High_Lev1
    else Async_Buffer_High:=(Async_Buffer_Size div 4)*3;

  if (Async_High_Lev2>0) then Async_Buffer_High_2:=Async_High_Lev2
    else Async_Buffer_High_2:=(Async_Buffer_Size div 10)*9;

                                   (* Allocate buffers *)

(*  getmem(Async_Buffer_Ptr,Async_Buffer_Size+1);
  getmem(Async_OBuffer_Ptr,Async_OBuffer_Size+1);*)

                                   (* No UART addresses defined yet *)
(*procedure Async_Init;
begin
  Async_Open_Flag := FALSE;
  Async_Buffer_Overflow := FALSE;
  Async_Buffer_Used := 0;
  Async_MaxBufferUsed := 0;
end;*)

  Async_Uart_IER:=0;
  Async_Uart_IIR:=0;
  Async_Uart_MSR:=0;
  Async_Uart_LSR:=0;
                                   (* Set default port addresses *)
                                   (* and default IRQ lines *)
  for i:=1 to MaxComPorts do begin
    com_base[i]:=default_com_base[i];
    com_irq[i]:=default_com_irq[i];
  end;
                                   (* Get the delay loop value for 1 ms *)
                                   (* delay loops. *)

(* ---- You should turn off time sharing if running under a multitasker *)
(* ---- to get an accurate delay loop value.  If MTASK is $DEFINEd, *)
(* ---- then the calls to the PibMDos routines for interfacing with *)
(* ---- multitaskers will be generated. *)

{$IFDEF MTASK}
  if (timesharingactive) then turnofftimesharing;
{$ENDIF}

(*  Async_find_delay(Async_onemsdelay );*)

{$IFDEF MTASK}
  if (timesharingactive) then turnontimesharing;
{$ENDIF}
end;

(*----------------------------------------------------------------------*)
(*      Async_Carrier_Drop --- Check for modem carrier drop/timeout     *)
(*----------------------------------------------------------------------*)

function Async_carrier_drop:boolean;

(*----------------------------------------------------------------------*)
(*                                                                      *)
(*     Function:   Async_Carrier_Drop                                   *)
(*                                                                      *)
(*     Purpose:    Looks for modem carrier drop/timeout                 *)
(*                                                                      *)
(*     Calling Sequence:                                                *)
(*                                                                      *)
(*        Flag := Async_Carrier_Drop : BOOLEAN;                         *)
(*                                                                      *)
(*           Flag is set TRUE if carrier dropped, else FALSE.           *)
(*                                                                      *)
(*     Calls:  None                                                     *)
(*                                                                      *)
(*----------------------------------------------------------------------*)

begin
  Async_carrier_drop:=not (odd(port[UART_MSR+Async_base] shr 7) or
                           Async_hard_wired_on);
end;

(*----------------------------------------------------------------------*)
(*          Async_Line_Error --- Check if line status error occurred    *)
(*----------------------------------------------------------------------*)

function Async_line_error(var error_flags:byte):boolean;

(*----------------------------------------------------------------------*)
(*                                                                      *)
(*     Function:   Async_Line_Error                                     *)
(*                                                                      *)
(*     Purpose:    Check if line status error occurred                  *)
(*                                                                      *)
(*     Calling Sequence:                                                *)
(*                                                                      *)
(*        Flag := Async_Line_Error(VAR Error_Flags: BYTE): BOOLEAN;   *)
(*                                                                      *)
(*           Error_Flags --- Current error flags                        *)
(*                                                                      *)
(*           Flag returned TRUE if line status error occurred,          *)
(*           Flag returned FALSE if no error.                           *)
(*                                                                      *)
(*     Calls:  None                                                     *)
(*                                                                      *)
(*     Remarks:                                                         *)
(*                                                                      *)
(*        The line status error flag is cleared here.                   *)
(*                                                                      *)
(*----------------------------------------------------------------------*)

begin
  Async_line_error:=(Async_line_error_flags<>0);
  Error_flags:=Async_line_error_flags;
  Async_line_error_flags:=0;
end;

(*----------------------------------------------------------------------*)
(*            Async_Ring_Detect --- Check for phone ringing             *)
(*----------------------------------------------------------------------*)

function Async_ring_detect:boolean;

(*----------------------------------------------------------------------*)
(*                                                                      *)
(*     Function:   Async_Ring_Detect                                    *)
(*                                                                      *)
(*     Purpose:    Looks for phone ringing                              *)
(*                                                                      *)
(*     Calling Sequence:                                                *)
(*                                                                      *)
(*        Flag := Async_Ring_Detect : BOOLEAN;                          *)
(*                                                                      *)
(*           Flag is set TRUE if ringing detected, else FALSE.          *)
(*                                                                      *)
(*     Calls:  None                                                     *)
(*                                                                      *)
(*----------------------------------------------------------------------*)

begin
  Async_ring_detect:=odd(port[UART_MSR+Async_base] shr 6);
end;

(*----------------------------------------------------------------------*)
(*          Async_Send_Break --- Send break (attention) signal          *)
(*----------------------------------------------------------------------*)

procedure Async_send_break;

(*----------------------------------------------------------------------*)
(*                                                                      *)
(*     Procedure:  Async_Send_Break                                     *)
(*                                                                      *)
(*     Purpose:    Sends break signal over communications port          *)
(*                                                                      *)
(*     Calling Sequence:                                                *)
(*                                                                      *)
(*        Async_Send_Break;                                             *)
(*                                                                      *)
(*     Calls:  None                                                     *)
(*                                                                      *)
(*----------------------------------------------------------------------*)

var break_lcr,old_lcr:byte;

begin
  Old_Lcr   := Port[ UART_LCR + Async_Base ];
  Break_Lcr := Old_Lcr;

  IF Break_Lcr >  127 THEN Break_Lcr := Break_Lcr - 128;
  IF Break_Lcr <=  63 THEN Break_Lcr := Break_Lcr +  64;

  Port[ UART_LCR + Async_Base ] := Break_Lcr;

  DELAY( Async_Break_Length * 10 );

  Port[ UART_LCR + Async_Base ] := Old_Lcr;

end;

(*----------------------------------------------------------------------*)
(*     Async_Send_String --- Send string over communications port       *)
(*----------------------------------------------------------------------*)

PROCEDURE Async_Send_String( S : AnyStr );

(*----------------------------------------------------------------------*)
(*                                                                      *)
(*     Procedure:  Async_Send_String                                    *)
(*                                                                      *)
(*     Purpose:    Sends string out over communications port            *)
(*                                                                      *)
(*     Calling Sequence:                                                *)
(*                                                                      *)
(*        Async_Send_String( S : AnyStr );                              *)
(*                                                                      *)
(*           S --- String to send                                       *)
(*                                                                      *)
(*     Calls:  Async_Send                                               *)
(*                                                                      *)
(*----------------------------------------------------------------------*)

var i:integer;
begin
  for i:=1 to length(s) do Async_send(s[i]);
end;

(*----------------------------------------------------------------------*)
(*     Async_Send_String_With_Delays --- Send string with timed delays  *)
(*----------------------------------------------------------------------*)

procedure Async_send_string_with_delays(s:anystr;
                                        char_delay:integer;
                                        eos_delay:integer);

(*----------------------------------------------------------------------*)
(*                                                                      *)
(*     Procedure:  Async_Send_String_With_Delays                        *)
(*                                                                      *)
(*     Purpose:    Sends string out over communications port with       *)
(*                 specified delays for each character and at the       *)
(*                 end of the string.                                   *)
(*                                                                      *)
(*     Calling Sequence:                                                *)
(*                                                                      *)
(*        Async_Send_String_With_Delays( S          : AnyStr ;          *)
(*                                       Char_DelayTPU9     P .D  p0    P                                      ~     &      I  ]    8                                             h                8                      YMISC2  [5 8  YSYSTEM  s     YCRT  }   YDOS  K{   YOVERLAY  &  YCOMMON  8  YFILE2  l  &  SPSTAT        
           S	BULLETINS        
        0  SABBS        
           SANSIG         
              SYOURINFO (       
           STFILES 0       
           SULIST 8       
           SADDWISHLIST @       
           SSEEWISHLIST H       
           S
USERCONFIG P       
                   0                  
     0 B    X x     `      h      p 	     x            ( 0     8      @      H      P       8          C(  
  m     8     Z    ~  4 (   M
  COMMON  MISC2  SYSTEM  CRT  DOS  FILE2  ;	MISC2.PAS  Y|	REC04.PAS  New User Pass   : Board is        : ClosedOpenNumber Users    : Number calls    : Date & Time     : Active today    : Calls today     : Messages today  : Email sent today: Feed back today : Uploads today   : Sysop           : Disk free space : kSysop hours     : None: to Hit any keyU    P    W  W      W        ~W  W        >   t~W  W        ~W  W        W  W    W  RP            W  W    W6  6              W  W    W            W  W    W  RP            W  W    W  RP            W  W    W  RP            W  W    W  RP            W  W    W  RP            W  W    W  RP            W  W    W    P  W  W            W  W    W1P    RP          W        ~W  W          ;  u~W  W         WW  < RP          W    WW  < RP              W    WW  < RP              W    WW  < RP                >   u(        ~W  W        ~W    ]bulletin;bullet	bulletin;;Q?U帊    ~W^W P        ^ uF>   u  W^W P    )vW  W      W    ^W P      W^W    	u vW^W P  W^W    HP    W P    vW^W  W^W    @P  W^W    Њ^0+P    W P    *^WW P    ^WW P    W    >   t0и +vv}ǆv   W    xWv    vWxW    xW P    >   t x u  WxW P    xW  W    uW    xW  W     t@PxW  W     t@Z"Ѐx  t@"t!vWW    xW        xW  W     u@
  u] BBSLIST.DAT  
 ###-###-####:bbslist.msg             []TAG ()	Is this correct? Added to BBS list:U	    	W\W  W      W        W7P    W\W        W        Ɔ Ɔ P<W  W P        tW    <W\W      W        u)    W    <W  W      W        .W  W        :W  W         P    W P      u@Ѐ u@

  ulW<W  W      W        W        	 t@  Ɔ >   upW        uLW^W P            <W^W P P    W    uƆ렍W         t1     t <W  W    W        Ɔ W^W P    ^ u    OW    :W  W        ) P    W) P    <W<W^W      W      W    W    8 P    ^W P        W    :W  W         P    W P     u,<W^W      W    ^W P    ]<W^W      W      W      W    W      W      W    ^W P     u!    W    :W  W         P    W P     u <WW P P      W    t_<W^W      W      W      W    W      W      W    ^W P    ]<W^W      W      W      W    W      W      W    ^W P        ^WWW        *W  W        u  W*W  W      W         W        	t5 W*W  W      W         W         W^W1P             W        W  W        ^W     <W  W    BW        ]KB[;HU        W  W    tU W  W     WFRP          W     WFRP          W        >   t
FPFP    1  ]  YesNo U
    
  W~W	 P    ~ t*W~W      W    ~W	 P    (W~W      W    ~W	 P    W~W      W      W    ~W	 P    ~W~W P    ]  SL DSL calls posts letters letters min.U帢    F= uƆ^ = u"^W  W    ^W P    = u  W^W P    = u0^W  01RP      W    ^W P    b= u0^W  01RP      W    ^W P    -= u.^W  @RP      W    ^W P    = u0^W  01RP      W    ^W P    = u-^W  RP      W    ^W P    =	 u1^W    RP      W    ^W P    ]=
 ua^W  01RP      W    ^W P    >  v*^W^W      W    ^W P     = uX~W    ~W  W~W    ^W~W    RSP    ^W P     = u|~W    ~W  W~W    ^W~W    RSP        Y^_        RP      W    ^W P    =
 u  W^W P    ^W~
W P    ] !Display your account statistics?                                 
USTUFF.DAT years old @TYour name      : Phone number   : Sec Level      :  SLDL Sec Level   :  DSL# times on     : On today       : Public posts   : E-mail sent    : Mail waiting   : Time on today  : Total time ever: Last called    : Uh    h    u+~W  W        u>  uF>   uF xW  W P    ~W  W P      W        uFxW  W P    ~W  W P      W        uF ~W  W P      W      W P           W  W      W         P P  W  W      W         P P  W  W      W         P P  W  W      W         P P  W  W      W         P P  W  W      W         P	 P  W  W      W         P
 P  W  W    W  P             P P  W  W    W  W    RP          W      W         P P  W  W      W        C P P  W  W    W
P~W  W P         t@P          C P P  W  W    WP~W  W P         t@P          C P P  W  W    WP~W  W P         t@P          C P P  W  W    WP~W  W P         t@P           P P  W  W    W  01RP             P P  W  W    W  01RP             P P  W  W      W         P P  W  W      W         P P  W  W    W  01RP             P P  ~W  W         P P  W  W    W  RP             P P  W  W    W6  6               P P  W  W    W  RP            1  7 P P  W  W    W  RP            7 P P  W  W    W  RP            7 P P  W  W    W  RP            7 P P  W  W    W  01RP            7 P P  W  W    W  RP            7 P P  W  W    W6  6              7 P P  W  W    W  RP            7 P P  W  W    W6  6              7 P P  W  W    W  RP             P P      ~u    P  0P    ~ u   ~u+~W  W P      W      W P            tW  W      W        W  W      W        W  W    W  01RP          W        W  W    W  01RP          W        W  W    W  @RP            W  W    W  01RP                W  W    W  RP            W  W    W    RP            W  W    W	 PU          W  W    W
 PU          W  W    W PU          W  W    W PU          ][ Main Section ]U|     |~16zփ~ ~M~ǀWFRP        ~ǀW~W        ~W~&W P      W~&W P    F@FF~6;~ ~ǀWFRP        ~ǀW~W        ~ t@ЋF~6;ְ @"u ~W    tQ~6z֋~C 6z֋~ǅ׉~V~W~W( P    F~&E)~&E+F~&EAFF~6;4~ǀWFRP        ~ǀW~W        6~ t F~6;~ ~ǀWFRP        ~ǀW~W        ~W    Ѐ~ u@"tQ~6z֋~C 6z֋~ǅ׉~V~W~W( P    F~&E)~&E+ F~&EAFJ] 
No Tfiles.: * U        W  W    ~&W            ~6z u~W  W        =F F F ~  u@ЋF~6;zְ @"uW  W    WFRP          W      W      W    C f~ǅW    ~ǄW P      W    ȸC f~6;|2W  W    ~ǄW    ~ǄW P    0W  W    ~ǄW    ~ǄW P    ~ǄW~W~W    F] 
0123456789 U    ~W W P    Ɔ ~& W    P    ~W W P    WP     W    	 t@~&=  u@"t&ƆWP    ~W P    WP      W    	t?~&=s3W~W    WP        ~W P      u@~&=  t@"t.W~W P~&0HP    ~W P    _uL~&0䉆 ;)W  W        ;u~& Ɔ  
uƆ~&: sW  W        ~&: v"W~W~&0P P        
  u    ]
 *Extract text-file to temporary directory -Already in TEMP: 3\*.*Nothing. files totalling  bytes.
The limit is k bytes.You have exceeded this limit.6Please remove some files from the TEMP directory using/the user-archive command to free up some space.
T-file #:  3\Progress:  - Copy successful.)Copy unsuccessful - insufficient space!Copy unsuccessful!User copied t-file "" into TEMP directory.U>    >    W  W            W  W        11W  W      W    / P~W    >    u@ t2FV ~W    >    u@ǋuW  W        DW      W    W          W            t W  W    W  RP          W           1ۚ    ;|R;vL    W  W            W  W        W  W            W  W        WW  W    v    u@
  tW    ~6;zְ @Ѓ |@"utC ~6 u]~ǀWC ~6יRP        ~ǀW~
W        W  W    ~3W    W P    W  W      W    ~3W    W P    W  W        WWPWW     tW  W        3 tW  W        W  W        W  W    ~3W      W        ] 
gfiles.datNo Tfiles available today.==Skipped to next==[] Tfiles: (1-,?,Q) : QX?Q?X.No Tfiles there.U帊,    ,    ~WvW  W      W        ~Wv P        	t1~Wv P        1I~W
W        ~W11RP        ~W
W        IƆy Ɔx  uZW  W        1PU  Ɔv U  1~Ɔw 1|֚    x t'Ɔx Ɔ `W  W             vW  W    vW~֙RP          W      W      W    vWz֙RP          W         P    WrW  W    U       uB~;zu  WW P    "vW~@RP    W P    W  W    uU  W  W    u(w tƆw 1PU  U  |։~ƆvW  W    uU  W    ֋;zְ @Ѓ  ~@"uC ֋ u ~WC ֋יRP        ~W
W          W3W    	t1vW  W    3W    yWxWP     vW  W    3W        ։~]C ֋U  ։~փz ~U  ։|1~Ɔw"1PU      dW  W        v
  u2~W        ]	Users with access to "	"RUser Name                 :Computer Type                :Sex:Last onG       #    Users. ] UR
    R
>  װ t@ u  W' P            6      W  W      W      W      W            \W  W        fW  W          WP        11Ɔ   W        -  ȋڋ;|
;r Ѐ  u@"uK  WRP          WXW          W}RP          WW        W}  W    u W  W    WWXW      W    W}RP         P          W    WTW P          W      W    W`P          W     W    WW    r t       WW P    t*WW      W    W P    WW      W    W P    W  W    WRP        W    WW      W         u  W        ]%Do you want to add to the Wish List?  ^4Enter your file request below.: ^7Function Aborted!   wishlist.msgAdded request to Wish List.(^7Added your request to The Wish List...Ux    x    W  W        u        fW  W        W  W        WP P     utW  W        &W  W    W      W      W      W    W  W        ~WP P    WW  W      W        W        	t5WW  W      W        W        W~W1P            W        lW  W        ^W  W            ]wishlistU
     
    ~W  W        ]                                :^4[^0PCElite User Config^4]Ŀ^4 ^3[1].^5Real Name  ^2: ^4 ^3[2].^5Alias      ^2: ^4 ^3[3].^5Phone #    ^2: ^4 ^3[4].^5Address    ^2: ^4 ^3[5].^5Password   ^2: ^4 ^3[6].^5City,State ^2: ^4 ^3[7].^5Birthdate  ^2: ^4 ^3[8].^5Occuptaion ^2: ^4 ^3[9].^5Reference  ^2: ^4 ^3[A].^5Modem Speed^2: ^4 ^3[B].^5Screen Size^2: ^4 ^3[C].^5Computer   ^2: 6^4^5Note   : ^4[^0ONLINE^4]^4x.^4[^01-9^4] ^3 ^4[^0A-C^4] ^3 ^4[^0Q^4]^0uit^5Status : ^2[
QABC123456789^71^31^72^32^73^33^74^34^75^35^76^36^77^37^78^38^79^39^7A^3A^7BWide Is Screen (32-132) [] *                                          Lines Per Page (4-50) [^3B^7C^3CU帤    <W  W P      W      W P         P P   W  W         P P  @W  W         P P  @W  W         P P  @W  W         P P  @W  W         P P  @W  W         P P  @W  W         P P  @W  W         P	 P  @W  W         P
 P  @W  W         P P  @W  W         P P  @W  W         P
 P  @W  W         P P  $W  W         P P  BW  W        4 P P  XW  W        4 P P  XW  W        4 P P  XW  W        4 P P  XW  W        4 P P  XW  W        4 P P  XW  W        4 P P  XW  W        4 P	 P  XW  W        4 P
 P  XW  W        4 P P  XW  W        4 P P  XW  W        4 P
 P  XW  W        	 P     P P    W     P P    W     P P    W     P P    W     P P    W     P P    W     P P    W     P	 P    W     P
 P    W     P P    W     P P  \W  01RP      W    \W  01RP             P
 P    W     P P  ,W  W        JW  W        ~WNW  W        F<Qu
    Ɔ\<1u{ P P  XW  W         P P  ^W P    ^ t5^W  W$ P     P P  XW  W        <2u{ P P  XW  W         P P  ^W P    ^ t5^W  W$ P     P P  XW  W        <3u{ P P  XW  W         P P  ^W P    ^ t5^W  W P     P P  XW  W        <4u{ P P  XW  W         P P  ^W P    ^ t5^W  W P     P P  XW  W        <5u{ P P  XW  W         P P  ^W P    ^ t5^W  W P     P P  XW  W        <6u{ P P  XW  W         P P  ^W P    ^ t5^W  W P     P P  XW  W        <7u{ P P  XW  W         P P  ^W P    ^ t5^W  W P     P P  XW  W        <8u{ P	 P  XW  W         P	 P  ^W P    ^ t5^W  W( P     P	 P  XW  W        <9u{ P
 P  XW  W         P
 P  ^W P    ^ t5^W  W( P     P
 P  XW  W        <AuQ P P  XW  W         P P   P P  XW  W        <BtC P P  XW  W         P P  \W  W    \W  01RP          W        ]W    >   u]   P P  0W  W         P P  \W  W    \W  01RP          W        ]W    >   u]  >  2v  2>  s  >  v   P P  XW  W        |<Cux P
 P  XW  W         P
 P  ^W P    ^ t5^W  W P     P
 P  XW  W        ~Q u@
  u3<W  W P      W      W P        ]   0  7 0  C	P    N0X   S  X0x   ] 0  b	P   l0X   q 0`  v  |	P  & 0X    0  	P  - 0X    0  	P  2 0X      0  0x    0  	P  E 0X        0  0x    0  	P  X 
0X    0  0x    0  $	P  k /0X   4  -? 0  E0x   J 0  O	P  ~ Z0X   _  /j 0  p0x   u 0  z	P   0X     3 0  0x    0  	P   0X     5 0  0x    0  	P   0X     7 0  0x    0  	P   0X     ; 0  0x   ! 0  &	P   10X   6 0p  A  g G   L 0  Q0x   V 0`  [	P   f0X   k 0   y 0  0x   	P  0x    0  	P  0X    0`      	P  0X    0     0   0  	P  0x      0   0  0x   	P  !0x   &  7 0  C 0  H0x   M	P  R0x   W  h 0  u 0  z0x    0    >  0   0  	P  $0X    0   0  0  ' 0`   ?  0  D   Q 	P   W 0`   f 	P  s 0X   x   } 0x    0`    	P   0    	P   0    0p    0`    	P   0    	P  0   0p   0`   +0`   B0`   W 0  b   h  ( 0   0(   0h  0`      	P  0`   	P  0    0  	P  0   	P  &0   +0X   V0x   a 0  f	P  q0   v   0     	 0X    	P    0x    0H   0P   0   0   0`   0     8 0   	0    0  0X   )	P  .0x   3 0  8 0  D 0  O	P  Z0X   _  Qd0x   i 0p  n	P  y0X   ~ 0  	P   0X    0   0   0(       	0X   	P " 0x   0(  00  0        0  )0  .0  G0  L0  Q0p   j0   u0@  0   0  	P . 0X   0x    0p  0`    0   0  	P    0X    0  
 0   00  "0X   9	P 1 >0x   C	P 4 H0x   M0x   X 0x  a0`   p 0  u 0  	P   0X    0   0   0(  0X   	P 7 0x   0`   0X   	P @ 0x   	P C  0x   	P G 
0x   0x   	P @ 0x   $	P J )0x   .0`   = 0  L 0  W	P   b0X   g 0  l 0  u 0(  0p   	P L 0   0X   	P P 0x   	P S 0x   	P G 0x   0x   	P P 0x   	P V 0x   0`   0X   #	P P (0x   -	P S 20x   7	P X <0x   A0x   L	P P Q0x   V	P V [0x   `0`   o 0  t 0   0  	P [ 0X    0    	0X   	P " 0x   0(  0H  0    	0X   	P "  0x   0(  
08  0  0  .0  30  80@  C0  H	P m S0X   X 0  ] 0  h	P P u0X   z0x    0p  0     RM 	P    0   $ 	P  1 0X   6  0  G 0x   L 	P  Q 0x   V  0  g 0x   l 	P  q 0x   v  0   {   	  00      a 0   	P      0`   . 0X   D 	P   I 0x   N 0`   \ 0X   n 	P   s 0x   x 0`    0X    	P    0x    	P  
  0x    0`    0`    0  7   7[  0   ` 0`   o   o7| 0`      :  0   	P(    0x    0`      :  0   	P(   0x    0`      : 0  	P( 	 0x   0`   (  :; 0  D	P( 	 I0x   N0`   ]  :p 0  v	P(  {0x   0`     
:  : 0  	P(  0x   0`     : 0  	P(   0x   0`     : 0X   	P( ( 0x   0`   + 0  A  aO 0  ] 0  q 0x  y0`    0    a 0   0    9  90  0p  0   0  	P( * 0x   0`   
  70`   %0`   90  I 0   R	P0   c0X   h 0  m  Kz  K  80     80   	P0 " 0X  0p    80     80   	P0 " 0`  0p    80   	P0 " 0`    8$0   - 0  2  K8  	B0X   G	P0 B L0x   Q 0  V	     d	P0 M m0X   r  7w0x   | 0p  	     	P0 M 0X     570x    0p  	     	P0 M 0X     70x    0p  	     	P0 M 0X     70x    0p  	     	P0 M 0X     7#0x   ( 0p  -	     ;	P0 M D0X   I  o7N0x   S 0p  X	     f	P0 M o0X   t  90   0x    0p  	     	P0 M 0X     |7 0    0  0x   	P0 P 0x     |70x    0p  	     	P0 M 0X     U8 0x    0p  
	     	P0 M !0X   &  890   B0   G	 X   S0x   V 0p  [	     i	P0 M r0X   w  80   0   	 X   0x    0p  	     	P0 M 0X     80   0   	 X   0x    0p  	     	P0 M 0X     8,0   50   :	 X   F0x   I 0p  N	     \	P0 M e0X   j  :u 0  ~0x    0p  	     	P0 M 0X     : 0  0x    0p  	     	P0 M 0X     70x    0p  	     	P0 M 0X   	  70x    0p  	     &	P0 M /0X   4  :? 0  H0x   M 0p  R	     `	P0 \ h0X   m 0p  r	     	P0 M 0X     : 0  0x    0p  	     	P0 M 0X     9  9 0  0x    0p  	     	P0 M 0X     8:	 0  0x    0p    a 	     ,	P0 M 50X   :  :E 0  K0x   P 0p  U	     c	P0 M l0X   q  
:| 0  0x    0p  	     	P0 M 0X     : 0  0x    0p  	     	P0 M 0X     : 0  0x    0p  	     	P0 M 0X     :$ 0  *0x   / 0p  4	     B	P0 M K0X   P  