{--------------------------------------------------------------------------}
{                         TechnoJock's Turbo Toolkit                       }
{                                                                          }
{                              Version   5.01                              }
{                                                                          }
{                                                                          }
{              Copyright 1986, 1989 TechnoJock Software, Inc.              }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

                     {--------------------------------}                                       
                     {       Unit:  ListTTT5          }
                     {--------------------------------}


{$S-,R-,V-,D-}       

Unit ListTTT5;

interface

Uses CRT, DOS, FastTTT5, WinTTT5, KeyTTT5, StrnTTT5;

const
     Max_Topics = 255;

Type
   Choices = array[1..Max_Topics] of boolean;
   {$IFDEF VER50}
    List_Hook = Procedure(var Ch: char; HiPick:byte);
   {$ENDIF}
   L_Display = record
                     X           : byte;             {top X coord}
                     Y           : byte;             {top Y coord}
                     LeftSide    : Boolean;          {X,Y is leftside of box}
                     Lines       : byte;             {max no of lines to display in box}
                     TopicWidth  : byte;             {width of the slection bar}
                     AllowEsc    : boolean;          {allow the user to escape?}
                     BoxType     : byte;             {single,double etc}
                     BoxFCol     : byte;             {Border foreground color}
                     BoxBCol     : byte;             {Border background color}
                     CapFCol     : byte;             {Capital letter foreground color}
                     BacCol      : byte;             {menu background color}
                     NorFCol     : byte;             {normal foreground color}
                     HiFCol      : byte;             {highlighted topic foreground color}
                     HiBCol      : byte;             {highlighted topic background color}
                     LeftChar    : char;             {left-hand topic highlight character}
                     RightChar   : char;             {right-hand topic highlight character}
                     ToggleChar  : char;             {indicates if a topic has been selected}
                     AllowToggle : Boolean;          {can user select more than one topic}
                     End_Chars   : set of char;      {end of input chars}
                     Select_Chars: set of char;      {keys for user to select topic}
                     {$IFDEF VER50}
                     Hook: List_Hook; {a procedure called after every key is pressed}
                     {$ENDIF}
               end;

Var
   LTTT    : L_Display;
   L_Picks : Choices;
   L_Char  : Char;
   L_Pick  : Byte;
   {$IFNDEF VER50}
   L_UserHook  : pointer;
   {$ENDIF}

Procedure Default_Settings;
Procedure Show_List(var StrArray;StrLength:Byte;TotalPicks:byte);

IMPLEMENTATION
const
    Default_Display_Lines = 10;
    Default_Y1            = 7;

  {$IFDEF VER50}
  {$F+}
  Procedure No_Hook(var Ch: char; HiPick :byte);
  {}
  begin
  end; {of proc No_Hook}
  {$F-}
  {$ENDIF}

  Procedure Default_Settings;
  begin
      with LTTT do
      begin
          AlloWEsc := true;
          X := 0;
          Y := 0;
          LeftSide := true;
          BoxType      := 1;
          Lines := 0;
          TopicWidth   := 0;
          If BaseOfScreen = $B800 then
          begin
              BoxFCol      := yellow;
              BoxBCol      := blue;
              CapFCol      := White;
              BacCol       := blue;
      }
    write_msg:boolean=FALSE;      { is user writing a message?            }

    telluserevent:byte=0;     { has user been told about the up-coming event? }
    exiterrors:byte=254;          { ERRORLEVEL for Critical Error exit    }
    exitnormal:byte=255;          { ERRORLEVEL for Normal exit            }

    unlisted_filepoints=5;        { file points for unlisted downloads    }

var
    first_time:boolean;           { first time loading a menu?            }
    menustack:array[1..8] of string[12]; { menu stack                     }
    menustackptr:integer;         { menu stack pointer                    }
    last_menu,                    { last menu loaded                      }
    curmenu:string;                 { current menu loaded                   }
    menur:menurec;                { menu information                      }
    cmdr:array[1..50] of commandrec; { command information                }
    noc:integer;                  { # of commands on menu                 }
    fqarea,mqarea:boolean;        { file/message quick area changes       }

    doit,doitt:boolean;
    newdate:string[8];            { NewScan pointer date                  }
    lrn:integer;                  { last record # for recno/nrecno        }
    lfn:string;                     { last filename for recno/nrecno        }

    batchtime:real;               { }
    numbatchfiles:integer;        { # files in DL batch queue             }
    batch:array[1..20] of record
      fn:string[65];
      section:integer;
      pts:integer;
      blks:longint;
      tt:real;
    end;

    numubatchfiles:integer;       { # files in UL batch queue }
    ubatch:array[1..maxubatchfiles] of record
      fn:string[12];
      section:integer;
      description:string[65];
      filepass:string[30];
      vr:byte;
    end;
    ubatchv:array[1..maxubatchfiles] of ^verbrec;
    hiubatchv:integer;
    curcolor:integer;

function lenn(s:string):integer;
function center(S:String):integer;
function l
      'F':res:=(upcase(vs[1]) in u.ar);
      'G':res:=(u.sex=upcase(vs[1]));
      'H':begin
            gettime(hour,minute,second,sec100);
            res:=(hour=vsi);
          end;
      'P':res:=(u.filepoints>=vsi);
      'R':res:=(tacch(upcase(vs[1])) in u.ac);
      'S':res:=(u.sl>=vsi);
      'T':res:=(trunc(nsl) div 60>=vsi);
      'U':res:=(un=vsi);
      'V':res:=((u.sl>systat.newsl) or (u.dsl>systat.newdsl) or
           ((systat.newsl=systat.autosl) and (systat.newdsl=systat.autodsl)));
      'W':begin
            getdate(year,month,day,dayofweek);
            res:=(dayofweek=ord(s[1])-48);
          end;
      'Y':res:=(trunc(timer) div 60>=vsi);
    end;
    if (not boolstate) then res:=not res;
    argstat:=res;
  end;

begin
  s:=allcaps(s);
  i:=0;
  while (i<length(s)) do begin
    inc(i);
    c:=s[i];
    if (c in ['A'..'Z']) and (i<>length(s)) then begin
      getrest;
      b:=argstat(s1);
      delete(s,p1,length(s1));
      if (b) then s2:='^' else s2:='%';
      insert(s2,s,p1);
      dec(i,length(s1)-1);
    end;
  end;
  s:='('+s+')';
  while (pos('&',s)<>0) do delete(s,pos('&',s),1);
  while (pos('^^',s)<>0) do delete(s,pos('^^',s),1);
  while (pos('(',s)<>0) do begin
    i:=1;
    while ((s[i]<>')') and (i<=length(s))) do begin
      if (s[i]='(') then p1:=i;
      inc(i);
    end;
    p2:=i;
    s1:=copy(s,p1+1,(p2-p1)-1);
    while (pos('|',s1)<>0) do begin
      i:=pos('|',s1);
      c1:=s1[i-1]; c2:=s1[i+1];
      s2:='%';
      if ((c1 in ['%','^']) and (c2 in ['%','^'])) then begin
        if ((c1='^') or (c2='^')) then s2:='^';
        delete(s1,i-1,3);
        insert(s2,s1,i-1);
      end else
        delete(s1,i,1);
    end;
    while(pos('%%',s1)<>0) do delete(s1,pos('%%',s1),1);   {leave only "%"}
    while(pos('^^',s1)<>0) do delete(s1,pos('^^',s1),1);   {leave only "^"}
    while(pos('%^',s1)<>0) do delete(s1,pos('%^',s1)+1,1); {leave only "%"}
    while(pos('^%',s1)<>0) do delete(s1,pos('^%',s1),1);   {leavennmci(s:string):integer;
procedure loaduboard(i:integer);
procedure loadboard(i:integer);
function smci(c:char):string;
function GetOnePost:String;
procedure sprompt(s:string);
procedure tc(n:integer);
function mso:boolean;
function fso:boolean;
function cso:boolean;
function so:boolean;
function timer:real;
function fbaseac(b:byte):boolean;
function mbaseac(nb:integer):boolean;
procedure newcomptables;
procedure changefileboard(b:integer);
procedure changeboard(b:integer);
function freek(d:integer):longint;    (* See disk space *)
function nma:integer;
function okansi:boolean;
function okavatar:boolean;
procedure cline(var s:string; dd:string);
function nsl:real;
function ageuser(bday:string):integer;     (* returns age of user by birthdate *)
function allcaps(s:string):string;    (* returns a COMPLETELY capitalized string *)
function caps(s:string):string;                (* returns a capitalized string.. *)
procedure remove_port;
procedure iport;
{procedure initthething;}
function getwindysize(wind:integer):integer;
procedure commandline(s:string);
procedure sclearwindow;
procedure schangewindow(needcreate:boolean; newwind:integer);
function ccinkey1:char;
function cinkey1:char;
procedure gameport;
procedure sendcom1(c:char);
function recom1(var c:char):boolean;
procedure term_ready(ready_status:boolean);
procedure checkhangup;
function cinkey:char;
{procedure o(c:char);}
function intime(tim:real; tim1,tim2:integer):boolean;
					      (* check whether in time range *)
function sysop1:boolean;
function checkpw:boolean;
function sysop:boolean;
function stripcolor(o:string):string;
procedure sl1(s:string);
procedure sysoplog(s:string);
function tch(s:string):string;
function time:string;
function date:string;
function value(s:string):longint;
function cstr(i:longint):string;
function nam:string;
procedure shelldos(bat:boolean; cl:string; var rcode:integer);
procedure sysopshell(takeuser:boolean);
procedure readinzscan;
procedure savezscanr;
procedure redrawforansi;
function leapyear(yr:integer):boolean;
function days(mo,yr:integer):integer;
function daycount(mo,yr:integer):integer;
function daynum(dt:string):integer;
function dat:string;
procedure doeventstuff;
procedure getkey(var c:char);
procedure pr1(s:string);
procedure pr(s:string);
procedure sde; {* restore curco colors (DOS and tc) loc. after local *}
procedure sdc;
procedure stsc;
procedure setc(c:byte);
procedure cl(c:integer);
(*procedure promptc(c:char);*)
procedure dosansi(c:char);
procedure prompt(s:string);
function sqoutsp(s:string):string;
function exdrv(s:string):byte;
function mln(s:string; l:integer):string;
function mlnnomci(s:string; l:integer):string;
function mlnmci(s:string; l:integer):string;
function mrn(s:string; l:integer):string;
function mn(i,l:longint):string;
procedure pausescr;
procedure print(s:string);
procedure nl;
procedure prt(s:string);
procedure ynq(s:string);
procedure mpl(c:integer);
procedure tleft;
procedure prestrict(u:userrec);
procedure topscr;
procedure readinmacros;
procedure saveuf;
procedure loadurec(var u:userrec; i:integer);
procedure saveurec(u:userrec; i:integer);
function empty:boolean;
function inkey:char;
{procedure oc(c:char);}
procedure outkey(c:char);
function checkeventday(i:integer; t:real):boolean;
function checkpreeventtime(i:integer; t:real):boolean;
function checkeventtime(i:integer; t:real):boolean;
function checkevents(t:real):integer;
procedure dm(i:string; var c:char);
procedure cls;
procedure wait(b:boolean);
procedure swac(var u:userrec; r:uflags);
function tacch(c:char):uflags;
procedure acch(c:char; var u:userrec);
procedure sprint(s:string);
procedure lcmds(len,c:byte; c1,c2:string);
procedure autovalidate(var u:userrec; un:integer);
procedure rsm;
procedure inittrapfile;
procedure chatfile(b:boolean);
function aonoff(b:boolean; s1,s2:string):string;
function onoff(b:boolean):string;
function syn(b:boolean):string;
procedure pyn(b:boolean);
function yn:boolean;
function pynq(s:string):boolean;
procedure inu(var i:integer);
procedure ini(var i:byte);
procedure Box2(X,Y,O,P,F,B:Integer;I:Boolean);
procedure Locate(x,y,f,b:Integer;I:Boolean);
procedure XLocate(x,y:Integer);
procedure Acolor(F,B:Integer;Int:Boolean);
procedure inputwn1(var v:string; l:integer; flags:string; var changed:boolean);
procedure inputwn(var v:string; l:integer; var changed:boolean);
procedure inputwnwc(var v:string; l:integer; var changed:boolean);
procedure inputmain(var s:string; ml:integer; flags:string);
procedure inputwc(var s:string; ml:integer);
procedure input(var s:string; ml:integer);
procedure inputl(var s:string; ml:integer);
procedure inputcaps(var s:string; ml:integer);
procedure onek(var c:char; ch:string);
procedure local_input1(var i:string; ml:integer; tf:boolean);
procedure local_input(var i:string; ml:integer);
procedure local_inputl(var i:string; ml:integer);
procedure local_onek(var c:char; ch:string);
function centre(s:string):string;
procedure wkey(var abort,next:boolean);
function ctim(rl:real):string;
function tlef:string;
procedure printa1(s:string; var abort,next:boolean);
procedure printacr(s:string; var abort,next:boolean);
function longtim(dt:datetimerec):string;
function dt2r(dt:datetimerec):real;
procedure r2dt(r:real; var dt:datetimerec);
procedure timediff(var dt:datetimerec; dt1,dt2:datetimerec);
procedure getdatetime(var dt:datetimerec);
function cstrl(li:longint):string;
function cstrr(rl:real; base:integer):string;
procedure savesystat;  (* save systat *)
procedure pfl(fn:string; var abort,next:boolean; cr:boolean);
procedure printfile(fn:string);
function exist(fn:string):boolean;
procedure printf(fn:string);
procedure mmkey(var s:string);

procedure com_flush_rx;
function com_carrier:boolean;
function com_rx_empty:boolean;
procedure com_set_speed(speed:word);

procedure chat;
procedure skey(c:char);
procedure showudstats;
procedure skey1(c:char);
function verline(i:integer):string;
function aacs1(u:userrec; un:integer; s:string):boolean;
function aacs(s:string):boolean;

procedure DisableInterrupts;
procedure EnableInterrupts;

implementation

uses common1, common2, common3;

(*****************************************************************************\
 **
 **  These routines have been placed in the overlay to decrease the
 **  in-memory size of the BBS.  Routines that are used frequently, and are
 **  HIGHLY related to the overall speed of the BBS, have been kept out
 **  of the overlay file, and remain in memory at all times.
 **
\*****************************************************************************)
function checkpw:boolean; begin checkpw:=common1.checkpw; end;
procedure newcomptables; begin common1.newcomptables; end;
procedure cline(var s:string; dd:string); begin common1.cline(s,dd); end;
procedure pausescr; begin common1.pausescr; end;
procedure wait(b:boolean); begin common1.wait(b); end;
(*procedure fix_window; begin common1.fix_window; end;*)
procedure inittrapfile; begin common1.inittrapfile; end;
procedure chatfile(b:boolean); begin common1.chatfile(b); end;
procedure local_input1(var i:string; ml:integer; tf:boolean);
	  begin common1.local_input1(i,ml,tf); end;
procedure local_input(var i:string; ml:integer);
	  begin common1.local_input(i,ml); end;
procedure local_inputl(var i:string; ml:integer);
	  begin common1.local_inputl(i,ml); end;
procedure local_onek(var c:char; ch:string);
	  begin common1.local_onek(c,ch); end;
function chinkey:char; begin chinkey:=common1.chinkey; end;
procedure inli1(var s:string); begin common1.inli1(s); end;
procedure chat; begin common1.chat; end;
procedure sysopshell(takeuser:boolean);
	  begin common1.sysopshell(takeuser); end;
procedure globat(i:integer); begin common1.globat(i); end;
procedure exiterrorlevel; begin common1.exiterrorlevel; end;
proce