
Unit scroll;

Interface

Uses crt;

Procedure retrace;
Procedure movecharsleft (startingrow : Word);

Implementation

Const SSeg : Word = $b900; Hi = 24; wideness = 1;
  txt : String = 'DONOTDISTRIBUTEDONOTDISTRIBUTE';
  maxcols = 17; cols : Array [0..maxcols] Of Byte =
  (8, 8, 8, 7, 7, 7, 7, 15, 7, 15, 15, 15, 7, 15, 7, 7, 8, 7);
Var idx : Word; i, cur, Line, bitpos : Byte;
  ccol : Byte; colw : Byte; CH : Char;
  
Procedure retrace; Assembler;
Asm
  mov DX, 3dah;
  @l1: In AL, DX; Test AL, 8; jnz @l1;
  @l2: In AL, DX; Test AL, 8; jz @l2;
End;

Procedure movecharsleft (startingrow : Word); Assembler;
Asm
  push  DS;
  mov   AX, $b800;
  mov   DS, AX;
  mov   DI, 2
  @@MoveByte:
  add   DI, startingrow;
  mov   AL, [DS: DI];
  sub   DI, 2
  mov   [DS: DI], AL;
  sub   DI, startingrow;
  add   DI, 4
  cmp   DI, 160
  jl      @@MoveByte;
  pop   DS
End;

Procedure movecolsright (startingrow : Word); Assembler;
Asm
  push  DS
  mov   AX, $b800
  mov   DS, AX
  mov   DI, 161
  @@MoveByte:
  add   DI, startingrow
  sub   DI, 4
  mov   AL, [DS: DI]
  add   DI, 2
  mov   [DS: DI], AL
  sub   DI, startingrow
  cmp   DI, 0001
  ja      @@MoveByte
  pop   DS
End;


Begin
  TextAttr := 7; ClrScr; ccol := 1; idx := 1; colw := 0;
  Repeat
    Inc (colw);
    retrace;
    mem [$b800: Hi * 160 + 158] := Ord (txt [idx] );
    movecharsleft (Hi * 160);
    If (colw > 0) Then Begin
      colw := 1; Inc (ccol);
      mem [$b800: Hi * 160 + 1] := cols [ccol Mod (maxcols + 0) ];
      movecolsright (Hi * 160);
    End;
    If Not KeyPressed Then idx := 1 + idx Mod Length (txt);
  Until KeyPressed;
  While KeyPressed Do CH := ReadKey; TextAttr := 7; ClrScr;
End.

The push / pop DS might be superfluous... I don't know if you need them or not...
I'm just starting assembly, you know.  :^)
It's kinda like the one you made, but it doesn't lock up on my computer - - you
can't check port[$60] on XTs.  :^)
And in this, the colours move one way, and the text, the other.  It's kinda
distracting when you're trying to read the scroll, but oh well...
C-YA.

