Unit routine;
Interface
Uses DOS, crt;

Type
  CharSet = Set Of #0..#255; { This MUST be present for the routine to work }

Function Left (s: String; num: Integer): String;
Function value (s: String): Integer;
Function space (a: Integer): String;
Function ISTR (number: Integer): String;
Procedure LineInput (a: String; Left, Top: Integer);
Procedure stringstring (Length: Integer; Text: Char; vari: String);
Function Input (X, Y: Byte; StartStr, BackG, PassChar: String; MaxLen, StartPos:
               Integer; AcceptSet: CharSet; Ins: Boolean): String;

Implementation

Function value (s: String): Integer;
Var r, code: Integer;
Begin
  Val (s, r, code);
  value := r;
End;

Function ISTR (number: Integer): String;
Var s: String;
Begin
  Str (number, s);
  istr := s;
End;

Function Left (s: String; num: Integer): String;
Begin
  Left := Copy (s, 1, num);
End;

Function space (a: Integer): String;
Var s: String;
  loop: Integer;
Begin
  For loop := 1 To a Do s := s + ' ';
  space := s;
End;

Procedure stringstring (Length: Integer; Text: Char; vari: String);
Var loop: Integer;
Begin
  For loop := 1 To Length Do vari := vari + Text;
End;

Procedure LineInput (a: String; Left, Top: Integer);
Var tookin, posi, incount: Integer;
  hit: String;
  i: Char;
  go_on: Boolean;
Begin
  posi := Left;
  a := '';
  incount := 0;
  Repeat
    i := ReadKey;
    tookin := Length (i);
    If i = Chr (8) Then
    Begin
      If incount = 1 Then
      Begin
        If posi > Left Then
        Begin
          Write (#8 + #32 + #8);
          Dec (posi);
          Dec (incount);
          a := Copy (a, 1, Length (a) - 1);
        End;
      End;
    End;
    If i = Chr (13) Then go_on := True;
    If i > Chr ({&H1F <???> what's an equiv??} 20) Then
    Begin
      GotoXY (posi, Top);
      Write (i);
      a := a + i;
      incount := incount + tookin;
      posi := posi + 1;
    End;
  Until go_on;
  WriteLn;
End;

  { ------ START OF GENERAL ROUTINES ------ }

Function Mid (s: String; nr, nr2: Byte): String;
Begin
  Delete (s, 1, nr - 1);
  Delete (s, nr2 + 1, Length (s) );
  Mid := s;
End;

Procedure WriteXY (X, Y: Byte; s: String);
Var
  loop:   Word;
Begin (* This can be _higly_ optimized *)
  For loop := X To X + Length (s) - 1 Do
    Mem [$B800: (loop - 1) * 2 + (Y - 1) * 160] := Ord (S [loop - X + 1] );
End;

Function RepeatChar (s: String; antal: Byte): String;
Var
  temp: String;
Begin
  temp := s [1];
  While Length (temp) < Antal Do Insert (s [1], temp, 1);
  RepeatChar := Temp;
End;

Procedure NormalCursor; Assembler;
Asm
  mov AH, 1
  mov CH, 6
  mov CL, 7
  Int $10
End;

Procedure BlockCursor; Assembler;
Asm
  mov AH, 1
  mov CH, 0
  mov CL, 7
  Int $10
End;

{ ------ END OF GENERAL ROUTINES ------ }

Function Input (X, Y: Byte; StartStr, BackG, PassChar: String; MaxLen, StartPos:
               Integer; AcceptSet: CharSet; Ins: Boolean ): String; {Version 1.5}
Var
  P         : Byte;
  Exit      : Boolean;
  CH        : Char;
  ext       : Char;
  s         : String;
  t         : String [1];
  InputStatus: Byte;

Begin
  Exit := False;                                      { Don't quit on me yet! }
  If Length (PassChar) > 1 Then PassChar := PassChar [1]; { Just in Case... ;-) }
  If Length (BackG) > 1 Then BackG := BackG [1];
  If Length (BackG) = 0 Then BackG := ' ';
  If Length (StartStr) > MaxLen Then StartStr := Left (StartStr, MaxLen);
  If StartPos > Length (StartStr) Then StartPos := Length (StartStr);
  If StartPos = - 1 Then StartPos := Length (StartStr);
  If StartPos >= MaxLen Then StartPos := MaxLen - 1;
  InputStatus := 27;
  
  s := StartStr;                                { Put StartStr into Edit Buffer }
  WriteXY (X, Y, RepeatChar (BackG, MaxLen) );
  
  If StartStr <> '' Then Begin
    If passchar = '' Then WriteXY (X, Y, StartStr) Else
      WriteXY (X, Y, RepeatChar (PassChar, Length (StartStr) ) );
  End;
  
  p := StartPos;
  GotoXY (X + StartPos, Y);
  
  Repeat
    If Ins Then NormalCursor Else BlockCursor;
    ext := #0;
    CH := ReadKey;
    TextColor (15);
    If CH = #0 Then ext := ReadKey;
    If CH = #27 Then Begin
      InputStatus := 27;
      Exit := True;
    End;
    {   (ch<#255) and (ch>#31) }
    If CH In AcceptSet Then
    Begin   { Welcome to the jungle...}
      t := CH;
      If (p = Length (s) ) And (Length (s) < MaxLen) Then
      Begin
        s := s + t;
        If PassChar = '' Then WriteXY (X + P, Y, T) Else WriteXY (X + P, Y, PassChar);
        Inc (p);
      End Else
        If Length (s) < MaxLen Then Begin
          If Ins Then Insert (T, S, P + 1) Else s [p + 1] := CH;
          If PassChar = '' Then WriteXY (X + P, Y, Copy (S, P + 1, Length (S) ) ) Else
            WriteXY (X + Length (S) - 1, Y, PassChar);      Inc (p);
        End Else If (Length (s) = MaxLen) And (Not Ins) Then
        Begin
          s [p + 1] := CH;
          If PassChar = '' Then WriteXY (X + P, Y, T) Else WriteXY (X + P, Y, PassChar);
          Inc (p);
        End;
      CH := #0;
      If p > MaxLen - 1 Then p := MaxLen - 1;
      GotoXY (X + P, Y);
    End Else Begin
      
      Case CH Of { CTRL-Y }
        #25:
            Begin
              WriteXY (X, Y, RepeatChar (BackG, Length (S) ) );
              P := 0;
              S := '';
              GotoXY (X, Y);
            End;
        
        {Backspace}
        #8: If (P > 0) Then
        Begin
          If (p + 1 = MaxLen) And (p < Length (s) ) Then Ext := #83 Else
          Begin
            Delete (S, P, 1);
            Dec (P);
            GotoXY (X + P, Y);
            If PassChar = '' Then WriteXY (X + P, Y, Copy (S, P + 1, Length (s) ) + BackG) Else
              If P > 0 Then WriteXY (X + Length (s) - 1, Y, PassChar + BackG) Else
                WriteXY (X + Length (s), Y, BackG);
          End;
        End;
        
        #9:
           Begin { Exit on TAB }
             InputStatus := 9;
             Exit := True;
           End;
        
        #13:
            Begin
              InputStatus := 13;
              Exit := True;
            End;
      End; { Case CH of }
      
      Case ext Of
        #75: If P > 0 Then Begin
          {Left Arrow}      Dec (P);
          GotoXY (X + P, Y);
        End;
        
        #77: If (P < Length (s) ) And (P + 1 < MaxLen) Then Begin
          {Right Arrow}             Inc (P);
          GotoXY (X + P, Y);
        End;
        
        #82: Ins := Not (Ins); {Insert}
        {Delete}
        #83: If P < Length (s) Then
        Begin
          Delete (S, P + 1, 1);
          If PassChar = '' Then WriteXY (X + P, Y, Copy (S, P + 1, Length (s) ) + BackG) Else
            If p > 0 Then WriteXY (X + Length (S) - 1, Y, PassChar + BackG) Else
              WriteXY (X + Length (S), Y, BackG);
        End;
        
        #71:
            Begin
              p := 0;
              GotoXY (X + P, Y);
            End;
        
        #79: 
             Begin
               p := Length (s);
               If p >= MaxLen Then P := MaxLen - 1;
               GotoXY (X + P, Y);
             End;
        
        #72, #73, #80, #81, #59..#68:
                                     Begin
                                       InputStatus := Ord (Ext);
                                       Exit := True;
                                     End;
        
      End; {Case of EXT }
    End; { if not normal char }
    
  Until Exit;
  Input := S;
End;

End.