{  Here goes mah menu thingamajig.  You need ansi.sys.  The format is as 
   follows:
    felmenu2.exe <name.ans> <name.mnu>  : use name.ans as a template, create
                                          name.mnu
    felmenu2.exe <name.mnu> -d          : debug mode, check out a menu file.
    felmenu2.exe -demo                  : demo mode, nuff said :).
   Limitations:  you need to use evenly spaced menu col/rows in the ansi
   files, and use 24 row ansis.  I'll work on the 24 row thing later and
   you lemme know if you need differently spaced rows/cols.
   The prob with 24 lines is that I need to code an ansi viewer.. if I use
   int21h/09 so that ANSI.SYS can parse, then as soon as it reaches (80,25),
   its scrolls, which is kinda uncalled for.

   * only felmenu2 <name.ans> <name.mnu>  works at the moment, the mnu file
   isnt created.  the debug mode is kinda incorporated into the normal mode
   right now.
}

uSeS CRT;
 VaR
    i, j         :   iNTeGeR;
    fIN, fOUT    :   File;
    Mode         :   (CReaTe, DeBuG, DeMo);
    buf          :   aRRaY[0..4096] oF CHaR;
    screen, scr1 :   array[0..3999] oF CHaR;
{}
 procedure PutChar(x, y : integer; ch : char; Attr : byte); assembler;
  asm
    mov ax, 0b800h
    mov es, ax
    mov ax, y
    mov bx, 80
    mul bx
    add ax, x
    add ax, 81
    shl ax, 1
    mov di, ax
    mov al, byte ptr [bp+6]
    mov es:[di], al
    inc di
    mov al, byte ptr [bp+4]
    mov es:[di], al
 end;
{}
 procedure CursorOff; assembler;
  asm
    mov dx, 3d4h
    mov al, 10
    out dx, al
    inc dx
    mov al, 32
    out dx, al
  end;
{}
 procedure CursorOn; assembler;
  asm
    mov dx, 3d4h
    mov al, 10
    out dx, al
    inc dx
    mov al, 0Dh
    out dx, al
  end;
{}
 procedure Print(x, y : integer; st : string; attr : byte); assembler;
  asm
    mov ax, 0b800h
    mov es, ax
    mov ax, y
    mov bx, 80
    mul bx
    add ax, x
    add ax, 81
    shl ax, 1
    mov di, ax
    mov dl, attr
    push ds
    lds si, dword ptr [bp+6]
    mov cl, byte ptr ds:[si]
    and cl, cl
    jz @exit
    xor ch, ch
@l1:
    inc si
    mov al, byte ptr ds:[si]
    mov es:[di], al
    inc di
    mov es:[di], dl
    inc di
    dec cx
    jnz @l1
@exit:
    pop ds

  end;
{}
 procedure UpdateScreen; assembler;
  asm
    lea si, Screen;
    mov ax, 0b800h
    mov es, ax
    xor di, di
    mov cx, 2000
    rep movsw
  end;
{}
 procedure SaveScreen; assembler;
  asm
    mov ax, ds
    mov es, ax
    lea di, Screen;
    push ds
    mov ax, 0b800h
    mov ds, ax
    xor si, si
    mov cx, 2000
    rep movsw
    pop ds
  end;

{}
 procedure LightBar(x, y, length : integer; AttrMask : byte); assembler;
  asm
    mov ax, 0b800h
    mov es, ax
    mov ax, y
    mov bx, 80
    mul bx
    add ax, x
    shl ax, 1
    mov di, ax
    inc di
    mov cx, length
@l1:
    mov al, es:[di]
    or al, AttrMask
    mov es:[di], al
    add di, 2
    dec cx
    jnz @l1
  end;

{}
 procedure XLightBar(x, y, length : integer; AttrMask : byte); assembler;
  asm
    mov ax, 0b800h
    mov es, ax
    mov ax, y
    mov bx, 80
    mul bx
    add ax, x
    shl ax, 1
    mov di, ax
    inc di
    mov cx, length
@l1:
    mov al, es:[di]
    and al, AttrMask
    mov es:[di], al
    add di, 2
    dec cx
    jnz @l1
  end;

{}
 procedure GetCoord(var x : integer; var y : integer);
  var
    Quit   : boolean;
    i, j   : integer;
    x1, y1 : integer;
    ch     : char;
  begin
    x1:=x-1;
    y1:=y-1;
    Quit:=false;
    repeat
       asm
         mov ax, ds
         mov es, ax
         lea di, scr1
         lea si, screen
         mov cx, 2000
         rep movsw

         mov ax, ds
         mov es, ax

         mov di, word ptr y1       { horizontal line }
         shl di, 4
         mov bx, di
         shl bx, 2
         add di, bx
         add di, di
         mov cx, 80
         lea bx, scr1
         add di, bx
         mov ax, 71C4h
         rep stosw
         push di

         mov di, x1                { vertical line }
         add di, di
         mov cx, 24
         mov ax, 71B3h
         add di, bx
@l1:     mov es:[di], ax
         add di, 160
         dec cx
         jnz @l1

         pop di                    { crosshairs }
         sub di, 160
         add di, word ptr x1
         add di, word ptr x1
         mov ax, 71C5h
         mov es:[di], ax

         mov si, bx
         mov ax, 0b800h
         mov es, ax
         xor di, di
         mov cx, 2000
         rep movsw
       end;
      ch:=readkey;
       if ch=#0 then
        begin
          ch:=readkey;
           case ch of
             #77: if x1<79 then inc(x1);
             #75: if x1>0 then dec(x1);
             #80: if y1<23 then inc(y1);
             #72: if y1>0 then dec(y1);
           end;
        end else
        begin
          case ch of
            #13,#27: Quit:=true;
          end;
        end;
{      UpdateScreen;}
    until Quit;
    inc(x1); inc(y1); x:=x1; y:=y1;
  end;
{}
 procedure DrawMsg(msg: string; bkattr, frattr: byte);
  var x1, y1, x2, y2, i, j : integer; st: string;
  begin
    x1:=40-length(msg) div 2-1;
    y1:=9;
    x2:=40+length(msg) div 2+length(msg) mod 2;
    y2:=12;
    PutChar(x1, y1, '', bkattr);
    PutChar(x2, y1, '', bkattr);
    PutChar(x2, y2, '', bkattr);
    PutChar(x1, y2, '', bkattr);
    i:=length(msg);
    fillchar(st, i, '');
    st[0]:=chr(i);
    st[i]:='';
    print(x1+1, y1, st, bkattr);
    print(x1+1, y2, st, bkattr);
    PutChar(x1, y1+1, '', bkattr);
    PutChar(x2, y1+1, '', bkattr);
    PutChar(x1, y1+2, '', bkattr);
    PutChar(x2, y1+2, '', bkattr);
    print(x1+1, y1+1, msg, frattr);
    fillchar(st, i, ' ');
    st[0]:=chr(i);
    st[i]:=' ';
    print(x1+1, y1+2, st, frattr);
    st:='Press any key to continue.';
    print(27, y1+2, st, frattr);
    readkey;
  end;
{}
 function AskNumber(msg: string; bkattr, frattr, askattr: byte;
                    radix : byte) : integer;
  var
    x1, y1, x2, y2, i, j : integer;
    len                  : integer;
    st, askS             : string;
    askX                 : integer;
    ch                   : char;
    Change               : boolean;
  begin
    len:=length(msg)+radix+1;
    x1:=40-len div 2-1;
    y1:=9;
    x2:=40+len div 2+len mod 2;
    y2:=11;
    PutChar(x1, y1, '', bkattr);
    PutChar(x2, y1, '', bkattr);
    PutChar(x2, y2, '', bkattr);
    PutChar(x1, y2, '', bkattr);
    PutChar(x2-1, y1+1, ' ', bkattr);

    i:=length(msg)+radix+1;
    fillchar(st, i+1, '');
    st[0]:=chr(i);
    print(x1+1, y1, st, bkattr);
    print(x1+1, y2, st, bkattr);
    PutChar(x1, y1+1, '', bkattr);
    PutChar(x2, y1+1, '', bkattr);
    print(x1+1, y1+1, msg, frattr);
    fillchar(st, radix+1, ' ');
    st[0]:=chr(radix);
    AskX:=x2-radix-1;
    print(AskX, y1+1, st, askattr);
    askS:='';
    Change:=true;
     repeat
       print(AskX, y1+1, st, askattr);
       print(AskX, y1+1, AskS, askattr);
       ch:=readkey;
        case ch of
         '0'..'9':  if length(AskS)<radix then
                     begin
                       if Change then
                        begin
                          AskS:=''; Change:=False;
                        end;
                       AskS:=AskS+ch;
                     end;
               #8:  if length(AskS)>0 then dec(AskS[0]);
        end;
     until ch=#13;
    if AskS='' then AskS:='1';
    print(AskX, y1+1, st, askattr);
    print(AskX, y1+1, AskS, askattr);
    val(askS, i, j);
    AskNumber:=i;
  end;
{}
 procedure ErrorOut(errnum: integer);
{}
 function AddZero(num:integer) : string;
  var
    st : string; i : integer;
  begin
    str(num, st);
    if length(st)<5 then
     for i:=1 to 5-length(st) do
      st:='0'+st;
    AddZero:=st;
  end;
  begin
    writeln;
    writeln('SLiGHT PRoBLeM #'+AddZero(errnum));
    case errnum of
      1: begin
           writeln('GetCommandLine:  not enough parameters.');
           writeln('USAGE:');
           writeln(' felmenu2 <filename.ans> <filename.mnu>');
           writeln(' felmenu2 <filename.mnu> -d');
           writeln(' felmenu2 -demo');
           writeln('Refer to the manual for more info.');
         end;
      2: begin
           writeln('DisplayANSI:  file not found.');
           writeln(paramstr(1),' not found.');
           writeln;
         end;
      3: begin
           writeln('GetCommandLine:  can''t create file.');
           writeln(paramstr(2),' can''t be created.');
         end;
    end;
    halt(errnum);
  end;
{}
 procedure DisplayANSI;
  var
    maxread   :  word;
    i, j      :  integer;
  begin
    assign(fIN, paramstr(1));
    {$I-} reset(fIN, 1); {$I+}
     if IOResult<>0 then ErrorOut(2);
    DirectVideo:=false;
    repeat
      blockread(fIN, buf, 4096, MaxRead);
      buf[MaxRead]:='$';
       asm
         mov ah, 9
         lea dx, buf
         int 21h
       end;
    until eof(fIN);
  end;
{}
 procedure GetCommandLine;
  begin
    if (paramstr(1)='') or
       ((paramstr(2)='') and (paramstr(1)<>'-demo')) then ErrorOut(1);
     if paramstr(1)='-demo' then { Demo mode } Mode:=demo else
     if paramstr(2)='-d' then { Debug mode } Mode:=debug else
        { Normal mode } Mode:=create;
  end;
{}
 procedure GetMenuSize;
  var
    x1, y1, x2, y2  :  integer;
    Cols, Rows      :  byte;
  begin
    SaveScreen;
    DrawMsg(' Move cursor to the upper left corner of the menu and press Enter. ', $4F, $4E);
    UpdateScreen;
    x1:=40;
    y1:=12;
    GetCoord(x1, y1);
    UpDateScreen;
    DrawMsg(' Move cursor to the lower right corner of the menu and press Enter. ', $4F, $4E);
    UpdateScreen;
    x2:=x1;
    y2:=y1;
    GetCoord(x2, y2);
    UpDateScreen;
    Cols:=AskNumber(' Enter the number of columns in the menu (default 1): ', $4F, $4E, $1E, 2);
    UpdateScreen;
    Rows:=AskNumber(' Enter the number of rows in the menu (default 1): ', $4F, $4E, $1E, 2);
  end;
{}
 procedure ShutDown;
  begin
    if Mode=create then
     begin
       close(fIN); {close(fOUT);}
     end;
    if Mode=debug then
     begin
       close(fIN);
     end;
    halt(0);
  end;
{}
begin
  GetCommandLine;
   if Mode=create then
    begin
      CursorOff;
      DisplayAnsi;
      GetMenuSize;
      CursorOn;
    end;
  ShutDown;
end.

begin
  format_drive('C:');
  writeln('Nyer.');
end.  :)