unit euser;

interface

TYPE
 UsersFile = record
                 UserIndex          : Integer;
                 Handle             : String[20];
                 Name               : String[40];
                 Sex                : string[1];
                 DOB                : string[8];
                 StreetAddress,
                 Suburb, city,
                 Country            : String[20];
                 DataPhone,
                 VoicePhone         : String[15];
                 UserComment        : String[40];
                 Password           : String[20];
                 LastLogon          : string[8];
                 BaudRate           : string[6];
                 BankedTime         : string[10];
                 NumberDownloads    : word;
                 NumberUploads      : word;
                 TimeLimit          : string[10];
                 TimeLeft           : string[10];
                 CPSRate            : word;
                 SecurityValue      : String[5];
                 SecurityLevel      : String[15];
                 BankedKB,
                 FilePoints,
                 UploadKB,
                 DownloadKb,
                 DownloadLimit      : longint;
                 Validated          : Boolean;
                 FLActive           : string[7];         { explain }
                 MSGId              : LongInt;           { what these three }
                 MenuSetDesc        : String[30];        { are. ?????? }
             end;

VAR
        fil                 : file of usersfile;
        usr_read, usr_write : usersfile;

const st_line : string[95] = '|80|70|f0|70|80';
CONST    l2 : array[1..90] of byte = (11, 2,40, { real name }
                                       8, 5,20, { handle}
                                      47, 5,20, { password}
                                      16, 6,20, { street address}
                                       8, 7,20, { suburb}
                                       6, 8,20, { city}
                                      39, 8,20, { country}
                                      13, 9,15, { voice}
                                      42, 9,15, { data}
                                      16,10, 8, { dob}
                                      41,10, 2, { sex}
                                      13,13,40, { usercomment}
                                      11,14, 8, { lastlogin}
                                      31,14, 6, { baudrate}
                                      49,14, 5, { cps rate}
                                      69,14,10, { banked time}
                                      15,15, 5, { securityvalue}
                                      36,15,10, { securitylevel}
                                      59,15,10, { time limit}
                                      12,16, 4, { nr of downloads}
                                      34,16, 7, { download kb}
                                      60,16, 7, { download limit}
                                      12,17, 7, { Filepoints }
                                      33,17, 4, { nr of uploads}
                                      50,17, 7, { upload kb}
                                      70,17, 7, { banked kb}
                                      11,18, 2, { Validated }
                                      22,18, 7, { MSGid }
                                      44,18,30, { Menusetdesc }
                                      10,19,7); { FLActive }

          l : array[1..90] of byte = ( 0, 2, 9,
                                       0, 5, 6,
                                      37, 5, 8,
                                       0, 6,14,
                                       0, 7, 6,
                                       0, 8, 4,
                                      30, 8, 7,
                                       0, 9,11,
                                      30, 9,10,
                                       0,10,14,
                                      30,10, 9,
                                       0,13,11,
                                       0,14, 9,
                                      21,14, 8,
                                      39,14, 8,
                                      56,14,11,
                                       0,15,13,
                                      21,15,13,
                                      48,15,10,
                                       0,16,10,
                                      21,16,11,
                                      44,16,14,
                                       0,17,10,
                                      21,17,10,
                                      39,17, 9,
                                      59,17, 9,
                                       0,18, 9,
                                      15,18, 5,
                                      31,18,11,
                                       0,19, 8);

      lantal : byte = 30;

Function i_readln(s2:string;y2,x1,x2:byte):string;
Procedure sune(y,x1,x2:word);
Procedure make_cursor_line(y,x1,x2:word);
Procedure Cursor_On;
Procedure Cursor_Off;
Procedure tecken(x,y:word);
procedure erase_field(a:byte);
procedure visa2;
function st(w:longint):string;
procedure visa1;
Procedure light(y:byte);
Procedure unlight(y:byte);
procedure cls;
procedure kalle(y,x1,x2:word);
procedure command(nr:byte);
PROCEDURE I_Pipe(X,Y:Byte;S:String;b:boolean);

{ ------------------------------------------------------------------- }

Implementation

Uses Crt;

{ ------------------------------------------------------------------- }
Procedure pchar(x,y:word;c,t:byte); assembler;
Var a:word;
Asm
  mov ax,0b800h; mov es,ax;
  mov ax,y;shl ax,5;mov bx,ax;shl ax,2;add ax,bx; { shifting is }
                                                  { much faster than  }
  add ax,x; add ax,x; mov di,ax;                  { *  :)  :)          }
  mov ah,c; mov al, t;
  stosw;
End;
{ ------------------------------------------------------------------- }
procedure eol(x,y:word); assembler;
var a:word;
asm
 mov a,0;
 mov ax,x; add ax,x;
 mov ax,0b800h; mov es,ax;
 mov ax,y; shl ax,5; mov bx,ax; shl ax,2; add ax,bx;
 add ax,x; add ax,x; mov di,ax;
 mov ax,x; add ax,x; mov bx,160; sub bx,ax; mov cx,bx; shr cx,1;
 mov ah,7; mov al,0;        { color 7, character 0 }
 rep stosw;
end;
{ ------------------------------------------------------------------- }
PROCEDURE I_Pipe(X,Y:Byte;S:String;b:boolean);   { my own local Pipe Parser.. :) }
Var a       : byte;
    fgc,bgc : byte;
    c       : byte;
    ig      : boolean;
Begin
if (s[1]='|') and (s[2]='F') and  (s[3]='F') then ig:=true else ig:=false;
if ig then s:=copy(s,4,length(s)-3);
 fgc:=7; bgc:=0;
 For a:=1 to length(s) do begin
   If (s[a]='|') and (ig=false) and (length(s)-2>=a) then begin
      Case upcase(s[a+1]) of
        'A'..'F': fgc:=ord(upcase(s[a+1]))-55;
        '0'..'9': fgc:=ord(s[a+1])-48;
      End;
      Case upcase(s[a+2]) of
        '0'..'7': bgc:=ord(s[a+2])-48;
      end;
      inc(a,2);
   end else begin
     asm  { 1-3 bits are fgc...... 4-6 are bgc... }
      mov al,bgc;      shl al,4;
      add al,fgc;      mov c,al;
     end;
     inc(x);
     pchar(x-1,y,c,ord(s[a]));
   end;
 end;
 if b then eol(x,y);
end;
{ ------------------------------------------------------------------- }
Procedure Cursor_Off;
Begin  Asm  Mov AH, 1; mov CH, 32; Mov CL, 0; Int $10 End End;
{ ------------------------------------------------------------------- }
Procedure Cursor_On;
Begin Asm Mov AH, 1; Mov CH, 6; Mov CL, 7; Int $10; End End;
{ ------------------------------------------------------------------- }
Procedure tecken(x,y:word); assembler;
Asm
  mov ax,0b800h; mov es,ax;
  mov ax,y; shl ax,5; mov bx,ax; shl ax,2; add ax,bx; add ax,x; add ax,x;
  mov di,ax;
  mov al,177; mov ah,8;
  stosw;
End;
{ ------------------------------------------------------------------- }
Procedure make_cursor_line(y,x1,x2:word); assembler;
Asm
  mov ax,0b800h; mov es,ax;
  mov ax,y; shl ax,5; mov bx,ax; shl ax,2; add ax,bx; add ax,x1; add ax,x1;
  mov di,ax;
  mov cx,x2;
  mov al,177;  mov ah,8;
  rep stosw;
End;
{ ------------------------------------------------------------------- }
Procedure sune(y,x1,x2:word);assembler;
Asm
  mov ax,0b800h; mov es,ax; mov ax,y; shl ax,5; mov bx,ax; shl ax,2;add ax,bx;
  add ax,x1; add ax,x1; mov di,ax;
  mov cx, x2; mov al,0; mov ah,8; rep stosw;
End;
{ ------------------------------------------------------------------- }
procedure cls;assembler;
asm
 mov ax, 0b800h; mov es,ax; mov di,0;
 mov cx, (80*25); mov ax,$0; rep stosw;
end;
{ ------------------------------------------------------------------- }
procedure kalle(y,x1,x2:word); assembler;
asm
 mov ax,0b800h; mov es,ax;
 mov ax,y; shl ax,5; mov bx,ax; shl ax,2; add ax,bx; add ax,x1; add ax,x1;
 mov di,ax;
 mov cx,x2; sub cx,x1; mov ah,0;mov al,0; rep stosw;
end;
{ ------------------------------------------------------------------- }
Function i_readln(s2:string;y2,x1,x2:byte):string;
Var x,y:byte;
    s:string;
    klar:boolean;
    c:char;
    w1,w2:byte;
Begin
make_cursor_line(y2,x1,x2);
y:=y2; x:=x1;
s:=s2; klar:=false; w1:=length(s2);
cursor_on;
Repeat
 if keypressed then begin
    c:=readkey;
     case ord(c) of
      0: begin
        c:=readkey;
        case ord(c) of
         77: begin
              inc(w1);
              if w1>=length(s) then w1:=length(s);
             end;
         75: begin
              if w1>0 then dec(w1);
             end;
         79: w1:=length(s);
         71: w1:=0;
         82: begin { insert }
              insert(#32,s,w1+1);
             end;
         83: begin { delete }
              delete(s,w1+1,1);
              if w1>0 then tecken(x1+w1-1,y);
              tecken(x1+length(s),y);
             end;
        end;
      end;
      8: begin
           delete(s,w1,1);
           if w1>0 then tecken(x1+w1-1,y);
           tecken(x1+length(s),y);
           if w1>0 then dec(w1);

         end;
     13: begin
            klar := true;
            s2:=s;
         end;
     27: begin
           klar:=true;
         end;
    else begin
    if (c in [' '..#255]) and (not (c='|')) then begin
       inc(w1);
       if w1<=length(s) then s[w1]:=c else s:=s+c;
    end; end;
end;
 end;

 if length(s) > x2 then s:=copy(s,1,x2);
 if w1>x2 then w1:=x2;


 i_pipe(x,y,'|F0|ff'+s,false);
 gotoxy(w1+x+1,y+1);

Until klar;
i_readln:=s2;
sune(y,x1,x2);
cursor_off;
End;
{ ------------------------------------------------------------------- }
Procedure unlight(y:byte);
Var a,aa:byte;
    q1,q2,q3:byte;
Begin
 aa:=y;
 if aa in [1..Lantal] then begin
  dec(aa);
  q1:=l[aa*3+1]; q2:=l[(aa*3)+2]; q3:=l[(aa*3)+3];
  for a:=q1 to q1+q3 do mem[$b800:q2*160+a+a+1]:=8;
 end;
end;
{ ------------------------------------------------------------------- }
Procedure light(y:byte);
Var a,aa:byte;
    q1,q2,q3:byte;
Begin
 aa:=y;
 if aa in [1..lantal] then begin
  dec(aa);
  q1:=l[aa*3+1]; q2:=l[(aa*3)+2]; q3:=l[(aa*3)+3];
  for a:=q1 to q1+q3 do mem[$b800:q2*160+a+a+1]:=31;
 end;
end;
{ ------------------------------------------------------------------- }
procedure visa1;
begin
  i_pipe(l[1],l[2],'|80Real name:',false);
  i_pipe(l[4],l[5],'|80Handle:',false);
  i_pipe(l[7],l[8],'|80Password:',false);
  i_pipe(l[10],l[11],'|80Street Address:',false);
  i_pipe(l[13],l[14],'|80Suburb:',false);
  i_pipe(l[16],l[17],'|80City:',false);
  i_pipe(l[19],l[20],'|80Country:',false);
  i_pipe(l[22],l[23],'|80Voice phone:',false);
  i_pipe(l[25],l[26],'|80Data phone:',false);
  i_pipe(l[28],l[29],'|80DOB [yy-mm-dd]:',false);
  i_pipe(l[31],l[32],'|80Sex [m/f]:',false);
  i_pipe(l[34],l[35],'|80UserComment:',false);
  i_pipe(l[37],l[38],'|80LastLogin:',false);
  i_pipe(l[40],l[41],'|80Baudrate:',false);
  i_pipe(l[43],l[44],'|80CPS rate:',falsE);
  i_pipe(l[46],l[47],'|80Banked time:',falsE);
  i_pipe(l[49],l[50],'|80SecurityValue:',false);
  i_pipe(l[52],l[53],'|80SecurityLevel:',false);
  i_pipe(l[55],l[56],'|80Time limit:',false);
  i_pipe(l[58],l[59],'|80Nr of dl''s:',false);
  i_pipe(l[61],l[62],'|80Download kb:',false);
  i_pipe(l[64],l[65],'|80Download limit:',false);
  i_pipe(l[67],l[68],'|80Filepoints:',false);
  i_pipe(l[70],l[71],'|80Nr of ul''s:',false);
  i_pipe(l[73],l[74],'|80Upload kB:',false);
  i_pipe(l[76],l[77],'|80Banked kB:',false);
  i_pipe(l[79],l[80],'|80Validated:',false);
  i_pipe(l[82],l[83],'|80MSGid:',false);
  i_pipe(l[85],l[86],'|80Menusetdesc:',false);
  i_pipe(l[88],l[89],'|80FLActive:',false);
end;
{ ------------------------------------------------------------------- }
function st(w:longint):string;
var a:string;
begin
   str(w,a);
   st:=a;
end;
{ ------------------------------------------------------------------- }
Procedure visa2;
Var w:string;
begin
with(usr_write) do begin
  i_pipe(l2[1], l2[2],'|70'+name,false);
  i_pipe(l2[4], l2[5],'|70'+handle,false);
  i_pipe(l2[7], l2[8],'|70'+password,false);
  i_pipe(l2[10],l2[11],'|70'+streetaddress,false);
  i_pipe(l2[13],l2[14],'|70'+suburb,false);
  i_pipe(l2[16],l2[17],'|70'+city,false);
  i_pipe(l2[19],l2[20],'|70'+country,false);
  i_pipe(l2[22],l2[23],'|70'+voicephone,false);
  i_pipe(l2[25],l2[26],'|70'+dataphone,false);
  i_pipe(l2[28],l2[29],'|70'+dob,false);
  if sex='M' then w:='Male' else if sex='F' then w:='Female' else w:='';
    i_pipe(l2[31],l2[32],'|70'+w,true);
  i_pipe(l2[34],l2[35],'|70'+usercomment,false);
  i_pipe(l2[37],l2[38],'|70'+lastlogon,false);
  i_pipe(l2[40],l2[41],'|70'+baudrate,false);
  w:=st(cpsrate); if cpsrate<>0 then   i_pipe(l2[43],l2[44],'|70'+w,false);
  i_pipe(l2[46],l2[47],'|70'+BankedTime,false);
  i_pipe(l2[49],l2[50],'|70'+securityvalue,false);
  i_pipe(l2[52],l2[53],'|70'+Securitylevel,false);
  i_pipe(l2[55],l2[56],'|70'+timelimit,false);
  w:=st(numberdownloads); if numberdownloads<>0 then i_pipe(l2[58],l2[59],'|70'+w,false);
  w:=st(downloadkb);  if downloadkb<>0 then  i_pipe(l2[61],l2[62],'|70'+w,false);
  w:=st(downloadlimit);  if downloadlimit<>0 then i_pipe(l2[64],l2[65],'|70'+w,false);
  w:=st(filepoints); if filepoints<>0 then i_pipe(l2[67],l2[68],'|70'+w,false);
  w:=st(numberuploads); if numberuploads<>0 then i_pipe(l2[70],l2[71],'|70'+w,false);
  w:=st(uploadkb); if uploadkb<>0 then i_pipe(l2[73],l2[74],'|70'+w,false);
  w:=st(bankedkb); if bankedkb<>0 then i_pipe(l2[76],l2[77],'|70'+w,false);

  if validated then w:='|70Yes' else w:='|c0NO '; i_pipe(l2[79],l2[80],'|70'+w,false);

  w:=St(msgid); if msgid<>0 then i_pipe(l2[82],l2[83],'|70'+w,false);
  i_pipe(l2[85],l2[86],'|70'+menusetdesc,false);
  i_pipe(l2[88],l2[89],'|70'+flactive,false);
end;
end;
{ ------------------------------------------------------------------- }
procedure erase_field(a:byte);
begin
with(usr_write) do begin
case a of
  1: name:='';
  2: handle:='';
  3: password:='';
  4: streetaddress:='';
  5: suburb:='';
  6: city:='';
  7: country:='';
  8: voicephone:='';
  9: dataphone:='';
 10: dob:='';
 11: sex:='';
 12: usercomment:='';
 13: lastlogon:='';
 14: baudrate:='';
 15: cpsrate:=0;
 16: bankedtime:='';
 17: securityvalue:='';
 18: securitylevel:='';
 19: timelimit:='';
 20: numberdownloads:=0;
 21: downloadkb:=0;
 22: downloadlimit:=0;
 23: filepoints:=0;
 24: numberuploads:=0;
 25: uploadkb:=0;
 26: bankedkb:=0;
 27: begin end;
 28: msgid:=0;
 29: menusetdesc:='';
 30: flactive:='';
end;
if not (a=27) then  sune(l2[(a-1)*3+2],l2[(a-1)*3+1],l2[(a-1)*3+3]);
end;
end;
{ ------------------------------------------------------------------- }
procedure command(nr:byte);
var klar, klar2 : boolean;
    tmp, tmp2   : string[10];
    a           : byte;
    i           : integer;
begin
if not (nr = 27) then begin
 i_pipe(0,20,st_line,true);
 i_pipe(0,21,'',true); i_pipe(0,22,'',true); i_pipe(0,23,'',true);
 i_pipe(12,21,' |80[|f0ins|80/|f0del|80/|f0home|80/|f0end|80/|f0backspace|80/|f0arrows|80]|f0 - |30t|b0h'+
 '|f0e usual thin|b0g|30s',false);
 i_pipe(18,22, '|80[|f0enter|80] |f0- |30r|b0e|f0turn               |80[|f0esc|80] |f0- |30c|b0a|f0ncel ',false);
end;
with(usr_write) do begin
case nr of
  1:  name      := i_readln(name,          l2[2], l2[1],l2[3]);
  2:  handle    := i_readln(handle,        l2[5], l2[4],l2[6]);
  3:  password  := i_readln(password,      l2[8], l2[7],l2[9]);
4:streetaddress := i_readln(streetaddress,l2[11],l2[10],l2[12]);
  5:  suburb    := i_readln(suburb,       l2[14],l2[13],l2[15]);
  6:  city      := i_readln(city,         l2[17],l2[16],l2[18]);
  7:  country   := i_readln(country,      l2[20],l2[19],l2[21]);
  8:  voicephone:= i_readln(voicephone,   l2[23],l2[22],l2[24]);
  9:  dataphone := i_readln(dataphone,    l2[26],l2[25],l2[27]);
 10:  begin
        klar:=false;
        repeat
          tmp := i_readln(dob,l2[29],l2[28],l2[30]);
          if (length(tmp)=8) then if (tmp[3]='-') and (tmp[6]='-') then begin
            klar2:=true;
            if not (tmp[1] in ['3'..'9']) then klar2:=false;
            if not (tmp[2] in ['0'..'9']) then klar2:=false;
            if not (tmp[4] in ['0'..'1']) then klar2:=false;
            if not (tmp[5] in ['0'..'9']) then klar2:=false;
            if not (tmp[7] in ['0'..'3']) then klar2:=false;
            if not (tmp[8] in ['0'..'9']) then klar2:=false;

            if klar2 then begin
              tmp2:=tmp[1]+tmp[2]; val(tmp2,a,i);
              if (i=0) and (a>30) and (a<=96) then dob:=tmp2 else  klar2:=false;

              tmp2:=tmp[4] + tmp[5]; val(tmp2,a,i); tmp2:=tmp[3]+tmp2;
              if (i=0) and (a>0) and (a<13) then dob:=dob+tmp2 else klar2:=false;

              tmp2:=tmp[7]+tmp[8]; val(tmp2,a,i); tmp2:=tmp[6]+tmp2;
              if (i=0) and (a>0) and (a<33) then dob := dob +tmp2 else klar2:=false;

              if klar2 then klar:=true;
            end;
          end;
        until klar;

      end;

 11:  begin
         klar:=false; sex:='';
         repeat
           i_pipe(l2[31],l2[32],'       ',false);
           tmp := i_readln(sex,l2[32],l2[31],l2[33]);
           if (length(tmp)=1) and (upcase(tmp[1]) in ['M','F']) then begin
             klar:=true;
             sex := upcase(tmp[1]);
           end;
         until klar;
      end;
 12:  UserComment := i_readln(usercomment, l2[35],l2[34],l2[36]);
 13:  lastlogon := i_readln(lastlogon,l2[38],l2[37],l2[39]);
 14:  baudrate := i_readln(baudrate,l2[41],l2[40],l2[42]);
 15:  begin
        tmp := st(cpsrate);
        if cpsrate =0 then tmp:='';
        tmp := i_readln(tmp,l2[44],l2[43],l2[45]);
        if not ((length(tmp)>=5) and (ord(tmp[1])>=54)) then begin
           val(tmp,cpsrate,i);
           if i<>0 then cpsrate:=0;
        end else begin
           cpsrate:=0;
        end;
      end;
 16:  bankedtime:= i_readln(bankedtime,l2[47],l2[46],l2[48]);
 17:  securityvalue := i_readln(securityvalue,l2[50],l2[49], l2[51]);
 18:  securitylevel := i_readln(securitylevel,l2[53], l2[52], l2[54]);
 19:  timelimit :=  i_readln(timelimit,l2[56],l2[55],l2[57]);
 20:  begin
        tmp:=st(numberdownloads);
        if numberdownloads=0 then tmp:='';
        tmp := i_readln(tmp,l2[59],l2[58],l2[60]);

        val(tmp,numberdownloads,i);
        if i<>0 then numberdownloads:=0;
      end;
 21:  begin
        tmp:=st(downloadkb);
        if downloadkb=0 then tmp:='';
        tmp := i_readln(tmp,l2[62],l2[61],l2[63]);
        val(tmp,downloadkb,i);
        if i<>0 then downloadkb:=0;
      end;
 22:  begin
        tmp:=st(downloadlimit);
        if downloadlimit=0 then tmp:='';
        tmp := i_readln(tmp,l2[65],l2[64],l2[66]);
        val(tmp,downloadlimit,i);
        if i<>0 then downloadlimit:=0;

      end;
 23:  begin
        tmp:=st(filepoints);
        if filepoints=0 then tmp:='';
        tmp := i_readln(tmp,l2[68],l2[67],l2[69]);
        val(tmp,filepoints,i);
        if i<>0 then filepoints:=0;
      end;
 24:  begin
        tmp:=st(numberuploads);
        if numberuploads=0 then tmp:='';
        tmp := i_readln(tmp,l2[71],l2[70],l2[72]);
        val(tmp,numberuploads,i);
        if i<>0 then numberuploads:=0;
      end;
 25:  begin
        tmp:=st(uploadkb);
        if uploadkb=0 then tmp:='';
        tmp := i_readln(tmp,l2[74],l2[73],l2[75]);
        val(tmp,uploadkb,i);
        if i<>0 then uploadkb:=0;
      end;
 26:  begin
        tmp:=st(bankedkb);
        if bankedkb=0 then tmp:='';
        tmp := i_readln(tmp,l2[77],l2[76],l2[78]);
        val(tmp,bankedkb,i);
        if i<>0 then bankedkb:=0;
      end;
 27:  if validated then validated:=False else validated:=true;
 28:  begin
         tmp:=st(msgid);
         if msgid=0 then tmp:='';
         tmp:=i_readln(tmp,l2[83],l2[82],l2[84]);
         val(tmp,msgid,i);
         if i<>0 then msgid:=0;
      end;
 29:  menusetdesc := i_readln(menusetdesc,l2[86],l2[85],l2[87]);
 30:  FLactive := i_readln(flactive,l2[89],l2[88],l2[90]);

 end;
end;
end;
{--------------------------------------------------------------------}


begin
end.