package zinger.io.file;

import java.io.File;
import java.util.EventObject;

public class FileEvent extends EventObject
{
    public static final byte MODIFIED = 0;
    public static final byte DELETED = 1;
    public static final byte CREATED = 2;

    private final byte type;
    private final File file;

    public FileEvent(final Object source, final File file, final byte type)
    {
        super(source);
        this.file = file;
        this.type = type;
    }

    public File getFile()
    {
        return this.file;
    }

    public byte getType()
    {
        return this.type;
    }
}