{
 $Id$
}
{*****************************************************************************
 *
 * Purpose ...............: setup Export (Reports) used with fm_9.pas
 *
 * vbc 12/03/08 - added support for site Reports -> site.txt
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

  { export }

Var
  T : Text;
  I_File : Boolean;
  RFile_Open : Boolean;

Function Assign_T ( filename:string; tmp:string ) : Boolean;
Begin
  if not RFile_Open then
    Begin
     Assign(T,filename);
     {$I-} Rewrite(T); {$I+}
     If Ioresult <> 0 then
       Begin
         Assign_T := False;
         Exit;
       End;
    End;

    RFile_Open := True;
    Writeln(T,#13#10+replicate(79,'-'));
    Writeln(T,' FileMgr v'+verstr(setup.version)+Build+' - '+tmp);
    Writeln(T,' '+copyright);
    Writeln(T,replicate(79,'-'));
    Writeln(T,'');
    Assign_T := True;

End;



 {------------------------ NODES REPORT ---------------------------}


Function Nodes_List ( filename:string; full:boolean ) : Boolean;
Var
  Tmp   : String;
  X     : Integer;
  Count : Word;
Begin
  Writeat(1,25,7,0,expand('Working...',80));

  If not Assign_T(filename,'Nodes Report') then
    Begin
      Nodes_List := False;          { Can't open Report file }
      Exit;
    End;

  For X := 1 to NodeIdx do
    Begin
      Seek(nf,nfxt^[x].noderec);
      Blockread(nf,node,sizeof(node),count);
      If Count <> sizeof(node) then
        Begin
          If not I_File then
           Begin
            Close(T);
            RFile_Open := False;
           End;
          Nodes_List := False;
          Exit;
        End Else
        Begin
          If full then
            Begin

              Writeln(T,' System address       '+node2str(node.address));
              Writeln(T,' Main address         '+node2str(node.akaaddress));
              Writeln(T,' Operator name        '+node.sysopname);
              Writeln(T,' .TIC file password   '+node.password);
              Writeln(T,' AreaMgr password     '+node.mgrpassword);
              Writeln(T,' Available groups     '+writegroups(55,node.groups));
              Writeln(T,' Visible groups       '+writegroups(55,node.visible));
              Writeln(T,' Default new group    '+int_to_str(node.newgroup)+' - '+gfx[node.newgroup].groupname);
              Write(T,  ' .TIC file type       ');
                Case node.tictype of
                  0 : Writeln(T,'None');
                  1 : Writeln(T,'Antique');
                  2 : Writeln(t,'Advanced');
                 End;
              Write(T,' Packing method       ');
                 If packtic in node.defstatus then writeln(T,'Pack *.tic files') else
                 If packfile in node.defstatus then writeln(T,'Pack all files') else
                  Writeln(T,'No packing');
              Write(T,' Archiver             '+zipstr[node.archiver]);
{                Case node.archiver of
                  ZIP : writeln(t,'ZIP');
                  ARJ : writeln(t,'ARJ');
                  LZH : writeln(t,'LZH');
                  ARC : writeln(t,'ARC');
                  PAK : writeln(t,'PAK');
                End; }
              Writeln(T,' Maximum bundle size  '+int_to_str(node.maxsize));

              Tmp := '';
              if crash in node.defstatus then tmp := 'Crash ';
              if hold in node.defstatus then tmp := tmp + 'Hold ';
              if direct in node.defstatus then tmp := tmp + 'Direct';
              Writeln(T,' Default mail status  '+tmp);

              Tmp := '';
              if crash in node.mgrstatus then tmp := 'Crash ';
              if hold in node.mgrstatus then tmp := tmp + 'Hold ';
              if direct in node.mgrstatus then tmp := tmp + 'Direct';
              Writeln(T,' Manager mail status  '+tmp);

              if not node.billing then tmp := 'Disabled' else
                tmp := 'Enabled, '+real_to_str(node.credit,2)+' credit cents left';
              Writeln(T,' Costsharing          '+tmp);
              Writeln(T,' System status        Remote  '+yesno(remote in node.status)+'   %From  '+
                yesno(from in node.status)+'   Notify '+yesno(donotify in node.status)+'   Pause  '+
                yesno(pause in node.status));
              Writeln(T,'                      Magic   '+yesno(upmagic in node.status)+'   ForwRq '+
                yesno(forwreq in node.status)+'   AddNew '+yesno(addnew in node.status)+'   Create '+
                yesno(cancreate in node.status));
              Writeln(T,'                      Netmail '+yesno(netmail in node.status));
              Writeln(T,'');
              Writeln(T,'');

            End Else
            Begin
              Writeln(T,' '+expand(node2str(node.address),25)+' '+node.sysopname);
            End;
        End;
    End;

  If not full then
    Begin
      Writeln(T,'');
      Writeln(T,'');
    End;
  Writeln(T,'End of Report');
  Writeln(T,'');
  Writeln(T,'');

  Nodes_List := True;
  If not I_File then
    Begin
      Close(T);
      RFile_Open := False;
    End;
End;


  {----------------------- GROUPS REPORT -------------------------}


Function Groups_List ( filename:string; full:boolean ) : Boolean;
Var
  Tmp : String;
Begin
  Writeat(1,25,7,0,expand('Working...',80));

  Assign(gf,systempath+'groups.fm');
  {$I-} Reset(gf); {$I+}
  If ioresult <> 0 then
    Begin
      Groups_List := False;
      Exit;
    End;

  If not Assign_T(filename,'Groups Report') then
    Begin
      Groups_List := False;
      Exit;
    End;

  While not eof(gf) do
   Begin
     Read(gf,group);
     If full then
       Begin

         writeln(T,'Group number  '+int_to_Str(group.groupnr));
         writeln(T,'Description   '+group.groupname);
         writeln(T,'Format .TPL   '+group.format);
         writeln(T,'Directory     '+group.directory);
         writeln(T,'List file     '+group.listspec);
         writeln(T,'Batchfile     '+group.batchfile);
         writeln(T,'Description   '+group.defaultdesc);
         writeln(T,'Message file  '+group.msgfile);
         writeln(T,'Message(s)    '+writegroups(55,group.msgid));

         write(T,'Re-archive    ');
         If not (convert in group.Rearchive) then
           Writeln(t,'No') else
             Writeln(t,'Yes, to '+zipstr[group.usearchiver]);

         write(T,'Cleanup       ');
         If (group.Keepdays = 0) and (group.Keepamount = 0) then
           Writeln(t,'No') else
             If (group.Keepdays <> 0) and (group.Keepamount <> 0) then
               Writeln(t,'Max '+int_to_str(group.keepamount)+' files, '+int_to_str(group.keepdays)+' days') else
                 If group.Keepamount <> 0 then
                   Writeln(t,'Max '+int_to_str(group.keepamount)+' files') else
                     Writeln(t,'Max '+int_to_str(group.keepdays)+' days');

         write(T,'Replace mode  ');
         case group.replacemode of
           0 : writeln(t,'No replace');
           1 : writeln(t,'Hard replace');
           2 : writeln(t,'Move file');
         end;

         write(T,'Costsharing   ');
         if group.costperblock = 0 then writeln(t,'Disabled') else
           begin
             case group.block of
               0 : tmp := '100 kb';
               1 : tmp := '1024 kb';
               2 : tmp := 'file';
               3 : tmp := 'run';
             end;
             if group.addpercent <> 0 then tmp := tmp +' (+'+int_to_Str(group.addpercent)+'%)';
             writeln(t,int_to_str(group.costperblock)+' cents per '+tmp);
           end;

         writeln(T,'Status        Fuzzydup  '+yesno(fuzzydup in group.status)+'   CRC      '+yesno(crc in group.status)
           +'   Dupcheck '+yesno(dupcheck in group.status)+'   Tiny      '+yesno(tiny in group.status));
         writeln(T,'              Secure    '+yesno(secure in group.status)+'   Backup   '+yesno(backup in group.status)
           +'   Hide     '+yesno(hide in group.status)+'   VirusScan '+yesno(virus in group.status));
         writeln(T,'              ImportDiz '+yesno(importdiz in group.status)+'   LongDesc '+yesno(longdesc in group.status)
           +'   AnnNew   '+yesno(annnew in group.status)+'   HatchNew  '+yesno(hatchnew in group.status));

         write(T,'Seen-by       ');
           if group.aka > 0 then writeln(t,node2str(setup.address[group.aka])) else
             writeln(t,'Aka matching');
         writeln(T,'');
         writeln(T,'');
       End Else
       Begin
         Writeln(T,' '+expand(int_to_str(group.groupnr),5)+' '+group.groupname);
       End;
   End;

  If not full then
    Begin
      Writeln(T,'');
      Writeln(T,'');
    End;
  Writeln(T,'End of Report');
  Writeln(T,'');
  Writeln(T,'');

  Groups_List := True;
  Close(Gf);
  if not I_File then
    Begin
      Close(T);
      RFile_Open := False;
    End;
End;

  {----------------------------- AREAS REPORT ------------------------}


Function Areas_List ( filename:string; full:boolean ) : Boolean;
Var
  Tmp : String;
  X     : Integer;
  Count : Word;
Begin
  Writeat(1,25,7,0,expand('Working...',80));

  If MaxAvail < SizeOf(Sfxt^) then
    Begin
      Areas_List := False;
      Exit;
    End Else New(Sfxt);

  If not Assign_T(filename,'Areas Report') then
    Begin
      Dispose(Sfxt);
      Areas_List := False;
      Exit;
    End;

  For X := 1 to AreaIdx do
    Begin
      Seek(af,afxt^[x].arearec);
      Blockread(af,area,sizeof(area),count);
      If count = sizeof(area) then
        Begin
          BlockRead(Af, Sfxt^, area.exportnr*sizeof(exporttype), count);
          If count = area.exportnr*sizeof(exporttype) then
            Begin
              If full then
                Begin

                  writeln(t,'Area tag      '+area.tag);
                  writeln(t,'Description   '+area.name);
                  writeln(t,'Group ID      '+int_to_str(area.grp)+' - '+gfx[area.grp].groupname);
                  writeln(t,'Format .TPL   '+area.format);
                  writeln(t,'Directory     '+area.directory);
                  writeln(T,'List file     '+area.listspec);
                  writeln(t,'Batchfile     '+area.batchfile);
                  writeln(t,'Message file  '+area.msgfile);
                  writeln(t,'Message(s)    '+writegroups(55,area.msgid));

                  write(t,'Re-archive    ');
                  If not (convert in area.Rearchive) then
                    Writeln(t,'No') else
                      Writeln(t,'Yes, to '+zipstr[area.usearchiver]);

                  write(T,'Cleanup       ');
                  If (area.Keepdays = 0) and (area.Keepamount = 0) then
                    Writeln(t,'No') else
                      If (area.Keepdays <> 0) and (area.Keepamount <> 0) then
                        Writeln(t,'Max '+int_to_str(area.keepamount)+' files, '+int_to_str(area.keepdays)+' days') else
                          If area.Keepamount <> 0 then
                            Writeln(t,'Max '+int_to_str(area.keepamount)+' files') else
                              Writeln(t,'Max '+int_to_str(area.keepdays)+' days');

                  write(T,'Replace mode  ');
                  case area.replacemode of
                    0 : writeln(t,'No replace');
                    1 : writeln(t,'Hard replace');
                    2 : writeln(t,'Move file');
                  end;

                  write(T,'Costsharing   ');
                  if area.costperblock = 0 then writeln(t,'Disabled') else
                    begin
                      case area.block of
                        0 : tmp := '100 kb';
                        1 : tmp := '1024 kb';
                        2 : tmp := 'file';
                        3 : tmp := 'run';
                      end;
                      if area.addpercent <> 0 then tmp := tmp +' (+'+int_to_Str(area.addpercent)+'%)';
                      writeln(t,int_to_str(area.costperblock)+' cents per '+tmp);
                    end;

                  writeln(T,'Status        Fuzzydup  '+yesno(fuzzydup in area.status)+'   CRC      '+yesno(crc in area.status)
                    +'   Dupcheck '+yesno(dupcheck in area.status)+'   Tiny      '+yesno(tiny in area.status));
                  writeln(T,'              Secure    '+yesno(secure in area.status)+'   Backup   '+yesno(backup in area.status)
                    +'   Hide     '+yesno(hide in area.status)+'   VirusScan '+yesno(virus in area.status));
                  writeln(T,'              ImportDiz '+yesno(importdiz in area.status)+'   LongDesc '
                    +yesno(longdesc in area.status)
                    +'   AnnNew   '+yesno(annnew in area.status)+'   HatchNew  '
                    +yesno(hatchnew in area.status));
                  writeln(t,'              Notified  '+yesno(noti in area.status)+'   Discon.  '+yesno(disc in area.status));

                  write(T,'Seen-by       ');
                    if area.aka > 0 then writeln(t,node2str(setup.address[area.aka])) else
                      writeln(T,'Aka matching');

                  writeln(t,'');
                  writeln(t,'');

                End Else
                Begin
                  writeln(T,' '+expand(area.tag,17)+' '+area.name);
                End;
            End Else
            Begin
              Areas_List := False;
              Dispose(Sfxt);
              If not I_File then
                Begin                     {vbc 120208 }
                  Close(T);
                  RFile_Open := False;
                End;                      {vbc 120308 }
              Exit;
            End;
        End else
        Begin
          Areas_List := False;
          Dispose(Sfxt);
          If not I_File then
            Begin                     {vbc 120208 }
              Close(T);
              RFile_Open := False;
            End;                      {vbc 120308 }
          Exit;
        End;
    End;

  If not full then
    Begin
      Writeln(T,'');
      Writeln(T,'');
    End;
  Writeln(T,'End of Report');
  Writeln(T,'');
  Writeln(T,'');

  Dispose(Sfxt);
  If not I_File then
    Begin
      Close(T);
      RFile_Open := False;
    End;
  Areas_List := True;
End;



  {------------------------ GROUPS AND AREAS REPORT ----------------------}


Function G_AndAreas_List ( filename:string; bol:booleanset ) : Boolean;
Var
  cost, cblock : word;
  X     : Word;
  Count : Word;
Begin
  Writeat(1,25,7,0,expand('Working...',80));
  Assign(gf,systempath+'groups.fm');
  {$I-} Reset(gf); {$I+}
  If ioresult <> 0 then
    Begin
      G_AndAreas_List := False;
      Exit;
    End;

  If not Assign_T(filename,'Groups and Areas Report') then
    Begin
      G_AndAreas_List := False;
      Exit;
    End;


  While not eof(gf) do
   Begin
     Read(gf,group);
     If bol[group.groupnr] then
       Begin
         Writeln(T,' - ['+int_to_str(group.groupnr)+'] '+group.groupname);
         Writeln(T,'');

         if (group.costperblock <> 0) or group.incluplink then
           begin
             cost := group.costperblock;
             cblock := group.block;
             write(t,' Costs: '+int_to_str(group.costperblock)+' cents per ');
             case group.block of
               0 : write(t,'100 Kb');
               1 : write(t,'1024 Kb');
               2 : write(t,'file');
             end;
             if group.incluplink then write(t,' + costs uplink');
             if group.alllinks then writeln(t,' (for all connected systems + host)')
               else writeln(t,' (for all connected systems)');
             writeln(t,'');
           end else
           begin
             cost := 0;
             cblock := 0;
           end;

         For X := 1 to AreaIdx do
           Begin
             If afxt^[x].grp = group.groupnr then
               Begin
                 Seek(af,afxt^[x].arearec);
                 Blockread(af,area,sizeof(area),count);
                 If count = sizeof(area) then
                   Begin
                     Writeln(T,' '+expand(area.tag,17)+' '+area.name);
                   End Else
                   Begin
                     If not I_File then
                       Begin
                         Close(T);
                         RFile_Open := False;
                       End;
                     G_AndAreas_List := False;
                     Exit;
                   End;
               End;
           End;
         Writeln(T,'');
         Writecolor(25,7,15,0,expand(group.groupname,79));
       End;
   End;
  Writeln(T,'');
  Writeln(T,'End of Report');
  Writeln(T,'');
  Writeln(T,'');

  G_AndAreas_List := True;
  Close(Gf);
  If not I_File then
    Begin
      Close(T);
      RFile_Open := False;
    End;
End;


 {---------------------- GROUPS AND NODES REPORT -------------------------}


Function G_AndNodes_List ( filename:string; bol:booleanset ) : Boolean;
Var
  X, y   : Word;
  Count  : Word;
  Sysfxt : ^SystemList;
  InSys  : Word;
  Tmp    : String[50];
Begin
  Writeat(1,25,7,0,expand('Working...',80));

  If MaxAvail < SizeOf(Sfxt^) then
    Begin
      G_AndNodes_List := False;
      Exit;
    End Else New(Sfxt);

  If MaxAvail < Sizeof(Sysfxt^) then
    Begin
      Dispose(Sfxt);
      G_AndNodes_List := False;
      Exit;
    End Else New(SysFxt);

  If not Assign_T(filename,'Groups and Nodes Report') then
    Begin
      G_AndNodes_List := False;
      Dispose(Sfxt);
      Dispose(SysFxt);
      Exit;
    End;

  Assign(gf,systempath+'GROUPS.FM');
  {$I-} Reset(gf); {$I+}
  If ioresult <> 0 then
    Begin
      If not I_File then
        Begin
          Close(T);
          RFile_Open := False;
        End;
      Dispose(Sfxt);
      Dispose(SysFxt);
      G_AndNodes_List := False;
      Exit;
    End;

  While not eof(gf) do
   Begin
     Read(gf,group);

     If bol[group.groupnr] then
       Begin

         Writeln(T,' - ['+int_to_str(group.groupnr)+'] '+group.groupname);
         Writeln(T,'');
         insys := 0;

         For X := 1 to AreaIdx do
           Begin
             If afxt^[x].grp = group.groupnr then
               Begin
                 Seek(af,afxt^[x].arearec);
                 Blockread(af,area,sizeof(area),count);
                 If count = sizeof(area) then
                   Begin
                     BlockRead(Af, Sysfxt^, area.exportnr*sizeof(exporttype), count);
                     If count = area.exportnr*sizeof(exporttype) then
                       Begin
                         for y := 1 to area.exportnr do
                           Begin
                             if not is_dup(insys,sysfxt^[y].a) then
                               Begin
                                 inc(insys);         { sysfxt^ vullen met systemen }
                                 move(sysfxt^[y],sfxt^[insys],sizeof(exporttype));
                               End;
                           End;
                       End Else
                       Begin
                         If not I_File then
                           Begin
                             Close(T);
                             RFile_Open := False;
                           End;
                         Close(gf);
                         Dispose(Sfxt);
                         Dispose(SysFxt);
                         G_AndNodes_List := False;
                         Exit;
                       End;
                   End Else
                   Begin
                     If not I_File then
                        Begin
                          Close(T);
                          RFile_Open := False;
                        End;
                     Close(gf);
                     Dispose(Sfxt);
                     Dispose(SysFxt);
                     G_AndNodes_List := False;
                     Exit;
                   End;
               End;
           End;

          { sysfxt^ wegschrijven naar T }
          SortSystemlist(insys);
          For y := 1 to insys do
            Begin
              Write(T,' '+expand(node2str(sfxt^[y].a),27));
              Tmp := '<unknown>';
              For X := 1 to Nodeidx do
                Begin
                  If samerec(nfxt^[x].address,sfxt^[y].a,sizeof(nodetype)) then
                    Begin
                      Seek(nf,nfxt^[x].noderec);
                      BlockRead(nf,node,sizeof(node),count);
                      If count <> sizeof(node) then
                        Begin
                          Askwindow('','Error reading nodefile.fm','',[#13,#32,#27]);
                          Dispose(sfxt);
                          Dispose(Sysfxt);
                          Close(Gf);
                          If not I_File then
                            Begin
                              Close(T);
                              RFile_Open := False;
                            End;
                          G_AndNodes_List := False;
                          Exit;
                        End Else
                          Tmp := node.sysopname;
                    End;
                End;
              Writeln(T,expand(Tmp,35)+' '+node_bits_status(sfxt^[y].s));
            End;
          Writeln(T,'');
          Writecolor(25,7,15,0,expand(group.groupname,79));
       End;
   End;

  Writeln(T,'');
  Writeln(T,'End of Report');
  Writeln(T,'');
  Writeln(T,'');

  G_AndNodes_List := True;
  Dispose(Sfxt);
  Dispose(SysFxt);
  If not I_File then
    Begin
      Close(T);
      RFile_Open := False;
    End;
  Close(Gf);
End;


 {----------------------- AREAS AND NODES REPORT -------------------------}


Function A_AndNodes_List ( filename:string; bol:booleanset ) : Boolean;
Var
  X, Y, Z, Count : Word;
  Tmp : String[50];
Begin
  Writeat(1,25,7,0,expand('Working...',80));

  If not Assign_T(filename,'Areas and Nodes Report') then
    Begin
      A_AndNodes_List := False;
      Exit;
    End;

  If MaxAvail < SizeOf(Sfxt^) then
    Begin
      If not I_File then
        Begin
          Close(T);
          RFile_Open := False;
        End;
      A_AndNodes_List := False;
      Exit;
    End Else New(Sfxt);

  For X := 1 to AreaIdx do
    Begin
      If bol[afxt^[x].grp] then
        Begin
          Seek(af,afxt^[x].arearec);
          Blockread(af,area,sizeof(area),count);
          If count = sizeof(area) then
            Begin
              BlockRead(Af, Sfxt^, area.exportnr*sizeof(exporttype), count);
              If count = area.exportnr*sizeof(exporttype) then
                Begin
                  Writeln(T,' - ['+area.tag+'] '+area.name);
                  Writeln(T,'');
                  For y := 1 to area.exportnr do
                    Begin
                      Write(T,' '+expand(node2str(sfxt^[y].a),27));
                      Tmp := '<unknown>';
                      For z := 1 to Nodeidx do
                        Begin
                          If samerec(nfxt^[z].address,sfxt^[y].a,sizeof(nodetype)) then
                            Begin
                              Seek(nf,nfxt^[z].noderec);
                              BlockRead(nf,node,sizeof(node),count);
                              If count <> sizeof(node) then
                                Begin
                                  Askwindow('','Error reading nodefile.fm','',[#13,#32,#27]);
                                  Dispose(sfxt);
                                  If not I_File then
                                    Begin
                                      Close(T);
                                      RFile_Open := False;
                                    End;
                                  A_AndNodes_List := False;
                                  Exit;
                                End Else
                                  Tmp := node.sysopname;
                            End;
                        End;
                      Writeln(T,expand(Tmp,35)+' '+node_bits_status(sfxt^[y].s));
                    End;
                  Writeln(T,'');
                  Writecolor(25,7,15,0,expand(area.tag,79));
                End Else
                Begin
                  If not I_File then
                    Begin
                      Close(T);
                      RFile_Open := False;
                    End;
                  Dispose(Sfxt);
                  A_AndNodes_List := False;
                  Exit;
                End;
            End Else
            Begin
              If not I_File then
                Begin
                  Close(T);
                  RFile_Open := False;
                End;
              Dispose(Sfxt);
              A_AndNodes_List := False;
              Exit;
            End;
        End;
    End;
  Writeln(T,'');
  Writeln(T,'End of Report');
  Writeln(T,'');
  Writeln(T,'');

  A_AndNodes_List := True;
  Dispose(Sfxt);
  If not I_File then
    Begin
      Close(T);
      RFile_Open := False;
    End;
End;


 {------------------------- MEMBER REPORT ----------------------------}
    { This Report not done for All Full Reports    }

Function Member_List ( filename:string; nop:nodetype ) : Boolean;
Var
  X, Count : Word;
Begin
  Writeat(1,25,7,0,expand('Working...',80));

  If not Assign_T(filename,'Member Report for '+node2str(nop)) then
    Begin
      Member_List := False;
      Exit;
    End;

  If MaxAvail < SizeOf(Sfxt^) then
    Begin
      Close(T);
      Member_List := False;
      Exit;
    End Else New(Sfxt);

  For X := 1 to AreaIdx do
    Begin
      Seek(af,afxt^[x].arearec);
      Blockread(af,area,sizeof(area),count);
      If count = sizeof(area) then
        Begin
          BlockRead(Af, Sfxt^, area.exportnr*sizeof(exporttype), count);
          If count = area.exportnr*sizeof(exporttype) then
            Begin
              If is_dup(area.exportnr,nop) then            { if nop in sfxt^ }
                Begin
                  Writeln(T,' '+expand(area.tag,17)+' '+area.name);
                End;
            End Else
            Begin
              Close(T);
              Dispose(Sfxt);
              Member_List := False;
              Exit;
            End;
        End Else
        Begin
          Close(T);
          Dispose(Sfxt);
          Member_List := False;
          Exit;
        End;
    End;

  Writeln(T,'');
  Writeln(T,'');
  Writeln(T,'End of Report');
  Writeln(T,'');
  Writeln(T,'');

  Member_List := True;
  Dispose(Sfxt);
  Close(T);
End;


 {------------------------- FLOW REPORT ----------------------------}


Procedure WriteFlow( flow:flowtype; lastmonth:byte );
Var
  Tmp,Tmp1,
  Tmp2     : string;
  dummy    : byte;
  months   : byte;
  avbytes,
  avfiles  : longint;
begin
  months  := 0;
  avbytes := 0;
  avfiles := 0;

  for dummy := 1 to 12 do
    begin
      if flow[dummy].bytes >= 0 then
        begin
          avbytes := avbytes + flow[dummy].bytes;
          inc (months);
        end;
      if flow[dummy].files >= 0 then avfiles := avfiles + flow[dummy].files;
    end;
  if months = 0 then tmp := '' else
    begin
      avbytes  := round((avbytes/months)/1024);
      avfiles  := round(avfiles/months);
      tmp := int_to_str(avbytes)+' '+int_to_str(avfiles)+' '+int_to_str(months);
    end;

  If Tmp = '' then
    Begin
      Writeln(T,' No flow ');
    End Else
    Begin
      Tmp1 := Extractwords(1,1,Tmp)+'Kb in '+Extractwords(2,1,Tmp)+' files.';

      case lastmonth of
       0 : tmp2 := '-';
       1 : tmp2 := 'January';
       2 : tmp2 := 'February';
       3 : tmp2 := 'March';
       4 : tmp2 := 'April';
       5 : tmp2 := 'May';
       6 : tmp2 := 'June';
       7 : tmp2 := 'July';
       8 : tmp2 := 'August';
       9 : tmp2 := 'September';
      10 : tmp2 := 'October';
      11 : tmp2 := 'November';
      12 : tmp2 := 'December';
      end;

      Writeln(T,' Average flow over '+extractwords(3,1,tmp)+' months: '+Tmp1);
      Writeln(T,' Last month was: '+tmp2);
    End;
End;



Function Flow_List ( filename:string; flow:byte ) : Boolean;
Var
  X, Count : Word;
Begin
  Writeat(1,25,7,0,expand('Working...',80));

  If not Assign_T(filename,'Flow Report') then
    Begin
      Flow_List := False;
      Exit;
    End;

  Case flow of
   1 : Begin
         For X := 1 to AreaIdx do
           Begin
             Seek(af,afxt^[x].arearec);
             Blockread(af,area,sizeof(area),count);
             If count = sizeof(area) then
               Begin
                 writeln(T,' '+area.tag+' - '+area.name);
                 writeflow(area.flow,area.lastmonth);
                 writeln(T,'');
               End Else
               Begin
                 Flow_List := False;
                 If not I_File then
                   Begin
                     Close(T);
                     RFile_Open := False;
                   End;
                 Exit;
               End;
           End;
       End;
   2 : Begin
         Assign(gf,systempath+'groups.fm');
         {$I-} Reset(gf); {$I+}
         If ioresult <> 0 then
           Begin
             Flow_List := False;
             If not I_File then
                Begin
                  Close(T);
                  RFile_Open := False;
                End;
             Exit;
           End;

         While not eof(gf) do
           Begin
             Read(gf,group);
             Writeln(T,' '+int_to_str(group.groupnr)+' - '+group.groupname);
             Writeflow(group.flow,group.lastmonth);
             Writeln(T,'');
           End;

         Close(gf);
       End;
   3 : Begin
         For X := 1 to NodeIdx do
           Begin
             Seek(nf,nfxt^[x].noderec);
             Blockread(nf,node,sizeof(node),count);
             If Count <> sizeof(node) then
               Begin
                 If not I_File then
                   Begin
                     Close(T);
                     RFile_Open := False;
                   End;
                 Flow_List := False;
                 Exit;
               End Else
               Begin
                 Writeln(T,' '+node2str(node.address)+' - '+node.sysopname);
                 Writeflow(node.flow,node.lastmonth);
                 Writeln(T,'');
               End;
           End;
       End;
  End;

  Writeln(T,'');
  Writeln(T,'');
  Writeln(T,'End of Report');
  Writeln(T,'');
  Writeln(T,'');

  Flow_List := True;
  If not I_File then
    Begin
      Close(T);
      RFile_Open := False;
    End;
End;


Function Request_List(filename:string; bol:booleanset) : Boolean;
Var Count, X : Word;
  dd : boolean;
Begin
  if (setup.mailer = 2) or (setup.mailer = 4) then dd := true else dd := false;

  Writeat(1,25,7,0,expand('Working...',80));


  If not Assign_T(filename,'Request List Report') then
    Begin
      Request_List := False;
      Exit;
    End;

  For X := 1 to Areaidx do
    Begin
      If bol[afxt^[x].grp] then
        Begin
          Seek(af,afxt^[x].arearec);
          Blockread(af,area,sizeof(area),count);
          If count = sizeof(area) then
            Begin
              if length(area.directory) > 0 then
                Begin
                  if dd then
                    writeln(t,expand(area.directory+'*.*',50)+' ;'+afxt^[x].tag) else
                      writeln(t,expand(area.directory,50)+' ;'+afxt^[x].tag);
                End;
            End Else
            Begin       { last rep for site so just close file }
              Writeln(T,'');
              Writeln(T,'End of Report');
              Writeln(T,'');
              Close(T);
              RFile_Open := False;     { will need to be changed if another }
              Request_List := False;   { report added after here  }
              Exit;
            End;
        End;
    End;
  Writeln(T,'');
  Writeln(T,'End of Report');
  Writeln(T,'');

  Close(T);              { last rep for site so just close file }
  RFile_Open := False;   { wiil need changing if another rep added after here }
  Request_List := True;
End;
