{
 $Id$
}
{*****************************************************************************
 *
 * Purpose ...............: File announcement unit
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Fm_Ann; {announce}

{$O+}

Interface

Uses
  Crt, Dos, Crosslib, S_String, F_File,
  Fm_Struct, Fm_Basic, Fm_Log, Nw_Msg, Nw_Tpl;

Procedure Announcement;

Implementation

Procedure Announcement;

Type
   List = ^Element;

   Element = Record
     Name  : string[12];
     Area  : String[15];
     Grp   : Byte;
     Rec   : Word;
     Next,
     Prev  : List;
   End;

Var
  Dt       : DateTime;
  wd       : Word;
  part     : byte;
  Tmp      : Element;
  Current,
  Start,
  LastHdr   : List;
  Rec, tel  : Word;
  grpinx    : word;
  AnnBak    : AnnounceLinkType;
  ANFbak    : File of AnnounceLinkType;
  F         : File of AnnounceLinkType;

  bol, stop,
  open      : boolean;
  filelist  : text;
  tmp1 : string;
  ton  : string;
  tono : nodetype;


  Procedure SortList (Order : SortType);
  VAR
    Swap : Boolean;

    Procedure SwapThem;
    Begin
      Tmp := current^;
      current^.name  := current^.next^.name;
      current^.area  := current^.next^.area;
      current^.grp   := current^.next^.grp;
      current^.rec   := current^.next^.rec;
      current^.next^.name  := tmp.name;
      current^.next^.area  := tmp.area;
      current^.next^.grp   := tmp.grp;
      current^.next^.rec   := tmp.rec;
      Swap := True;
    End;

  Begin
    Repeat
      Swap := False;
      Current := Start;
      While (Start^.Next <> Nil) and (Current^.Next^.Next <> NIL) do
        Begin
          Case Order of
            SFILE  : if Current^.Name > Current^.Next^.Name then SwapThem;
            SAREA  : if Current^.Area > Current^.Next^.Area then SwapThem;
            SGROUP : if Current^.Grp  > Current^.Next^.Grp then SwapThem;
          End; {case}
          Current := Current^.Next;
        End;
    Until NOT Swap;
  End;

  Procedure SetOrigline;
  Var
    Tmp           : String;
  Begin
    If TearLine in message.Status then
      DoStringln('--- '+msgtearline) else
        DoStringln('--- ');

    If Echo in message.Status then
      Begin
        If message.Origin > 0
          then DoStringLn(' * Origin: '+SETUP.OrigLine[message.Origin]+
            ' ('+node2str(setup.address[message.aka])+')') else
          Begin
            Repeat
              tmp := SETUP.OrigLine[Random(9)+1];
            Until tmp <> '';
            DoStringLn(' * Origin: '+tmp+' ('+node2str(setup.address[message.aka])+')');
          End;
      End;
  End;


Begin
  WriteLogCR (6, 'ANNOUNCE');
  Notifycr(8,'Announcing messages...');

  Reset(Mf);

  Assign (ANF, SystemPath + 'ANNOUNCE.FM');  {onderverdelen in files per id}
  {$I-} Reset (ANF); {$I+}
  if IOresult = 0 then
    begin


      if filesize(anf) > 0 then
        begin                          { making .bak file of announce file }
          if copyfile(systempath+'announce.fm',systempath+'announce.bak') <> 0 then
            notifycr(2,'Error creating ANNOUNCE.BAK backup file');
        end;

      Assign(ANFbak,Systempath + 'ANNOUNCE.NEW');
      {$I-} Reset(ANFBak); {$I+}
      If ioresult = 0 then
        Begin
          NotifyCr(2,'Cannot create '+systempath+'ANNOUNCE.NEW');
          Exit;
        End Else Rewrite(ANFBak);

       While not EOF(ANF) do
         begin
           Read (ANF, ANN);
           Seek (MF, 0);

           MESSAGE.messagenr := 0;
           While (not EOF(MF)) and (MESSAGE.messagenr <> ANN.Msg) do Read (MF, MESSAGE);
           If MESSAGE.messagenr = ANN.Msg then
             Begin

               FillChar (DT, SizeOf(DT), 0);
               With DT do GetDate (Year, Month, Day, WD);
               If (message.freq = imm) or (message.Next <= GetUnixDate(dt)) then  {qualified?}
                 Begin
                   Assign(F,systempath+'FMA_'+int_to_str(Message.messagenr)+'.ANN');
                   {$I-} reset(f); {$I+}
                   If ioresult <> 0 then rewrite(f) else seek(f,filesize(f));
                   write(f,ann);
                   close(f);
                 End Else
                 Begin                      {not yet qualified}
                   Write(ANFBak,ann);
                 End;
             End Else
             Begin
               Write(ANFBak,ann);
             End;
         End;
       Close(Anf);
       Erase(Anf);
       Close(AnfBak);
       {$I-} Rename(AnfBak,systempath+'ANNOUNCE.FM'); {$I+}
       If ioresult <> 0 then
         NotifyCr(2,'Error renaming ANNOUNCE.NEW to ANNOUNCE.FM');
       If File_Size( systempath+'ANNOUNCE.FM') = 0 then
         Delete_file(systempath+'ANNOUNCE.FM');
    End Else exit;

  { ok, nu hebben we 36 verschillende FMA<message.id>.$#$ files
    ipv 1 announce.fm file  }

  For GrpInx := 1 to 255 do
    Begin
      part := 0;

      Assign (ANF, SystemPath + 'FMA_'+int_to_str(grpinx)+'.ann');
      {$I-} Reset (ANF); {$I+}
      If IOresult = 0 then
        Begin

          New(Start);
          Start^.name := '';
          Start^.area := '';
          Start^.grp := 0;
          Start^.next := nil;
          Start^.prev := nil;
          Current := Start;

          Seek (MF, 0);                  {lees het bijbehorende message record}
          MESSAGE.messagenr := 0;   { en set message.next to volgende datum }
          While (not EOF(MF)) and (MESSAGE.messagenr <> grpinx) do Read (MF, MESSAGE);
          if message.messagenr = grpinx then
            begin
              if message.freq <> imm then
                begin
                  seek(mf,filepos(mf)-1);
                  message.Next := NextDate (message.next+(60*60*24), message.Freq, message.Day);
                  write(mf,message);
                end;
            end;

          Rec := 0;
          While not EOF(ANF) do
            Begin
              write(expand('('+int_to_str(maxavail)+')',15)+#13);

              Read (ANF, ANN);
              Inc(rec);

              { make entry }
              Current^.Name := Ann.name;
              Current^.Area := Ann.area;
              Current^.Grp  := Ann.grp;
              Current^.Rec  := Rec;

              New(Current^.Next);
              Current^.Next^.Prev := Current;
              Current^.Next^.Next := nil;
              Current := Current^.Next;
            End;

          Message.msgbaseidstr := string_to_tpl(message.msgbaseidstr);

          if current <> start then
            Begin
              Notify (7,'Processing message ' + int_to_str(grpinx));

              { if S sort records }
              if MESSAGE.SortOrder <> SNONE then
                begin
                  Notify (7,' (sorting)');
                  SortList (SFILE);
                  If message.sortorder = SAREA then sortlist(SAREA);
                  If message.sortOrder = SGROUP then SortList (SGROUP);
                end;

              Notify (7,' (posting) ');

              Stop := False;
              Open := False;

              Repeat

                If first(1,message.msgto) <> '@' then
                  Begin
                    stop := true;
                    ton := message.msgto;
                    tono := message.tonode;
                  End Else
                  Begin
                    If not open then
                      Begin
                        If not exist(last(length(message.msgto)-1,message.msgto)) then
                          Notifycr(1,'Cannot find file list '+last(length(message.msgto)-1,message.msgto)) else
                            Begin
                              Assign(filelist,last(length(message.msgto)-1,message.msgto));
                              {$I-} reset(filelist); {$I+}
                              If ioresult = 0 then
                                Begin
                                  If not eof(filelist) then readln(filelist,tmp1);
                                  If eof(filelist) then stop := true;
                                  If tmp1 <> '' then open := true;
                                End Else Notifycr(1,'Cannot open file list '+last(length(message.msgto)-1,message.msgto));
                            End;
                      End Else
                      Begin
                        If not eof(filelist) then readln(filelist,tmp1);
                        if eof(filelist) then stop := true;
                      End;

                    ton := '';
                    fillchar(tono,sizeof(tono),#0);

                    if pos(',',tmp1) <> 0 then
                      begin
                        ton := first(pos(',',tmp1)-1,tmp1);
                        tmp1 := last(length(tmp1)-pos(',',tmp1),tmp1);
                        str2node(tmp1,tono,setup.address[1],bol);
                        if not bol then notifycr(2,'Invalid node number '+tmp1);
                      end else
                      begin
                        ton := tmp1;
                      end;
                  End;

                if strip('B',' ',ton) <> '' then
                  begin

                Init_Message(message.msgbaseid+message.MsgBaseIdStr,not (TearLine in message.Status),message.aka,
                   message.status,tono, setup.address[message.aka],
                   message.MsgFrom,ton, message.Msgre);
                if open_message then
                  begin
                    Set_Attrib(message.msgattr,message.msgbaseid);

                    BlockCount := 0;
                    BlockSize  := 0;
                    TotalCount := 0;
                    TotalSize  := 0;

                    { header }
                    Empty_Tpl( message.headertpl, false, message.aka, message.msgto );
                    LastHdr := NIL;

                    Fillchar(annbak,sizeof(annbak),#0);

                    { for every entry }
                    Current := Start;
                    tel := 0;
                    While tel < rec do
                      begin                  { if new group/area then write blockheader }
                        if current^.name <> '' then
                          begin
                            inc(tel);
                            If current <> start then annbak := ann;
                            {$I-} Seek (ANF, current^.rec-1 );
                            Read (ANF, ANN); {$I+}
                            If ioresult = 0 then
                              begin

                                if ((Current^.prev = nil) and (MESSAGE.SortOrder in [SAREA,SGROUP]))
                                or ((MESSAGE.SortOrder = SAREA ) and (Current^.Prev^.Area <> Current^.Area))
                                or ((MESSAGE.SortOrder = SGROUP) and (Current^.Prev^.Grp  <> Current^.Grp)) then
                                  Begin
                                    { write footer }
                                    if Current^.Prev <> NIL then
                                      Convert_Tpl(message.blockftrtpl, annbak, false, message.aka, message.msgto);

                                    { reset BLOCK counters }
                                    BlockCount := 0;
                                    BlockSize  := 0;

                                    { write header }
                                    Convert_Tpl(message.blockHdrTpl, Ann, false, message.aka, message.msgto);
                                    LastHdr := Current;
                                  End;

                                { for every entry write entry text }
                                Inc (BlockCount);
                                Inc (TotalCount);
                                BlockSize := BlockSize + ann.Size;
                                TotalSize := TotalSize + ann.Size;

                                if totalcount <> 1 then write(replicate(2+length(int_to_str(totalcount-1)),#8));
                                write('('+int_to_str(totalcount)+')');

                                Convert_Tpl( message.entrytpl, ann, false, message.aka, message.msgto);

                                { check if it fits in the current messagebuffer }
                                if (message.maxsize <> 0)
                                  and big_messagetext(0,message.maxsize)
                                    and (Current^.Area = Current^.Next^.Area)
                                      and (message.msgbaseid <> 'T') then
                                  Begin
                                    {message wegschrijven, en nieuwe creeeren}
                                    { write footer }
                                    Convert_Tpl(message.blockftrtpl, ann, false, message.aka, message.msgto);
                                    DoStringLn(#13+#13+setup.cont1str+#13);
                                    inc(part);
                                    TMsg^.SetSubj( message.msgre+' ('+setup.partstr+' '+int_to_str(part)+')');
                                    SetORigLine;

                                    If not Save_Message then  {Save the message}
                                      begin
                                        writelogcr(9,'');
                                        notifycr(9,'Cannot save message');
                                      end;

                                    Writelog(7,'('+int_to_str(totalcount)+')');

                                    Notify (7,' (posting) ');
                                    write(replicate( length(int_to_str(totalcount))+2 ,' '));

                                    Init_Message(message.msgbaseid+message.MsgBaseIdStr,not (TearLine in message.Status)
                                      ,message.aka,message.status,tono,setup.address[message.aka],
                                      message.MsgFrom,Ton,message.Msgre);
                                    Set_Attrib(message.msgattr,message.msgbaseid);
                                    if open_message then
                                      begin
                                        DoStringLn(#13+setup.cont2str+#13);
                                        { repeat last blockheader }
                                        if LastHdr <> NIL then
                                          Convert_Tpl(message.blockhdrtpl, ann, false, message.aka, message.msgto);
                                     end else notifycr(2,'Cannot open message base');
                                  end;
                              end; {if ioresult <> 0}
                          end;
                        { pop to next entry }
                        Current := Current^.Next;
                      end;

                    if (LastHdr <> NIL) and (MESSAGE.SortOrder in [SAREA,SGROUP]) then
                      Convert_Tpl(message.blockFtrTpl, ann, false, message.aka, message.msgto);

                    { write footer }
                    Empty_Tpl(message.footertpl, false, message.aka, message.msgto);

                    Writelog(7,'('+int_to_str(totalcount)+')');
                    if part <> 0 then
                      begin
                        inc(part);
                        TMsg^.SetSubj( message.msgre+' ('+setup.partstr+' '+int_to_str(part)+')');
                      end;
                    if message.msgbaseid <> 'T' then SetOrigLine;
                    If not Save_Message then  {Save the message}
                      begin
                        writelogcr(9,'');
                        notifycr(9,'Cannot save message');
                      end;
                    inc(tannounce);

                    NotifyCr(7,'');
                    If message.messagename <> '' then Notify(7,''+message.messagename);
                    notify(7,' ('+ton+')');
                    notifycr(7,'');

                    if stop then
                      begin
                        close(anf);
                        erase(anf);
                      end;

                  end else
                  begin
                    writelogcr(9,'');
                    notifycr(9,'Cannot open messagebase');
                  end;
                end; { if strip('B',' ',ton) <> '' }
              until stop;
              if open then close(filelist);

            End; {  if current <> start then }

          While start <> nil do
            Begin
              Current := start;
              Start := current^.next;
              Dispose(current);
            End;

        End; { if ioresult <> 0 }
    End; {  For GrpInx := 1 to 36 do }
  Close(Mf);
End;


End.
