PAGE  80,132
TITLE WRDQTY  Words Count Routine, Ver 6.20

; WRDQTY.ASM - WrdQty
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine counts the number of words in a string delimited by spaces.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  WrdQty

S            EQU     DWORD PTR SS:[bx+4]

; WrdQty - Total number of words in a string.
; function WrdQty (S: string): byte;

WrdQty       PROC FAR
       mov   bx,sp            ; Set up stack base
       xor   cx,cx            ; Set CX=0
       mov   dx,cx            ; Set DX=0
       les   di,S             ; Point to dest string
       add   cl,es:[di]       ; Get length and test
       jz    Exit             ; Exit if null string
       mov   al,' '           ; Get Space char to scan
       inc   di               ; Start at S[1]
       cld                    ; Set DF to increment
       EVEN                   ; Align for speed
L1:    repe  scasb            ; Scan for non-space
       je    Exit             ; All spaces
       inc   dx               ; Word found, inc count
       repne scasb            ; Scan for space
       je    L1               ;   space found, look for next word
Exit:  xchg  ax,dx            ; Place result in AX
       ret   4                ; Clear all parameters
WrdQty       ENDP

CODE   ENDS

       END
