PAGE  80,132
TITLE WRDPOSL  Position of the Nth word from the LEFT, Ver 6.20

; WRDPOSL.ASM - WrdPosL
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine finds the index of the Nth word from the LEFT delimited by
; spaces.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  WrdPosL

S            EQU     DWORD PTR SS:[bx+6]
Nth          EQU     BYTE  PTR SS:[bx+4]

; WrdPosL - Index the Nth word from the LEFT.
; function WrdPosL (S: string; Nth: byte): byte;

WrdPosL      PROC FAR
       mov   bx,sp            ; Set up stack base
       xor   cx,cx            ; Set CX=0
       mov   dx,cx            ; Set DX=0
; -- Evalute Nth --
       add   dl,Nth           ; Get Nth, Nth=0?
       jz    Null             ;   yes, return null
; -- Point to string to be scanned (not Dest) --
       les   di,S             ; Point to source string
       mov   cl,es:[di]       ; Get length
       jcxz  Null             ; Exit if null string
; -- Set up constants --
       mov   al,' '           ; Get Space char to scan
       inc   di               ; Start at S[1]
       mov   ah,cl            ; Save length
       cld                    ; Set DF to increment
       EVEN                   ; Align for speed
L1:    repe  scasb            ; Scan for non-space
       je    Null             ; All spaces
       dec   dx               ; Word found, dec count
       jz    Done             ; Exit if Nth word found
       repne scasb            ; Scan for space
       je    L1               ;   space found, look for next word
       jmp   SHORT Null       ; CX=0.  Word not found.
Done:  neg   cx               ; Make negative down count
       add   cl,ah            ; Calc index
Null:  xchg  ax,cx            ; Set AL=value in CL
       ret   6                ; Clear all parameters

WrdPosL      ENDP

CODE   ENDS

       END
