PAGE  80,132
TITLE TOSTACK  Subroutine to copy Source and Find strings to Stack, Ver 6.20

; TOSTACK.ASM - For StrPosLI, StrPosRI, and StrPosXI
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ToStack, CopyStr, CopyStr2
        EXTRN   RepMovsB: NEAR

; ToStack - Copies Source and Find strings very quickly into the stack and
; converts them to lower case.  By conventional wisdom, most strings are
; converted to upper case, but IGNORE case routines are statistically used
; when strings are mostly lower case.  Therefore, it is more efficient to
; make the conversion only when necessary for greater speed.
; The DX register is preserved in the CopyStr procedure.

S1           EQU     DWORD PTR [bp+di+8]
Find         EQU     DWORD PTR [bp+di+4]
Nth          EQU     BYTE  PTR [bp+4]
S1upr        EQU     BYTE  PTR [bp-100h]
FindUpr      EQU     BYTE  PTR [bp-200h]


; Assumes source and destination are already defined in CopyStr
; CopyStr2 is used by StrCmpI.

CopyStr      PROC  NEAR
       lodsb                  ; Get length
       xor   ah,ah            ; Zero extend AL
       mov   cx,ax            ; Copy length in CX
       stosb                  ; Copy length
       jcxz  Exit2            ; Quit if null string

CopyStr2     PROC  NEAR
; -- Set conversion constants --
       push  dx               ; Save DX reg
       mov   bx,5A41h         ; Lo='A'; Hi='Z'
       mov   dl,20h           ; Set lower case constant
; -- Convert string --
; All strings in the stack using this routine have the first
; character aligned at an odd-byte.  So first convert the odd-byte
; and then really mean busines.  Do the conversions by words.
; -- Convert first byte --
       lodsb                  ; Get char
       cmp   al,bh            ; Char>Z?
       ja    C1               ;   yes, already lower case
       cmp   al,bl            ; Char<A?
       jb    C1               ;   no, not in range
       add   al,dl            ; Convert to lower case
C1:    stosb                  ; Store new char
       dec   cx               ; Decrement count
       jz    Exit1            ; Just one byte
; -- Now convert by words --
       shr   cx,1             ; Bytes -> words
       jz    C2               ; Just one byte left
       rcl   dh,1             ; Save CF
       EVEN                   ; Align for speed
L1:    lodsw                  ; Get TWO chars
       cmp   al,bh            ; Char>Z?
       ja    L2               ;   yes, already lower case
       cmp   al,bl            ; Char<A?
       jb    L2               ;   no, not in range
       add   al,dl            ; Convert to lower case
L2:    cmp   ah,bh            ; Char>Z?
       ja    L3               ;   yes, already lower case
       cmp   ah,bl            ; Char<A?
       jb    L3               ;   no, not in range
       add   ah,dl            ; Convert to lower case
L3:    stosw                  ; Store new chars
       loop  L1               ; Get next char
; -- Now get the last byte --
       shr   dh,1             ; Get flag test again
       jnc   Exit1            ; No last byte
C2:    lodsb                  ; Get char
       cmp   al,bh            ; Char>Z?
       ja    C3               ;   yes, already lower case
       cmp   al,bl            ; Char<A?
       jb    C3               ;   no, not in range
       add   al,dl            ; Convert to lower case
C3:    stosb                  ; Store new char
Exit1: pop   dx               ; Restore DX reg
Exit2: mov   bx,ss            ; Move SS into ...
       mov   ds,bx            ;  ... DS
       ret                    ; Return to call
CopyStr2     ENDP
CopyStr      ENDP


ToStack      PROC  NEAR
       pop   ax               ; Hold return offset
       mov   bx,sp            ; Save stack base
       sub   sp,200h          ; Allow 2 - 255 byte strings
       push  ax               ; Reset return offset
       push  bp               ; Save Pascal's BP
       push  ds               ; Save Pascal's DS
       mov   bp,bx            ; Set up stack base
       mov   dx,di            ; Save BP offset
; -- Copy S String --
       lds   si,S1            ; Point to S source
       lea   di,S1upr         ; EA of S1upr
       mov   cx,ss            ; Copy SS to ...
       mov   es,cx            ;   ES
       cld                    ; Set DF to increment
       push  di               ; Save S1upr offset
       call  CopyStr          ; Copy S1 to S1upr
; -- Copy Find String --
       mov   di,dx            ; Get BP offset
       lds   si,Find          ; Point to Find source
       lea   di,FindUpr       ; EA of FindUpr
       push  di               ; Save FindUpr offset
       call  CopyStr          ; Copy Find to FindUpr
; -- Retrieve offsets --
       mov   cl,Nth           ; Get Nth or Qty
       pop   bx               ; FindUpr offset
       pop   ax               ; S1upr offset
       pop   ds               ; Restore Pascal's DS
       pop   bp               ; Restore Pascal's BP
       ret                    ; Return to call
ToStack      ENDP


CODE   ENDS

       END
