PAGE  80,132
TITLE STRDETAB  Expands all Tabs to spaces, Ver 6.20

; STRDETAB.ASM - StrDeTab
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine expands all tabs to spaces given the tab spacing.
; Source and Dest can be the same address.
; Position 1 is the first tab setting.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrDeTab
        EXTRN   RepMovsB: NEAR

Dest         EQU     DWORD PTR [bp+12]
S            EQU     DWORD PTR [bp+8]
TabSpaces    EQU     BYTE  PTR [bp+6]
TempStr      EQU     BYTE  PTR [bp-100h]
Space        EQU     ' '
Tab          EQU     9

; StrDeTab - Expands all tabs to spaces given the tab spacing.
; procedure StrDeTab (VAR Dest: string; S: string; TabSpaces: byte);

; AH: DIV         AL: Tab char (9)
; BH:             BL: Length remain
; CH: 0           CL: Source count
; DH: Tab Spaces  DL: Save length

StrDeTab     PROC  FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       sub   sp,100h          ; Allow for TempStr
       push  ds               ; Save Pascal's DS
; -- Copy original string to stack --
       xor   ax,ax            ; Set AX=0
       mov   bx,ax            ; Set result length=0
       lds   si,S             ; Point to original string
       lea   di,TempStr       ; Point to Stack destination
       mov   dx,ss            ; Move SS into ..
       mov   es,dx            ;   ES
       cld                    ; Set DF to increment
       lodsb                  ; Get length
       mov   cx,ax            ; Place length in CX
       call  RepMovsB         ; Do Fast move of bytes
; -- Test length of string --
       xchg  ax,cx            ; Restore orig length in CX (AX=0)
       mov   si,di            ; Save as Source ofs
       les   di,Dest          ; Point to Dest
       jcxz  Exit0            ; If Zero, then exit
       sub   si,cx            ; Reset TempStr[1]
       mov   ds,dx            ; Move SS into DS
       dec   bl               ; Assume max result length = 255
       mov   dh,TabSpaces     ; Set Tab spaces in DH
       inc   di               ; Point to Dest[1]
; -- Scan for tabs --
T0:    mov   al,Tab           ; Set Tab char in AL
       EVEN                   ; Align for speed
T1:    cmp   al,[si]          ; Tab?
       je    Fill             ;   yes, fill with spaces
       movsb                  ;   no, copy char
       dec   bx               ; Decrement Dest length
T2:    loopne T1              ; Continue to scan
       jmp   SHORT Exit1      ; Go calc length
; -- Special loop for deleting tabs --
Null:  loop  T1               ; Continue to scan
       jmp   SHORT Exit1      ; Go calc length
; -- Attempt to fill spaces --
Fill:  inc   si               ; Point to next char
       cmp   dh,ch            ; Compare tab spaces
       je    Null             ; Nothing to fill
; -- Calculate postitions already filled --
       mov   ax,bx            ; Get Max remaining
       neg   al               ; Make negative for position
       dec   ax               ; Calc length
       div   dh               ; Positions already filled in AH
; -- Calculate spaces to fill --
       mov   dl,cl            ; Save Count
       mov   cl,dh            ; Set count
       sub   cl,ah            ; Spaces to add in CX
       cmp   cl,bl            ; Beyond limit?
       jb    Full             ;   no, do full replace
       mov   cl,bl            ;   yes, limit to max remain
Full:  sub   bl,cl            ; Adjust downcount  (Alter ZF flag)
       mov   al,Space         ; Set space char
       rep   stosb            ; Fill spaces
       mov   cl,dl            ; Restore count
       loopne T0              ; Continue to fill
; -- Calculate length --
Exit1: xchg  ax,bx            ; Get position
       inc   ax               ; Calc negative length
       neg   al               ; Make positive
       sub   di,ax            ; Point to Result[1]
       dec   di               ; Point to Result[0]
Exit0: stosb                  ; Save Result
       pop   ds               ; Restore Pascal's DS
       mov   sp,bp            ; Drop TempStr
       pop   bp               ; Restore Pascal's BP
       ret   10               ; Clear all parameters
StrDeTab     ENDP

CODE   ENDS

       END
