PAGE  80,132
TITLE STRCMP  Compares two substrings, Ver 6.20

; STRCMP.ASM - StrCmp, StrCmpI
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine compares two substrings and determines Less Than, Equal, or
; Greater Than.  The index of difference is saved in the global variable
; CmpIndex1 and CmpIndex2 which are 0 if the two substrings are equal.

; Results:
;   <0:  S1<S2
;   =0:  S1=S2
;   >0:  S1>S2

DATA    SEGMENT WORD PUBLIC
        EXTRN   CmpIndex1:  WORD
        EXTRN   CmpIndex2:  WORD
DATA    ENDS

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE, DS:DATA
        PUBLIC  StrCmp, StrCmpI
        EXTRN   RepMovsB: NEAR
        EXTRN   RepCmpsB: NEAR
        EXTRN   CopyStr2: NEAR

; StrCmp/StrCmpI - Compares two substrings with a maximum length to
; compare starting at Index1 and Index2.  -I ignores case.
; function StrCmp  (S1,S2: string; Index1,Index2,MaxLen: byte): shortint;
; function StrCmpI (S1,S2: string; Index1,Index2,MaxLen: byte): shortint;

S1           EQU     DWORD PTR [bp+16]
S2           EQU     DWORD PTR [bp+12]
Index1       EQU     BYTE  PTR [bp+10]
Index2       EQU     BYTE  PTR [bp+8]
MaxLen       EQU     BYTE  PTR [bp+6]
S1stk        EQU     BYTE  PTR [bp-0FFh]  ; At first char, skip length
S2stk        EQU     BYTE  PTR [bp-1FFh]  ; At first char, skip length

StrCmpI      PROC FAR
       mov   bh,1             ; Set BH to recognize StrCmpI
       jmp   SHORT Start      ; Jump into routine

StrCmp       PROC FAR
       xor   bh,bh            ; Set BH to recognize StrCmp
Start: push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       sub   sp,200h          ; Allow 2 - 255 byte strings
       push  ds               ; Save Pascal's DS
       xor   ax,ax            ; Set AX=0
; -- Get S1 addresses and lengths --
       lds   si,S1            ; At S1[0]
       cld                    ; Set DF to increment
       lodsb                  ; Get S1 length in AL
       mov   cx,ax            ; Save in CX
       mov   al,Index1        ; Get Index1
       cmp   ah,al            ; Index1>0? (CF=1?)
       sbb   al,ah            ;   yes, decrement
       mov   dl,al            ; Save Index1-1 in DL
       add   si,ax            ; At S1[Index1]
       sub   cl,al            ; Calc chars comparable
       ja    C1               ; Jump if not null
       mov   cl,ah            ; Make null
; -- Get S2 addresses and lengths --
C1:    les   di,S2            ; At S2[0]
       mov   al,es:[di]       ; Get S2 length in AL
       mov   bl,al            ; Save in BL
       mov   al,Index2        ; Get Index2
       cmp   ah,al            ; Index1>0? (CF=1?)
       sbb   al,ah            ;   yes, decrement
       add   di,ax            ; At S2[Index2-1]
       inc   di               ; At S2[Index2]
       sub   bl,al            ; Calc chars comparable
       ja    C2               ; Jump if not null
       mov   bl,ah            ; Make null
; -- Compare with MaxLen --
C2:    mov   al,MaxLen        ; Get maximum count
       cmp   al,cl            ; MaxLen>=S1 substring?
       jae   C3               ;   yes, length ok
       mov   cl,al            ;   no, truncate to MaxLen
C3:    cmp   al,bl            ; MaxLen>=S2 substring?
       jae   C4               ;   yes, length ok
       mov   bl,al            ;   no, truncate to MaxLen
; -- Compare lengths --
C4:    cmp   cl,bl            ; Length difference (S1-S2)
       lahf                   ; Save compare result in AH
       jb    C5               ; Jump if smallest in CL
       mov   cl,bl            ; Place lesser length in CL
C5:    mov   dh,cl            ; Save scan count       (DH=Chars to scan)
       jcxz  NoCmp            ; Exit if nothing to compare
; -- Test calling routine --
       shr   bh,1             ; StrCmp? (not StrCmpI)
       jnc   Reps             ;  yes, skip conversion

; -- Copy S1 substring to stack --
       push  ax               ; Save flags
       push  es               ; Save S2 seg
       push  di               ; Save S2 ofs
       mov   bx,ss            ; Copy SS to ...
       mov   es,bx            ;   ES
       lea   di,S1stk         ; EA of S1stk
       mov   cl,dh            ; Reset scan count
       call  CopyStr2         ; Copy S1 to S1stk
; -- Copy S2 substring to stack --
       pop   si               ; Restore S2 ofs
       pop   ds               ; Restore S2 seg
       lea   di,S2stk         ; EA of S2stk
       mov   cl,dh            ; Reset scan count
       call  CopyStr2         ; Copy S2 to S2stk
       pop   ax               ; Restore flags
; -- Adjust offsets --
       mov   cl,dh            ; Replace chars to scan CL
       sub   di,cx            ; Reset S2stk offset (ES=SS already)
       lea   si,S1stk         ; Reset S1stk offset

; -- Compare strings (CX always >0 ) --
Reps:  call  RepCmpsB         ; Fast compare of strings
       jne   NotEq            ; Jump if not equal
; -- Check for possible equal --
NoCmp: mov   bx,cx            ; Set result to zero
       sahf                   ; Lengths equal, too?
       je    Exit             ;   yes, strings are equal
       dec   cl               ; Past last char (not CH?)
; -- Calculate CmpIndex2 --
NotEq: lahf                   ; Save compare result in AH
       mov   bl,Index2        ; Get Index2
       cmp   bh,bl            ; Index1>0? (CF=1?)
       sbb   bl,bh            ;   yes, decrement
       sub   cl,dh            ; Chars scanned (neg)
       neg   cl               ; Chars scanned (pos)
       add   bl,cl            ; CmpIndex2
       adc   bh,bh            ; Account for CF when =256
; -- Calculate CmpIndex1 --
       add   cl,dl            ; CmpIndex1
       adc   ch,ch            ; Account for CF when =256

Exit:  pop   ds               ; Restore Pascal's DS
       mov   CmpIndex2,bx     ; Save index of difference 2
       mov   CmpIndex1,cx     ; Save index of difference 1
       xor   al,al            ; Set AL=0
       sahf                   ; Duplicate flags
       je    Exit2            ;   yes, sign is 0
       mov   al,1             ; Assume Greater Than
       ja    Exit2            ; Good assumption
       neg   al               ; No, set to -1 for Less Than
Exit2: mov   sp,bp            ; Drop local variables
       pop   bp               ; Restore Pascal's BP
       ret   14               ; Clear all parameters

StrCmp       ENDP
StrCmpI      ENDP


CODE   ENDS

       END
