PAGE  80,132
TITLE STRTOLN  String to Ln Routine, Ver 6.20

; STRTOLN.ASM - LnStr
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine converts Pascal type strings to ASCII TEXT strings that end
; with CR/LF.


DATA    SEGMENT WORD PUBLIC
        EXTRN   LnDestPtr: WORD
DATA    ENDS

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE, DS:DATA
        PUBLIC  LnStr
        EXTRN   RepMovsB: NEAR

LnDest       EQU     DWORD PTR SS:[bx+8]
S            EQU     DWORD PTR SS:[bx+4]


; LnStr - Converts Pascal string to ASCII TEXT string.  Source and
; destination can be the same.  This is a move-like procedure - make sure
; the destination size is sufficient.
; LnDestPtr is great for sequential processing.  After LnStr is executed,
; LnDestPtr is set to the next destination.

; procedure LnStr (VAR LnDest; VAR S: string);

LnStr        PROC FAR
       mov   bx,sp            ; Set up stack base
       mov   dx,ds            ; Save Pascal's DS
       lds   si,S             ; Point to source Pascal string
       les   di,LnDest        ; Point to dest ASCII TEXT string
       cld                    ; Set DF to increment
       lodsb                  ; Get length
       xchg  ax,cx            ; Save length in CX
       xor   ch,ch            ; Zero extend CL
       call  RepMovsB         ; Do fast move of bytes
       mov   ax,0A0Dh         ; Place CR/LF in AX
       stosw                  ; Terminate string
       mov   ds,dx            ; Restore Pascal's DS
       mov   LnDestPtr,di     ; Save next destination offset
       mov   LnDestPtr+2,es   ; Save next destination segment
       ret   8                ; Clear all parameters
LnStr        ENDP

CODE   ENDS

       END
