PAGE  80,132
TITLE CHRREPL  Find and Replace of Char in String Routine, Ver 6.20

; CHRREPL.ASM - ChrRepl
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine finds and replaces a character from a given index for Qty
; number of replacements.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ChrRepl

S            EQU     DWORD PTR [bp+12]
Find         EQU     BYTE  PTR [bp+10]
Repl         EQU     BYTE  PTR [bp+8]
Index        EQU     BYTE  PTR [bp+6]
Qty          EQU     BYTE  PTR [bp+4]

; ChrRepl - Finds and replace a character from a given index for Qty
; number of replacements.
; procedure ChrRepl (VAR S: string; Find,Repl: char; Index,Qty: byte);

ChrRepl      PROC FAR
       mov   bx,bp            ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       les   di,S             ; Point to dest string
       xor   ax,ax            ; Set AX=0
       mov   al,es:[di]       ; Get length
       mov   cx,ax            ; Also copy in CX
       jcxz  Exit             ; Quit if null string
; -- Evaluate indeX --
       mov   al,Index         ; Get Position
       cmp   ah,al            ; indeX=0?
       sbb   al,-1            ;   yes, increment
       sub   cx,ax            ; Chars to scan
       jb    Exit             ; None to search
; -- Get Qty to replace --
       inc   cx               ; 1-based
       add   di,ax            ; First char to scan
       mov   al,Qty           ; Get quantity to replace
       test  al,al            ; Test value
       jz    Exit             ; If zero, then none to replace
       xchg  ax,dx            ; Save in DX
; -- Get chars to swap --
       mov   al,Find          ; Get char to find
       mov   ah,Repl          ; Get char to replace
       cld                    ; Set DF to increment
; -- Do replacements --
       EVEN                   ; Align for speed
L1:    repne scasb            ; Scan   (ZF=0 after first loop)
       jne   Exit             ; Not found
       mov   es:[di-1],ah     ; Replace character
       dec   dx               ; Decrement Qty count
       jnz   L1               ; If not zero, replace more
Exit:  mov   bp,bx            ; Restore Pascal's BP
       ret   12               ; Clear all parameters
ChrRepl      ENDP

CODE   ENDS

       END
