PAGE  80,132
TITLE CHRQTY  Character Count Routine, Ver 6.20

; CHRQTY.ASM - ChrQty
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine counts the occurrences of a given character in a string.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ChrQty

S            EQU     DWORD PTR SS:[bx+6]
Find         EQU     BYTE  PTR SS:[bx+4]

; ChrQty - Total quantity of Finds in string.
; function ChrQty (S: string; Find: char): byte;

ChrQty       PROC FAR
       mov   bx,sp            ; Set up stack base
       xor   cx,cx            ; Set CX=0
       mov   dx,cx            ; Set DX=0
       les   di,S             ; Point to dest string
       add   cl,es:[di]       ; Get length
       jz    Exit             ; Quit if null string
       mov   al,Find          ; Get Find to scan
       inc   di               ; Start at S[1]
       cld                    ; Set DF to increment
       dec   dx               ; Start at -1
       EVEN                   ; Align for speed
L1:    inc   dx               ; Adjust count (Set ZF=0 after 1st time)
       repne scasb            ; Scan         (Pass if CX=0)
       je    L1               ; Found match
Exit:  xchg  ax,dx            ; Place result in AX
       ret   6                ; Clear all parameters
ChrQty       ENDP

CODE   ENDS

       END
