PAGE  80,132
TITLE CHRINS  String Insert Char Routine, Ver 6.20

; CHRINS.ASM - ChrIns
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine inserts a repeated character string into another string


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ChrIns
        EXTRN   RepMovsBRev: NEAR
        EXTRN   RepStosBRev: NEAR

S            EQU     DWORD PTR [bp+10]
Fill         EQU     BYTE  PTR [bp+8]
Index        EQU     BYTE  PTR [bp+6]
Count        EQU     BYTE  PTR [bp+4]

; ChrIns - Inserts an array of repeated characters in a string.
; procedure ChrIns (VAR S: string; Fill: char; Index,Count: byte);

; Quit if:
;   Count=0


ChrIns       PROC FAR
       mov   bx,bp            ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
; -- Check Fill length --
       xor   ax,ax            ; Set AX=0
       add   al,Count         ; Get length, Length=0?
       jz    Exit             ;   yes, quit if no count
       mov   dx,ax            ; Save in DX   (DL=Count)
; -- Get S length --
       les   di,S             ; At S[0]
       mov   al,es:[di]       ; Get length
       mov   cx,ax            ; Save in CX   (CL=S[0])
; -- Get Index --
       mov   al,Index         ; Get index
       cmp   ah,al            ; Index>0? (CF=1?)
       sbb   al,ah            ;   yes, decrement
; -- Calculate shifted string length --
       sub   cl,al            ; Index0<Length?  (CL=Move length)
       ja    C1               ;   yes, have to move a substring
       add   al,cl            ;   no, just append, adjust index
       mov   cl,ah            ; Set move length 0
; -- Calculate proposed total length --
C1:    add   al,cl            ; AL=S[0]
       add   al,dl            ; AL=S[0]+Count=NewLen
       jc    Adj              ; Adjust if NewLen >=256
; -- Store new length --
NoAdj: std                    ; Set DF to decrement
       mov   es:[di],al       ; Save new length
       add   di,ax            ; At new S[L]
; -- Append trailing chars --
       jcxz  C3               ; No appending chars
       mov   ax,ds            ; Save Pascal's DS
       mov   si,es            ; Move ES into ...
       mov   ds,si            ;  ... DS
       mov   si,di            ; Point at same place
       sub   si,dx            ; At old S[L] (DX=shift caused by insert)
       call  RepMovsBRev      ; Do fast move of bytes
       mov   ds,ax            ; Restore Pascal's DS
; -- Insert fill --
C3:    mov   al,Fill          ; Get Fill char
       mov   cl,dl            ; Set Count
       call  RepStosBRev      ; Do fast fill of bytes
Exit:  mov   bp,bx            ; Restore Pascal's BP
       ret   10               ; Clear all parameters

; -- Truncation is needed.  Find out where --
; -- Check Shifted substring length --
Adj:   inc   ax               ; 1-based cut size
       sub   cl,al            ; CX=New shift length>=0?
       mov   al,255           ;   (Max length)
       jae   NoAdj            ;   yes, ready to shift
; -- Calc room left for fill insert --
       sub   dl,cl            ; DL=remaining count
       mov   ch,cl            ; Set 0 to nullify shifted substring
       jmp   SHORT NoAdj      ;

ChrIns       ENDP

CODE   ENDS

       END
