PAGE  80,132
TITLE CHRDEL  Chararacter Delete Routine, Ver 6.20

; CHRDEL.ASM - ChrDel
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine operates on a string to delete all occurrences of a given
; character.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ChrDel

S            EQU     DWORD PTR ss:[bx+6]
Find         EQU     BYTE  PTR ss:[bx+4]


; ChrDel - Deletes all Find characters in the string.
; procedure ChrDel (VAR S: string; Find: char);

ChrDel       PROC FAR
       mov   bx,sp            ; Set up stack base
       mov   dx,ds            ; Save Pascal's DS
; -- Get string length --
       lds   si,S             ; Point to source string
       xor   cx,cx            ; Set CX=0
       add   cl,[si]          ; Get and evaluate length
       jz    Exit             ; Quit if null string
       cld                    ; Set DF to increment
       inc   si               ; At S[1]
; -- Copy address as destination --
       mov   di,ds            ; Move DS into ...
       mov   es,di            ;  ... ES
       mov   di,si            ; Align at S[1]
       mov   ah,Find          ; Get Find to delete
       mov   bx,di            ; Save offset
; -- Delete char --
       EVEN                   ; Align for speed
L1:    lodsb                  ; Get Char
       cmp   al,ah            ; Delete char?
       je    L2               ;   yes, skip it
       stosb                  ;   no, save it
L2:    loop  L1               ; Do full string
; -- Calculate new length --
       xchg  ax,di            ; Place final offset in AX
       sub   ax,bx            ; New length
       dec   bx               ; Point to S[0]
       mov   [bx],al          ; Save length
Exit:  mov   ds,dx            ; Restore Pascal's DS
       ret   6                ; Clear all parameters
ChrDel       ENDP

CODE   ENDS

       END
