PAGE  80,132
TITLE ASCSTR  String to ASCIIZ Routine, Ver 6.20

; ASCSTR.ASM - AscStr
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine creates ASCIIZ strings from Pascal type strings.


DATA    SEGMENT WORD PUBLIC
        EXTRN   AscDestPtr: WORD
DATA    ENDS

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE, DS:DATA
        PUBLIC  AscStr
        EXTRN   RepMovsB: NEAR

AscDest      EQU     DWORD PTR SS:[bx+8]
S            EQU     DWORD PTR SS:[bx+4]


; AscStr - Converts Pascal string to ASCIIZ string.  Source and destination
; can be the same.  Important: As all C programmers are aware, it is up to you
; to make sure the destination size is sufficient.
; AscDestPtr is great for sequential processing.  After AscStr is executed,
; AscDestPtr is set to the next destination.

; procedure AscStr (VAR AscDest; VAR S: string);

AscStr       PROC FAR
       mov   bx,sp            ; Set up stack base
       mov   dx,ds            ; Save Pascal's DS
       lds   si,S             ; Point to source Pascal string
       les   di,AscDest       ; Point to dest AsciiZ string
       cld                    ; Set DF to increment
       lodsb                  ; Get length
       xchg  ax,cx            ; Save length in CX
       xor   ch,ch            ; Zero extend CL
       call  RepMovsB         ; Do fast move of bytes
       xchg  ax,cx            ; Place null char in AL
       stosb                  ; Terminate string
       mov   ds,dx            ; Restore Pascal's DS
       mov   AscDestPtr,di    ; Save next destination offset
       mov   AscDestPtr+2,es  ; Save next destination segment
       ret   8                ; Clear all parameters
AscStr       ENDP

CODE   ENDS

       END
