{
 $Id$
}
Unit MkMsgTxt;       {plain ascii txt unit}

{$I MKB.Def}


 {*****************************************************************************
 *
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes               FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Interface

Uses MKGlobT, MKMsgAbs, MKFFile, Dos;

Type TMsgType = Record
  MsgFile: FFileObj;
  MsgName: String[13];
  TextCtr : Longint;
  TmpName: String[130];
  MsgOpen: Boolean;
  Error: Word;
  NetMailPath: String[128];
  MsgStart: LongInt;
  End;


Type TxtMsgObj = Object (AbsMsgObj)
  FM: ^tMsgType;
  Constructor Init;                      {Initialize FidoMsgOut}
  Destructor Done; Virtual; {Done FidoMsgOut}
  Procedure SetMsgPath(St: String); Virtual; {Set netmail path}
  Procedure PutByte(B: Byte; Position: LongInt); Virtual;
  Procedure DoString(Str: String); Virtual; {Add string to message text}
  Procedure DoChar(Ch: Char); Virtual; {Add character to message text}
  Procedure DoStringLn(Str: String); Virtual; {Add string and newline to msg text}
  Function  WriteMsg: Word; Virtual;
  Procedure StartNewMsg; Virtual;
  Function  OpenMsgBase: Word; Virtual;
  Function  CloseMsgBase: Word; Virtual;
  Function  CreateMsgBase(MaxMsg: Word; MaxDays: Word): Word; Virtual;
  End;


Type TxtMsgPtr = ^TxtMsgObj;

Implementation

Uses MKFile, MKString, MKDos;


Constructor TxtMsgObj.Init;
Begin
  New(FM);
  If FM = Nil Then
    Begin
      Fail;
      Exit;
    End;
  FM^.NetMailPath := '';
  FM^.MsgFile.Init(4000);
  FM^.MsgOpen := False;
End;

Destructor TxtMsgObj.Done;
Begin
  If FM^.MsgOpen Then
    If FM^.MsgFile.CloseFile Then {};
  FM^.MsgFile.Done;
  Dispose(FM);
End;

Procedure TxtMsgObj.SetMsgPath(St: String);
  Begin
    FM^.NetMailPath := Copy(St, 1, 110);
  End;

Procedure TxtMsgObj.PutByte(B: Byte; Position: LongInt);
  Begin
  If FM^.MsgFile.SeekFile(Position) Then
    If FM^.MsgFile.BlkWrite(B, SizeOf(Byte)) Then;
  End;

Procedure TxtMsgObj.DoString(Str: String);
  Var
    i: Word;
  Begin
    i := 1;
    While i <= Length(Str) Do
      Begin
        DoChar(Str[i]);
        Inc(i);
      End;
  End;

Procedure TxtMsgObj.DoChar(Ch: Char);
  Begin
    PutByte(Ord(Ch), FM^.TextCtr);
    Inc(FM^.TextCtr);
  End;

Procedure TxtMsgObj.DoStringLn(Str: String);
  Begin
    DoString(Str+#10#13);
  End;

Function  TxtMsgObj.WriteMsg: Word;
  Begin
    If FM^.MsgFile.CloseFile Then {};
    WriteMsg := IoResult;
  End;


Procedure TxtMsgObj.StartNewMsg;
  Begin
    FM^.Error := 0;
    FM^.TextCtr := 0;
    If FM^.MsgOpen Then
      Begin
        If FM^.MsgFile.CloseFile Then
          FM^.MsgOpen := False;
      End;
      FM^.TmpName := FM^.NetMailPath;
      If Length(FM^.TmpName) > 0 Then
        Begin
          If FM^.MsgFile.OpenFile(FM^.TmpName, fmReadWrite + fmDenyNone) Then
            Begin
              FM^.MsgOpen := True;
            End Else
              FM^.Error := 1002;
        End Else
          FM^.Error := 1001;
  End;

Function TxtMsgObj.OpenMsgBase: Word;
  Begin
    OpenMsgBase := 0;
  End;

Function TxtMsgObj.CloseMsgBase: Word;
  Begin
    CloseMsgBase := 0;
  End;

Function TxtMsgObj.CreateMsgBase(MaxMsg: Word; MaxDays: Word): Word;
  Begin
    CreateMsgBase := 0
  End;


End.


