{
 $Id$
}

 { 20/5/96 : line 277 & 283: added fix for if the area is passthru }

 {*****************************************************************************
 *
 * Purpose:  New scan : announce new files
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}
Unit fm_new;  {newscan}

{$O+}

Interface

Uses
  dos, crc32, crosslib, s_string, fil_spec, f_file,
  fm_struct, fm_basic, fm_proc, fm_log, fm_dup, fm_hex, nw_msg;

Procedure Newscan;

Implementation

Var
  nrfiles, nrscan, nrnew  : LongInt;
  afiles, anew            : Longint;
  ct                      : Array[1..2048] of longint;
  cttel                   : word;
  first, hatches          : Boolean;


Procedure CheckThisFile;
Var dummy   : word;
    inx     : longint;
    sr      : searchrec;
    crc     : longint;
    dt      : datetime;
    tmp     : char;
    i       : integer;
    currcrc : longint;
Begin
  findfirst (area.directory + name_buffer, $0, sr);
  if (doserror=0) and (sr.name <> 'FILES.FM') then
    begin
      crc := $ffffffff;
      for inx := 1 to length(name_buffer) do crc := updatecrc32(ord(name_buffer[inx]),crc);
      crc := updatecrc32(sr.time,crc);
      crc := updatecrc32(sr.size,crc);
      crc := not(crc);

      Inc(afiles);
      { find in table }

      inx := 1;
      while (inx <= cttel) and (ct[inx] <> crc) do inc(inx);
      if inx > cttel then
        begin
          if (not first) and ((HatchNew in area.Status) or (AnnNew in area.Status)) then
            begin
{              If Is_Dup(name_buffer,'',0,crc,sr.size,false,false,true,true,fuzzydup in area.status) = 0 then
                Begin }
                  inc(nrnew);
                  inc(anew);
                  fillchar (info, sizeof(info), 0);
                  FillChar (DT, SizeOf(DT), 0);
                  With DT do GetDate(Year, Month, Day, dummy);
                  INFO.TAG         := AFXt^[afxinx].TAG;
                  INFO.Release     := GetUnixDate(DT);
                  INFO.Forwar      := INFO.Release;
                  INFO.Status      := [Local, FileProcessed];
                  INFO.FilePath    := area.Directory;
                  INFO.FileSpec    := name_buffer;
                  INFO.Size        := sr.size;
                  INFO.Date        := sr.time;

                  inx := 0;
                  i := 0;
                  while i < desc_length do
                    begin
                      inc(i);

                      if (desc_buffer[i] in [#32..#63,#65..#126,#128..#168]) and
                        (length(info.description) < 250) and
                        (((desc_buffer[i] = #32) and (last(1,info.description) <> #32)) or (desc_buffer[i] <> #32)) then
                        info.description := info.description + desc_buffer[i];

                        if desc_buffer[i] <> #10 then
                          begin
                            inc(inx);
                            info.longdesc[inx] := desc_buffer[i];
                          end;
                      end;

                    info.description := strip('B',' ',info.description);
                    info.longcount := inx;
                    if info.longcount > 0 then strip_buffer(info);

                    INFO.CRCstr      := '';
                    if area.AKA > 0 then
                      INFO.Origin := SETUP.Address[area.AKA];
                    INFO.From        := INFO.Origin;
                    INFO.cSeen       := 1;
                    INFO.SeenbyLst[1]:= INFO.Origin;
                    Hatches := True;
                    if HatchNew in area.Status then
                      begin
                        { create hatch entry }
                        Assign (PF, SystemPath + 'PROCESS.FM');
                        {$I-} Reset (PF); {$I+}
                        if IOresult > 0 then Rewrite (PF);
                        Seek (PF, FileSize(PF));
                        Write (PF, INFO);
                        Close (PF);
                      end else
                      begin
                        { create announce entry }
                        if AREA.Grp <> 0 then
                          begin
                            Assign (ANF, SystemPath + 'ANNOUNCE.FM');
                            {$I-} Reset (ANF); {$I+}
                            if IOresult <> 0 then
                              Rewrite (ANF) else Seek (ANF, FileSize(ANF));

                            for I := 1 to 255 do
                              begin
                                if area.msgid[i] then
                                  begin
                                    FillChar (ANN, SizeOf(ANN), 0);
                                    Ann.Name         := INFO.FileSpec;
                                    Ann.Replaces     := INFO.Replaces;
                                    Ann.Area         := INFO.TAG;
                                    Ann.Msg          := i;
                                    Ann.Grp          := Area.Grp;
                                    Ann.Desc         := INFO.Description;
                                    For inx := 1 to sizeof(Ann.ldesc) do
                                      Ann.Ldesc[inx]   := info.longdesc[inx];
                                    Ann.Lcount       := info.longcount;
                                    Ann.CRCstr       := StrHex (CurrCRC,0);
                                    Ann.Arrived      := 0;
                                    Ann.Date         := INFO.Date;
                                    Ann.Size         := INFO.Size;
                                    Ann.Origin       := INFO.Origin;
                                    Ann.From         := INFO.From;
                                    Move (INFO.Path, Ann.Path, SizeOf(Ann.Path));
                                    Write (ANF, ANN);
                                  end;
                              end; { for I := 1 to ... }
                            Close (ANF);
                          end; { if AREA.Grp <> '' }
                      end; { if HatchNew in area.Status }
                 {end;} { if not is_dup }
              end; { if (not first) and ((HatchNew in area.Status) or (AnnNew in area.Status)) }
            inc(cttel);
            ct[cttel] := crc;
          end; { if inx > nr }
      end; { if (doserror=0) and (sr.name <> 'FILES.FM') }
   while doserror=0 do findnext(sr);
End;



Procedure DoScanNow;
Var
    inx      : word;
    filebase : byte;
    io       : word;
    b        : bbsareatype;
    cf       : file;
Begin
    notify(6, AFXt^[afxinx].TAG+' ');
    first  := false;
    if exist(area.directory+'FILES.FM') then
      begin
        assign (cf, area.directory+'FILES.FM');
        setfattr (cf, 0);
        if doserror <> 0 then notifycr(2,'Cannot remove hidden/readonly bit from FILES.FM');
      end else
      begin
        assign (cf, area.directory+'FILES.FM');
        first := true;
      end;

    {$i-} reset (cf,1); {$i+}
    io := ioresult;

    if (io = 0) and (filesize(cf) = 0) then io := 2;

    if io = 2 then
      begin
        {$i-} rewrite (cf,1); {$i+}
        io := ioresult;
      end;

    if io = 0 then
      Begin
        inc (nrscan);

        cttel := filesize(cf);
        cttel := cttel div 4;
        blockread(cf,ct[1],cttel*4,inx);
        if (cttel*4) <> inx then first := true;
        if cttel = 0 then first := true;

         Case Setup.Filebase of
          0 : begin  {files.bbs type filebase}
                bbsarea.path := area.listspec;
                filebase := 0;
              end;
          1 : Begin {ra 2.0 filebase}
                If area.areanr = 0 then
                  Begin
                    bbsarea.path := area.listspec;
                    filebase := 0;
                  End Else
                  Begin
                    filebase := 1;
                    getbbsareanaam(area.areanr);
                    B := BbsArea;
                    If last(1,b.path) <> '\' then b.path := b.path + '\';

                    Reset(bF,1);       {eerste record lezen for filebase path}
                    Seek(bF, 20);
                    BlockRead(bF,Bbsarea,Sizeof(Bbsarea));
                    Close(Bf);

                    If last(1,bbsarea.path) <> '\' then bbsarea.path := bbsarea.path + '\';
                  End;
              End;
        End; {case}

        afiles := 0;
        anew := 0;
        First_File(filebase,BBSAREA.PATH,b,false);
        While not FileListEnd do
          Begin
            Inc(Nrfiles);
            CheckThisFile;
            Next_File(Filebase,false);
          End;

        Close_file(Filebase);
        notifycr(6, '('+int_to_str(afiles)+' files, '+int_to_str(aNew)+' new)');
      End else
      Begin
        notifycr(2,'Cannot create FILES.FM (io_error '+int_to_str(io)); {If IO = 0 }
        exit;
      End;

   {$I-} rewrite(cf,1); {$I+}
   if ioresult <> 0 then
     begin
       notifycr(2,'Cannot rewrite FILES.FM');
       exit;
     end;

   blockwrite(cf,ct[1],afiles*4,inx);
   if afiles*4 <> inx then notifycr(2,'Cannot correctly write hidden FILES.FM file');

   {$I-} close(cf); {$I+}
   If ioresult <> 0 then
     begin
       notifycr(2,'Cannot close FILES.FM');
       exit;
     end;

   Setfattr (cf, hidden + archive);
   if doserror <> 0 then notifycr(2,'Cannot remove hidden/readonly bit from FILES.FM');
End;


Function DoNewScan : boolean;
var
  kk  : file;
begin
  WriteLogCR (6, 'NEWSCAN');
  NotifyCR(8,'Scanning new files...');
  nrscan := 0;
  nrnew  := 0;
  nrfiles := 0;
  hatches:= false;
  for afxinx := 1 to Areaidx do
    begin
      GetArea(afxinx);
      if ((hatchnew in area.status) or (annnew in area.status)) and
           (area.directory <> '') { not passthru } then
        begin
          fillchar (ct, sizeof(ct), 0);
          DoScanNow;
        end else
        begin
          if area.directory <> '' then {not passthru}
            begin
              assign(kk, area.directory + 'FILES.FM');
              {$i-} setfattr (kk, 0);
              if ioresult = 0 then erase (kk); {$i+}
              inoutres := 0;
            end;
        end;
    end;
  NotifyCR (4,int_to_str(NrScan)+' area(s), '+int_to_str(nrfiles)+' files scanned, '
      +int_to_str(NrNew)+' new file(s) found.');

  Donewscan := Hatches;
End;


Procedure NewScan;
begin
  if DoNewScan then
    begin
      Assign (PF, SystemPath + 'PROCESS.FM');
      {$I-} Reset (PF); {$I+}
      if IOresult = 0 then
        begin
          Assign(Pfnew,systempath+'PROCESS.NEW');
          {$I-} rewrite(pfnew); {$I+}
          While not EOF(PF) do
            begin
              Read (PF, INFO);
              If Date_Past (datestring(info.forwar)) then
                ProcessFile Else Write(pfnew,info);
            end;

          {$I-} Close (PF);
          Erase (Pf);
          Close (Pfnew); {$I+}
          If ioresult <> 0 then notifycr(2,'Cannot close PROCESS.FM');

          {$I-} Rename(pfnew,systempath+'PROCESS.FM'); {$I+}
          If ioresult <> 0 then notifycr(2,'Cannot rename PROCESS.NEW to PROCESS.FM');

          If file_size(systempath+'PROCESS.FM') = 0 then delete_file(systempath+'PROCESS.FM');
          If exist(systempath+'FMSYSTMP.#$') then sendsysopmsg('Areas created');
        end else NotifyCR (2,'Error opening PROCESS.FM');
    end;
end;


end.
