{
 $Id$
}
{*****************************************************************************
 *
 * Process:  Message processing for announce and other
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}


Unit Fm_File;  {filefind}

{$X+,V-}

Interface

Uses
  Dos, Crosslib, Fil_Spec, S_String,
  Fm_Struct, Fm_Log, Fm_Basic, Nw_Tpl, Nw_Msg,

  MKMsgAbs, MKGlobt, MkOpen,
  MkMsgSqu, MkMsgHud, MkMsgFid, MkMsgJam, MkmsgEzy;   {mkmsg}


Procedure FileFind;

Implementation


type
 ScanAreaType = Record                                         { FILEFIND.FM }
   MsgBaseId      : Char;         { the msgbase id: hudson, squize, fido etc }
   MsgBaseIdStr   : String[80];             { board number + path of msgbase }
   Status         : MsgStatusType;                 { tearline + echo/netmail }

   ReplyBaseId    : Char;         { the msgbase id: hudson, squize, fido etc }
   ReplyBaseIdStr : String[80];             { board number + path of msgbase }
   ReplyStatus    : MsgStatusType;                            { echo/netmail }
   MsgAttr        : MsgAttribSet;             { attrib bits: crash, hold etc }

   HeaderTpl,                                                { the tpl files }
   FooterTpl,
   EntryTpl,
   BlockHdrTpl,
   BlockFtrTpl    : String[12];

   Origin,                                  { origin to use, or 0 for random }
   Aka            : Byte;                            { aka (fromnode) to use }
   IdName         : String[50];         { for filefind door, identifyer name }

   NotUsed       : Array[1..10] of byte;
 End;


var
  SA            : File of ScanAreaType;                        { filefind.fm }
  ScanArea      : ScanAreaType;                                { filefind.fm }


Function Find_In_File(findstr:string; filename:string) : Boolean;
Var
  t       : file;
  buffer  : array[1..4096] of char;
  count   : word;
  find    : boolean;

  function pos(str:string; count:word) : boolean;
  var
    x, y  : word;
    found : boolean;
  begin
    for x := 1 to (count-length(str))+1 do
      begin
        if upcase(buffer[x]) = str[1] then
          begin
            found := true;
            for y := 2 to length(str) do
              if upcase(buffer[(x+y)-1]) <> str[y] then found := false;
            if found then
              begin
                pos := true;
                exit;
              end;
          end;
      end;
    pos := false;
  end;

begin
  assign(t,filename);
  {$i-} reset(t,1); {$I+}
  If ioresult <> 0 then
    begin
      find_in_file := false;
      exit;
    end;
  findstr := upper(findstr);
  find := false;
  repeat
    blockread(t,buffer,sizeof(buffer),count);
    if count <> 0 then
      begin
        if pos(findstr,count) then find := true;
        if count > length(findstr) then seek(t,filepos(t)-length(findstr));
      end;
  until (count = 0) or find;
  close(t);
  if find then find_in_file := true else find_in_file := false;
end;


Procedure FileFind;
Var
  MsgOut        : AbsMsgPtr;  {mkmsg object for reading}
  ReplyNode     : NodeType;
  MsgNum        : LongInt;
  MsgTo         : String[35];
  MsgFr         : String[35];
  Sr            : searchrec;
  Msgre         : string[72];
  MsgIdStr      : string[35];
  pWord         : String[25];
  pFile         : String[25];
  FFmax,
  FFlast,
  FFinx       : Longint;
  Winx        : Byte;
  DT          : DateTime;
  Firstfile   : Boolean;
  i           : byte;
  part        : byte;

Procedure DoOrigLine;
Begin
  If TearLine in scanarea.Status
    then DoStringln('--- '+msgtearline) else
      DoStringln('--- ');

  If Echo in scanarea.ReplyStatus then  {set msg type}
    Begin
      If scanarea.Origin > 0
        then DoStringLn(' * Origin: '+SETUP.OrigLine[scanarea.Origin]+
                   ' ('+node2str(setup.address[scanarea.aka])+')') else
          Begin
            Repeat
              MsgRe := SETUP.OrigLine[Random(9)+1];
            Until MsgRe <> '';
            DoStringLn(' * Origin: '+MsgRe+' ('+node2str(setup.address[scanarea.aka])+')');
          End;
    End;
End;

Procedure ProcessFound;
var
  x,y : word;
begin
  area.name := bbsarea.name; {!}

  ann.Name    := SR.Name;
  ann.CRCstr  := '';
  ann.Arrived := SR.Time;
  ann.Date    := SR.Time;
  UnpackTime (SR.Time, DT);
  ann.Date    := GetUnixDate (DT);
  ann.Size    := SR.Size;
  ann.Origin  := SETUP.Address[SCANAREA.AKA];
  ann.From    := SETUP.Address[SCANAREA.AKA];
  ann.Grp     := 0;
  ann.Expo    := 0;
  FillChar (ann.Path, SizeOf(ann.Path), 0);

  x := 0;
  y := 0;
  While x < desc_length do
    Begin
      inc(x);

      If setup.wrapdesc then
         if desc_buffer[x] = #13 then desc_buffer[x] := ' ';
      If not (desc_buffer[x] in [#0,#10,#27]) then
        Begin
          If (not setup.extendeddiz) or
            (setup.extendeddiz and (desc_buffer[x] in [#32..#127])) then
              Begin
                Inc(ann.lcount);
                inc(y);

                if x < 255 then ann.desc := ann.desc + desc_buffer[x];
                ann.ldesc[y] := desc_buffer[x];
              End;
        End;
    End;

  { gotcha! }
  If Firstfile then
    Begin
      Write(' ('+ int_to_str(totalcount+1) +')');

      Init_Message (scanarea.ReplyBaseId+scanarea.replybaseidstr,not (TearLine in scanarea.Status),
                    scanarea.aka,scanarea.replystatus,replynode,setup.address[scanarea.aka],
                    'FileMgr '+node2str(setup.address[scanarea.aka]),msgfr,SearchArg);
      DoKludgeln(msgidstr);

      Convert_Tpl( scanarea.headertpl, ann, false, scanarea.aka, msgfr);

      Firstfile := false;
      FfLast := 0;
    End Else
    Begin
      Write(replicate(length(int_to_str(totalcount))+2,#8));
      Write('('+int_to_str(totalcount+1)+')');
    End;

  If (FFlast <> FFinx) and (FFLast > 0) then  { block footer? }
    Begin
      Convert_Tpl( scanarea.blockftrtpl, ann, false, scanarea.aka, msgfr);
      BlockSize  := 0;
      BlockCount := 0;
    End;

  If Big_MessageText(0,setup.ffmaxsize) and (scanarea.msgbaseid <> 'T') then
    Begin
      Writelog(7,' ('+int_to_str(totalcount)+')');
      notify(7,' (posting) ');
      If not Open_Message then NotifyCr(2,'Error opening message base');
      DoStringLn(#13#13+setup.cont1str+#13);
      DoOrigLine;
      inc(part);
      TMsg^.SetSubj( SearchArg+' ('+setup.partstr+' '+int_to_str(part)+')');
      Set_Attrib(scanarea.msgattr,scanarea.msgbaseid);
      If not Save_Message then NotifyCr(2,'Error posting message');

      Init_Message (scanarea.ReplyBaseId+scanarea.replybaseidstr,not (TearLine in scanarea.Status),
                    scanarea.aka,scanarea.replystatus,replynode,setup.address[scanarea.aka],
                    'FileMgr '+node2str(setup.address[scanarea.aka]),msgfr,SearchArg);
      DoKludgeln(msgidstr);
      DoStringLn(#13+setup.cont2str+#13);
      write('('+int_to_str(totalcount+1)+')');
    End;

  If FFlast <> FFinx then
    Begin       { block header }
      Convert_Tpl(scanarea.blockhdrtpl, ann, false, scanarea.aka, msgfr);
      FFlast := FFinx;
    End;

  { entry }
  Inc (BlockSize, ann.Size);
  Inc (BlockCount);
  Inc (TotalSize, ann.Size);
  Inc (TotalCount);

  Convert_Tpl( scanarea.entrytpl, ann, false, scanarea.aka, msgfr);
  pWord := '';
End;


Procedure GetId;
Var Bool   : Boolean;
    TmpStr : String;
    D      : addrtype;

    procedure checkit(bol:boolean);
    begin
      if (Msgidstr = '') and (pos('* Origin:',tmpstr) <> 0) then
        Begin
          Tmpstr := extractwords(wordcnt(tmpstr),1,tmpstr);
          If (first(1,tmpstr) = '(') and (last(1,tmpstr) = ')') then
            Begin
              tmpstr := first(length(tmpstr)-1,tmpstr);
              tmpstr := last(length(tmpstr)-1,tmpstr);

              while not (tmpstr[1] in ['1','2','3','4','5','6','7','8','9','0']) do
                begin
                  tmpstr := last(length(tmpstr)-1,tmpstr);
                end;
              Str2node(tmpstr,replynode,setup.address[scanarea.aka],bool);
              Msgidstr := #1+'REPLY: '+tmpstr;
            End;
        End;
      IF bol then TmpStr := MsgOut^.GetString(78);
    End;

Begin
  MsgOut^.MsgTxtStartUp;
  TmpStr := MsgOut^.GetString(78);
  While (Not MsgOut^.EOM) Do
    Begin
      if (Msgidstr = '') and (pos(#1'MSGID: ',tmpstr) = 1) then
        Begin
          Msgidstr := #1+'REPLY: '+extractwords(2,2,tmpstr);
          Str2node(extractwords(2,1,tmpstr),replynode,setup.address[scanarea.aka],bool);
        End;
      TmpStr := MsgOut^.GetString(79);
    End;

  If MsgIdStr = '' then
    Begin
      Fillchar(D,sizeof(D),#0);
      MsgOut^.GetDest(D);
      If D.Net <> 0 then
        Begin
          Move(D,ReplyNode,sizeof(d));
          MsgidStr := #1+'REPLY : '+node2str(replynode);
        End;
    End;

  If MsgIdStr = '' then
    Begin
      MsgOut^.MsgTxtStartUp;
      TmpStr := MsgOut^.GetString(79);
      While (Not MsgOut^.EOM) Do
        Begin
          Checkit(true);
        End;
      Checkit(false);
    End;
End;

Procedure FindFileFindInArea(BbsArea:BbsAreaType; SearchStr : String);
var
  b    : bbsareatype;  {voor ra 2.0 filebase}
  x, y : word;
  found : boolean;

  Function KeyWordInDesc(str:string) : Boolean;
  Var X,Y  : Word;
      Str1 : String;
  Begin
    KeyWordInDesc := False;
    If length(str) > desc_length then exit;
    For X := 1 to (desc_length-length(str)) do
      Begin
        str1 := '';
        For y := 1 to length(str) do
           str1 := str1 + desc_buffer[x+y-1];
        If upper(str1) = upper(str) then KeyWordInDesc := True;
      End;
  End;

  Procedure CheckFile(filepath:string);
  Var srch : string;
  Begin
    srch := msgre;
    Repeat
      Pword := Extractwords(1,1,srch);
      srch := Extractwords(2,wordcnt(srch),srch);
      if pWord <> '' then
        begin
          if pWord[1] = '/' then
            begin                           { keyword }
              pFile  := Copy(pWord, 2, Length(pWord)-1);
              FillChar (ann, SizeOf(ann), 0);
              if KeyWordInDesc(pfile) or (pos(pword,name_buffer) <> 0) then
                begin
                  FindFirst (filepath + name_buffer, $0, SR);
                  if DOSerror = 0 then ProcessFound;
                end;
            end else
            begin                           { filemask }
              if FileMatch(name_buffer, pWord) then
                begin
                  FillChar (ann, SizeOf(ann), 0);
                  FindFirst (filepath + name_buffer, $0, SR);
                  if DOSerror = 0 then processfound;
                end;
            end;
        end;
    until (pword = '') or (totalcount >= setup.ffmax);
  End;

Begin
  Case Setup.Filebase of
    0 : begin  {files.bbs type filebase}
          If Last(1,bbsarea.path) <> '\' then bbsarea.path := bbsarea.path + '\';

          found := false;
          Repeat
            Pword := Extractwords(1,1,searchstr);
            if wordcnt(searchstr) > 1 then
              searchstr := Extractwords(2,wordcnt(searchstr)-1,searchstr)
                else searchstr := '';
            if pWord[1] = '/' then
              begin                           { keyword }
                found := find_in_file(last(length(pword)-1,pword),bbsarea.path+'files.bbs');
              end else found := true;
          Until (searchstr = '') or found;

          if found then First_File(0,BBSAREA.PATH+'FILES.BBS',bbsarea,false);
        end;
    1 : Begin {ra 2.0 filebase}
          B := BbsArea;
          If last(1,b.path) <> '\' then b.path := b.path + '\';

          Reset(bF,1);               {eerste record lezen voor filebase path}
          Seek(bF, 20);
          BlockRead(bF,Bbsarea,Sizeof(Bbsarea));
          If last(1,bbsarea.path) <> '\' then bbsarea.path := bbsarea.path + '\';

          found := false;
          Repeat
            Pword := Extractwords(1,1,searchstr);
            if wordcnt(searchstr) > 1 then
              searchstr := Extractwords(2,wordcnt(searchstr)-1,searchstr)
                else searchstr := '';

            if pword[1] = '/' {keyword} then
              found := find_in_file(last(length(pword)-1,pword), bbsarea.path+'TXT\FDB'+int_to_str(b.nr)+'.TXT')
                else found := fileinarea(pword, bbsarea.path, b.nr);
          Until (searchstr = '') or found;

          if found then First_File(1,BBSAREA.PATH,b,false);
        End;
   End; {case}

  if found then
    begin
      While not FileListEnd and (TotalCount < Setup.FFmax) do
        Begin
          Case Setup.Filebase of
            0 : CheckFile(Bbsarea.Path);
            1 : CheckFile(B.Path);
          End;
          Next_File(Setup.Filebase,false);
        End;
      Close_file(Setup.Filebase);
    end;
End;


{-----------------}

Function InitMsgs(display:boolean):Boolean;
Begin
  If not OpenMsgArea(MsgOut, scanarea.msgbaseid+scanarea.msgbaseidstr) Then
    begin
      notifycr(2,'Cannot open message base '+scanarea.msgbaseid+scanarea.msgbaseidstr);
      initmsgs := false;
      exit;
    end;

  Case scanarea.MsgBaseId of
   'S': If Display then Notify(7,'Scanning Squish msgbase '+scanarea.msgbaseidstr);
   'H': If Display then Notify(7,'Scanning Hudson msgbase '+first(3,scanarea.msgbaseidstr));
   'F': If Display then Notify(7,'Scanning Fido msgbase '+scanarea.msgbaseidstr);
   'J': If Display then Notify(7,'Scanning Jam msgbase '+scanarea.msgbaseidstr);
   'E': If Display then Notify(7,'Scanning Ezycom msgbase '+first(4,scanarea.msgbaseidstr));
   End;

  MsgOut^.seekfirst(1);
  If Display then NotifyCr(2,' ('+int_to_str(msgout^.NumberOfMsgs)+' msgs)');
  filemode := 66;
  initmsgs := true;
End;



Begin
  WriteLogCR (6, 'FILEFIND');

  Assign (BF, SystemPath + 'FILEAREA.FM');
  {$I-} Reset (BF,1); {$I+}
  If IOresult > 0 then
    begin
      NotifyCR (2,'FILEAREA.FM not found. Please run FMCONV.EXE');
      Exit;
    end;
  FFMax := (Filesize(bF) div sizeof(bbsarea))-2;

  Assign (SA, SystemPath + 'FILEFIND.FM');
  {$I-} Reset (SA); {$I+}
  if IOresult > 0 then
    begin
      NotifyCR (2,'FILEFIND.FM not found. No areas defined to search.');
      Close(Bf);
      Exit;
    end;

  NotifyCr (8,'Scanning filefind requests...');

  While not EOF(SA) do
    Begin
      {$i-} Read (SA, SCANAREA); {$I+}
      If ioresult <> 0 then
        Begin
           NotifyCR(2,'Error reading FILEFIND.FM');
           Exit;
        End;

      If scanarea.msgbaseidstr <> '' then
        Begin
          if InitMsgs(true) then
            begin
          While MsgOut^.SeekFound Do  {als er een bericht gevonden is}
            Begin
              MsgOut^.MsgStartUp;   {read hdr}

              If not MsgOut^.IsRcvd then
                Begin
                  If (Upper(MsgOut^.GetTo) = 'ALLFIX') or
                     (Upper(MsgOut^.GetTo) = 'FILEFIND') or
                     (upper(msgout^.getto) = 'FILEMGR') then
                    Begin
                      MsgIdstr := '';
                      Fillchar(ReplyNode,sizeof(replynode),#0);
                      MsgTo := MsgOut^.GetTo;
                      MsgFr := MsgOut^.Getfrom;
                      MsgNum := MsgOut^.GetMsgDisplayNum;
                      FirstFile := True;
                      SearchArg := MsgOut^.GetSubj;
                      MsgRe := lower(MsgOut^.GetSubj);
                      GetId;

                      if msgidstr <> '' then
                        begin

                          MsgOut^.SetRcvd(True);
                          MsgOut^.RewriteHdr;
                          If not CloseMsgArea(msgout) then
                            notifycr(2,'Cannot close message base');

                          Notify (7,'FileFind request ('+int_to_str(msgnum)+') by '+MsgFr);

                          part := 0;
                          Winx := 0;
                          Repeat
                            Inc (Winx);
                            msgre := replace('\','/',msgre);
                            pword := extractwords(winx,1,msgre);

                            If pWord <> '' then
                              Begin

                                If pWord[1] = '/' then
                                  Begin
                                    If Length(pWord) < (SETUP.FFKeyLen+1) then
                                    {  Delete (msgre, WrdPosL(msgre, Winx), Length(pWord)); }
                                      begin
                                        subject := msgre;  {subject als tmp variable die in deze unit niet wordt gebruikt}
                                        msgre := first(pos(pword,subject)-1,subject) +
                                          last( length(subject)-(pos(pword,subject)+length(pword)), subject);
                                      end;

                                  End Else
                                  Begin
                                    if (pos('.',pword) = 0) and (length(pword) > 8) then pword := first(8,pword);
                                    If (pos('.',pword) = 0) and (length(pword) <= 8) then pword := pword + '*';
                                    If (Length(pWord) <= 12) and (Pos('.',pWord) > 0) then
                                      Begin
                                        if pos(' ',pword) <> 0 then pword := strip('A',' ',pword);
                                        if pos('/',pword) <> 0 then pword := strip('A','/',pword);

                                        pFile := Copy(pWord, 1, Pos('.', pWord)-1);
                                        If Pos('*', pFile) > 0 then {*'s vervangen door ???'s}
                                          Begin
                                            FFinx := Pos('*', pFile);
                                            While Pos('*', pFile) > 0 do Delete(pFile, Pos('*',pFile),1);
                                            I := SETUP.FFstar;
                                            While Length(pFile)+I > 8 do Dec(I);
                                            Insert (Replicate(I,'?'), pFile, FFinx);
                                            pWord := pFile + Copy(pWord, Pos('.', pWord), Length(pWord)-Pos('.', pWord)+1);
                                          End;

                                       {WrdL (pFile, msgre, Winx);}
                                       pfile := extractwords(winx,1,msgre);
                                       subject := msgre;  {subject als tmp variable die in deze unit niet wordt gebruikt}
                                       if pos( replicate(setup.ffone+1,'?'),pfile) <> 0 then
                                       {If (ChrQty(pFile, '?') > SETUP.FFone) then}
                                          {Delete (msgre, WrdPosL(msgre, Winx), Length(pWord)); }
                                          msgre := first(pos(pword,subject)-1,subject) +
                                            last( length(subject)-(pos(pword,subject)+length(pword)), subject)
                                            else
                                           {StrRepl (msgre, pFile, pWord, 1, 1, 255); }
                                           msgre := first(pos(pfile,subject)-1,subject) +
                                             pword + ' ' +
                                             last( length(subject)-(pos(pfile,subject)+length(pfile)), subject);



                                      End;
                                  End;
                              End;
                          Until pWord = '';

                          FirstFile := true;
                          BlockSize  := 0;
                          TotalSize  := 0;
                          BlockCount := 0;
                          TotalCount := 0;

                          If MsgRe = '' then NotifyCR (7,' (rejected)') Else
                            Begin
                              Notify (7,' (searching');
                              Notify (9,' for '+msgre);
                              Notify (7,')');
                              For FFinx := 1 to FFmax+1 do
                                Begin
                                  Reset(bF,1);            {filearea lezen}
                                  Seek(bF, ((FFinx-1) * Sizeof(Bbsarea)) + Sizeof(BbsArea) + 20);
                                  BlockRead(bF,Bbsarea,Sizeof(Bbsarea));
                                  If (TotalCount < Setup.FfMax) and
                                    BbsArea.on then
                                       FindFileFindInArea(BbsArea,MsgRe); {zoeken in de area}
                                End;
                            End;

                          If not FirstFile then with SCANAREA do
                            Begin
                              Writelog(7,' ('+int_to_str(totalcount)+')');
                              If FFlast > 0 then
                                Begin
                                  Empty_Tpl( scanarea.blockftrtpl, false, scanarea.aka, msgfr);
                                End;

                              Empty_Tpl(scanarea.footertpl, false, scanarea.aka, msgfr);

                              NotifyCR (7,' (posting) ');
                              If not Open_Message then NotifyCr(2,'Error opening message base');
                              if scanarea.msgbaseid <> 'T' then DoOrigLine;
                              if part <> 0 then
                                begin
                                  inc(part);
                                  TMsg^.SetSubj( SearchArg+' ('+setup.partstr+' '+int_to_str(part)+')');
                                end;
                              Set_Attrib(scanarea.msgattr,scanarea.msgbaseid);
                              If not Save_Message then NotifyCr(2,'Error posting message');

                            End Else
                            If MsgRe <> '' then NotifyCR(7,' (none found)');

                        End Else
                        Begin
                          MsgOut^.SetRcvd(True);
                          MsgOut^.RewriteHdr;
                          If not CloseMsgArea(msgout) then
                            notifycr(2,'Cannot close message base');
                        End;

                      InitMsgs(false);
                    End;  {aan filefind or allfix}
                End;    {isrcvd}
              MsgOut^.seeknext; {zoek de volgende}
            End;
            If not CloseMsgArea(msgout) then notifycr(2,'Cannot close message base');
            End;

        End; {if msgbaseidstr <> ''}
    End; {while not eof(sa) }

  Close(Sa);
  Close(Bf);
End;


End.


