{
 $Id$
}
{*****************************************************************************
 *
 * Purpose ...............: Create Billing data and reports to nodes
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Fm_Bill;

{$O+}

Interface

Uses Dos,
     Fm_Struct, Fm_Hex, Fm_Basic, Fm_Log, Nw_Msg, Nw_Tpl,
     S_String, F_File, Crosslib, Crc32;

{-----------------------------------------------------------------------------}

Function WriteBillInfo(fromcostprocedure:boolean):Real;   { incl user account deduct }

   { create temp bill file per node, create entries per file, bill node }

Procedure Bill;                                           { send bill to user }

   { collect billed files from tmp file, write bill to user }

Procedure WriteBillHistory(cost:real);                     { add bill history }

   { write per day per user bill history }

Procedure Costs;   { for filemgr's COST parameter }

{-----------------------------------------------------------------------------}

type
  billrec = record           { temp bill file }
    node      : nodetype;    { for this node }
    date      : datetime;
    filename  : string[12];  { the filename }
    totalcost : word;        { total costs for this file }
    cost      : real;        { costs for this node for this file }
    size      : longint;
    downlinks : word;        { how many downlinks received this file }
    tag       : string[20];
  end;

  billhis = record           { history file }
    node  : nodetype;        { for this node }
    date  : datetime;        { date this was billed }
    files : word;            { number of files which were billed }
    cost  : real;            { total costs billed that day }
  end;

Implementation

Function WriteBillInfo(fromcostprocedure:boolean) : Real;
var
  dummy : nodetype;
  x     : word;
  tmp   : string;
  inx   : word;
  crc   : longint;
  b     : billrec;
  dt    : datetime;
  bfile : file of billrec;
Begin
  tmp := node2str(node.address);
  crc := $ffffffff;
  for inx := 1 to length(tmp) do crc := updatecrc32(ord(tmp[inx]),crc);
  crc := not(crc);
  tmp := strhex(crc,8)+'.BIL';

  assign(bfile,systempath+tmp);
  {$I-} reset(bfile); {$I+}
  if ioresult <> 0 then rewrite(bfile);
  seek(bfile,filesize(bfile));

  if (node.addpercent > 0) and not fromcostprocedure then
    begin
      b.cost := info.cost   + ( node.addpercent * ( info.cost / 100 ));
      b.totalcost := round(b.cost * info.nodes);

      if setup.expandedlog then
        writelogcr(3,'Added '+int_to_str(node.addpercent)+' percent to cost for '+node2str(node.address)+' ('+
          real_to_str((info.cost / 100) * node.addpercent,2) +')');

    end else
    begin
      b.totalcost := round(info.totalcost);
      b.cost      := info.cost;
    end;

  b.node      := node.address;
  b.filename  := info.filespec;
  b.size      := info.size;
  b.downlinks := info.nodes;
  b.tag       := info.tag;

  fillchar(dt,sizeof(dt),0);
  with dt do
    getdate (year, month, day, min);
  dt.min := 0;
  b.date := dt;

  write(bfile,b);
  close(bfile);

  writebillinfo := b.cost;

  { bill node }
  x := 1;
  While (x <= Nodeidx) and (Not NodeEQ(NFXt^[x].ADDRESS, node.address)) Do Inc(x);
  if x <= Nodeidx then
    begin
      Seek (NF, NFXt^[x].NodeRec);
      blockRead (NF, NODE, sizeof(node));

      if fromcostprocedure then
        begin
          if first(1,partag) = '+' then
            begin
              node.credit := node.credit + b.cost;
              notifycr(3,'Added '+real_to_str(b.cost,0)+' cents to '+node2str(node.address)+' credit.');
            end else
            begin
              node.credit := node.credit - b.cost;
              notifycr(3,'Billed '+real_to_str(b.cost,0)+' cents to '+node2str(node.address)+'.');
            end;
        end else
        begin
          node.credit := node.credit - b.cost;
          if setup.expandedlog then
            writelogcr(3,node2str(node.address)+' billed for '+real_to_str(b.cost,2)+' cents.');
        end;

      if (node.credit <= node.warnlevel) and not node.warnnot then
        begin
          node.warnnot := true;
          writelogcr(3,node2str(node.address)+' credits left: '+real_to_str(node.credit,2)+' cents. Warning send.');
          {stuur notify bericht}

          Dummy.Zone := 0;
          MatchAKA (Dummy, Node.Address);

          Init_Message ('F'+setup.netmailpath, true, 0, [net],
              node.address, dummy, 'FileMgr '+version,
              node.sysopname, 'Low on credits!');
          Open_message;
          Set_Attrib([Privat,Killsent],'F');
          Set_Attrib2(node.mgrstatus);

          DoStringLn('Hello '+extractwords(1,1,node.sysopname)+',');
          DoStringLn('');

          if (strip('B',' ',setup.aooctplmsg) <> '') and exist(setup.aooctplmsg) then
            begin
              Empty_Tpl (setup.aooctplmsg, false,0, node.sysopname);
            end else
            begin
              DoStringln('You are low on credits!');
              Dostringln('');
              Dostringln('You have '+real_to_str(node.credit,0)+' left, and as soon as this hits '
                +int_to_str(node.stoplevel)+' you will be set on pause.');
              Dostringln('');
              DoStringLn( 'Regards,');
              DoStringLn( SETUP.SysopName + ' ('+ Node2Str(dummy) +')'+#13);
            end;
          Save_Message;
        end;

      if node.credit <= node.stoplevel then
        begin
          node.warnnot := true;

          writelogcr(3,node2str(node.address)+' credits left: '+real_to_str(node.credit,2)+' cents. Sysop notified.');
          {stuur notify bericht}

          Dummy.Zone := 0;
          MatchAKA (Dummy, Node.Address);

          Init_Message ('F'+setup.netmailpath, true, 0, [net],
            node.address, dummy, 'FileMgr '+version,
            node.sysopname, 'No credits left!');
          Open_message;
          Set_Attrib([Privat,Killsent],'F');
          Set_Attrib2(node.mgrstatus);

          DoStringLn('Hello '+extractwords(1,1,node.sysopname)+',');
          DoStringLn('');

          if (strip('B',' ',setup.ooctplmsg) <> '') and exist(setup.ooctplmsg) then
            begin
              Empty_Tpl (setup.ooctplmsg, false,0, node.sysopname);
            end else
            begin
              DoStringln('You have no credits left!');
              Dostringln('');
              Dostringln('You do not receive any files anymore for which credits are needed.');
              Dostringln('');
              DoStringLn( 'Regards,');
              DoStringLn( SETUP.SysopName + ' ('+ Node2Str(dummy) +')'+#13);
            end;

          Save_Message;
        end;

      Seek (NF, NFXt^[x].NodeRec);
      blockwrite(NF, NODE, sizeof(node));
    end;
End;

Procedure Bill;
var
  y, m, d, dow : Word;
  doorgaan : boolean;
  dummy : nodetype;
  total : real;
  totalp : real;
  b     : billrec;
  bfile : file of billrec;
  Sr    : Searchrec;
  x     : word;
  tmp   : string[10];
  totalkb : longint;

{
Dostringln('
File:         Area:           Size:  Totalcost:  Downlinks:  Cost for you:');
1234567890123456789012345678901234567890123456789012345678901234567890
              1234567890123 12345678   1234         123        123456.78
}
  Procedure WriteIt;
  var
    tmp : string[80];
  Begin
    if b.size > 1024 then
      begin
        b.size := b.size div 1024; {kb's}
        tmp := int_to_str(b.size)+' Kb';
        totalkb := totalkb + b.size;
      end else
      begin
       tmp := int_to_str(b.size)+'   ';
       inc(totalkb);
      end;

    If (wordcnt(b.filename) = 2) and (extractwords(1,1,b.filename) = 'Manual') then
      begin
        if extractwords(2,1,b.filename) = '+' then
          begin
            Dostringln('Manually added by sysop '+expand(' ',39)+allign(real_to_str(b.cost,2),9)+' +');
            totalp := totalp + b.cost;
          end else
          begin
            Dostringln('Manually deducted by sysop '+expand(' ',36)+allign(real_to_str(b.cost,2),9));
            total := total + b.cost;
          end;
      end else
      begin
        Dostringln(expand(b.filename,14)
              +first(13,expand(b.tag,13))+' '+allign(tmp,8)+'   '+
               allign(int_to_str(b.totalcost),4)+  expand(' ',9)+
               allign(int_to_str(b.downlinks),3)+  expand(' ',9)+
               allign(real_to_str(b.cost,2),8));
        total := total + b.cost;
      end;

  End;

Begin
(*
  node.sendbill =             { 0 = direct, 1 = daily, 2 = weekly, 3 = montly }
*)
  Findfirst(systempath+'*.BIL',$0,sr);
  While doserror = 0 do
    begin
      assign(bfile,systempath+sr.name);
      {$I-} reset(bfile); {$I+}
      if ioresult = 0 then
        begin
          read(bfile,b);
          x := 1;
          While (x <= Nodeidx) and (Not NodeEQ(NFXt^[x].ADDRESS, b.node)) Do Inc(x);
          if x <= Nodeidx then
            begin
              Seek (NF, NFXt^[x].NodeRec);
              blockRead (NF, NODE, sizeof(node));

              doorgaan := false;
              case node.sendbill of
               0 : doorgaan := true;
               1 : begin {daily}
                     GetDate(y,m,d,dow);
                     if d <> node.sendday then
                       begin
                         doorgaan := true;
                         node.sendday := d;
                         Seek (NF, NFXt^[x].NodeRec);
                         blockwrite(NF, NODE, sizeof(node));
                       end;
                   end;
               2 : begin {weekly}
                     tmp := daynumber;
                     if (node.sendday > str_to_int(tmp)) or (node.sendday+6 >= str_to_int(tmp)) then
                       begin
                         doorgaan := true;
                         node.sendday := str_to_int(tmp);
                         Seek (NF, NFXt^[x].NodeRec);
                         blockwrite(NF, NODE, sizeof(node));
                       end;
                   end;
               3 : begin {montly}
                     tmp := daynumber;
                     if (node.sendday > str_to_int(tmp)) or (node.sendday+30 >= str_to_int(tmp)) then
                       begin
                         doorgaan := true;
                         node.sendday := str_to_int(tmp);
                         Seek (NF, NFXt^[x].NodeRec);
                         blockwrite(NF, NODE, sizeof(node));
                       end;
                   end;
              end;

              if doorgaan then
                begin
                  write('Sending bill to: '+expand(node2str(b.node),30)+#13);

                  Dummy.Zone := 0;
                  MatchAKA (Dummy, Node.Address);

                  Init_Message ('F'+setup.netmailpath, true, 0, [net],
                       node.address, dummy, 'FileMgr '+version,
                       node.sysopname, 'Invoice');

                  rescan := true;
                  total := 0;
                  totalp := 0;
                  totalkb := 0;
                  Open_Message;
                  Set_Attrib([Privat,Killsent],'F');
                  Set_Attrib2(node.mgrstatus);

                  DoStringLn('Hello '+extractwords(1,1,node.sysopname)+',');
                  DoStringLn('');
                  DoStringLn('These charges have been made to your account at '+setup.systemname+':');
                  Dostringln('');
                  Dostringln('File:         Area:           Size:  Totalcost:  Downlinks:  Cost for you:');
                  Dostringln('--------------------------------------------------------------------------');
                  writeit;
                  while not eof(bfile) do
                    begin
                      read(bfile,b);
                      writeit;
                    end;


                  Dostringln('--------------------------------------------------------------------------');
                  Dostringln(expand(' ',25)+allign(int_to_str(totalkb),8)+' Kb'+expand(' ',29)+
                     allign(real_to_str(total-totalp,2),7));


                  Dostringln('');
                  if total > 0 then Dostringln('Total credits deducted: '+real_to_Str(total,0)+' cents');
                  if totalp > 0 then Dostringln('Total credits added   : '+real_to_str(totalp,0)+' cents');
                  Dostringln('Credits left          : '+real_to_Str(node.credit,0)+' cents');
                  Dostringln('');

                  if (strip('B',' ',setup.csobillmsg) <> '') and exist(setup.csobillmsg) then
                    begin
                      Empty_Tpl (setup.csobillmsg, false,0, node.sysopname);
                    end;

                  DoStringln('--- ' + msgtearline);
                  Save_Message;
                  close(bfile);
                  erase(bfile);
                  writelogcr(3,node2str(node.address)+' billed totally for '+real_to_str(total,2));
                end;
            end else close(bfile);
        end;
      findnext(sr);
    end;
  write(expand(' ',50));
End;

Procedure WriteBillHistory(cost:real);
Var
  tel      : longint;
  x, count : word;
  b,k      : billhis;
  bfile    : file;
  dt       : datetime;
  barray   : array[1..30] of billhis;
  found    : boolean;
Begin
  write('-> Updating bill history for '+node2str(node.address)+#13);
  b.node := node.address;
  fillchar(dt,sizeof(dt),0);
  with dt do
    getdate (year, month, day, min);
  dt.min := 0;
  b.date := dt;

  assign(bfile,systempath+'BILLHIS.FM');
  {$I-} reset(bfile,1); {$I+}
  if ioresult <> 0 then rewrite(bfile,1);

  {kijken of we van deze node van deze dag al een record hebben }
  found := false;
  tel := 0;
  repeat
    blockread(bfile,barray,sizeof(barray),count);
    count := count div sizeof(b);
    for x := 1 to count do
      begin
        if not found then inc(tel);
        if samerec(barray[x].node,b.node,sizeof(b.node)) then
          begin
            if samerec(barray[x].date,b.date,sizeof(b.date)) then
              found := true;
          end;
      end;
  until found or (count = 0);
  if found then
    begin
      seek(bfile,(tel-1)*sizeof(b));
      blockread(bfile,k,sizeof(b));
      seek(bfile,(tel-1)*sizeof(b));
       {change}
      k.files := k.files + 1;
      k.cost := k.cost + cost;
      blockwrite(bfile,k,sizeof(b));
    end else
    begin
      seek(bfile,filesize(bfile));
      b.files := 1;
      b.cost := cost;
      blockwrite(bfile,b,sizeof(b));
    end;
  close(bfile);
  write(replicate(79,' ')+#13);
End;

procedure costs;
var i   : word;
    bak : word;
begin
  writelogcr(6,'COST');

  info.size := 0;
  info.nodes := 0;
  info.tag := '';

  if validnode then
    begin
      i := 1;
      While (i <= Nodeidx) and (Not NodeEQ(NFXt^[i].ADDRESS, parnode)) Do Inc(i);
      If NodeEQ(NFXt^[i].ADDRESS, parnode) then
        Begin
          Seek (NF, NFXt^[i].NodeRec);
          blockRead (NF, NODE, sizeof(node));

          info.filespec := 'Manual -';

          if first(1,partag) = '+' then
            begin
              info.cost := str_to_real(last(length(partag)-1,partag));
              info.filespec := 'Manual +';
            end else
          if first(1,partag) = '-' then
            info.cost := str_to_real(last(length(partag)-1,partag)) else
            info.cost := str_to_real(partag);

          writebillhistory(writebillinfo(true));

        End Else NotifyCr (2,'System '+Node2Str(parnode)+' not found.');
    end else
  if part then
    begin
      i := 1;
      While (i <= nodeidx) do
        Begin
          Seek(nf,nfxt^[i].noderec);
          Blockread(nf,node,sizeof(node));

          If pos(pnod,node2str(node.address)) <> 0 then
            begin

              info.filespec := 'Manual -';

              if first(1,partag) = '+' then
                begin
                  info.cost := str_to_real(last(length(partag)-1,partag));
                  info.filespec := 'Manual +';
                end else
              if first(1,partag) = '-' then
                info.cost := str_to_real(last(length(partag)-1,partag)) else
                info.cost := str_to_real(partag);

              writebillhistory(writebillinfo(true));

            end;
          inc(i);
        End;

    end else notifycr(2,'No valid nodenumber supplied');
end;

END.
