/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.test.TestTools;
import com.enterprisedt.util.debug.FileAppender;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public abstract class FTPTestCase
extends TestCase {
    public static String cvsId = "@(#)$Id: FTPTestCase.java,v 1.22 2007-05-29 04:16:16 bruceb Exp $";
    protected Logger log = Logger.getLogger("FTPTestCase");
    protected FTPClientInterface ftp;
    protected int lowPort = 10000 + (int)Math.random() * 20000;
    protected int highPort = this.lowPort + 15;
    protected String testdir;
    protected String remoteTextFile;
    protected String localTextFile;
    protected String localUnixTextFile;
    protected String remoteBinaryFile;
    protected String localBinaryFile;
    protected String localEmptyFile;
    protected String remoteEmptyFile;
    protected String remoteEmptyDir;
    protected String localBigFile;
    protected String localBigTextFile;
    protected String localTestDir;
    protected String logDir;
    protected String localDataDir;
    protected int bulkCount = 100;
    protected Properties props = new Properties();
    protected TestTools tools;

    public FTPTestCase() {
        String highPortStr;
        String lowPortStr;
        Logger.setLevel(Level.DEBUG);
        String propsfile = System.getProperty("ftptest.properties.filename", "test.properties");
        try {
            this.props.load(new FileInputStream(propsfile));
        }
        catch (IOException iOException) {
            System.out.println("Failed to open " + propsfile);
            System.exit(-1);
        }
        this.testdir = this.props.getProperty("ftptest.testdir");
        this.localTextFile = this.props.getProperty("ftptest.file.local.text");
        this.localUnixTextFile = this.props.getProperty("ftptest.file.local.text.unix");
        this.localTestDir = this.props.getProperty("ftptest.dir.local");
        this.localDataDir = this.props.getProperty("ftptest.datadir.local", "data");
        if (!this.localDataDir.endsWith(File.separator)) {
            this.localDataDir = String.valueOf(this.localDataDir) + File.separator;
        }
        this.localBigFile = this.props.getProperty("ftptest.file.local.big");
        this.localBigTextFile = this.props.getProperty("ftptest.file.local.big.text");
        this.remoteTextFile = this.props.getProperty("ftptest.file.remote.text");
        this.localBinaryFile = this.props.getProperty("ftptest.file.local.binary");
        this.remoteBinaryFile = this.props.getProperty("ftptest.file.remote.binary");
        this.localEmptyFile = this.props.getProperty("ftptest.file.local.empty");
        this.remoteEmptyFile = this.props.getProperty("ftptest.file.remote.empty");
        this.remoteEmptyDir = this.props.getProperty("ftptest.dir.remote.empty");
        String bulkCountStr = this.props.getProperty("ftptest.bulkcount");
        this.logDir = this.props.getProperty("ftptest.logdir", "log");
        if (bulkCountStr != null) {
            this.bulkCount = Integer.parseInt(bulkCountStr);
        }
        if ((lowPortStr = this.props.getProperty("ftptest.lowport")) != null) {
            this.lowPort = Integer.parseInt(lowPortStr);
        }
        if ((highPortStr = this.props.getProperty("ftptest.highport")) != null) {
            this.highPort = Integer.parseInt(highPortStr);
        }
        String testToolsClass = this.props.getProperty("ftptest.testtools");
        this.tools = this.loadTestTools(testToolsClass);
        this.tools.setProperties(this.props);
    }

    private TestTools loadTestTools(String testToolsClass) {
        try {
            Class<?> clazz = Class.forName(testToolsClass);
            return (TestTools)clazz.newInstance();
        }
        catch (Exception ex) {
            this.log.error("Failed to instantiate " + testToolsClass, ex);
            return null;
        }
    }

    protected void setUp() throws Exception {
        Logger.addAppender(new FileAppender(String.valueOf(this.logDir) + File.separator + this.getLogName()));
    }

    protected void tearDown() throws Exception {
        Logger.shutdown();
    }

    protected void connect() throws Exception {
        this.ftp = this.tools.connect();
        Assert.assertEquals((boolean)true, (boolean)this.ftp.connected());
        this.log.debug("connected successfully");
    }

    protected String generateRandomFilename() {
        Date now = new Date();
        Long ms = new Long(now.getTime());
        return ms.toString();
    }

    protected void assertIdentical(byte[] buf1, byte[] buf2) throws Exception {
        Assert.assertEquals((int)buf1.length, (int)buf2.length);
        int i = 0;
        while (i < buf1.length) {
            Assert.assertEquals((byte)buf1[i], (byte)buf2[i]);
            ++i;
        }
    }

    protected void assertIdentical(String file1, String file2) throws Exception {
        File f1 = new File(file1);
        File f2 = new File(file2);
        this.assertIdentical(f1, f2);
    }

    protected void assertIdentical(File file1, File file2) throws Exception {
        FilterInputStream is2;
        block10: {
            FilterInputStream is1 = null;
            is2 = null;
            try {
                try {
                    Assert.assertEquals((long)file1.length(), (long)file2.length());
                    this.log.debug("Identical size [" + file1.getName() + "," + file2.getName() + "]");
                    is1 = new BufferedInputStream(new FileInputStream(file1));
                    is2 = new BufferedInputStream(new FileInputStream(file2));
                    int ch1 = 0;
                    int ch2 = 0;
                    int count = 0;
                    try {
                        while ((ch1 = ((BufferedInputStream)is1).read()) != -1 && (ch2 = ((BufferedInputStream)is2).read()) != -1) {
                            ++count;
                            Assert.assertEquals((int)ch1, (int)ch2);
                        }
                    }
                    catch (AssertionFailedError e) {
                        this.log.debug("Comparison failed on char position=" + count);
                        throw e;
                    }
                    this.log.debug("Contents equal");
                }
                catch (IOException ex) {
                    Assert.fail((String)("Caught exception: " + ex.getMessage()));
                }
                Object var6_10 = null;
                if (is1 == null) break block10;
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                if (is1 != null) {
                    is1.close();
                }
                if (is2 != null) {
                    is2.close();
                }
                throw throwable;
            }
            is1.close();
        }
        if (is2 != null) {
            is2.close();
        }
    }

    protected void bulkTransfer(String localFile) throws Exception {
        String filename = this.generateRandomFilename();
        this.log.debug("Bulk transfer count=" + this.bulkCount);
        int i = 0;
        while (i < this.bulkCount) {
            this.ftp.put(String.valueOf(this.localDataDir) + localFile, filename);
            this.ftp.get(String.valueOf(this.localDataDir) + filename, filename);
            this.ftp.delete(filename);
            ++i;
        }
        this.assertIdentical(String.valueOf(this.localDataDir) + localFile, String.valueOf(this.localDataDir) + filename);
        File local = new File(String.valueOf(this.localDataDir) + filename);
        local.delete();
    }

    protected void print(String[] list) {
        this.log.debug("Directory listing:");
        int i = 0;
        while (i < list.length) {
            this.log.debug(list[i]);
            ++i;
        }
        this.log.debug("Listing complete");
    }

    protected void print(File[] list) {
        this.log.debug("Directory listing:");
        int i = 0;
        while (i < list.length) {
            this.log.debug(list[i].getName());
            ++i;
        }
        this.log.debug("Listing complete");
    }

    protected void print(FTPFile[] list) {
        this.log.debug("Directory listing:");
        int i = 0;
        while (i < list.length) {
            this.log.debug(list[i].toString());
            ++i;
        }
        this.log.debug("Listing complete");
    }

    protected abstract String getLogName();
}

