/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPDataSocket;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPReply;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class FTPControlSocket {
    private static String cvsId = "@(#)$Id: FTPControlSocket.java,v 1.3 2001/10/09 20:53:46 bruceb Exp $";
    static final String EOL = "\r\n";
    private static final int CONTROL_PORT = 21;
    private boolean debugResponses = false;
    private PrintWriter log = new PrintWriter(System.out);
    private Socket controlSock = null;
    private Writer writer = null;
    private BufferedReader reader = null;

    public FTPControlSocket(String string) throws IOException, FTPException {
        this(string, 21);
    }

    public FTPControlSocket(String string, int n) throws IOException, FTPException {
        this.controlSock = new Socket(string, n);
        this.initStreams();
        this.validateConnection();
    }

    public FTPControlSocket(InetAddress inetAddress) throws IOException, FTPException {
        this(inetAddress, 21);
    }

    public FTPControlSocket(InetAddress inetAddress, int n) throws IOException, FTPException {
        this.controlSock = new Socket(inetAddress, n);
        this.initStreams();
        this.validateConnection();
    }

    FTPDataSocket createDataSocket(FTPConnectMode fTPConnectMode) throws IOException, FTPException {
        if (fTPConnectMode == FTPConnectMode.ACTIVE) {
            return new FTPDataSocket(this.createDataSocketActive());
        }
        return new FTPDataSocket(this.createDataSocketPASV());
    }

    ServerSocket createDataSocketActive() throws IOException, FTPException {
        ServerSocket serverSocket = new ServerSocket(0);
        InetAddress inetAddress = this.controlSock.getLocalAddress();
        this.setDataPort(inetAddress, (short)serverSocket.getLocalPort());
        return serverSocket;
    }

    Socket createDataSocketPASV() throws IOException, FTPException {
        String string = this.sendCommand("PASV");
        this.validateReply(string, "227");
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        if (n < 0 && n2 < 0) {
            n = string.toUpperCase().lastIndexOf("MODE") + 4;
            n2 = string.length();
        }
        String string2 = string.substring(n + 1, n2);
        int[] nArray = new int[6];
        int n3 = string2.length();
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = 0;
        while (n5 < n3 && n4 <= 6) {
            char c = string2.charAt(n5);
            if (Character.isDigit(c)) {
                stringBuffer.append(c);
            } else if (c != ',') {
                throw new FTPException("Malformed PASV reply: " + string);
            }
            if (c == ',' || n5 + 1 == n3) {
                try {
                    nArray[n4++] = Integer.parseInt(stringBuffer.toString());
                    stringBuffer.setLength(0);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FTPException("Malformed PASV reply: " + string);
                }
            }
            ++n5;
        }
        String string3 = String.valueOf(nArray[0]) + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
        int n6 = (nArray[4] << 8) + nArray[5];
        return new Socket(string3, n6);
    }

    void debugResponses(boolean bl) {
        this.debugResponses = bl;
    }

    String getRemoteHostName() {
        InetAddress inetAddress = this.controlSock.getInetAddress();
        return inetAddress.getHostName();
    }

    private void initStreams() throws IOException {
        InputStream inputStream = this.controlSock.getInputStream();
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        OutputStream outputStream = this.controlSock.getOutputStream();
        this.writer = new OutputStreamWriter(outputStream);
    }

    public void logout() throws IOException {
        this.log.flush();
        this.log = null;
        IOException iOException = null;
        try {
            this.writer.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        try {
            this.reader.close();
        }
        catch (IOException iOException3) {
            iOException = iOException3;
        }
        try {
            this.controlSock.close();
        }
        catch (IOException iOException4) {
            iOException = iOException4;
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    String readReply() throws IOException {
        String string = this.reader.readLine();
        if (string == null) {
            throw new IOException("Unexpect null reply received");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (this.debugResponses) {
            this.log.println(stringBuffer.toString());
        }
        String string2 = stringBuffer.toString().substring(0, 3);
        if (stringBuffer.charAt(3) == '-') {
            boolean bl = false;
            while (!bl) {
                String string3 = this.reader.readLine();
                if (string3 == null) {
                    throw new IOException("Unexpected null reply received");
                }
                if (this.debugResponses) {
                    this.log.println(string3);
                }
                if (string3.length() > 3 && string3.substring(0, 3).equals(string2) && string3.charAt(3) == ' ') {
                    stringBuffer.append(string3.substring(3));
                    bl = true;
                    continue;
                }
                stringBuffer.append(" ");
                stringBuffer.append(string3);
            }
        }
        return stringBuffer.toString();
    }

    String sendCommand(String string) throws IOException {
        if (this.debugResponses) {
            this.log.println("---> " + string);
        }
        this.writer.write(String.valueOf(string) + EOL);
        this.writer.flush();
        return this.readReply();
    }

    private void setDataPort(InetAddress inetAddress, short s) throws IOException, FTPException {
        byte[] byArray = inetAddress.getAddress();
        byte[] byArray2 = this.toByteArray(s);
        String string = "PORT " + this.toUnsignedShort(byArray[0]) + "," + this.toUnsignedShort(byArray[1]) + "," + this.toUnsignedShort(byArray[2]) + "," + this.toUnsignedShort(byArray[3]) + "," + this.toUnsignedShort(byArray2[0]) + "," + this.toUnsignedShort(byArray2[1]);
        String string2 = this.sendCommand(string);
        this.validateReply(string2, "200");
    }

    void setLogStream(PrintWriter printWriter) {
        this.log = printWriter;
    }

    void setTimeout(int n) throws IOException {
        if (this.controlSock == null) {
            throw new IllegalStateException("Failed to set timeout - no control socket");
        }
        this.controlSock.setSoTimeout(n);
    }

    protected byte[] toByteArray(short s) {
        byte[] byArray = new byte[]{(byte)(s >> 8), (byte)(s & 0xFF)};
        return byArray;
    }

    private short toUnsignedShort(byte by) {
        return by < 0 ? (short)(by + 256) : (short)by;
    }

    private void validateConnection() throws IOException, FTPException {
        String string = this.readReply();
        this.validateReply(string, "220");
    }

    FTPReply validateReply(String string, String string2) throws IOException, FTPException {
        String string3 = string.substring(0, 3);
        String string4 = string.substring(4);
        FTPReply fTPReply = new FTPReply(string3, string4);
        if (string3.equals(string2)) {
            return fTPReply;
        }
        throw new FTPException(string4, string3);
    }

    FTPReply validateReply(String string, String[] stringArray) throws IOException, FTPException {
        String string2 = string.substring(0, 3);
        String string3 = string.substring(4);
        FTPReply fTPReply = new FTPReply(string2, string3);
        int n = 0;
        while (n < stringArray.length) {
            if (string2.equals(stringArray[n])) {
                return fTPReply;
            }
            ++n;
        }
        throw new FTPException(string3, string2);
    }
}

