/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPControlSocket;
import com.enterprisedt.net.ftp.FTPDataSocket;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.FTPTransferType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class FTPClient {
    private static String cvsId = "@(#)$Id: FTPClient.java,v 1.3 2001/10/09 20:53:46 bruceb Exp $";
    private SimpleDateFormat tsFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private FTPControlSocket control = null;
    private FTPDataSocket data = null;
    private int timeout = 0;
    private FTPTransferType transferType = FTPTransferType.ASCII;
    private FTPConnectMode connectMode = FTPConnectMode.PASV;
    private FTPReply lastValidReply;

    public FTPClient(String string) throws IOException, FTPException {
        this.control = new FTPControlSocket(string);
    }

    public FTPClient(String string, int n) throws IOException, FTPException {
        this.control = new FTPControlSocket(string, n);
    }

    public FTPClient(InetAddress inetAddress) throws IOException, FTPException {
        this.control = new FTPControlSocket(inetAddress);
    }

    public FTPClient(InetAddress inetAddress, int n) throws IOException, FTPException {
        this.control = new FTPControlSocket(inetAddress, n);
    }

    public void chdir(String string) throws IOException, FTPException {
        String string2 = this.control.sendCommand("CWD " + string);
        this.lastValidReply = this.control.validateReply(string2, "250");
    }

    public void debugResponses(boolean bl) {
        this.control.debugResponses(bl);
    }

    public void delete(String string) throws IOException, FTPException {
        String string2 = this.control.sendCommand("DELE " + string);
        this.lastValidReply = this.control.validateReply(string2, "250");
    }

    public String[] dir() throws IOException, FTPException {
        return this.dir(null, false);
    }

    public String[] dir(String string) throws IOException, FTPException {
        return this.dir(string, false);
    }

    public String[] dir(String string, boolean bl) throws IOException, FTPException {
        String string2;
        this.data = this.control.createDataSocket(this.connectMode);
        this.data.setTimeout(this.timeout);
        String string3 = string2 = bl ? "LIST " : "NLST ";
        if (string != null) {
            string2 = String.valueOf(string2) + string;
        }
        string2 = string2.trim();
        String string4 = this.control.sendCommand(string2);
        String[] stringArray = new String[]{"125", "150"};
        this.lastValidReply = this.control.validateReply(string4, stringArray);
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(this.data.getInputStream()));
        Vector<String> vector = new Vector<String>();
        String string5 = null;
        while ((string5 = lineNumberReader.readLine()) != null) {
            vector.add(string5);
        }
        try {
            lineNumberReader.close();
            this.data.close();
        }
        catch (IOException iOException) {}
        String[] stringArray2 = new String[]{"226", "250", "550"};
        string4 = this.control.readReply();
        this.lastValidReply = this.control.validateReply(string4, stringArray2);
        String[] stringArray3 = new String[]{};
        if (!this.lastValidReply.getReplyCode().equals("550")) {
            stringArray3 = vector.toArray(new String[0]);
        }
        return stringArray3;
    }

    public void get(OutputStream outputStream, String string) throws IOException, FTPException {
        if (this.getType() == FTPTransferType.ASCII) {
            this.getASCII(outputStream, string);
        } else {
            this.getBinary(outputStream, string);
        }
        this.validateTransfer();
    }

    public byte[] get(String string) throws IOException, FTPException {
        int n;
        this.initGet(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new DataInputStream(this.data.getInputStream()));
        int n2 = 4096;
        byte[] byArray = new byte[n2];
        byte[] byArray2 = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        while ((n = bufferedInputStream.read(byArray, 0, n2)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        byArray2 = byteArrayOutputStream.toByteArray();
        try {
            bufferedInputStream.close();
            this.data.close();
        }
        catch (IOException iOException) {}
        this.validateTransfer();
        return byArray2;
    }

    public void get(String string, String string2) throws IOException, FTPException {
        if (this.getType() == FTPTransferType.ASCII) {
            this.getASCII(string, string2);
        } else {
            this.getBinary(string, string2);
        }
        this.validateTransfer();
    }

    private void getASCII(OutputStream outputStream, String string) throws IOException, FTPException {
        this.initGet(string);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(this.data.getInputStream()));
        this.data.setTimeout(this.timeout);
        IOException iOException = null;
        String string2 = null;
        try {
            try {
                while ((string2 = lineNumberReader.readLine()) != null) {
                    bufferedWriter.write(string2, 0, string2.length());
                    bufferedWriter.newLine();
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            bufferedWriter.close();
            throw throwable;
        }
        bufferedWriter.close();
        try {
            lineNumberReader.close();
            this.data.close();
        }
        catch (IOException iOException3) {}
        if (iOException != null) {
            throw iOException;
        }
    }

    private void getASCII(String string, String string2) throws IOException, FTPException {
        this.initGet(string2);
        File file = new File(string);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(this.data.getInputStream()));
        this.data.setTimeout(this.timeout);
        IOException iOException = null;
        String string3 = null;
        try {
            try {
                while ((string3 = lineNumberReader.readLine()) != null) {
                    bufferedWriter.write(string3, 0, string3.length());
                    bufferedWriter.newLine();
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                file.delete();
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            bufferedWriter.close();
            throw throwable;
        }
        bufferedWriter.close();
        try {
            lineNumberReader.close();
            this.data.close();
        }
        catch (IOException iOException3) {}
        if (iOException != null) {
            throw iOException;
        }
    }

    private void getBinary(OutputStream outputStream, String string) throws IOException, FTPException {
        this.initGet(string);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new DataInputStream(this.data.getInputStream()));
        this.data.setTimeout(this.timeout);
        int n = 4096;
        byte[] byArray = new byte[n];
        IOException iOException = null;
        try {
            try {
                int n2;
                while ((n2 = bufferedInputStream.read(byArray, 0, n)) >= 0) {
                    bufferedOutputStream.write(byArray, 0, n2);
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            bufferedOutputStream.close();
            throw throwable;
        }
        bufferedOutputStream.close();
        try {
            bufferedInputStream.close();
            this.data.close();
        }
        catch (IOException iOException3) {}
        if (iOException != null) {
            throw iOException;
        }
    }

    private void getBinary(String string, String string2) throws IOException, FTPException {
        this.initGet(string2);
        File file = new File(string);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string, false));
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new DataInputStream(this.data.getInputStream()));
        this.data.setTimeout(this.timeout);
        int n = 4096;
        byte[] byArray = new byte[n];
        IOException iOException = null;
        try {
            try {
                int n2;
                while ((n2 = bufferedInputStream.read(byArray, 0, n)) >= 0) {
                    bufferedOutputStream.write(byArray, 0, n2);
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                file.delete();
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            bufferedOutputStream.close();
            throw throwable;
        }
        bufferedOutputStream.close();
        try {
            bufferedInputStream.close();
            this.data.close();
        }
        catch (IOException iOException3) {}
        if (iOException != null) {
            throw iOException;
        }
    }

    public FTPReply getLastValidReply() {
        return this.lastValidReply;
    }

    String getRemoteHostName() {
        return this.control.getRemoteHostName();
    }

    public FTPTransferType getType() {
        return this.transferType;
    }

    public String help(String string) throws IOException, FTPException {
        String string2 = this.control.sendCommand("HELP " + string);
        String[] stringArray = new String[]{"211", "214"};
        this.lastValidReply = this.control.validateReply(string2, stringArray);
        return this.lastValidReply.getReplyText();
    }

    private void initGet(String string) throws IOException, FTPException {
        this.data = this.control.createDataSocket(this.connectMode);
        this.data.setTimeout(this.timeout);
        String string2 = this.control.sendCommand("RETR " + string);
        String[] stringArray = new String[]{"125", "150"};
        this.lastValidReply = this.control.validateReply(string2, stringArray);
    }

    private void initPut(String string, boolean bl) throws IOException, FTPException {
        this.data = this.control.createDataSocket(this.connectMode);
        this.data.setTimeout(this.timeout);
        String string2 = bl ? "APPE " : "STOR ";
        String string3 = this.control.sendCommand(String.valueOf(string2) + string);
        String[] stringArray = new String[]{"125", "150"};
        this.lastValidReply = this.control.validateReply(string3, stringArray);
    }

    public static void initSOCKS(String string, String string2) {
        Properties properties = System.getProperties();
        ((Hashtable)properties).put("socksProxyPort", string);
        ((Hashtable)properties).put("socksProxyHost", string2);
        System.setProperties(properties);
    }

    public static void initSOCKSAuthentication(String string, String string2) {
        Properties properties = System.getProperties();
        ((Hashtable)properties).put("java.net.socks.username", string);
        ((Hashtable)properties).put("java.net.socks.password", string2);
        System.setProperties(properties);
    }

    public String list(String string) throws IOException, FTPException {
        return this.list(string, false);
    }

    public String list(String string, boolean bl) throws IOException, FTPException {
        String[] stringArray = this.dir(string, bl);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("line.separator");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(string2);
            ++n;
        }
        return stringBuffer.toString();
    }

    public void login(String string, String string2) throws IOException, FTPException {
        String string3 = this.control.sendCommand("USER " + string);
        this.lastValidReply = this.control.validateReply(string3, "331");
        string3 = this.control.sendCommand("PASS " + string2);
        this.lastValidReply = this.control.validateReply(string3, "230");
    }

    public void mkdir(String string) throws IOException, FTPException {
        String string2 = this.control.sendCommand("MKD " + string);
        this.lastValidReply = this.control.validateReply(string2, "257");
    }

    public Date modtime(String string) throws IOException, FTPException {
        String string2 = this.control.sendCommand("MDTM " + string);
        this.lastValidReply = this.control.validateReply(string2, "213");
        Date date = this.tsFormat.parse(this.lastValidReply.getReplyText(), new ParsePosition(0));
        return date;
    }

    public void password(String string) throws IOException, FTPException {
        String string2 = this.control.sendCommand("PASS " + string);
        String[] stringArray = new String[]{"230", "202"};
        this.lastValidReply = this.control.validateReply(string2, stringArray);
    }

    public void put(InputStream inputStream, String string) throws IOException, FTPException {
        this.put(inputStream, string, false);
    }

    public void put(InputStream inputStream, String string, boolean bl) throws IOException, FTPException {
        if (this.getType() == FTPTransferType.ASCII) {
            this.putASCII(inputStream, string, bl);
        } else {
            this.putBinary(inputStream, string, bl);
        }
        this.validateTransfer();
    }

    public void put(String string, String string2) throws IOException, FTPException {
        this.put(string, string2, false);
    }

    public void put(String string, String string2, boolean bl) throws IOException, FTPException {
        if (this.getType() == FTPTransferType.ASCII) {
            this.putASCII(string, string2, bl);
        } else {
            this.putBinary(string, string2, bl);
        }
        this.validateTransfer();
    }

    public void put(byte[] byArray, String string) throws IOException, FTPException {
        this.put(byArray, string, false);
    }

    public void put(byte[] byArray, String string, boolean bl) throws IOException, FTPException {
        this.initPut(string, bl);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new DataOutputStream(this.data.getOutputStream()));
        bufferedOutputStream.write(byArray, 0, byArray.length);
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        try {
            this.data.close();
        }
        catch (IOException iOException) {}
        this.validateTransfer();
    }

    private void putASCII(InputStream inputStream, String string, boolean bl) throws IOException, FTPException {
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream));
        this.initPut(string, bl);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.data.getOutputStream()));
        String string2 = null;
        while ((string2 = lineNumberReader.readLine()) != null) {
            bufferedWriter.write(string2, 0, string2.length());
            bufferedWriter.write("\r\n", 0, "\r\n".length());
        }
        lineNumberReader.close();
        bufferedWriter.flush();
        bufferedWriter.close();
        try {
            this.data.close();
        }
        catch (IOException iOException) {}
    }

    private void putASCII(String string, String string2, boolean bl) throws IOException, FTPException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this.putASCII(fileInputStream, string2, bl);
    }

    private void putBinary(InputStream inputStream, String string, boolean bl) throws IOException, FTPException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        this.initPut(string, bl);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new DataOutputStream(this.data.getOutputStream()));
        byte[] byArray = new byte[512];
        int n = 0;
        while ((n = bufferedInputStream.read(byArray)) > 0) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedInputStream.close();
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        try {
            this.data.close();
        }
        catch (IOException iOException) {}
    }

    private void putBinary(String string, String string2, boolean bl) throws IOException, FTPException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this.putBinary(fileInputStream, string2, bl);
    }

    public String pwd() throws IOException, FTPException {
        String string = this.control.sendCommand("PWD");
        this.lastValidReply = this.control.validateReply(string, "257");
        String string2 = this.lastValidReply.getReplyText();
        int n = string2.indexOf(34);
        int n2 = string2.lastIndexOf(34);
        if (n >= 0 && n2 > n) {
            return string2.substring(n, n2);
        }
        return string2;
    }

    public void quit() throws IOException, FTPException {
        try {
            String string = this.control.sendCommand("QUIT");
            this.lastValidReply = this.control.validateReply(string, "221");
        }
        finally {
            Object var2_2 = null;
            this.control.logout();
            this.control = null;
        }
    }

    public void quote(String string, String[] stringArray) throws IOException, FTPException {
        String string2 = this.control.sendCommand(string);
        if (stringArray != null && stringArray.length > 0) {
            this.lastValidReply = this.control.validateReply(string2, stringArray);
        }
    }

    public void rename(String string, String string2) throws IOException, FTPException {
        String string3 = this.control.sendCommand("RNFR " + string);
        this.lastValidReply = this.control.validateReply(string3, "350");
        string3 = this.control.sendCommand("RNTO " + string2);
        this.lastValidReply = this.control.validateReply(string3, "250");
    }

    public void rmdir(String string) throws IOException, FTPException {
        String string2 = this.control.sendCommand("RMD " + string);
        this.lastValidReply = this.control.validateReply(string2, "250");
    }

    public void setConnectMode(FTPConnectMode fTPConnectMode) {
        this.connectMode = fTPConnectMode;
    }

    public void setLogStream(PrintWriter printWriter) {
        this.control.setLogStream(printWriter);
    }

    public void setTimeout(int n) throws IOException {
        this.timeout = n;
        this.control.setTimeout(n);
    }

    public void setType(FTPTransferType fTPTransferType) throws IOException, FTPException {
        String string = FTPTransferType.ASCII_CHAR;
        if (fTPTransferType.equals(FTPTransferType.BINARY)) {
            string = FTPTransferType.BINARY_CHAR;
        }
        String string2 = this.control.sendCommand("TYPE " + string);
        this.lastValidReply = this.control.validateReply(string2, "200");
        this.transferType = fTPTransferType;
    }

    public boolean site(String string) throws IOException, FTPException {
        String string2 = this.control.sendCommand("SITE " + string);
        String[] stringArray = new String[]{"200", "202", "502"};
        this.lastValidReply = this.control.validateReply(string2, stringArray);
        return string2.substring(0, 3).equals("200");
    }

    public String system() throws IOException, FTPException {
        String string = this.control.sendCommand("SYST");
        this.lastValidReply = this.control.validateReply(string, "215");
        return this.lastValidReply.getReplyText();
    }

    public void user(String string) throws IOException, FTPException {
        String string2 = this.control.sendCommand("USER " + string);
        String[] stringArray = new String[]{"230", "331"};
        this.lastValidReply = this.control.validateReply(string2, stringArray);
    }

    private void validateTransfer() throws IOException, FTPException {
        String[] stringArray = new String[]{"226", "250"};
        String string = this.control.readReply();
        this.lastValidReply = this.control.validateReply(string, stringArray);
    }
}

