unit Screen;
interface

procedure scrInitPages(Pages : Byte);
procedure scrDeInitPages;
procedure scrStoreScreen(Page : Byte);
procedure scrRestoreScreen(Page : Byte);

implementation

uses
   {$IFDEF OS2} OS2base, {$ENDIF}
   StrProc, FastIO, Global;

const
  MaxPages  = 8;

Type
  PageType  = Array [1..50,1..80] Of Word;
  PageArray = Array [1..MaxPages] Of ^PageType;
Var
  ScrPtr    : ^PageType;
  ScrPages  : PageArray;
  PageInMem : Array [1..MaxPages] Of Boolean;
  VideoMode : ^Byte;
  UseDisk   : Boolean;

Var
  MPages       : word;
  SaveExitProc : Pointer;

Procedure scrInitPages(Pages : Byte);
Var
  Loop : Byte;
begin
  If Pages>MaxPages Then
    Pages := MaxPages;
  For Loop:=1 To Pages Do
  If (MaxAvail>=SizeOf(PageType)) And (Not UseDisk) Then
  begin
    PageInMem[Loop] := True;
    New(ScrPages[Loop]);
  end
  Else
  begin
    PageInMem[Loop] := False;
    ScrPages[Loop]  := NIL;
  end;
  MPages := Pages;
end;

Procedure scrDeInitPages;
Var Loop : Byte;
begin
  If MPages>0 Then
    For Loop:=MPages DownTo 1 Do
      If PageInMem[Loop] Then
      begin
        Dispose(ScrPages[Loop]);
        PageInMem[Loop] := False;
      end;
  MPages := 0;
end;

Procedure scrStoreScreen(Page : Byte);
Var
  F : File Of PageType;
begin
  If Page<=MPages Then
  begin
    If PageInMem[Page] Then
      Move(ScrPtr^,ScrPages[Page]^,textbufsize)
    Else
    begin
      Assign(F,Cfg^.pathData+'INISCREEN.S'+St(Page));
      {$I-}
      ReWrite(F);
      {$I+}
      If IOResult=0 Then
      begin
        Write(F,pagetype(ScrPtr^));
        Close(F);
      end;
    end;
  end;
end;

Procedure scrRestoreScreen(Page : Byte);
Var
  F : File Of PageType;
begin
  If Page<=MPages Then
  begin
    If PageInMem[Page] Then
      Move(ScrPages[Page]^,ScrPtr^,textbufsize)
    Else
    begin
      Assign(F,Cfg^.pathData+'INISCREEN.S'+St(Page));
      {$I-}
      Reset(F);
      {$I+}
      If IOResult=0 Then
      begin
        Read(F,pagetype(ScrPtr^));
        Close(F);
      end;
    end;
  end;
{$IFDEF OS2}
  vioshowbuf(0, textbufsize, 0);
{$ENDIF}
end;

Procedure ScreenExitProc;
Var
  Loop : Byte;
  F    : File;
begin
  ExitProc := SaveExitProc;
  If MPages>0 Then
    For Loop:=1 To MPages Do
    begin
      Assign(F,Cfg^.pathData+'INISCREEN.S'+St(Loop));
      {$I-} Erase(F); {$I+}
      If IOResult <> 0 Then;
    end;
end;

begin
   {$IFDEF OS2}
   vioGetBuf(pointer(scrptr),textbufsize,0);
   selToFlat(pointer(scrptr));
   textvidseg := $b800;
   {$ELSE}
   {$IFNDEF LINUX}
   {$IFNDEF WIN32}
   textbufsize:=4000;
   VideoMode := Ptr(Seg0040,$0049);
   if VideoMode^ = 7 then textvidseg := segb000 else textvidseg := segb800;
   scrptr := Ptr(textvidseg,$0000);
   {$ENDIF}
   {$ENDIF}
   {$ENDIF}
   MPages := 0;
   UseDisk := False;
   SaveExitProc := ExitProc;
   ExitProc := @ScreenExitProc;
end.
