{$IFDEF OVERLAY} {$O+} {$ENDIF}

unit MsgArea;

interface

uses Global;

function  maAddMessage(var M : tMessage; var Head : tMsgHeaderRec; Save : Boolean) : Boolean;
function  maChangeArea(Area : Word) : Boolean;
function  maDownloadMessage(N : Word) : Boolean;
procedure maEditMessage(var Head : tMsgHeaderRec; mn : Word);
procedure maEditTextfile(Fn : String);
procedure maFindAreaWithAccess;
function  maHasAccess : Boolean;
function  maImportMessage(var M : tMessage) : Word;
procedure maListAreas(Change : Boolean);
procedure InitmaList(var maRef : pmaRef; var NumMa : word);
 { Loads a list of areas to which the user has access, compress area nums if enable in config }
function  maLoad : Boolean;
function  maLoadHeader(var Head : tMsgHeaderRec; M : Word) : Boolean;
function  maLoadMessage(var Mr : tMessage; var Head : tMsgHeaderRec; M : Word) : Boolean;
procedure maLoadScan(var S : tScanRec; U : Word);
function  maLoadTextFile(fn : String; var Txt : tMessage) : Word;
procedure maNewScanAsk(Par : String);
function  maNewScanMsgNum : Word;
procedure maNextArea;
function  maOKtoRead(var Head : tMsgHeaderRec) : Boolean;
procedure maPackAreaAsk(Par : String);
procedure maPackAreas(AllAreas : Boolean; Num : Word);
function  maPostMessage(whoTo, theSubject : String; rN : Word; AskUL : Boolean) : Boolean;
procedure maPrevArea;
function  maReadMessages(Start : Word; Mand : Boolean; Show : Boolean) : Boolean;
function  maReadStr(var F : file) : String;
procedure maReset;
procedure maSave;
function  maSaveHeader(var Head : tMsgHeaderRec; M : Word) : Boolean;
procedure maSaveScan(var S : tScanRec; U : Word);
procedure maScanForMandatory(N : Word);
procedure maSetPointerDate;
procedure maShowMessage(var mf : file; var Head : tMsgHeaderRec; realMsg : Word);
procedure maUpdateAllScanFiles;
procedure maUpdateScanFile;
function  maUploadMessage(var H : tMsgHeaderRec) : Boolean;
function  maCopyMessage(Head: tMsgHeaderRec; var mf : file; CopyTo : integer) : boolean;
function  maUncompressedNum(Num : integer) : integer;
procedure maNewScanSelect;
procedure maPackMessageArea;

implementation

uses
   Dos, Crt, Files, Output, Input, Misc, StrProc, FsEditor, ShowFile,
   Logs, Users, DateTime, Emulate, Email, Comm;

function maHasAccess : Boolean;
begin
   maHasAccess := acsOk(mArea^.Acs);
end;

function maIsSponsor : Boolean;
begin
   maIsSponsor := (maHasAccess) and ((UpStr(User^.UserName) = UpStr(mArea^.Sponsor)) or
                                     (UpStr(User^.RealName) = UpStr(mArea^.Sponsor)));
end;

function maHasPostAccess : Boolean;
begin
   maHasPostAccess := acsOk(mArea^.PostAcs);
end;

function maChangeArea(Area : Word) : Boolean;
begin
end;

procedure maPrevArea;
begin
end;

procedure maNextArea;
begin
end;

function maReadStr(var F : file) : String;
var C : Char; Len : Byte; S : String;
begin
   S := '';
   BlockRead(F,C,1);
   Len := Ord(C);
   S[0] := Chr(Len);
   BlockRead(F,S[1],Len);
   maReadStr := S;
end;

procedure maWriteStr(var F : file; S : String);
var C : Char; Len : Byte;
begin
   Len := Length(S);
   BlockWrite(F,Len,1);
   BlockWrite(F,S[1],Len);
end;

function maSaveHeader(var Head : tMsgHeaderRec; M : Word) : Boolean;
var HF : file of tMsgHeaderRec;
begin
   maSaveHeader := False;
   Assign(HF,Cfg^.pathMsgs+mArea^.Filename+extMsgHead);
   {$I-}
   Reset(HF);
   {$I+}
   if ioResult <> 0 then
   begin
      {$I-}
      Rewrite(HF);
      {$I+}
      if ioResult <> 0 then Exit;
   end else Seek(HF,M-1);
   Write(HF,Head);
   Close(HF);
   maSaveHeader := True;
end;

function maLoadHeader(var Head : tMsgHeaderRec; M : Word) : Boolean;
var HF : file of tMsgHeaderRec;
begin
   maLoadHeader := False;
   Assign(HF,Cfg^.pathMsgs+mArea^.Filename+extMsgHead);
   {$I-}
   Reset(HF);
   {$I+}
   if ioResult <> 0 then Exit;
   if M > FileSize(HF) then
   begin
      Close(HF);
      Exit;
   end;
   Seek(HF,M-1);
   Read(HF,Head);
   Close(HF);
   maLoadHeader := True;
end;

function maAddMessage(var M : tMessage; var Head : tMsgHeaderRec; Save : Boolean) : Boolean;
var F : file; HF : file of tMsgHeaderRec; S : String; C : Char;
    N : Word; TmpHdr : tMsgHeaderRec;
begin
   maAddMessage := False;
   Assign(F,Cfg^.pathMsgs+mArea^.Filename+extMsgData);
   {$I-}
   Reset(F,1);
   {$I+}
   if ioResult <> 0 then
   begin
      {$I-}
      Rewrite(F,1);
      {$I+}
      if ioResult <> 0 then Exit;
   end else Seek(F,FileSize(F));
   Head.Pos := FileSize(F)+1;
   for N := 1 to Head.Size do maWriteStr(F,M[N]);
   Close(F);
   Assign(HF,Cfg^.pathMsgs+mArea^.Filename+extMsgHead);
   {$I-}
   Reset(HF);
   {$I+}
   if ioResult <> 0 then
   begin
      {$I-}
      Rewrite(HF);
      {$I+}
      if ioResult <> 0 then Exit;
   end else Seek(HF,FileSize(HF));
   Write(HF,Head);
   Close(HF);
   Inc(mArea^.Msgs);
   if Save then
   begin
      if mArea^.areaType = mareaEmail then emailSave else maSave;
   end;
   maAddMessage := True;
end;

function maReplaceMessage(var M : tMessage; var Head : tMsgHeaderRec; mn : Word) : Boolean;
var F : file; HF : file of tMsgHeaderRec; S : String; C : Char;
    N : Word; TmpHdr : tMsgHeaderRec;
begin
   maReplaceMessage := False;
   Assign(F,Cfg^.pathMsgs+mArea^.Filename+extMsgData);
   {$I-}
   Reset(F,1);
   {$I+}
   if ioResult <> 0 then
   begin
      {$I-}
      Rewrite(F,1);
      {$I+}
      if ioResult <> 0 then Exit;
   end else Seek(F,FileSize(F));
   Head.Pos := FileSize(F)+1;
   for N := 1 to Head.Size do maWriteStr(F,M[N]);
   Close(F);
   Assign(HF,Cfg^.pathMsgs+mArea^.Filename+extMsgHead);
   {$I-}
   Reset(HF);
   {$I+}
   if ioResult <> 0 then
   begin
      {$I-}
      Rewrite(HF);
      {$I+}
      if ioResult <> 0 then Exit;
   end else Seek(HF,mn-1);
   Write(HF,Head);
   Close(HF);
   maReplaceMessage := True;
end;

function GetTearLine : string; forward;
function GetOriginLine : string; forward;

function maAddMsgFile(var fn : String; var Head : tMsgHeaderRec) : Boolean;
var F : file; M : Text; HF : file of tMsgHeaderRec; S : String; C : Char;
    N : Word; TmpHdr : tMsgHeaderRec;
begin

   Head.Size := 0;
   maAddMsgFile := False;
   Assign(M,Fn);
   {$I-}
   Reset(M);
   {$I+}
   if ioResult <> 0 then Exit;
   N := 0;

   Assign(F,Cfg^.pathMsgs+mArea^.Filename+extMsgData);
   {$I-}
   Reset(F,1);
   {$I+}
   if ioResult <> 0 then
   begin
      {$I-}
      Rewrite(F,1);
      {$I+}
      if ioResult <> 0 then
      begin
         Close(M);
         Exit;
      end;
   end else Seek(F,FileSize(F));
   Head.Pos := FileSize(F)+1;

   while (not Eof(M)) and (N < 64000) do
   begin
      Inc(N);
      FillChar(S,SizeOf(S),0);
      ReadLn(M,S);
      if Length(S) > 80 then S[0] := #80;
      maWriteStr(F,S);
   end;

{ --- added by ck ---------------------------------- 11/07/97 - }
   maWriteStr(F,GetTearLine);
   maWriteStr(F,GetOriginLine);
   maWriteStr(F,'');
   inc(N,3);
{ - end of changes -------------------------------------------- }

   Head.Size := N;

   Close(M);
   Close(F);

   Assign(HF,Cfg^.pathMsgs+mArea^.Filename+extMsgHead);
   {$I-}
   Reset(HF);
   {$I+}
   if ioResult <> 0 then
   begin
      {$I-}
      Rewrite(HF);
      {$I+}
      if ioResult <> 0 then Exit;
   end else Seek(HF,FileSize(HF));
   Write(HF,Head);
   mArea^.Msgs := fileSize(hf);
   Close(HF);
   maAddMsgFile := True;
end;

function maLoadMessage(var Mr : tMessage; var Head : tMsgHeaderRec; M : Word) : Boolean;
var F : file; HF : file of tMsgHeaderRec; N, s : Word;
begin
   maLoadMessage := False;
   Assign(HF,Cfg^.pathMsgs+mArea^.Filename+extMsgHead);
   Assign(F,Cfg^.pathMsgs+mArea^.Filename+extMsgData);
   {$I-}
   Reset(HF);
   {$I+}
   if ioResult <> 0 then Exit;
   if M > FileSize(HF) then
   begin
      Close(HF);
      Exit;
   end;
   Seek(HF,M-1);
   Read(HF,Head);
   Close(HF);
   {$I-}
   Reset(F,1);
   {$I+}
   if ioResult <> 0 then Exit;
   if Head.Pos > FileSize(F) then
   begin
      Close(F);
      Exit;
   end;
   Seek(F,Head.Pos-1);
   FillChar(Mr,SizeOf(Mr),0);
   s := Head.Size;
   if s > maxMsgLines then s := maxMsgLines;
   Head.Size := s;
   for N := 1 to s do Mr[N] := maReadStr(F);
   Close(F);
   maLoadMessage := True;
end;

function maCopyMessage(Head: tMsgHeaderRec; var mf : file; CopyTo : integer) : boolean;
begin;
end;

function GetTearLine : string;
begin;
GetTearLine := '--- iniquity/2';
end;

function GetOriginLine : string;
var O,T : byte;
    OriginLine : string[80];
begin;
O := mArea^.Origin;
T := mArea^.Address;
if Cfg^.Address[T].Point <>0 then OriginLine := OriginLine + '.'+St(Cfg^.Address[T].Point);
OriginLine := OriginLine+')';
GetOriginLine := OriginLine;
end;


function maPostMessage(whoTo, theSubject : String; rN : Word; AskUL : Boolean) : Boolean;
var Usr : tUserRec; Head : tMsgHeaderRec; Txt, rTxt : pMessage; Def : String;
    Reply, Ok, autoQuote{, AttachIt} : Boolean; rHead : pMsgHeaderRec;

    IsNetmail : boolean; { added by ck for netmail support }
    NetmailFromAKA : byte;

procedure MsgAddTearLine;
var TearLine : string[80];
begin;
TearLine := GetTearLine;
inc(Head.Size,1);
Txt^[Head.Size] := TearLine;
end;

procedure MsgAddOriginLine;
begin;
inc(Head.Size,1);
Txt^[Head.Size] := GetOriginLine;
inc(Head.Size,1);
Txt^[Head.Size] := '';
end;

function MatchAKA(Address : tNetAddressRec) : byte; { MatchAKA and AskAKA to use added by ck for netmail support }
var i : byte;
    Matched : boolean;
begin;
Matched := false;
i := 0;
while (i<MaxAddress) and (not Matched) do
 begin;
 inc(i,1);
 if Cfg^.Address[i].Zone = Address.Zone then Matched := true;
 end;
if Matched then MatchAKA := i else MatchAKA := 0;
end;

function AskAKAToUse : byte;
var i : integer;
    Result : byte;
    chValidAKAs : set of char;
    AKAChar : char;
begin;
chValidAKAs := [];
oWriteln('');
for i := 1 to MaxAddress do
 begin;
   if Cfg^.Address[i].Zone <> 0 then
    begin;
{    ocWriteln('|U2[|U4'+chr(i+ord('A'))+'|U2] |U1'+cfgAddressStr(Cfg^.Address[i]));}
    chValidAKAs := chValidAKAs + [chr(i+ord('A'))];
    end;
 end;
oString(strEmailAskOriginAddr);
AKAChar := #0;
while (not (AKAChar in chValidAKAs)) and (not Hangup) do AkaChar := UpCase(iReadKey);
oWriteln(AKAChar);
AskAKAToUse := ord(AKAChar)-ord('A');
end;

function FindUser(var U : tUserRec; DelToo : Boolean) : Boolean;
begin;
if userSearch(U,true,true) then
 FindUser := true
else
 if userPartialSearch(U,true) then
  FindUser := true
 else
  FindUser := false;
end;

begin
   maPostMessage := False;
   Reply := rN > 0;
   rTxt := nil; rHead := nil;
   if Reply then
   begin
      New(rTxt);
      New(rHead);
      if not maLoadMessage(rTxt^,rHead^,rN) then
      begin
         Dispose(rTxt);
         Dispose(rHead);
         Exit;
      end;
   end;
   FillChar(Head,SizeOf(Head),0);
   if (not maHasAccess) or (not maHasPostAccess) then
   begin
      oStringLn(strMsgNoPostAcs);
      oDnLn(1);
      if Reply then
      begin
         Dispose(rTxt);
         Dispose(rHead);
      end;
      Exit;
   end;
   Head.Status := [];
   Head.NetFlag := [];

   if mArea^.areaType = mareaEmail then
   begin
      Head.Status := Head.Status+[msgPrivate];
      Head.msgTag := emailTag;
{      AttachIt := acsOk(Cfg^.acsAttachEmail);}
   end else
   if mArea^.areaType = mareaEchoMail then
   begin
      Head.Status := Head.Status+[msgEchoMail];
      Head.msgTag := 0;
{      AttachIt := False;  EchoMail = no files :) }
   end else
   begin
      Head.msgTag := 0;
{      AttachIt := acsOk(Cfg^.acsAttachPublic);}
   end;

   if Reply then
   begin
      Def := rHead^.Subject;
      if UpStr(Copy(Def,1,3)) <> 'RE:' then Insert('Re: ',Def,1);
      Head.ToInfo := rHead^.FromInfo;
      if maPrivate in mArea^.Flag then
      begin
         oString(strMsgAskPrivate);
         if iYesNo(msgPrivate in rHead^.Status) then Head.Status := Head.Status+[msgPrivate];
      end;

      if (mArea^.areaType = mareaEmail) and  { added by ck for netmail support }
         (rHead^.FromInfo.Address.Zone <> 0) then
          begin;
            Head.ToInfo.Address := rHead^.FromInfo.Address;
            Head.FromInfo.Address := rHead^.ToInfo.Address;
          end;
   end else
   begin
      if mArea^.areaType = mareaEmail then Def := '' else Def := 'All';
      oString(strMsgAskWhoTo);
      if whoTo = '' then
      Usr.UserName := iReadString(Def,inNormal,chNormal,'',36) else
      begin
         Usr.UserName := whoTo;
         oCWriteLn(Usr.UserName);
      end;
 IsNetmail := false;

      Def := '';
      if (Usr.UserName = '') and (not IsNetmail) then Exit; { added and (Not IsNetmail) }

      if IsNetmail then { added by ck for netmail support }
      begin
        oString(strEmailAskAddress);
        {cfgToAddress(Head.ToInfo.Address,iReadString(Def,inNormal,chNumeric+chNumeric+['/','.',':'],'',40));}
        NetmailFromAKA := MatchAKA(Head.ToInfo.Address);
        if NetmailFromAKA = 0 then NetmailFromAKA := AskAKAToUse;
        Head.FromInfo.Address := Cfg^.Address[NetmailFromAKA];

      with Head.ToInfo do
       begin;
        UserNum := 0;
        Name := usr.UserName;
        Alias := usr.UserName;
        RealName := usr.UserName;
        UserNote := 'None';
       end;

      Head.Status := Head.Status + [msgPrivate];
      end else
      if (msgPrivate in Head.Status) and FindUser(Usr,False) then with Head.ToInfo do
      begin
         userLoad(Usr);
         UserNum := Usr.Number;
         Alias := Usr.UserName;
         RealName := Usr.RealName;
         Name := Usr.UserName;
         UserNote := Usr.UserNote;
         FillChar(Address,SizeOf(Address),0);
         if mArea^.areaType = mareaEchoMail then
                Address := Cfg^.Address[mArea^.Address];
 if (mArea^.areaType = mareaEmail) then
      begin
         oStringLn(strEmailUserUnknown);
         Exit;
      end else with Head.ToInfo do
      begin
         UserNum := 0;
         Alias := 'None';
         RealName := 'None';
         Name := Usr.UserName;
         UserNote := 'None';
         FillChar(Address,SizeOf(Address),0);
      end;
   end;
   oString(strMsgAskTitle);
   if theSubject = '' then
   Head.Subject := iReadString(Def,inNormal,chNormal,'',40) else
   begin
      Head.Subject := theSubject;
      oCWriteLn(Head.Subject);
   end;
   if Head.Subject = '' then Exit;
   with Head.FromInfo do
   begin
      UserNum := User^.Number;
      Alias := User^.UserName;
      RealName := User^.RealName;
      if maRealName in mArea^.Flag then Name := User^.RealName else
                                        Name := User^.UserName;
      UserNote := User^.UserNote;
   end;
   Head.Replies := 0;
   Head.Date := dtDateTimePacked;
   Head.incFile := 0;

   if msgPrivate in Head.Status then Head.netFlag := Head.netFlag+[nPrivate];
   Head.netFlag := Head.netFlag+[nHold];
   New(Txt);

   autoQuote := true;{(Reply) and (acQuote in User^.acFlag);}
   Ok := False;
   if (Reply) then
   begin
      oString(strMsgAskQuote);
      autoQuote := iYesNo(true);
   end;
   if not Ok then if fsEdit(Txt^,Head,True,rTxt,rHead,autoQuote,false) then
    begin;
      if mArea^.AreaType = mareaEchomail then
       begin;
        msgAddTearLine;
        msgAddOriginLine;
       end;
     Ok := maAddMessage(Txt^,Head,False);
    end;

   maPostMessage := Ok;
   if Ok then

{      if User^.curMsgArea = 0 then}
      begin
         logWrite('Email sent');
         oStrLn(strCode(mStr(strEmailSent),1,Head.ToInfo.Name));
      end{ else
      begin
         logWrite('Message posted in area "'+mArea^.Name+'"');
         oStrLn(strCode(mStr(strMsgPublicPosted),1,mArea^.Name));
      end};
      logWrite('  Title: "'+Head.Subject+'",  From: '+Head.FromInfo.Name+',  To: '+Head.ToInfo.Name);
      if msgPrivate in Head.Status then
      begin
{         Inc(Stat^.Email);
         Inc(His^.Email);}
         Inc(User^.Email);
      end else
      begin
{         Inc(Stat^.Posts);
         Inc(His^.Posts);}
         Inc(User^.Posts);
      end;
{      if (mArea^.AreaType = mareaEchomail) or IsNetmail then errorLevel := Cfg^.echomailLev;}
{      statSave;
      hisSave;}
      userSave(User^);
      if mArea^.areaType = mareaEmail then emailSave else maSave;
   end;
   Dispose(Txt);
   if Reply then
   begin
      Dispose(rTxt);
      Dispose(rHead);
   end;

end;

{
Date: 4:06 pm  Mon Nov 28, 1994        Number : 50 of 51
From: Highflyer                        Base   : [Local] General Messages
To  : Sysop                            Refer #: None
Subj: log out                          Replies: 1
Stat: Normal                           Origin : Local
}

function maStatus(var Head : tMsgHeaderRec) : String;
var StatStr : String;
begin
   StatStr := '';
   if msgDeleted in Head.Status then StatStr := '[Deleted] ';
   if msgSent in Head.Status then StatStr := StatStr+'[Sent] ';
   if msgPrivate in Head.Status then StatStr := StatStr+'[Private] ';
   if msgForwarded in Head.Status then StatStr := StatStr+'[Forward] ';
   if Head.incFile > 0 then StatStr := StatStr+'[File] ';
   if msgAnonymous in Head.Status then StatStr := StatStr+'[Anonymous]';
   StatStr := CleanUp(StatStr);
   if StatStr = '' then StatStr := '[Normal]';
   maStatus := StatStr;
end;

function maUncompressedNum(Num : integer) : integer;
var CompressedNum, i : integer;
    A : tMsgAreaRec;
    F : file of tMsgAreaRec;
begin;
maUncompressedNum := 0;
{if not Cfg^.compMsgAreas then
 maUncompressedNum := Num
else}
 begin;
   Assign(F,Cfg^.pathData+fileMsgArea);
   {$I-}
   Reset(F);
   {$I+}
   if ioResult <> 0 then exit;
   CompressedNum := 1;
   i := 1;
   while (CompressedNum < Num) and (not eof(F)) do
    begin;
    read(F,A);
    if (acsOk(A.Acs)) or (maUnhidden in A.Flag) then
     inc(CompressedNum,1);
    inc(i,1);
    end;
   maUncompressedNum := i;
   Close(F);
 end;
end;

procedure maShowMessage(var mf : file; var Head : tMsgHeaderRec; realMsg : Word);
var Ans : Boolean; RepStr, StatStr, uNote, S : String; Ln, X : Word;
begin
   Seek(mf,Head.Pos-1);
   oClrScr;
   if Head.Replies < 1 then RepStr := 'None' else RepStr := St(Head.Replies);
   StatStr := maStatus(Head);
   if msgAnonymous in Head.Status then uNote := 'Unknown' else
                                       uNote := Head.FromInfo.UserNote;

   sfStr[1]  := dtTimePackedString(Head.Date);
   sfStr[2]  := dtDatePackedString(Head.Date);
   sfStr[3]  := Head.FromInfo.Name;
   sfStr[4]  := Head.ToInfo.Name;
   sfStr[5]  := Head.Subject;
   sfStr[6]  := St(curMsg)+'/'+St(numMsg);
   sfStr[7]  := mArea^.Name;
   sfStr[8]  := St(Head.Replies);
   sfStr[9]  := StatStr;
   sfStr[10] := uNote;

{ --- added by ck --------------------------------------------- 10/23/97 -- }
{   if Head.FromInfo.Address.Zone <> 0 then
    sfStr[3] := sfStr[3] + ' ('+cfgAddressStr(Head.FromInfo.Address)+')';

   if Head.ToInfo.Address.Zone <> 0 then
    sfStr[4] := sfStr[4] + ' ('+cfgAddressStr(Head.ToInfo.Address)+')';}
{ --- end of changes ------------------------------------------------------ }

   PausePos := 1;
{   PauseAbort := False;}
{   if User^.curMsgArea <> 0 then Ans := sfShowTextFile(txMsgHeader,ftMsgHeader) else}
                                 Ans := sfShowTextFile(txEmailHeader,ftMsgHeader);
   if Ans then
   begin
      sfGotoPos(11);
      oUpPause(ansiRows-1);
   end else
   begin
      oCWriteLn('|U4Time  |U5: |U6'+Resize(dtTimePackedString(Head.Date),7)+
              '   |U4Date |U5: |U6'+dtDatePackedString(Head.Date)+
     '        |U4Number   |U5: |U6'+St(curMsg)+'|U4 of |U6'+St(numMsg));
      oCWriteLn('|U4From  |U5: |U6'+Resize(Head.FromInfo.Name,32)+
            ' |U4Msg Area |U5: |U6'+strSquish(mArea^.Name,28));
      oCWriteLn('|U4To    |U5: |U6'+Resize(Head.ToInfo.Name,32)+
            ' |U4Replies  |U5: |U6'+RepStr);
      oCWriteLn('|U4Title |U5: |U6'+Resize(Head.Subject,32)+
            ' |U4Status   |U5: |U6'+strSquish(StatStr,28));
      oUpPause(4);
      oDnLn(1);
      oUpPause(1);
   end;
   if (msgAnonymous in Head.Status) and ((maIsSponsor)) {or (acsOk(Cfg^.acsCoSysOp)))} then
   begin
      oCWriteLn('|U5Anonymous message by: |U4'+Head.FromInfo.Alias+
                ' |U5['+Head.FromInfo.RealName+']');
      oUpPause(1);
   end;
   emuANSiInit;
   oSetCol(colTextHi);
   for Ln := 1 to Head.Size do if (not HangUp) {and (not PauseAbort) }then
   begin
      S := maReadStr(mf);
      X := Pos('>',S);
      if Pos(#27,S) = 0 then
      begin
         if (X > 0) and (X < 4) then
         begin
            Insert('|U1',S,1);
            S := S+'|U3';
         end else if (Copy(S,1,3) = '---') and
                     ((Ord(S[0]) = 3) or (S[4] = ' ')) then Insert('|U2',S,1);
         oStrCtrLn(S);
         oUpPause(1);
      end else oWriteANSi(S+#13#10);
   end;
   if Head.incFile > 0 then
   begin
      {atAskDownload(Head);}
      maSaveHeader(Head,realMsg);
   end;
   PausePos := 0;
end;

function maOKtoRead(var Head : tMsgHeaderRec) : Boolean;
begin
   maOKtoRead := ((not (msgPrivate in Head.Status)) and (not (msgDeleted in Head.Status))) or
                  (((msgPrivate in Head.Status) or (msgDeleted in Head.Status)) and
                  ((Head.ToInfo.Alias = User^.UserName) or
                   (Head.ToInfo.RealName = User^.RealName) or
{                   (acsOk(Cfg^.acsCoSysOp)) or}
                   (maIsSponsor) or
                   (Head.FromInfo.Alias = User^.UserName) or
                   (Head.FromInfo.RealName = User^.RealName)));
end;

function maOKtoDelete(var Head : tMsgHeaderRec) : Boolean;
begin
   maOKtoDelete := {(acsOk(Cfg^.acsCoSysOp)) or}
                   (maIsSponsor) or

                    ((msgPrivate in Head.Status) and
                    ((Head.ToInfo.Alias = User^.UserName) or
                    (Head.ToInfo.RealName = User^.RealName))) or

                    ((Head.FromInfo.Alias = User^.UserName) or
                    (Head.FromInfo.RealName = User^.RealName));
end;

function maOKtoEdit(var Head : tMsgHeaderRec) : Boolean;
begin
   maOKtoEdit   := {(acsOk(Cfg^.acsCoSysOp)) or}
                   (maIsSponsor) or

                    ((Head.FromInfo.Alias = User^.UserName) or
                    (Head.FromInfo.RealName = User^.RealName));
end;

function maOktoMove(var Head : tMsgHeaderRec) : Boolean;
begin;
 maOktoMove := maOktoEdit(Head);
end;


function maCheckMessage(var Head : tMsgHeaderRec) : Boolean;
begin
   maCheckMessage := False;
   while (not maOktoRead(Head)) and (curMsg < numMsg) do
   begin
      Inc(curMsg);
      maLoadHeader(Head,curMsg);
   end;
   maCheckMessage := maOktoRead(Head);
end;

function maCheckMessageBack(var Head : tMsgHeaderRec) : Boolean;
begin
   maCheckMessageBack := False;
   while (not maOktoRead(Head)) and (curMsg > 1) do
   begin
      Dec(curMsg);
      maLoadHeader(Head,curMsg);
   end;
   maCheckMessageBack := maOktoRead(Head);
end;

procedure maUpdateScanFile;
var sf : file of tScanRec; sfs, N : LongInt; sfr : tScanRec;
begin
   Assign(sf,Cfg^.pathMsgs+mArea^.Filename+extMsgScan);
   {$I-}
   Reset(sf);
   {$I+}
   if ioResult <> 0 then
   begin
      {$I-}
      Rewrite(sf);
      {$I+}
      if ioResult <> 0 then Exit;
   end;

   sfs := FileSize(sf);

   with sfr do
   begin
      scnMsg := True;
      ptrMsg := 0;
   end;

   if sfs > numUsers then
   begin
      Seek(sf,numUsers+1);
      Truncate(sf);
   end else
   begin
      Seek(sf,sfs);
      while FileSize(sf) < numUsers do Write(sf,sfr);
      sfs := FileSize(sf);
   end;

{  if numUsers > sfs then
   begin
      Seek(sf,sfs);
      for N := sfs to numUsers do Write(sf,sfr);
   end else}
   Close(sf);
end;

procedure maLoadScan(var S : tScanRec; U : Word);
var sf : file of tScanRec;
begin
   Assign(sf,Cfg^.pathMsgs+mArea^.Filename+extMsgScan);
   {$I-}
   Reset(sf);
   {$I+}
   if ioResult <> 0 then
   begin
      maUpdateScanFile;
      {$I-}
      Reset(sf);
      {$I+}
      if ioResult <> 0 then Exit;
   end;
   {$I-}
   Seek(sf,U-1);
   {$I+}
   if ioResult <> 0 then
   begin
      Close(sf);
      maUpdateScanFile;
      Reset(sf);
      Seek(sf,U-1);
   end;
   Read(sf,S);

   Close(sf);
end;

procedure maSaveScan(var S : tScanRec; U : Word);
var sf : file of tScanRec;
begin
   Assign(sf,Cfg^.pathMsgs+mArea^.Filename+extMsgScan);
   {$I-}
   Reset(sf);
   {$I+}
   if ioResult <> 0 then
   begin
      maUpdateScanFile;
      {$I-}
      Reset(sf);
      {$I+}
      if ioResult <> 0 then Exit;
   end;
   {$I-}
   Seek(sf,U-1);
   {$I+}
   if ioResult <> 0 then
   begin
      Close(sf);
      maUpdateScanFile;
      Reset(sf);
      Seek(sf,U-1);
   end;
   Write(sf,S);

   Close(sf);
end;

procedure maUpdateAllScanFiles;
var N, X : Word; F : file of tMsgAreaRec;
begin
(*   X := User^.curMsgArea;
   Assign(F,Cfg^.pathData+fileMsgArea);
   {$I-}
   Reset(F);
   {$I+}
   if ioResult <> 0 then Exit;
   numMsgArea := FileSize(F);
   while not Eof(F) do
   begin
      User^.curMsgArea := FilePos(F)+1;
      Read(F,mArea^);
      maUpdateScanFile;
   end;
   Close(F);
   User^.curMsgArea := X;
   maLoad;*)
end;

function maReadMessages(Start : Word; Mand : Boolean; Show : Boolean) : Boolean;
var Ch : Char; S : String; Head : pMsgHeaderRec; mf : file;
    Temp, HiMsg : Word; readDone, readShow, readGoto : Boolean;

 procedure rmPostAMessage(Show : Boolean);
 begin
    if {(Cfg^.AskPostInArea) and }(maHasPostAccess) then
    begin
       oDnLn(1);
       oString(strMsgReadAskPost);
       if iYesNo(False) then maPostMessage('','',0,True);
    end else if {(Cfg^.askPostInArea)}  (Show) then
    begin
       oDnLn(1);
       oStringLn(strMsgNoPostAcs);
       oDnLn(1);
    end;
    readDone := True;
 end;

 procedure rmListMessages;
 var fm, lm, cm : Integer; Ans, Hil : Boolean;
  function lmHil : Boolean;
  begin
     lmHil := (UpStr(Head^.ToInfo.Alias) = UpStr(User^.Username)) or
              (UpStr(Head^.ToInfo.RealName) = UpStr(User^.RealName)) or
              (UpStr(Head^.FromInfo.Alias) = UpStr(User^.Username)) or
              (UpStr(Head^.FromInfo.RealName) = UpStr(User^.RealName));
  end;
 begin
    fm := curMsg;
    lm := fm+{User^.PageLength}24-5;
    if lm > numMsg then lm := numMsg;
    if lm < fm then lm := fm;
    Ans := (sfGetTextFile(txListMsgTop,ftTopLine) <> '') and
           (sfGetTextFile(txListMsgMid,ftListMsg) <> '') and
           (sfGetTextFile(txListMsgBot,ftNormal) <> '');
    Hil := (not Ans) or (sfGetTextFile(txListMsgHil,ftListMsg) <> '');
    if Ans then
    begin
       sfShowTextFile(txListMsgTop,ftTopLine);
       sfGotoPos(1);
       sfLoadRepeat(txListMsgMid);
    end else
    begin
       oSetCol(colInfo);
       oCWriteLn('|U4 Num   Sender                 Receiver               Subject');
{                         5                     22                     22}
       oSetCol(colBorder);
       oWriteLn(sRepeat('',79));
    end;
    cm := fm;
    for cm := fm to lm do if (maLoadHeader(Head^,cm)) and
                             (maOkToRead(Head^)) then
    begin
       if Ans then
       begin
          sfStr[1] := St(cm);
          sfStr[2] := Head^.FromInfo.Name;
          sfStr[3] := Head^.ToInfo.Name;
          sfStr[4] := dtTimePackedString(Head^.Date);
          sfStr[5] := dtDatePackedString(Head^.Date);
          sfStr[6] := Head^.Subject;
          if (Hil) and (lmHil) then
          begin
             sfKillRepeat;
             sfLoadRepeat(txListMsgHil);
             sfShowRepeat(ftListMsg);
             sfKillRepeat;
             sfLoadRepeat(txListMsgMid);
          end else sfShowRepeat(ftListMsg);
          if oWhereX <> 1 then oDnLn(1);
       end else
       begin
          if lmHil then oSetCol(colTextHi) else oSetCol(colText);
          oWriteLn(' '+Resize(St(cm),5)+
                   ' '+Resize(Head^.FromInfo.Name,22)+
                   ' '+Resize(Head^.ToInfo.Name,22)+
                   ' '+strSquish(Head^.Subject,25));
       end;
    end;
    sfKillRepeat;
    if Ans then sfShowTextFile(txListMsgBot,ftNormal) else
    begin
       oSetCol(colBorder);
       oWriteLn(sRepeat('',79));
    end;
    curMsg := lm;
    maLoadHeader(Head^,curMsg);
    maCheckMessageBack(Head^);
 end;

var CopyTo,
    MoveTo  : integer;

begin
   maReadMessages := True;
   New(Head);
   numMsg := mArea^.Msgs;
   readDone := False;
   readShow := True;
   if numMsg < 1 then
   begin
      if Show then
      begin
         oDnLn(1);
         oStringLn(strMsgReadNoMsgs);
         oDnLn(1);
      end;
      Dispose(Head);
      Exit;
   end;
   curMsg := Start;
   maLoadScan(Scan^,User^.Number);
   HiMsg := maNewScanMsgNum;
   if HiMsg = 0 then HiMsg := mArea^.Msgs;
   if curMsg <= 0 then
   begin
      oStr(strCode(strCode(mStr(strMsgReadStartAt),1,St(numMsg)),2,St(HiMsg)));
      S := iReadString(St(HiMsg),inUpper,chNumeric,'',Length(St(numMsg)));
      if S = '' then S := '1';
      curMsg := StrToInt(S);
   end;
   if curMsg > numMsg then curMsg := numMsg;
   if curMsg < 1 then curMsg := 1;
   Assign(mf,Cfg^.pathMsgs+mArea^.Filename+extMsgData);
   {$I-}
   Reset(mf,1);
   {$I+}
   if ioResult <> 0 then
   begin
      Dispose(Head);
      Exit;
   end;
   if (not maLoadHeader(Head^,curMsg)) or (not maCheckMessage(Head^)) then
   begin
      Dispose(Head);
      Exit;
   end;
   repeat
      if readShow then maShowMessage(mf,Head^,curMsg);
      if Head^.Date > Scan^.ptrMsg then
      begin
         Scan^.ptrMsg := Head^.Date;
         maSaveScan(Scan^,User^.Number);
      end;
      readShow := False;
      oStr(strCode(strCode(mStr(strMsgReadPrompt),1,St(curMsg)),2,St(numMsg)));
{      if (iplResult <> '') then
       begin;
       Ch := UpCase(iplResult[1]);
       iplResult := '';
       readGoto := False;
       end else}
      begin;
       S := '';
       readGoto := False;
       repeat
          Ch := UpCase(iReadKey);
          if Ch in ['0'..'9'] then
          begin
            S := S+Ch;
            readGoto := Length(S) >= Length(St(mArea^.Msgs));
            oWriteChar(Ch);
          end else
          if (Ch = #8) and (Length(S) > 0) then
          begin
            oBackSpace(' ');
            Delete(S,Length(S),1);
          end else
          if (Ch = #13) and (Length(S) > 0) then readGoto := True;
       until (HangUp) or (readGoto) or
             ((extKey = #0) and (Ch in [#27,#13,'Q','-','P','?','A','C','R','D','E','H','M','L','I','X',{'U','Z',}'S']));
       if (S = '') then oWriteLn(Ch);
      end;

      if not readGoto then
      case Ch of
         #27,'Q' : if {(Cfg^.AbortMandOk) or} (not Mand) then
                   begin
                      readDone := True;
                      maReadMessages := False;
                   end else oStringLn(strMsgReadMandatory);
         #13     : begin
              if Length(S) > 0 then readGoto := True else
              if (curMsg < numMsg) and (maLoadHeader(Head^,curMsg+1)) then
              begin
                 Inc(curMsg);
                 if not maCheckMessage(Head^) then rmPostAMessage(False);
                 readShow := True;
              end else rmPostAMessage(False);
         end;
         'I'     : if {(Cfg^.AbortMandOk) or} (not Mand) then begin
              curMsg := numMsg;
              maLoadHeader(Head^,curMsg);
              Scan^.ptrMsg := Head^.Date;
              maSaveScan(Scan^,User^.Number);
              readDone := True;
         end else oStringLn(strMsgReadMandatory);
         'S'     : if {(Cfg^.AbortMandOk) or} (not Mand) then readDone := True
                      else oStringLn(strMsgReadMandatory);
         '-'     : begin
              if (curMsg > 1) and (maLoadHeader(Head^,curMsg-1)) then
              begin
                 Temp := curMsg;
                 Dec(curMsg);
                 if not maCheckMessageBack(Head^) then
                 begin
                    curMsg := Temp;
                    maLoadHeader(Head^,curMsg);
                 end;
                 readShow := True;
              end;
         end;
         'P'     : begin
              readShow := True;
              maPostMessage('','',0,True);
              numMsg := mArea^.Msgs;
         end;
         '?'     : begin
              if sfShowTextFile(txReadHelp,ftNormal) then
              begin
                 oPromptKey;
                 readShow := True;
              end;
         end;
         'A'     : readShow := True;
         'R'     : if maPostMessage('','',curMsg,True) then
                   begin
              Inc(Head^.Replies);
              maSaveHeader(Head^,curMsg);
              oDnLn(1);
{             readShow := True;}
              numMsg := mArea^.Msgs;
         end;
         'D'     : if maOktoDelete(Head^) then
                   begin
              if msgDeleted in Head^.Status then
              begin
                 Head^.Status := Head^.Status-[msgDeleted];
                 oStringLn(strMsgUndeleted);
                 logWrite('-Message "'+Head^.Subject+'" in area "'+mArea^.Name+'" undeleted');
              end else
              begin
                 Head^.Status := Head^.Status+[msgDeleted];
                 oStringLn(strMsgDeleted);
                 logWrite('-Message "'+Head^.Subject+'" in area "'+mArea^.Name+'" deleted');
              end;
              maSaveHeader(Head^,curMsg);
              if (curMsg < numMsg) and (maLoadHeader(Head^,curMsg+1)) then
              begin
                 Inc(curMsg);
                 if not maCheckMessage(Head^) then rmPostAMessage(False);
                 readShow := True;
              end else rmPostAMessage(False);
         end;
         'E'     : if maOktoEdit(Head^) then
                   begin
                   maEditMessage(Head^,curMsg);
                   logWrite('-Message "'+Head^.Subject+'" in area "'+mArea^.Name+'" edited');
                   readShow := True;
                   end;
         'C' :{ if maOkToMove(Head^) then}
               begin;
{                maListAreas(false);
                oDnLn(1);
                oString(strMsgCopyAskDest);
                CopyTo := maUncompressedNum(StrToInt(iReadString('',inUpper,chNumeric,'',4)));
                if (CopyTo <> 0) and (CopyTo <> user^.CurMsgArea) then
                 if maCopyMessage(Head^,mf,CopyTo) then
                  logWrite('-Message "'+Head^.Subject+'" in area "'+mArea^.Name+'" copied to area #'+St(MoveTo));
                readShow := True;}
               end;
         'M' : {if maOkToMove(Head^) then}
                begin;
                { maListAreas(false);
                 oDnln(1);
                 oString(strMsgMoveAskDest);
                 MoveTo := maUncompressedNum(StrToInt(iReadString('',inUpper,chNumeric,'',4)));
                 if (MoveTo <> 0) and (MoveTo <> user^.CurMsgArea) then
                 if maCopyMessage(Head^,mf,MoveTo) then
                  begin;
                  Head^.Status := Head^.Status+[msgDeleted];
                  maSaveHeader(Head^,curMsg);
                  if (curMsg < numMsg) and (maLoadHeader(Head^,curMsg+1)) then
                   begin
                    Inc(curMsg);
                    if not maCheckMessage(Head^) then rmPostAMessage(False);
                    readShow := True;
                   end else rmPostAMessage(False);
                  logWrite('-Message "'+Head^.Subject+'" in area "'+mArea^.Name+'" moved to area #'+St(MoveTo));
                 end;
                  readShow := True;       }
                end;
         'H'     : begin
              oStringLn(strMsgSetPointer);
              Scan^.ptrMsg := Head^.Date;
              readShow := True;
         end;
         'L'     : rmListMessages;
{         'U'     : if acsOk(Cfg^.acsSysOp) then cfgUserEditor(Head^.FromInfo.UserNum);}
         'X'     : begin maDownloadMessage(curMsg); readShow := True; end;
{         'Z'     : if acsOk(Cfg^.acsCoSysOp) then
                   begin
                      Head^.Date := dtDateTimePacked;
                      maSaveHeader(Head^,curMsg);
                      readShow := True;
                   end;}
      end else
      begin
         oDnLn(1);
         Temp := curMsg;
         curMsg := StrToInt(S);
         if (curMsg >= 1) and (curMsg <= mArea^.Msgs) then
         begin
            maLoadHeader(Head^,curMsg);
            if not maCheckMessageBack(Head^) then curMsg := Temp;
         end else curMsg := Temp;
         maLoadHeader(Head^,curMsg);
         readShow := True;
      end;
   until (HangUp) or (readDone);
   maSaveScan(Scan^,User^.Number);
   maSave;
   Dispose(Head);
   Close(mf);
   oDnLn(1);
end;

function maNewScanMsgNum : Word;
var HF : file; Head : pMsgHeaderRec; N : Word; Found : Boolean;
begin
   maNewScanMsgNum := 0;
   New(Head);
   Assign(HF,Cfg^.pathMsgs+mArea^.Filename+extMsgHead);
   {$I-}
   Reset(HF,SizeOf(Head^));
   {$I+}
   if ioResult <> 0 then
   begin
      Dispose(Head);
      Exit;
   end;
   Found := False;
   N := 0;
   while (not Found) and (not Eof(HF)) do
   begin
      BlockRead(HF,Head^,1);
      Inc(N,1);
      Found := (Head^.Date > Scan^.ptrMsg) and (maOktoRead(Head^));
   end;
   if Found then maNewScanMsgNum := N else maNewScanMsgNum := 0;
   Close(HF);
   Dispose(Head);
end;

procedure maListAreas(Change : Boolean);
begin
end;

procedure InitmaList(var maRef : pmaRef; var NumMa : word);
var f : file of tMsgAreaRec;
    A : tMsgAreaRec;
    N,cN : integer;
begin;
   maRef := nil;
   NumMa := 0;
   N := 0;
   cN := 0;
   Assign(F,Cfg^.pathData+fileMsgArea);
   {$I-}
   Reset(F);
   {$I+}
   if ioResult <> 0 then Exit;

   new(maRef);
   if (maRef = nil) then
    begin;
    close(F);
    exit;
    end;

   while not Eof(F) do
   begin
      Read(F,A);
      Inc(N);
{      if not Cfg^.compMsgAreas then
      begin
         Inc(cN);
         maRef^[cN] := N;
         inc(NumMa,1);
      end;                          }
      if (acsOk(A.Acs)) or (maUnhidden in A.Flag) then
      begin
{         if Cfg^.compMsgAreas then}
         begin
            Inc(cN);
            maRef^[cN] := N;
            inc(NumMa,1);
         end;
      end;
   end;
   close(F);
end;

procedure maNewScan(AllAreas, aconf : Boolean; Num : Word);
  begin
end;

procedure maNewScanAsk(Par : String);
var All, aconf : Boolean; Num : Word;
begin
   oDnLn(1);
   All := False;
   Num := 0;
   if Par <> '' then
   begin
      Par := UpStr(Par);
      All := Par[1] in ['A','C'];
      aconf := Par[1] = 'C';
      if not All then Num := StrToInt(Par);
   end;
   if (not All) and (Num = 0) then
   begin
      oString(strMsgNewScanAskAll);
      All := iYesNo(True);
      if all then
      begin
         oString(strMsgNewScanAskConfs);
         aconf := iYesNo(True);
      end else aconf := False;
      oDnLn(1);
   end;
   maNewScan(All,aconf,Num);
end;

procedure maPackMessageArea;
var fH, tH : file of tMsgHeaderRec; fD, tD : file;
    Head, TmpHead : pMsgHeaderRec;
    Z, X, P, numM : Word; Pack : Boolean;
begin
   Assign(fH,Cfg^.pathMsgs+mArea^.Filename+extMsgHead);
   Assign(fD,Cfg^.pathMsgs+mArea^.Filename+extMsgData);
   Assign(tH,Cfg^.pathMsgs+'MSGHEAD.$$$');
   Assign(tD,Cfg^.pathMsgs+'MSGDATA.$$$');

   Pack := False;
   {$I-}
   Reset(fH);
   if ioResult <> 0 then Exit;
   Reset(fD,1);
   if ioResult <> 0 then
   begin
      Close(fH);
      Exit;
   end;
   {$I-}

   oStr(strCode(strCode(mStr(strMsgPackStart),1,mArea^.Name),2,St(mArea^.Msgs)));

   New(Head);
   New(TmpHead);

   if ((mArea^.maxMsgs <> 0) and (FileSize(fH) > mArea^.maxMsgs)) then
   begin
      numM := 0;
      Pack := True;
      while not Eof(fH) do
      begin
         Read(fH,Head^);
         if (not (msgDeleted in Head^.Status)) then Inc(numM);
      end;
      if (numM > mArea^.maxMsgs) then
      begin
         Dec(numM,mArea^.maxMsgs);
         Seek(fH,0);
         while (numM > 0) and (not Eof(fH)) do
         begin
            Read(fH,Head^);
            if (not (msgDeleted in Head^.Status)) then
            begin
               Head^.Status := Head^.Status+[msgDeleted];
               Seek(fH,FilePos(fH)-1);
               Write(fH,Head^);
               Dec(numM);
            end;
         end;
      end;
      Seek(fH,0);
   end else
   begin
      while (not Pack) and (not Eof(fH)) do
      begin
         Read(fH,Head^);
         Pack := msgDeleted in Head^.Status;
      end;
      Seek(fH,0);
   end;

   if Pack then
   begin
      Rewrite(tH);
      Rewrite(tD,1);
      while not Eof(fH) do
      begin
         Read(fH,Head^);
         Seek(fD,Head^.Pos-1);
         if not (msgDeleted in Head^.Status) then
         begin
            Head^.Pos := FilePos(tD)+1;
            Write(tH,Head^);
            for x := 1 to Head^.Size do maWriteStr(tD,maReadStr(fD));
         end else
         begin
            Dec(mArea^.Msgs);
{            if Head^.incFile > 0 then atKillAttach(Head^.incFile);}
         end;
      end;
      mArea^.Msgs := FileSize(tH);
      Close(tH);
      Close(tD);
   end else mArea^.Msgs := FileSize(fH);

   Dispose(Head);
   Dispose(TmpHead);

   Close(fH);
   Close(fD);

   if Pack then
   begin
      Erase(fD);
      Erase(fH);
      fRenameFile(Cfg^.pathMsgs+'MSGDATA.$$$',Cfg^.pathMsgs+mArea^.Filename+extMsgData);
      fRenameFile(Cfg^.pathMsgs+'MSGHEAD.$$$',Cfg^.pathMsgs+mArea^.Filename+extMsgHead);
   end;

{   if User^.curMsgArea = 0 then emailSave else maSave;}
emailsave;
   oStrLn(strCode(strCode(mStr(strMsgPackEnd),1,mArea^.Name),2,St(mArea^.Msgs)));
end;

procedure maPackAreas(AllAreas : Boolean; Num : Word);
var N, Z, A : Word;
begin
   if numMsgArea < 1 then Exit;
{   A := User^.curMsgArea;}
   if AllAreas then logWrite('*Packing all message areas');
   if AllAreas then for N := 0 to numMsgArea do
   begin
{      User^.curMsgArea := N;}
n:=0;
      if N = 0 then emailLoad else maLoad;
      maPackMessageArea;
   end else
   begin
{      if Num = 0 then N := User^.curMsgArea else N := Num;}
      if N > numMsgArea then N := numMsgArea else if N < 1 then N := 1;
{      User^.curMsgArea := N;}
      maLoad;
      if maHasAccess then
      begin
         logWrite('*Packing message area "'+mArea^.Name+'"');
         maPackMessageArea;
      end;
   end;
{   User^.curMsgArea := A;}
   if UserOn then maLoad;
end;

procedure maPackAreaAsk(Par : String);
var All : Boolean; Num : Word;
begin
   oDnLn(1);
   All := False;
   Num := 0;
   if Par <> '' then
   begin
      Par := UpStr(Par);
      All := (Par[1] = 'A');
      if not All then Num := StrToInt(Par);
   end;
   if (not All) and (Num = 0) then
   begin
      oString(strMsgPackAskAll);
      All := iYesNo(True);
      oDnLn(1);
   end;
   maPackAreas(All,Num);
end;
procedure maEditMessage(var Head : tMsgHeaderRec; mn : Word);
var H2 : tMsgHeaderRec; Txt : ^tMessage;
begin
   if {(User^.curMsgArea <> 0) and }(not maOktoEdit(Head)) then Exit;
   New(Txt);
   if not maLoadMessage(Txt^,Head,curMsg) then
   begin
      Dispose(Txt);
      Exit;
   end;
   H2 := Head;
   if fsEdit(Txt^,Head,False,nil,nil,False,False) then maReplaceMessage(Txt^,Head,mn) else
      Head := H2;
   Dispose(Txt);
end;

function maLoadTextFile(fn : String; var Txt : tMessage) : Word;
var tF : Text; N : Word; S : String;
begin
   maLoadTextFile := 0;
   Assign(tF,Fn);
   {$I-}
   Reset(tF);
   {$I+}
   if ioResult <> 0 then Exit;
   N := 0;
   while (not Eof(tF)) and (N < maxMsgLines) do
   begin
      Inc(N,1);
      FillChar(S,SizeOf(S),0);
      ReadLn(tF,S);
      if Length(S) > 80 then Delete(S,81,255);
      Txt[N] := S;
   end;
   Close(tF);
   maLoadTextFile := N;
end;

function maExportMessage(fn : String; var Txt : tMessage; var Head : tMsgHeaderRec) : Boolean;
var tF : Text; N, E : Word;
begin
   maExportMessage := False;
   Assign(tF,Fn);
   {$I-}
   Rewrite(tF);
   {$I+}
   if ioResult <> 0 then Exit;
   WriteLn(tF,'From      : '+NoColor(Head.FromInfo.Name));
   WriteLn(tF,'To        : '+NoColor(Head.ToInfo.Name));
   WriteLn(tF,'Subject   : '+NoColor(Head.Subject));
   WriteLn(tF,'Area      : '+NoColor(mArea^.Name));
   WriteLn(tF,'Status    : '+NoColor(maStatus(Head)));
   WriteLn(tF);
   E := Head.sigPos;
   if E = 0 then E := Head.Size else Dec(E);
   for N := 1 to E do WriteLn(tF,Txt[N]);
   Close(tF);
   maExportMessage := True;
end;

procedure maScanForMandatory(N : Word);
begin
end;

procedure maReset;
begin
   FillChar(mArea^,SizeOf(tMsgAreaRec),0);
   with mArea^ do
   begin
      Name          := 'New '+bbsTitle+' Message Area';
      Filename      := 'NEWAREA';
      MsgPath       := '';
      Sponsor       := Cfg^.SysOpname;
      Acs           := 's25';
      PostAcs       := 's50';
      MaxMsgs       := 200;
      Msgs          := 0;
      Password      := '';
      AreaType      := mareaNormal;
      Origin        := 1;
      Address       := 1;
      qwkName       := 'NewArea';
      Flag          := [maPrivate,maAnonymous];
   end;
end;

function maLoad : Boolean;
var F : file of tMsgAreaRec;
begin
   maLoad := False;
   Assign(F,Cfg^.pathData+fileMsgArea);
   {$I-}
   Reset(F);
   if ioResult = 0 then numMsgArea := FileSize(F) else Exit;
   {$I+}
   begin
      Close(F);
      Exit;
   end;
   {$I-}
   Read(F,mArea^);
   {$I+}
   maLoad:= ioResult = 0;
   Close(F);
end;

procedure maSave;
var F : file of tMsgAreaRec;
begin
   Assign(F,Cfg^.pathData+fileMsgArea);
   {$I-}
   Reset(F);
   {$I+}
   if ioResult = 0 then numMsgArea := FileSize(F) else Exit;
   begin
      Close(F);
      Exit;
   end;
   {$I-}
   Write(F,mArea^);
   numMsgArea := FileSize(F);
   {$I+}
   Close(F);
end;

procedure maSetPointerDate;
var D : String; Dt : Dos.DateTime; L : LongInt; ca, ma, fs, ls : Word;
begin
   oString(strMsgAskPointer);
   D := iReadDate('');
   if not dtValidDate(D) then Exit;
   Dt.Sec   := 0;
   Dt.Min   := 0;
   Dt.Hour  := 0;
   Dt.Month := strToInt(Copy(D,1,2));
   Dt.Day   := strToInt(Copy(D,4,2));
   Dt.Year  := strToInt(Copy(D,7,2))+1900;
   PackTime(Dt,L);
   oString(strMsgAskAllPointers);
   if iYesNo(True) then
   begin
      fs := 1;
      ls := numMsgArea;
   end else
   begin
      fs := ma;
      ls := ma;
   end;
   for ca := fs to ls do
   begin
      maLoad;
      maLoadScan(Scan^,User^.Number);
      Scan^.ptrMsg := L;
      maSaveScan(Scan^,User^.Number);
   end;
   maLoad;
end;

function maUploadMessage(var H : tMsgHeaderRec) : Boolean;
begin
end;

function maImportMessage(var M : tMessage) : Word;
begin
end;

function maDownloadMessage(N : Word) : Boolean;
begin
end;

procedure maEditTextfile(Fn : String);
var Head : ^tMsgHeaderRec; Txt : ^tMessage; X : Word; F : Text;
begin
   New(Txt);
   New(Head);
   FillChar(Txt^,SizeOf(Txt^),0);
   FillChar(Head^,SizeOf(Head^),0);
   X := maLoadTextfile(Fn,Txt^);
   with Head^ do
   begin
      with FromInfo do
      begin
         UserNum := User^.Number;
         Alias := User^.UserName;
         RealName := User^.RealName;
         Name := User^.UserName;
         UserNote := User^.UserNote;
      end;
      with ToInfo do
      begin
         UserNum := 0;
         Alias := 'n/a';
         RealName := 'n/a';
         Name := 'n/a';
         UserNote := 'None';
      end;
      Size := X;
      Replies := 0;
      Date := dtDateTimePacked;
      Subject := #10'Text Editor ('+UpStr(Fn)+')';
      sigPos := 0;
   end;
   if fsEdit(Txt^,Head^,False,nil,nil,False,False) then
   begin
      Assign(F,Fn);
      {$I-}
      Rewrite(F);
      {$I+}
      if ioResult = 0 then
      begin
         for X := 1 to Head^.Size do WriteLn(F,Txt^[X]);
         Close(F);
      end else oWriteLn('Error saving file.');
   end;
   Dispose(Head);
   Dispose(Txt);
end;

procedure maFindAreaWithAccess;
var old, N : Word; F : file of tMsgAreaRec; Found : Boolean;
begin
   maLoad;
   if maHasAccess then Exit;
   Assign(F,Cfg^.pathData+fileMsgArea);
   {$I-}
   Reset(F);
   {$I+}
   if ioResult <> 0 then Exit;
   N := 0;
   Found := False;
   while (not Found) and (not Eof(F)) do
   begin
      Read(F,mArea^);
      Inc(N);
      Found := maHasAccess;
   end;
   Close(F);
   maLoad;
end;
procedure maNewScanSelect;

begin
end;
end.