{$IFDEF OVERLAY} {$O+} {$ENDIF}
unit FileSort;

interface

procedure fsSortusersScores;

implementation

uses
   Global,StrProc, DateTime, Output, Input, Misc,files;

procedure fsSortusersScores;
var fD : file of tuserRec;

function Precedes (A, B : tuserRec) : boolean;
begin
   Precedes := (a.xp >= b.xp);
end;

procedure Swap (Index1, Index2 : Integer; Temp1, Temp2 : tuserrec);
    begin {Swap}
        Seek (fD, Index1);
        Write (fD, Temp2);
        Seek (fD, Index2);
        Write (fD, Temp1);
    end; {Swap   }
procedure ShellSortInsertion (NumVals : Integer);
var
    EleDist : Integer;
    Temp1, Temp2 : tuserRec;
    procedure SegmentedInsertion (N, K : Integer);
    var
        J, L : Integer;
    begin {SegmentedInsertion}
        for L := K + 1 to N do
            begin
                J := L - K;
                while J > 0 do
                    begin
                        Seek (fD, J+K-1);
                        Read (fD, Temp1);
                        Seek (fD, J-1);
                        Read (fD, Temp2);
                        if Precedes (Temp1, Temp2) then
                            begin
                                Swap (J+K-1, J-1, Temp1, Temp2);
                                J := J - K;
                            end
                        else
                            J := 0;
                    end;
            end;
    end; {SegmentedInsertion}
begin {ShellSortInsertion}
    EleDist :=  NumVals div 2;
    while EleDist > 0 do
        begin
            SegmentedInsertion (NumVals, EleDist);
            EleDist := EleDist div 2;
        end;
end; {ShellSortInsertion}

begin
   fcopyfile('users.dat','users.tmp');
   Assign(fD,'users.tmp');
   {$I-}
   Reset(fD);
   {$I+}
   if ioResult <> 0 then Exit;
   ShellSortInsertion(FileSize(fD));
   Close(fD);
end;

end.
