unit Comm;

interface

uses
   {$IFDEF OS2} Use32, {$ENDIF}
   Crt, Dos, eComm;

const
   noDevice = 0;

procedure cCheckIt;
procedure cCheckUser;
function  cInitialize : Boolean;
function  cModemRinging : Boolean;
function  cNoCarrier : Boolean;
procedure cClearInBuffer;
procedure cClearOutBuffer;
procedure cHangUp;
procedure cModemWrite(S : String);
procedure cPurgeInput;
procedure cRaiseDTR;
procedure cTerminate;
procedure cWaitOutput;

implementation

uses
   Global, StrProc, Misc, Logs, Output, DateTime, Nodes,bbsinit;

function cAbort : Boolean; far;
begin
   cAbort := (keypressed) and (readkey = #27);
end;

function cInitialize : Boolean;
var bh:boolean;
begin
    {$IFDEF LINUX}
    bh:=einit(modem^.comport);
    {$ELSE}
    bh:=eInit(modem^.comport, modem^.baudrate);
    {$ENDIF}

    modemio:=bh;
    cinitialize:=bh;
    modemoff:=not bh;
    {$IFDEF LINUX}
    logwrite('Com: '+modem^.comport+'Baud: '+st(modem^.baudrate));
    {$ELSE}
    logwrite('Com: '+st(modem^.comport)+'Baud: '+st(modem^.baudrate));
    {$ENDIF}
    logwrite('Inited: '+b2st(bh));
end;

procedure cTerminate;
begin
   eclosemodem;
end;

function cNoCarrier : Boolean;
begin
   cNoCarrier := ModemIO and (not echeckdcd);
end;

procedure cCheckIt;
begin
{   if UserOn then sbUpdate;}
{$IFNDEF LINUX}
   if not LocalIO then
   begin
      if (HangUp) and (not cNoCarrier) then
      begin
         HungUp := False;
{         if not asDoor then cHangUp;}
{         RemoteOut := False;}
         LocalIO := True;
         ModemIO := False;
         if cfg2^.daemon or cfg2^.wfc then begin end else killterminatebbs(false);
      end else
      if cNoCarrier then
      begin
         HangUp := True;
         HungUp := True;
         logWrite('Carrier lost');
{         if not asDoor then cHangUp;}
{         RemoteOut := False;}
         LocalIO := True;
         ModemIO := False;
         if cfg2^.daemon or cfg2^.wfc then begin end else killterminatebbs(false);
      end;
   end;
   {$ENDIF}
{   if (not nodebusy) and (useron) then nodeProcess;}
   if oprType > oprDOS then mTimeSlice;
end;

procedure cCheckUser;
begin
   if (not ChatModeOn) and (timeCheck) and (UserOn) and (LoggedIn) and
      (not HangUp) and (mTimeLeft('S') < 1) then
   begin
      oStringLn(strTimeExpired);
      logWrite('User''s time expired.');
      if cfg2^.daemon or cfg2^.wfc then begin end else killterminatebbs(false);
   end;
   cCheckIt;
end;

function cModemRinging : Boolean;
begin
   cModemRinging := ModemIO and echeckRI;
end;

procedure cClearOutBuffer;
begin
   if ModemIO then eFlushOutBuffer;
end;

procedure cClearInBuffer;
begin
   if ModemIO then eFlushInBuffer;
end;

procedure cPurgeInput;
var c : Char;
begin
   if ModemIO then
      while echeckdcd and echarready do egetchar(c);
end;

procedure cHangUp;
var
  hTimer: real;
begin
(*   if ModemIO then
   begin
      esetDTR(False);
      hTimer:=dtTimer;
      repeat
        mTimeSlice;
      until (echeckdcd=false) or (dtTimer>=hTimer+10); {fail in 10 seconds}
      esetDTR(True);
      Delay(100);
      eflushinbuffer;
   end;*)
   killterminatebbs(false);
end;

procedure cRaiseDTR;
begin
   if ModemIO then esetDTR(True);
end;

procedure cModemWrite(S : String);
var P : Byte;
begin
   if not ModemIO then Exit;
   for P := 1 to Length(S) do
   begin
      case S[P] of
        '|' : eputChar(#13);
        '~' : Delay(500);
        '^' : cHangUp;
        else eputChar(s[p]);
      end;
   end;
end;

procedure cWaitOutput;
begin
   if not ModemIO then Exit;
   while (not Hangup) and (eoutBuffUsed > 0) do cCheckUser;
end;

end.
