{$IFDEF OVERLAY} {$O+} {$ENDIF}
unit bbuild;

interface

uses global{$IFDEF LINUX},linux{$ENDIF};

function buildlimitok(num:word):boolean;
function buildload(a:tbuildingrec) : boolean;
function buildcheckprereq : boolean;
procedure bstat;
procedure builddisplaydone;
procedure buildlistavail;
procedure buildconstruction;

implementation

uses input, output, showfile, mudmisc, users,rrun,strproc,crt,strategy;

function buildlimitok(num:word):boolean;
begin
if ((city3^.builddone[num] > building^.maxnumber) and (building^.maxnumber > 0)) then buildlimitok:=false
else buildlimitok:=true;
end;

function buildload(a:tbuildingrec) : boolean;
var {$IFDEF LINUX} f:longint; {$ELSE} F : file;{$ENDIF}
begin
   buildload := False;
{$IFDEF LINUX}
   f := fdopen ('buildg.dat', open_rdonly);
   if f <> 0 then Exit;
   fdSeek(F,(a.Number-1) * sizeof (tbuildingrec), seek_set);
   buildload := fdRead(F,a,sizeof (tbuildingrec)) = sizeof (tbuildingrec);
   fdClose(F);
{$ELSE}
   Assign(F,'buildg.dat');
   {$I-}
   Reset(F,SizeOf(tbuildingRec));
   {$I+}
   if ioResult <> 0 then Exit;
   Seek(F,a.Number-1);
   {$I-}
   BlockRead(F,building^,1);
   {$I+}
   buildload := ioResult = 0;
   Close(F);
{$ENDIF}
end;

function buildcheckprereq : boolean;
var check:byte;
begin
buildcheckprereq:=true;
for check:=1 to 15 do
begin
if (building^.prereq[check] > 0) then
begin
  if (city3^.builddone[building^.prereq[check]] = 0) then
  begin
    buildcheckprereq:=false;
    break;
  end;
end;
if (building^.prereqsci[check] > 0) then
begin
  if ((city^.scilevel[check]) < (building^.prereqsci[check])) then
  begin
    buildcheckprereq:=false;
    break;
  end;
end;
end;
end;

procedure builddisplaydone;
var xyz:word;  xaa:byte;
begin
xaa:=11;
sfshowfile('buillist.ans',ftnocode);
for xyz:=1 to 32760 do
begin
if (city3^.builddone[xyz] > 0) then
begin
building^.number:=xyz;
buildload(building^);
osetfore(9);
ogotoxy(3,xaa);
owrite(st(city3^.builddone[xyz]) + ' ');
osetfore(7);
ogotoxy(12,xaa);
ocwriteln(building^.name);
inc (xaa);
end;
if (xaa > 23) then
begin
xaa:=11;
whpause;
sfshowfile('buillist.ans',ftnocode);
end;
end;
whpause;
end;

procedure buildlistavail;
var xaa:word;
begin
oclrscr;
building^.number:=1;
sfshowfile('buillist.ans', ftnocode);
xaa:=11;
while buildload(building^) do
begin
ogotoxy(3,xaa);
osetfore(9);
owrite(st(building^.number));
ogotoxy(12,xaa);
osetfore(7);
ocwriteln(building^.name);
inc(xaa);
inc(building^.number);
if (xaa > 24) then begin odnln(1); whpause; xaa:=11; sfshowfile('buillist.ans',ftnocode); end;
end;
odnln(1);
whpause;
end;

procedure bstat;
begin
sfshowfile('bstat.ans',ftnocode);
ogotoxy(16,4);
ocwrite(building^.name);
osetfore(9);
ogotoxy(15,8);  owrite(st(building^.revenue));
ogotoxy(34,8);  owrite(st(building^.upkeep[1]));
ogotoxy(49,8);  owrite(st(building^.costgold));
osetfore(3);
ogotoxy(15,9);  owrite(st(building^.prodmetal));
ogotoxy(34,9);  owrite(st(building^.upkeep[2]));
ogotoxy(49,9);  owrite(st(building^.costmetal));
osetfore(9);
ogotoxy(15,11); owrite(st(building^.prodstone));
ogotoxy(34,11); owrite(st(building^.upkeep[3]));
ogotoxy(49,11); owrite(st(building^.coststone));
osetfore(3);
ogotoxy(15,12); owrite(st(building^.prodpop));
ogotoxy(34,12); owrite(st(building^.upkeep[4]));
ogotoxy(49,12); owrite('N/A');
osetfore(9);
ogotoxy(15,14); owrite(st(building^.prodlumber));
ogotoxy(34,14); owrite(st(building^.upkeep[5]));
ogotoxy(49,14); owrite(st(building^.costlumber));
osetfore(3);
ogotoxy(15,15); owrite(st(building^.prodfood));
ogotoxy(34,15); owrite(st(building^.upkeep[6]));
ogotoxy(49,15); owrite('N/A');
osetfore(9);
ogotoxy(15,17); owrite(st(building^.prodwater));
ogotoxy(34,17); owrite(st(building^.upkeep[7]));
ogotoxy(49,17); owrite('N/A');
osetfore(3);
ogotoxy(15,18); owrite(st(building^.prodweapons));
ogotoxy(34,18); owrite(st(building^.upkeepweapons));
ogotoxy(49,18); owrite('N/A');
osetfore(9);
ogotoxy(16,20); owrite(st(building^.size));
ogotoxy(16,22); owrite(st(building^.employ));
end;

procedure buildconstruction;
var selected:string[5]; ok:boolean;
begin
repeat
buildlistavail;
odnln(1);
owrite('Witch building to construct? ');
repeat
selected:=ireadstring('',inupper,chnumeric,'',5);
until ((strtoint(selected) <= 32760) and (strtoint(selected) >= 1));
building^.number:=strtoint(selected);
ok:=buildload(building^);
if ok then
begin
ok := buildcheckprereq;
if ok then
begin
ok:=buildlimitok(strtoint(selected));
if ok then
begin
bstat;
odnln(1);
owriteln('Are you sure you want to build a '+building^.name+'?');
if iyesno(true) then begin
if (building^.costmetal > city^.stormetal) then begin owrite('Not enough metals'); delay(user^.delayn); end else
if (building^.coststone > city^.storstone) then begin owrite('Not enough stones'); delay(user^.delayn); end else
if (building^.costlumber > city^.storlumber) then begin owrite('Not enough lumber'); delay(user^.delayn); end else
if (building^.size > city^.wilderness) then begin owrite('Not enough territory'); delay(user^.delayn); end else
if (building^.costgold > ((city^.bankdeposited) + (user^.gold))) then begin owrite('Not enough gold'); delay(user^.delayn); end
 else
begin
dec(city^.stormetal,building^.costmetal);
dec(city^.storstone,building^.coststone);
dec(city^.storlumber,building^.costlumber);
dec(city^.wilderness, building^.size);
dec(city^.bankdeposited,building^.costgold);
if (city^.bankdeposited < 0) then
begin
inc(user^.gold,city^.bankdeposited);
city^.bankdeposited:=0;
end;
city^.nowbldname:=building^.name;
city^.constdone:=0;
city^.constneeded:=building^.constneeded;
city^.nowbuilding:=building^.number;
usersave(user^);
citysave(city^);
end;

end;
end
else
begin
owrite('You have reached the limit for this building'); delay(user^.delayn);
end;
end

else begin owrite('You don''t have the prerequisite to build it'); delay(user^.delayn);

end;
end
else begin owrite('Building does not exist'); delay(user^.delayn); end;
until ok;
end;
end.