{$IFDEF OVERLAY} {$O-} {$ENDIF}
unit bbsInit;

interface

procedure fixUsers;
procedure killTerminateBBS(pause: boolean);
procedure killVariables;
procedure initCommPort;
procedure initFiles;
procedure initParameters;
procedure initPaths;
procedure initVariables;
procedure resetArchivers;
procedure resetMessage;
procedure resetModem;
procedure resetProtocols;
procedure resetVariables(Full : Boolean);
function resetString(sn : Word) : String; { added by ck }

implementation

uses
   Crt, Global, StrProc, Files, Comm, Misc, Screen, MsgArea, Detect, FastIO, Logs, Users, DateTime,
{   FileArea,}mudmisc, FileSort, Nodes, Emulate, {Events,} Showfile,output
{$IFDEF LINUX},linux{$ENDIF};

procedure resetVariables(Full : Boolean);
begin
   vt100 := False;
   ChatModeOn := False;
   DetANSi := False;
   DetAVATAR := False;
   DetRIP := False;
   detTextFX := false;
   ExecFirst := False;
   Hangup := False;
   Hungup := False;
   {OkFlag := False;
   PauseAbort := False;}
   QuitAfter := true;
   LocKey := True;
   LoggedIn := False;
   {RemoteIn := True;
   RemoteOut := False;}
   ScreenOff := False;
{   StringEdit := False;
   TempSysOp := False; }
   UserOn := False;
{   NewMnuToLoad := True;
   NewMenuCmd := '';
   CmdList := '';
   chatReason := '';}
   Baudrate := 0;
   emailTag := 0;
   readTag := 0;
   useTag := False;
   {numBatch := 0;}
   scrCol.Fore := $07;
   scrCol.Back := $00;
   scrCol.Blink := False;
   Col := scrCol;
   saveCol := scrCol;
   colAttr := $07;
   posX := 1;
   posY := 1;
   savX := 1;
   savY := 1;
   scrX := 1;
   scrY := 1;
   {doHelp := False;}
   {macroPos := 0;}
   pausePos := 0;
   curMsg       := 0;
   timeEvent    := 0.0;
   timeExtra    := 0.0;
   timeFree     := 0.0;
   extKey := #0;
{   FillChar(MenuStack,SizeOf(MenuStack),#0);
   LastMenu := Cfg^.StartMenu;
   CurMenu := Cfg^.StartMenu;
   MenuPtr := 0;}
   mandMsg := False;
   {fConfAll := False;}
   posX := 1;
   posY := 1;
   nodeready := False;
   nodebusy := false;
{   emuTextFX := false;}
{   intextfx := false;
   fontchanged := false;
   interminal := false;
 }
   if not Full then Exit;
{$IFDEF LINUX}
   LocalIO := True;
{$ENDIF}
   LocalIO := False;
   ModemIO := False;
   ModemOff := False;
   {tLibOpen := False;}
   Node := 1;
   ErrorLevel := 0;
   {scrTop := 1;}
   {scrBot := 25;
   curStat := 1;}
   ansiRows := 0;
   {macroNum := 0;}
   oprDelay := 100;


   {numCmds      := 0;
   numEvent     := 0;}
   numMsgArea   := 0;
{   numFileArea  := 0;}
   numUsers     := 0;
   numMsg       := 0;
   numMsgConf   := 0;
{   numFileConf  := 0;}
   {numLib       := 0;}
end;

procedure resetModem;
begin
   FillChar(Modem^,SizeOf(tModemRec),0);
   with Modem^ do
   begin
      ComDevice     := 0;
      {$IFDEF LINUX}
      ComPort       := '/dev/ttyS0';
      {$ELSE}
      ComPort       := 2;
      {$ENDIF}
      BaudRate      := 38400;
      Parity        := 'N';
      StopBits      := 1;
      DataBits      := 8;
      RecvBuff      := 2048;
      SendBuff      := 1024;
      LockedPort    := True;
      MultiRing     := False;
      irqNumber     := 0;
      baseAddr      := '0';

      sInit1        := 'ATH0E1&C1&D2&A3S0=0|';
      sInit2        := '';
      sInit3        := '';
      sExitStr      := '';
      sAnswer       := 'ATA|';
      sHangup       := 'ATH0|';
      sOffhook      := 'ATH1|';
      sDialPrefix   := 'ATDT';

      rError        := 'ERROR';
      rNoCarrier    := 'NO CARRIER';
      rOK           := 'OK';
      rRing         := 'RING';
      rBusy         := 'BUSY';
      rNoDialTone   := 'NO DIAL TONE';

      c300          := 'CONNECT';
      c1200         := 'CONNECT 1200';
      c2400         := 'CONNECT 2400';
      c4800         := 'CONNECT 4800';
      c7200         := 'CONNECT 7200';
      c9600         := 'CONNECT 9600';
      c14400        := 'CONNECT 14400';
      c16800        := 'CONNECT 16800';
      c19200        := 'CONNECT 19200';
      c21600        := 'CONNECT 21600';
      c24000        := 'CONNECT 24000';
      c26400        := 'CONNECT 26400';
      c28800        := 'CONNECT 28800';
      c31200        := 'CONNECT 31200';
      c33600        := 'CONNECT 33600';
      c38400        := 'CONNECT 38400';
      c57600        := 'CONNECT 57600';
      c64000        := 'CONNECT 64000';
      c115200       := 'CONNECT 115200';
   end;
end;

procedure fixUsers;
var F : file of tUserRec; U : tUserRec; Z : Word;
begin
   Assign(F,Cfg^.pathData+fileUsers);
   {$I-}
   Reset(F);
   {$I+}
   Z := 0;
   if ioResult <> 0 then Exit;
   while not Eof(F) do with U do
   begin
      Inc(Z,1);
      Read(F,U);

      Username := strMixed(Username);
      Realname := strMixed(Realname);

      Posts        := 0;
      Email        := 0;

      FillChar(Reserved,SizeOf(Reserved),0);
      Seek(F,Z-1);
      Write(F,U);
   end;
   Close(F);
end;

function resetString(sn : Word) : String;
var s : String;
begin
   FillChar(s,SizeOf(s),0);
   case sn of
       strHitAKey           : S := '|08-|04-|12[ |15p|07res|08s |15a|07n|08y |15k|07e|08y |07t|08o |15c|07onti'+
                                   'nu|08e |12]-|04-|08-';
       strChatInitiate      : S := '|LF|12|04-|08- |12C|04h|08at |12m|04o|08de |12i|04n|08itiated |12-|04-|08-|L'+
                                   'F';
       strChatTerminate     : S := '|LF|12|04-|08- |12C|04ha|08t |12m|04o|08de |12t|04e|08rminated |12-|04-|08-|'+
                                   'LF';
       strFsAskAbort        : S := '|10|02-|08- |10A|02b|08ort |10m|02e|08ssage? ';
       strFsAskCommand      : S := '|15|07-|08- |15C|07o|08mmand |07[|15?|07|15H|07e|08lp] ';
       strFsCommandHelp     : S := '|15|07-|08- |15E|07d|08itor |15c|07o|08mmand? |07[|15?|07|15H|07e|08lp] ';
       strFsSavingMsg       : S := '|15|07-|08- |15S|07a|08ving |15m|07e|08ssage ...';
       strMsgNoPostAcs      : S := '|12Y|04o|08u |12d|04o |12n|04o|08t |12h|04a|08ve |12p|04o|08st |12a|04c|08ces'+
                                   's in this area.';
       strMsgAskWhoTo       : S := '|CS|11D|03e|08stination        : |07';
       strMsgAskPrivate     : S := '|11P|03r|08ivate |11m|03e|08ssage? ';
       strMsgAskTitle       : S := '|11E|03n|08ter |11m|03e|08ssage |11t|03i|08tle: |07';
       strMsgReadNoMsgs     : S := '|12|04-|08- |12M|04e|08ssage |12b|04a|08se |12i|04s |12e|04m|08pty.';
       strMsgReadStartAt    : S := '|12|04-|08- |12S|04t|08art |12r|04e|08ading |12a|04t |08|04[|121|04-|08%S1] |09';
       strMsgReadPrompt     : S := '|08-|01-|09-|01-|08 |15r|07eadi|08ng |15m|07essa|08ge |08[|13%S1 |05o|08f |05%S'+
                                   '2|08]  |09C|01omma|08nd |08[|15?|08/|07h|08elp, |15e|07nter|08/|07n|08ext|08]: ';
       strMsgReadAskPost    : S := '|10|02-|08- |10P|02o|08st |10i|02n |10t|02h|08is |10a|02r|08ea? ';
       strMsgAlterTitle     : S := '|15|07-|08- |15E|07n|08ter |15n|07e|08w |15m|07e|08ssage |15t|07i|08tle.';
       strMsgQuoteFirst     : S := '|10|02-|08- |10E|02n|08ter |10f|02i|08rst |10l|02i|08ne |10o|02f |10m|02e|08'+
                                   'ssage |10t|02o |10q|02u|08ote |02[|101|02-|08%S1]: |07';
       strMsgQuoteSecond    : S := '|10|02-|08- |10E|02n|08ter |10s|02e|08cond |10l|02i|08ne |10o|02f |10m|02e|0'+
                                   '8ssage |10t|02o |10q|02u|08ote |02[|10%S1|02-|08%S2]: |07';
       strMsgDeleted        : S := '|12|04-|08- |12M|04e|08ssage |12d|04e|08leted |12-|04-|08-';
       strMsgUndeleted      : S := '|12|04-|08- |12M|04e|08ssage |12u|04n|08deleted |12-|04-|08-';
       strMsgNewScanAskAll  : S := '|15|07-|08- |13N|05e|08wScan |13a|05l|08l |13m|05e|08ssage |13a|05r|08eas? ';
       strMsgPackStart      : S := '|12|04-|08- |12P|04a|08cking |12a|04r|08ea: |12%S1 |04[|12%S2 |04msgs|08] ...';
       strMsgPackEnd        : S := ' |12c|04o|08mplete.';
       strMsgPackAskAll     : S := '|10|02-|08- |10P|02a|08ck |10a|02l|08l |10m|02e|08ssage |10a|02r|08eas? ';
       strMsgReadMandatory  : S := '|LF|12|04-|08- |12Y|04o|08u |12m|04u|08st |12r|04e|08ad |12a|04l|08l |12o|0'+
                                   '4f |12t|04h|08e |12m|04e|08ssages |12i|04n |12t|04h|08is |12b|04a|08se |12-|'+
                                   '04-|08-';
       strEmailUserUnknown  : S := '|12|04-|08- |12U|04s|08er |12n|04o|08t |12f|04o|08und |12-|04-|08-';
       strEmailNoMail       : S := '|12N|04o |12m|04a|08il |12w|04a|08iting';
       strEmailSelectToRead : S := '|15|07-|08- |15B|07e|08gin |15r|07e|08ading |15a|07t |15w|07h|08ich |15m|07'+
                                   'e|08ssage |08[|071|08-|07%S1|08]: |15';
       strEmailReadPrompt   : S := '|08= |15Rea|07di|08ng |15Em|07ai|08l |15%S1 |08of |07%S2 |08 |11Com|03ma|08'+
                                   'nd [|15q|08/|07quit|08|15?|08/|07help|08|15enter|08/|07next|08]: |07';
       strEmailKillOriginal : S := '|15|07-|08- |15D|07e|08stroy |15o|07r|08ignal |15m|07e|08ssage? ';
       strMsgSetPointer     : S := '|12|04-|08- |12N|04e|08wscan |12p|04o|08inter |12s|04e|08t |04t|08o |12c|04'+
                                   'u|08rrent |12m|04e|08ssage.';
       strEmailAskRead      : S := '|15|07-|08- |15Y|07o|08u |15h|07a|08ve |15e|07m|08ail.  |15R|07e|08ad |07i|08t? ';
       strTimeExpired       : S := '|15-|07-|08- |12S|04orr|08y, |12y|04o|08ur |12t|04i|08me |12h|04a|08s |12e|04x|08pired.';
       strMsgAskPointer     : S := '|09-|01-|08- |15E|07nt|08er |15m|07es|08sage |15p|07oi|08nter |15d|07at|08e [|07mm|08'+
                                   '/|07dd|08/|07yy|08]: ';
       strMsgAskAllPointers : S := '|09-|01-|08- |15U|07pd|08ate |15a|07l|08l |15m|07es|08sage |15a|07re|08as? ';
       strEmailSent         : S := '|08- |11Em|03ai|08l |11s|03en|08t |03t|08o |15%S1|08.';
       strEmailAskKillAll   : S := '|08\-/ |15De|07let|08e |15a|07l|08l |15r|07ea|08d |15m|07ai|08l? ';
       strMsgAskQuote       : S := '|11A|03u|08toQuote |11m|03e|08ssage? ';
       strTimeInactive      : S := '|U4Inactivity timeout|U5.  |U4Hanging up|U5 ...';
       strNodeNotMulti      : S := '|U4This is |U6not |U4a multi-node BBS|U5.';
       strMsgNewscanAskConfs: S := '|u1Scan all message conferences|u2? ';
       strMNCyouspeak       : S := ':%s1: %s2';
       strMNCtheyspeak      : S := '<%s1> %s2';
       strMNCenterchat      : S := '%s1 has entered multinode chat';
       strMNCquitchat       : S := '%s1 has quit multinode chat';
       strNodeAskNode       : S := 'Enter node # or username to send text to [?/list] ';
       strNodeUserOn        : S := 'Node #%S1 - %S2 is online at %S3 bps';
       strNodeMsgAskText    : S := 'Enter message to send: ';
       strNodeMsgSent       : S := 'Message sent to %S1 on node %S2';
       strNodeBCaskText     : S := 'Enter message to broadcast: ';
       strNodeBCsent        : S := 'Broadcast sent to all nodes';
       strEmailAskAddress   : S := 'Enter the address: ';
       strEmailAskOriginAddr: S := 'Enter the AKA to use: ';
       strDidYouMeanUser    : S := 'Did you mean %S1? ';
       strFsAskClear        : S := 'Clear message? ';

   end;
   resetString := s;
end;

procedure resetMessage;
begin
   with Msg^ do
   begin
      with FromInfo do
      begin
         UserNum := 1;
         Alias := 'Unknown';
         RealName := 'None';
         Name := 'None';
         UserNote := 'None';
      end;
      with ToInfo do
      begin
         UserNum := 1;
         Alias := 'Unknown';
         RealName := 'None';
         Name := 'None';
         UserNote := 'None';
      end;
      Pos := 1;
      Size := 0;
      Date := dtDateTimePacked;
      Status := [];
      Replies := 0;
      Subject := 'Untitled';
   end;
end;

procedure initVariables;
var {$IFNDEF LINUX} f:file of tlockfile; {$ELSE} f:longint;{$ENDIF} x:byte;
begin
   write('Initializing variables');
   new(igm);
   New(User);
   New(user2);
   new(city);
   new(reg);
{   New(Modem);
   write('.');}
   New(strBuf);
   New(mArea);
   New(Msg);
   New(Scan);
   New(ioWin);
   New(nodeInfo);
   New(event);
{  new(cfg2);}                   {Now inits in initdoordriver of darkland.pas}
{  write('.');}
   new(armor);
   new(weapon);
   new(room);
   new(item);
   new(monster);
{   new(cfg);
   write('.');}
   new(levels);
{   new(cfg3);
   write('.');}
   new(city2);
   new(city3);
   new(building);
   new(army);
   new(lockfile);
   fillchar(army^,sizeof(army^),0);
   fillchar(building^,sizeof(building^),0);
   fillchar(city2^,sizeof(city2^),0);
   fillchar(city3^,sizeof(city3^),0);
   fillchar(igm^,sizeof(igm^),0);
{   fillchar(cfg3^,sizeof(cfg3^),0);
   write('.');}
   fillchar(levels^,sizeof(levels^),0);
{   fillchar(cfg^,sizeof(cfg^),0);
   write('.');}
   fillchar(reg^,sizeof(reg^),0);
   fillchar(monster^,sizeof(monster^),0);
   fillchar(item^,sizeof(item^),0);
   fillchar(room^,sizeof(room^),0);
   Fillchar(armor^,sizeof(armor^),0);
   fillchar(weapon^,sizeof(weapon^),0);
   FillChar(User^,SizeOf(User^),0);
{  FillChar(cfg2^,sizeOf(cfg2^),0);}
{  write('.');}
{   FillChar(Modem^,SizeOf(Modem^),0);
   write('.');}
   FillChar(strBuf^,SizeOf(strBuf^),0);
   FillChar(mArea^,SizeOf(mArea^),0);
   FillChar(Msg^,SizeOf(Msg^),0);
   FillChar(Scan^,SizeOf(Scan^),0);
   FillChar(ioWin^,SizeOf(ioWin^),0);
   FillChar(nodeInfo^,SizeOf(nodeInfo^),0);
   FillChar(lockfile^,SizeOf(lockfile^),0);

   FillChar(strIdx,SizeOf(strIdx),0);

   GetDir(0,StartDir);
   {$IFNDEF LINUX}
   if StartDir[Length(StartDir)] <> '\' then StartDir := StartDir+'\';
   {$ELSE}
   if StartDir[Length(StartDir)] <> '/' then StartDir := StartDir+'/';
   {$ENDIF}

   resetVariables(True);
   mWriteInit('analyzing node information');

   if cfg^.daemon then
   begin
    cfg^.multinode:=true;
    multinode:=true;
    {$IFDEF LINUX}
    f:=fdopen ('lockfile.lck', open_rdonly);
    if not ((fdread (f, lockfile^, sizeof(tlockfile))) = (sizeof(tlockfile))) then
    begin
     f:=fdopen('lockfile.lck', open_rdwr OR open_creat, 436);
     fdwrite(f,lockfile^,sizeof(lockfile^));
     f:=fdopen('lockfile.lck', open_rdonly);
    end;
     fdclose(f);
    {$ELSE}
    assign (f, 'lockfile.lck');
    {$I-}
    reset (f);
    {$I+}
    if ioresult <> 0 then begin rewrite(f); write(f, lockfile^); reset(f); end;
    read (f, lockfile^);
    {$ENDIF}
    for x:=0 to 255 do
      if not (lockfile^.locked[x]) then break;
    Node:=x;
    lockfile^.locked[node]:=true;
    {$IFDEF LINUX}
    f:=fdopen('lockfile.lck', open_rdwr OR open_creat, 436);
    fdwrite(f,lockfile^,sizeof(lockfile^));
    fdclose(f);
    {$ELSE}
    rewrite(f);
    write(f, lockfile^);
    close(f);
    {$ENDIF}

   end else
   Node := strToInt(paramstr(1));

{   multinode:=cfg^.multinode;}
{   if (not MultiNode) or (Node < 1) or (Node > maxNode) then Node := 1;}

   scrInitPages(10);

   curEvent := 0;
   ErrorLevel := errNormal;
   posX := 1;
   posY := 1;
{   mWriteInit('detecting computer hardware');
   detProcessor;
   detVideoCard;
   detOperator;}
   inforest:=false;
   incombat:=false;
writeln;
{   write ('Initiating node');
   Nodeinit;
   writeln('...done');}
end;

procedure initPaths;
begin
   write('initializing paths ');
  cfg^.pathData         := '';
  cfg^.pathText         := '';
  cfg^.pathMenu         := '';
  cfg^.pathMsgs         := '';
  cfg^.pathSwap         := '';
  cfg^.pathDoor         := '';
  cfg^.pathProt         := '';
  {$IFNDEF LINUX}
  cfg^.pathTemp         := 'temp\';
  {$ELSE}
  cfg^.pathTemp         := './temp/';
  {$ENDIF}
  cfg^.pathDnld         := '';
  if not fdirexists('logs') then fcreatedir('logs',true);
  {$IFNDEF LINUX}
  cfg^.pathLogs         := 'logs\';
  {$ELSE}
  cfg^.pathLogs         := './logs/';
  {$ENDIF}
  Write('Done'); writeln;
end;

procedure resetProtocols;
{var F : file of tProtRec; P : tProtRec; N : Word;}
begin

end;

procedure resetArchivers;
{var F : file of tArchiverRec; A : tArchiverRec; N : Word;}
begin
end;

procedure killVariables;
begin
   dispose(armor);
   dispose(cfg);
   dispose(cfg2);
   dispose(cfg3);
   dispose(igm);
   Dispose(ioWin);
   dispose(item);
   dispose(levels);
   Dispose(mArea);
   Dispose(Modem);
   dispose(monster);
   Dispose(Msg);
   Dispose(nodeInfo);
   dispose(reg);
   dispose(room);
   Dispose(Scan);
   Dispose(strBuf);
   Dispose(User);
   dispose(weapon);
   scrDeInitPages;

end;

procedure killTerminateBBS(pause : boolean);
var S : String; N : Byte; {$IFNDEF LINUX}fl:file of tlockfile;{$ELSE} fl:longint;{$ENDIF}
begin
{$IFDEF LINUX}
fdclose (file_room);
fdclose (file_user_1);
fdclose (file_user_2);
{$ELSE}
close (file_room);
close (file_user_1);
close (file_user_2);
{$ENDIF}

incombat:=false;
inforest:=false;
mcursor(true);
oclrscr;
if pause then
begin
  sfshowfile('cred2.ans',ftnocode);
  whpause;
{$IFDEF DEBUG}writeln ('DEbug1'); {$ENDIF}
if not (reg^.reged) then
  begin
    osetfore(12);
    ogotoxy(1,25);
    owriteln('Unregistered Pause!');
    owriteln('And you tought it is bad to lose some precious time.');
    owriteln('Tell you what, it''s worse than you thought');
    owriteln('You see I won''t ask your sysop to pay for freeware');
    owriteln('All you have to do is to make him go to');
    owriteln('http://fly.to/darklands');
    owriteln('and use the quick form and wait for me to send the keyfile');
    owriteln('All he needs to say is his alias and bbs name');
    owriteln('So tell HIM/HER or have someone else to do it.');
    odnln(2);
    owriteln('Now you have a really loosy countdown to watch');
    owrite(' 5 ');
    delay(1000);
    owrite(' 4 ');
    delay(1000);
    owrite(' 3 ');
    delay(1000);
    owrite(' 2 ');
    delay(1000);
    owrite(' 1 ');
    delay(1000);
    owrite('Cya around!');
  end;
end;
  if cfg^.daemon then begin
    lockfile^.locked[node]:=false;
  {$IFDEF LINUX}
     fl:=fdopen('lockfile.lck', open_rdwr OR open_creat, 436);
     fdwrite(fl,lockfile^,sizeof(lockfile^));
     fdclose(fl);
  {$ELSE}
    assign(fl, 'lockfile.lck');
    rewrite(fl);
    write(fl, lockfile^);
    close(fl);
  {$ENDIF}
  end;
{$IFDEF DEBUG}writeln ('DEbug2'); {$ENDIF}

   ModemIO := not ModemOff;
   logWrite('>'+bbsTitle+' v'+bbsVersion+' terminated (errorlevel '+St(errorLevel)+').');
   ioScreenOn;
   TextAttr := $07;
      ioTextMode;
      cFwrite(1,1,'|08%|07:|08%');
      cFwrite(77,1,'|08%|07:|08%');
      s := ' Dark Lands version '+bbsVerLong+' terminated - errorlevel ' + st(errorlevel);
{$IFDEF DEBUG}writeln ('DEbug3'); {$ENDIF}

      while Pos(' ',s) > 0 do
      begin
         N := Pos(' ',s);
         Delete(S,N,1);
         Insert(#255'|12',s,N);
         Insert('|04',s,N+5);
      end;
      cFwrite(40-Length(noColor(s)) div 2,1,s);
      TextAttr := $07;
{      GotoXY(1,23);
      ClrEol;}
   {$I-}
   Close(strFile);
   {$I+}
   fNoLibrary;
{   nodeDone;}
   fKillDir(fTempPath('-'));
{$IFDEF DEBUG}writeln ('DEbug4'); {$ENDIF}

   cTerminate;
   killVariables;
{$IFDEF DEBUG}writeln ('DEbug5'); {$ENDIF}

   {$I-}
   ChDir(strBkSlash(False,StartDir));
   {$I+}
   halt(0);
end;

procedure initParameters;
var Quit, reset : Boolean;
begin
   asDoor := true;
   if ParamCount = 0 then Exit;
   Quit := true;
{$IFDEF LINUX}
   localio:=true;
   modemio:=false;
{$ENDIF}
   LocalIO := false;
   ModemIO := true;
   HangUp := False;
   HungUp := False;
   UserOn := False;
   reset := true;
   QuitAfter := true;
   asDoor := true;

   if Quit then killTerminateBBS(reset);
end;

function ModemFile : String;
var P : String; Ps : Byte;
begin
   P := fileModem;
   Ps := Pos('%',P);
   if Ps < 1 then Exit;
   Delete(P,Ps,1);
   Insert(St(Node),P,Ps);
   ModemFile := Cfg^.pathData+P;
end;

procedure initFiles;
var fUsers : file of tUserRec;
    S : String;
    fixStrs : Boolean;
begin
   initPaths;
   Assign(fUsers,Cfg^.pathData+fileUsers);
   {$I-} Reset(fUsers); {$I+}
   if ioResult <> 0 then
   begin
      userReset;
      userAdd(User^);
   end else
   begin
      {$I-} Read(fUsers,User^); {$I+}
      if ioResult <> 0 then
      begin
         Close(fUsers);
         userReset;
         Rewrite(fUsers);
         Write(fUsers,User^);
      end;
      numUsers := FileSize(fUsers);
      Close(fUsers);
   end;
   mWriteInit('analyzing user index');
   userCheckIndex;
   mWriteInit('initializing string cache');
   Assign(strFile,Cfg^.pathData+fileStrings);
   fixStrs := False;
   if not fopen(strFile,256,ffwait) then
   begin
      if fresult = 2 then
      begin
         if not fopen(strFile,256,ffnew+ffwait) then
         begin
            logWrite('xCould not access '+cfg^.pathData+fileStrings+', terminating');
            Halt(250);
         end else fixStrs := True;
      end else
      begin
         logWrite('xCould not access '+cfg^.pathData+fileStrings+', terminating');
         Halt(250);
      end;
   end else if fileSize(strFile) < numString then fixStrs := True;

   if fixStrs then
   begin
      Seek(strFile,0);
      while not eof(strFile) do
      begin
         BlockRead(strFile,s,1);
         if cleanUp(s) = '' then
         begin
            Seek(strFile,filePos(strFile)-1);
            s := resetString(filePos(strfile)+1);
            BlockWrite(strFile,s,1);
         end;
      end;
      while fileSize(strFile) < numString do
      begin
         s := resetString(filePos(strfile)+1);
         BlockWrite(strFile,s,1);
      end;
   end;
   mWriteInit ('opening data files :');
   {$IFNDEF LINUX}
   assign (file_room, 'rooms.dat');
   {$I-}
   reset (file_room);
   {$I+}
   if ioresult <> 0 then
   begin
     mWriteInit ('open of rooms.dat failed!');
     halt (254);
   end;
   {$I-}

   read (file_room, room^);
   {$I+}
   if ioresult <> 0 then
   begin
     mWriteInit ('can''t read from rooms.dat');
     halt (253);
   end;
   {$ELSE}
   file_room := fdopen ('rooms.dat', open_rdwr);
   if file_room < 0 then begin mWriteInit ('Can''t load rooms.dat!'); halt (254); end;

   {$ENDIF}

   {$IFNDEF LINUX}
   assign (file_user_1, 'users.dat');
   {$I-}
   reset (file_user_1);
   {$I+}
   if ioresult <> 0 then
   begin
     mWriteInit ('open of users.dat failed!');
     halt (254);
   end;
   {$I-}
   read (file_user_1, user^);
   {$I+}
   if ioresult <> 0 then
   begin
     mWriteInit ('can''t read from users.dat');
     halt (253);
   end;
   {$ELSE}
   file_user_1 := fdopen ('users.dat', open_rdonly);
   if file_user_1 < 0 then begin useradd(user^); end;

   {$ENDIF}

   {$IFNDEF LINUX}
   assign (file_user_2, 'user2.dat');
   {$I-}
   reset (file_user_2);
   {$I+}
   if ioresult <> 0 then
   begin
     mWriteInit ('open of user2.dat failed!');
     halt (254);
   end;
   {$I-}
   read (file_user_2, user2^);
   {$I+}
   if ioresult <> 0 then
   begin
     mWriteInit ('can''t read from user2.dat');
     halt (253);
   end;
   {$ELSE}
   file_user_2 := fdopen ('user2.dat', open_rdonly);
   if file_user_2 < 0 then begin mWriteInit ('Can''t load user2.dat!'); halt (254); end;

   {$ENDIF}

end;

procedure initCommPort;
begin
   if cfg2^.doortype=3 then exit;
   {$IFDEF LINUX}
   if modem^.comport='' then exit;
   {$ELSE}
   if modem^.comport=0 then exit;
   {$ENDIF}
   mWriteInit('initializing fossil');

   {if not (modem^.comport=0) then}
   if (not cInitialize) and (not modemOff) then
   begin
      {$IFDEF LINUX}
      logWrite('xError initializing device '+Modem^.ComPort);
      {$ELSE}
      logWrite('xError initializing comport (COM'+St(Modem^.ComPort)+')');
      {$ENDIF}
      ioClrScr;
      WriteLn;
      WriteLn(bbsTitle+' encountered an error while attempting to initialize the');
      WriteLn('communications port.  Please ensure that '+bbsTitle+'''s modem setup');
      WriteLn('for this node is configured properly');
      Halt(errFatal);
   end;

end;

end.
