unit General;

INTERFACE
uses CRT,Strings;
const RegBBSName = 'Area 59';      {Registered BBS Name}
      RegBBSSysop = 'Mr.Happy';    {Registered Sysop Name}
      Version = 'v.03a';
      MaxMessageSize = 50;

type
  filediz = array [1..10] of string[45];

  filerec=record
   sentby:string[30];
   filename:string[12];
   path:string[50];
   points:integer;
   filesize:longint;
   descrip:filediz;
   downloaded:integer;
   sendto:string[30];
   pass:string[10];
   newfile,specialfile:boolean;
  end;

  message = record
   text:array [1..maxmessagesize] of string[80];
   title:string[40];
   sendto:string[30];
   note:string[30];
   anon:boolean;
   numlines:integer;
  end;

  RUMOR = record
   Rumr : string[80];
  end;

   MESSAGES = record
    BaseName : string[40];
    NumMessages : integer;
    Path : string[80];
   end;

  FILES = record
   FileName : string[40];
   Path : string[80];
   AllowUploads,
   AllowDownloads : Boolean;
  end;

  CONFS = record
   ConfName : string[40];
   minlevel : byte;
   NumMessAreas : byte;
   NumFileAreas : byte;
   private_ : BOOLEAN;
   password : string[10];
   MessAreas : array [1..20] of MESSAGES;
   FileAreas : array [1..20] of FILES;
  end;

  BBSConfig = record               {The BBS Configuration Record}
   BBSName: string[50];
   SysopName: string[30];
   Nodenum: integer;
   rootdir: string[80];
   ansidir: string[80];
   ripdir: string[80];
   maindir: string[80];
   bbsphone: string[15];
   modemstr: string[30];
   matrixlogon: boolean;
   TotalUps,
   TotalDowns,
   TotalPosts,
   TotalEmail,
   Hackattempts,
   Chatrequests: integer;
   echodot: char;
   Yes: string[10];
   No: string[10];
   LastCaller: string[30];
   LastCallerUN: string[40];
   NumConfs: integer;
   SysopHere: boolean;
   port : byte;
   speed : longint;
   initstr : string;
  end;

  USERCARD = RECORD              { User Information Record}
   Handle: string[30];
   UserNote: string[40];
   RealName: string[40];
   Password: string[10];
   Address: string[80];
   City: string[40];
   State: string[2];
   Zip: string[12];
   DOB: string[8];
   IDverify: string[40];
   expertmode: boolean;
   mainlevel: integer;
   filelevel: integer;
   DataNum: string[20];
   VoiceNum: string[20];
   comptype: string[20];
   LastTimeOn: string[4];
   Lastdateon: string[6];
   ClearMsg,
   ScrollMsg,
   LongHeadr,
   FullScrEdit,
   Column79: boolean;
   backupml,
   backupfl,
   BytesDn,
   BytesUp,
   ByteRatio,
   totalposts,
   totalemail,
   filesup,
   filesdn,
   timeson,
   prompt,
   TimeAllowed: integer;
   asig : array[1..3] of string[80];
  end;

 screentype = array[1..4000] of byte;
 oneliner = record
   String1,
   String2,
   String3,
   String4,
   String5,
   String6,
   String7,
   String8,
   String9,
   String10 : String[80];
  end;

var BBSnfo : BBSConfig;
    Usernfo : USERCARD;
    Screen : Screentype absolute $B800:0000;
    TimeOn : integer;
    FileBatch : integer;
    Msg : message;
    result : word;
    LocalLogon : Boolean;
    done : boolean;
    input : string;
    Usernum : integer;
    PageBell : Boolean;
    curconf : Confs;
    area : byte;
    confnum : integer;
    f : filerec;

PROCEDURE LoadConfig;
PROCEDURE SaveConfig;
FUNCTION  Exist(filename : string) : boolean;
PROCEDURE WriteUser;

IMPLEMENTATION

 PROCEDURE WriteUser;
  var in_file : file of USERCARD;

  Begin
   Assign(in_file,'Users.dat');
   reset(in_file);
   seek(in_file,UserNum);
   write(in_file,Usernfo);
   close(in_file);
  End;

 FUNCTION Exist(filename : string) : BOOLEAN;
  var in_file : file;
      I : integer;
  Begin
   assign (in_file,filename);
   {$I-}
   reset (in_file);
   if IOResult = 0 then
    Exist := TRUE
   else
    Begin
     Writeln('('+filename+') was not found!');
     Exist := FALSE;
    End;
   close(in_file);
   i := IOresult;
   {$I+}
  End;


 PROCEDURE LoadConfig;
  var
   config : file;
   conf : file of confs;
  Begin
   if exist('config.dat') then
    Begin
     Assign(config,'config.dat');
     reset(config,sizeof(BBSnfo));
     BlockRead(config,BBSnfo,1);
     close(config);
    End
   else
    Halt;
   if exist('Confs.dat') then
    Begin
     Assign(conf,'Confs.dat');
     reset(conf);
     read(conf,curconf);
     close(conf);
     confnum := 1;
    End
   else
    Halt;
  End;

 PROCEDURE SaveConfig;
  var
   config : file;
  Begin
   Assign(config,'config.dat');
   rewrite(config,sizeof(BBSnfo));
   BlockWrite(config,BBSnfo,1);
   Close(config);
  End;


Begin
End.