/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.util;

/**
 * Exception designating an unsatisfied condition.
 * 
 * @author Christos KK Loverdos
 */
public class UnsatisfiedConditionException extends RuntimeException
{
    private static final long serialVersionUID = 2641855252689713622L;

    public UnsatisfiedConditionException()
    {
    }

    public UnsatisfiedConditionException(String message)
    {
        super(message);
    }

    public UnsatisfiedConditionException(Throwable cause)
    {
        super(cause);
    }

    public UnsatisfiedConditionException(String message, Throwable cause)
    {
        super(message, cause);
    }
}
