package org.ckkloverdos.type.java;

import java.util.Date;

/**
 * A static singleton registry having the default representatives for the Java primitive types.
 * 
 * @author Christos KK Loverdos
 *
 * @see org.ckkloverdos.type.java.JavaTypeRegistry
 */
public final class ObjectJavaTypes
{
    private static final JavaTypeRegistry r = new JavaTypeRegistry();

//    public static final JavaType INTEGER = r.register(Integer.class);
//    public static final JavaType INTEGER_ALIAS = r.register("INTEGER", Integer.class);
//    public static final JavaType INTEGER_ALIAS2 = r.register("INTEGER2", INTEGER);

    public static final JavaType BOOLEAN = r.register("BOOLEAN", Boolean.class);
    public static final JavaType BYTE = r.register("BYTE", Byte.class);
    public static final JavaType CHAR = r.register("CHAR", Character.class);
    public static final JavaType DOUBLE = r.register("DOUBLE", Double.class);
    public static final JavaType FLOAT = r.register("FLOAT", Float.class);
    public static final JavaType INTEGER = r.register("INTEGER", Integer.class);
    public static final JavaType LONG = r.register("LONG", Long.class);
    public static final JavaType SHORT = r.register("SHORT", Short.class);

    static
    {
        r.setRepresentative(boolean.class, BOOLEAN);
        r.setRepresentative(byte.class, BYTE);
        r.setRepresentative(char.class, CHAR);
        r.setRepresentative(double.class, DOUBLE);
        r.setRepresentative(float.class, FLOAT);
        r.setRepresentative(int.class, INTEGER);
        r.setRepresentative(long.class, LONG);
        r.setRepresentative(short.class, SHORT);
    }

    public static final JavaType STRING = r.register("STRING", String.class);
    public static final JavaType DATE = r.register("DATE", Date.class);

    private ObjectJavaTypes()
    {
    }

    public static JavaType register(Class c)
    {
        return r.register(c);
    }

    public static JavaType register(String aliasName, Class c)
    {
        return r.register(aliasName, c);
    }

    public static JavaType register(String aliasName, JavaType aliasType)
    {
        return r.register(aliasName, aliasType);
    }

    public static JavaType getByClass(Class c)
    {
        return r.getByClass(c);
    }

    public static JavaType getByName(String name)
    {
        return r.getByName(name);
    }

    public static JavaTypeRegistry getRegistry()
    {
        return r.copy();
    }

    public static void main(String[] args)
    {
        System.out.println(getRegistry().is(int.class, Integer.class));
        System.out.println(getRegistry().is(int.class, INTEGER));
        System.out.println(getRegistry().is(Integer.class, "INTEGER"));
    }
}