/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.tuple;

import java.util.List;

/**
 * A {@link org.ckkloverdos.tuple.ITuple} implementation backed by a {@link java.util.List}.
 * 
 * @author Christos KK Loverdos
 */
public class ListTuple extends TupleSkeleton
{
    private List list;

    /**
     * Constructs the tuple from the <code>list</code>.
     * @param list
     */
    public ListTuple(List list)
    {
        this.list = list;
    }

    /**
     * Returns the <code>n</code>th element of the tuple.
     * Indices start from zero.
     * @param n
     * @throws IndexOutOfBoundsException if the index <code>n</code>
     * is beyond the bounds of this tuple.
     * @throws NullPointerException if the underlying list is <code>null</code>.
     */
    public Object get(int n)
    {
        return list.get(n);
    }

    /**
     * Returns the size of this tuple.
     * If the underlying list is <code>null</code>, then it returns zero.
     */
    public int size()
    {
        if(null == list)
        {
            return 0;
        }
        return list.size();
    }

    /**
     * Returns <code>true</code> iff the <code>n</code>th element
     * of the tuple is <code>null</code>.
     * @param n
     * @throws IndexOutOfBoundsException if the index <code>n</code>
     * is beyond the bounds of this tuple.
     * @throws NullPointerException if the underlying list is <code>null</code>.
     */
    public boolean isNull(int n)
    {
        return null == list.get(n);
    }

    /**
     * Returns <code>true</code> iff this tuple contains no elements.
     * If the underlying list is <code>null</code>, then it returns <code>true</code>.
     */
    public boolean isEmpty()
    {
        if(null == list)
        {
            return true;
        }
        return list.isEmpty();
    }
}
