/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.tuple;

/**
 * A tuple of objects.
 * 
 * @author Christos KK Loverdos
 */
public interface ITuple
{
    /**
     * Returns the <code>n</code>th element of the tuple.
     * Indices start from zero.
     * @param n
     * @throws IndexOutOfBoundsException if the index <code>n</code>
     * is beyond the bounds of this tuple.
     */
    public Object get(int n);

    /**
     * Returns the size of this tuple.
     */
    public int size();

    /**
     * Returns <code>true</code> iff the <code>n</code>th element
     * of the tuple is <code>null</code>.
     * @param n
     * @throws IndexOutOfBoundsException if the index <code>n</code>
     * is beyond the bounds of this tuple.
     */
    public boolean isNull(int n);

    /**
     * Returns <code>true</code> iff this tuple contains no elements.
     */
    public boolean isEmpty();
}
