/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

/**
 * A resource abstraction, inspired as a generalization of the API
 * provided by {@link ClassLoader} to obtain resources.
 * 
 * @author Christos KK Loverdos
 */
public interface IResource
{
    /**
     * Returns the resource name.
     */
    public String getName();

    /**
     * Returns the resource URL.
     */
    public URL getURL();

    /**
     * Returns an input stream used to read the resource bytes.
     * @throws IOException
     */
    public InputStream getInputStream() throws IOException;

    /**
     * Returns <code>true</code> iff the resource exists.
     */
    public boolean exists();

    /**
     * Returns <code>true</code> iff the resource is actually a local file.
     */
    public boolean isFile();

    /**
     * Returns the resource file. If {@link #isFile()} returns <code>true</code>,
     * then the actual file is returned, otherwise <code>null</code>.
     */
    public File getFile();
}
