/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.reflect;

import java.lang.reflect.Field;

/**
 * A JavaBeans property reflective accessor, based on the defined class field.
 * 
 * @author Christos KK Loverdos
 */
public class FieldReflectiveAccessor implements IReflectiveAccessor
{
    private Field field;

    public FieldReflectiveAccessor(Field f)
    {
        field = f;
    }

    /**
     * Returns the value of the underlying field for the given <code>clientObject</code>.
     * @param clientObject
     */
    public Object get(Object clientObject)
    {
        try
        {
            return field.get(clientObject);
        }
        catch(IllegalAccessException e)
        {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o)
    {
        if(this == o)
        {
            return true;
        }
        if(o == null || getClass() != o.getClass())
        {
            return false;
        }

        FieldReflectiveAccessor that = (FieldReflectiveAccessor) o;

        if(!field.equals(that.field))
        {
            return false;
        }

        return true;
    }

    public int hashCode()
    {
        return field.hashCode();
    }

    public String toString()
    {
        return "FieldReflectiveAccessor(" + field.getName() + ")";
    }
}
