/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.filter;

import org.ckkloverdos.hint.BinaryHint;


/**
 * An implementation of {@link org.ckkloverdos.filter.IFilter} providing boolean OR
 * semantics between two other filters.
 * 
 * @author Christos KK Loverdos
 */
public class OrFilter implements IFilter
{
	private IFilter a, b;

    /**
     * Constructs an <code>AndFilter</code> that will combine filters <code>a</code>
     * and <code>b</code> with boolean OR.
     * @param a
     * @param b
     */
    public OrFilter(IFilter a, IFilter b)
	{
		this.a = a;
		this.b = b;
	}

    /**
     * Tests if <code>object</code> is accepted according to this filter semantics (boolean OR).
     *
     * If <code>hints</code> is an instance of {@link org.ckkloverdos.hint.BinaryHint}, then each one of the
     * binary hint's components is passed to the first and second filters respectively.
     * Otherwise, the same <code>hints</code> object is passed to both filters.
     *
     * @param object
     * @param hints
     */
    public boolean accept(Object object, Object hints)
	{
        if(hints instanceof BinaryHint)
        {
            BinaryHint bhint = (BinaryHint) hints;
            Object hintA = bhint.getHintA();
            Object hintB = bhint.getHintB();

            return a.accept(object, hintA) || b.accept(object, hintB);
        }
        return a.accept(object, hints) || b.accept(object, hints);	}

}
