/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.ckkloverdos.log.StdLog;
import org.ckkloverdos.string.IToStringAware;
import org.ckkloverdos.string.ToString;
import org.ckkloverdos.util.ClassUtil;
import org.ckkloverdos.util.Util;

public class CompositeClassLoader
extends ClassLoader
implements IToStringAware {
    private List loaders = new ArrayList();

    public CompositeClassLoader(ClassLoader parent) {
        super(parent);
    }

    public CompositeClassLoader() {
        this(ClassUtil.getContextClassLoader());
    }

    public CompositeClassLoader(List loaders) {
        this();
        this.loaders.addAll(loaders);
    }

    public CompositeClassLoader(ClassLoader[] loaders) {
        this();
        this.loaders.addAll(Arrays.asList(loaders));
    }

    public void add(ClassLoader l) {
        if (!this.loaders.contains(l)) {
            this.loaders.add(l);
        }
    }

    public void add(URL url) {
        this.add(new URL[]{url});
    }

    public void add(URL[] urls) {
        this.add(new URLClassLoader(urls));
    }

    public void add(URI[] uris) throws MalformedURLException {
        uris = (URI[])Util.safe(uris, URI.class);
        URL[] urls = new URL[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            urls[i] = uris[i].toURL();
        }
        this.add(urls);
    }

    public void add(URI uri) throws MalformedURLException {
        this.add(uri.toURL());
    }

    public void add(File f) {
        try {
            this.add(f.toURI().toURL());
        }
        catch (MalformedURLException e) {
            StdLog.error(e);
        }
    }

    public void addFile(String filename) {
        this.add(new File(filename));
    }

    public boolean remove(ClassLoader l) {
        return this.loaders.remove(l);
    }

    public ClassLoader[] getClassLoaders() {
        return this.loaders.toArray(new ClassLoader[this.loaders.size()]);
    }

    public void setAsContextClassLoader() {
        Thread.currentThread().setContextClassLoader(this);
    }

    protected Class findClass(String s) throws ClassNotFoundException {
        Iterator iLoaders = this.loaders.iterator();
        while (iLoaders.hasNext()) {
            ClassLoader cl = (ClassLoader)iLoaders.next();
            try {
                return cl.loadClass(s);
            }
            catch (ClassNotFoundException e) {
                StdLog.warn(e.getMessage());
            }
        }
        return this.findSystemClass(s);
    }

    public String toString() {
        ToString ts = new ToString(this);
        this.toStringAware(ts);
        return ts.toString();
    }

    public void toStringAware(ToString ts) {
        ToString ts2 = ts.save();
        ts.setUsingTypeNames(false).add(this.loaders).restore(ts2);
    }
}

