/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.string;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ckkloverdos.collection.IL;
import org.ckkloverdos.collection.IntArray;
import org.ckkloverdos.collection.L;
import org.ckkloverdos.java.JavaPlatform;
import org.ckkloverdos.log.StdLog;
import org.ckkloverdos.reflect.IReflectiveAccessor;
import org.ckkloverdos.reflect.ReflectUtil;
import org.ckkloverdos.string.IPrepareToStringAware;
import org.ckkloverdos.string.IToStringAware;
import org.ckkloverdos.string.IToStringAwareProvider;
import org.ckkloverdos.util.Assert;
import org.ckkloverdos.util.ClassUtil;
import org.ckkloverdos.util.Util;

public class ToString
implements Cloneable {
    private static final Map providers = new HashMap();
    private static final String[] defaultExludedProperties = new String[]{"class"};
    private Object theObject;
    private IdentityHashMap visited;
    private IdentityHashMap markedCircular;
    private boolean multiline;
    private StringBuffer sb;
    private IntArray addedItemsPerLevel;
    private int nestLevel;
    private boolean made;
    private String arrayStart = "[";
    private String arrayEnd = "]";
    private String mapStart = "{";
    private String mapEnd = "}";
    private String typeStart = "(";
    private String typeEnd = ")";
    private String indentationString = "  ";
    private int indentationMultiplier = 1;
    private boolean usingIndices = true;
    private String equalsString = "=";
    private String keyValueSeparator = "=";
    private String nullValue = "null";
    private String singleLineItemSeparator = ", ";
    private boolean endIndented = true;
    private boolean stringQuoted = true;
    private char stringQuote = (char)34;
    private boolean fullTypeNames = false;
    private boolean usingTypeNames = true;
    private String circularRefString = "REF";

    public ToString(Object theObject, boolean multiline, boolean fullTypeNames) {
        this.theObject = theObject;
        this.multiline = multiline;
        this.visited = new IdentityHashMap();
        this.markedCircular = new IdentityHashMap();
        this.sb = new StringBuffer();
        this.fullTypeNames = fullTypeNames;
        this.addedItemsPerLevel = new IntArray(3);
        this.addedItemsPerLevel.add(0);
        if (null != theObject) {
            this.addTypeStart(theObject.getClass());
            this.increaseNestLevel();
        }
    }

    public ToString(Object theObject, boolean multiline) {
        this(theObject, multiline, false);
    }

    public ToString(Object theObject) {
        this(theObject, false);
    }

    public ToString(boolean multiline) {
        this(null, multiline);
    }

    public ToString() {
        this(null, false);
    }

    public static void registerProvider(IToStringAwareProvider provider, Class c) {
        Assert.notNull(provider, "provider must not be null");
        Assert.notNull(c, "class must not be null");
        providers.put(c, provider);
    }

    private static IToStringAwareProvider getProvider(Class c) {
        IToStringAwareProvider provider = (IToStringAwareProvider)providers.get(c);
        if (null != provider) {
            return provider;
        }
        Iterator iter = providers.keySet().iterator();
        while (iter.hasNext()) {
            Class otherClass = (Class)iter.next();
            if (!otherClass.isAssignableFrom(c)) continue;
            return (IToStringAwareProvider)providers.get(otherClass);
        }
        return null;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public ToString save() {
        try {
            return (ToString)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public ToString restore(ToString ts) {
        this.theObject = ts.theObject;
        this.visited = ts.visited;
        this.markedCircular = ts.markedCircular;
        this.multiline = ts.multiline;
        this.sb = ts.sb;
        this.addedItemsPerLevel = ts.addedItemsPerLevel;
        this.nestLevel = ts.nestLevel;
        this.made = ts.made;
        this.arrayStart = ts.arrayStart;
        this.arrayEnd = ts.arrayEnd;
        this.mapStart = ts.mapStart;
        this.mapEnd = ts.mapEnd;
        this.typeStart = ts.typeStart;
        this.typeEnd = ts.typeEnd;
        this.indentationString = ts.indentationString;
        this.indentationMultiplier = ts.indentationMultiplier;
        this.usingIndices = ts.usingIndices;
        this.equalsString = ts.equalsString;
        this.keyValueSeparator = ts.keyValueSeparator;
        this.nullValue = ts.nullValue;
        this.singleLineItemSeparator = ts.singleLineItemSeparator;
        this.endIndented = ts.endIndented;
        this.stringQuoted = ts.stringQuoted;
        this.stringQuote = ts.stringQuote;
        this.fullTypeNames = ts.fullTypeNames;
        this.usingTypeNames = ts.usingTypeNames;
        this.circularRefString = ts.circularRefString;
        return this;
    }

    public String toString() {
        if (null != this.theObject && !this.made) {
            this.decreaseNestLevel();
            this.addTypeEnd();
            this.made = true;
        }
        return this.sb.toString();
    }

    public String getKeyValueSeparator() {
        return this.keyValueSeparator;
    }

    public ToString setKeyValueSeparator(String nameValueSeparator) {
        this.keyValueSeparator = nameValueSeparator;
        return this;
    }

    public String getTypeStart() {
        return this.typeStart;
    }

    public ToString setTypeStart(String typeStart) {
        this.typeStart = typeStart;
        return this;
    }

    public String getTypeEnd() {
        return this.typeEnd;
    }

    public ToString setTypeEnd(String typeEnd) {
        this.typeEnd = typeEnd;
        return this;
    }

    public String getMapEnd() {
        return this.mapEnd;
    }

    public ToString setMapEnd(String mapEnd) {
        this.mapEnd = mapEnd;
        return this;
    }

    public String getMapStart() {
        return this.mapStart;
    }

    public ToString setMapStart(String mapStart) {
        this.mapStart = mapStart;
        return this;
    }

    public boolean isUsingTypeNames() {
        return this.usingTypeNames;
    }

    public ToString setUsingTypeNames() {
        this.usingTypeNames = true;
        return this;
    }

    public ToString setUsingTypeNames(boolean usingTypeNames) {
        this.usingTypeNames = usingTypeNames;
        return this;
    }

    public String getCircularRefString() {
        return this.circularRefString;
    }

    public void setCircularRefString(String circularRefString) {
        this.circularRefString = circularRefString;
    }

    public boolean isFullTypeNames() {
        return this.fullTypeNames;
    }

    public ToString setFullTypeNames() {
        this.fullTypeNames = true;
        return this;
    }

    public ToString setFullTypeNames(boolean fullTypeNames) {
        this.fullTypeNames = fullTypeNames;
        return this;
    }

    public char getStringQuote() {
        return this.stringQuote;
    }

    public ToString setStringQuote(char stringQuote) {
        this.stringQuote = stringQuote;
        return this;
    }

    public boolean isStringQuoted() {
        return this.stringQuoted;
    }

    public ToString setStringQuoted() {
        this.stringQuoted = true;
        return this;
    }

    public ToString setStringQuoted(boolean stringQuoted) {
        this.stringQuoted = stringQuoted;
        return this;
    }

    public boolean isEndIndented() {
        return this.endIndented;
    }

    public ToString setEndIndented() {
        this.endIndented = true;
        return this;
    }

    public ToString setEndIndented(boolean arrayEndIndented) {
        this.endIndented = arrayEndIndented;
        return this;
    }

    public String getSingleLineItemSeparator() {
        return this.singleLineItemSeparator;
    }

    public ToString setSingleLineItemSeparator(String singleLineItemSeparator) {
        this.singleLineItemSeparator = singleLineItemSeparator;
        return this;
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public ToString setNullValue(String nullValue) {
        this.nullValue = nullValue;
        return this;
    }

    public boolean isUsingIndices() {
        return this.usingIndices;
    }

    public String getEqualsString() {
        return this.equalsString;
    }

    public ToString setEqualsString(String equalsString) {
        this.equalsString = equalsString;
        return this;
    }

    public ToString setUsingIndices(boolean useIndices) {
        this.usingIndices = useIndices;
        return this;
    }

    private int getAddedItemsForThisLevel() {
        return this.addedItemsPerLevel.get(this.nestLevel);
    }

    private void increaseNestLevel() {
        ++this.nestLevel;
        this.addedItemsPerLevel.push(0);
    }

    private void decreaseNestLevel() {
        --this.nestLevel;
        this.addedItemsPerLevel.pop();
    }

    private void postAddItem() {
        this.addedItemsPerLevel.increase(this.nestLevel);
    }

    private void newLine() {
        this.sb.append(JavaPlatform.LINE_SEPARATOR);
    }

    private void indent() {
        for (int l = 0; l < this.nestLevel; ++l) {
            for (int i = 0; i < this.indentationMultiplier; ++i) {
                this.sb.append(this.indentationString);
            }
        }
    }

    public String getIndentationString() {
        return this.indentationString;
    }

    public ToString setIndentationString(String indentationString) {
        this.indentationString = indentationString;
        return this;
    }

    public int getIndentationMultiplier() {
        return this.indentationMultiplier;
    }

    public ToString setIndentationMultiplier(int indentationMultiplier) {
        this.indentationMultiplier = indentationMultiplier;
        return this;
    }

    public String getArrayStart() {
        return this.arrayStart;
    }

    public void setArrayStart(String arrayStart) {
        this.arrayStart = arrayStart;
    }

    public String getArrayEnd() {
        return this.arrayEnd;
    }

    public void setArrayEnd(String arrayEnd) {
        this.arrayEnd = arrayEnd;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public ToString setSingleline() {
        this.multiline = false;
        return this;
    }

    public ToString setMultiline() {
        this.multiline = true;
        return this;
    }

    public ToString setMultiline(boolean multiline) {
        this.multiline = multiline;
        return this;
    }

    private void addItemSeparator() {
        if (this.multiline) {
            int howmanyAtThisLevel = this.getAddedItemsForThisLevel();
            if (this.nestLevel > 0 || howmanyAtThisLevel > 0) {
                this.newLine();
                this.indent();
            }
        } else {
            int howmanyAtThisLevel = this.getAddedItemsForThisLevel();
            if (howmanyAtThisLevel > 0) {
                this.sb.append(this.singleLineItemSeparator);
            }
        }
    }

    private void preAddItem() {
        this.addItemSeparator();
    }

    private String getTypeName(Class c) {
        return this.usingTypeNames ? (this.fullTypeNames ? c.getName() : ClassUtil.getShortClassName(c)) : "";
    }

    private void addComplexTypeStart(Class c, String startString) {
        this.sb.append(this.getTypeName(c));
        this.sb.append(startString);
    }

    private void addComplexTypeEnd(String endString) {
        if (this.endIndented && this.multiline) {
            this.addItemSeparator();
        }
        this.sb.append(endString);
    }

    private void addArrayStart(Class c) {
        this.addComplexTypeStart(c, this.arrayStart);
    }

    private void addArrayEnd() {
        this.addComplexTypeEnd(this.arrayEnd);
    }

    private void addMapStart(Class c) {
        this.addComplexTypeStart(c, this.mapStart);
    }

    private void addMapEnd() {
        this.addComplexTypeEnd(this.mapEnd);
    }

    private void addTypeStart(Class c) {
        this.addComplexTypeStart(c, this.typeStart);
    }

    private void addTypeEnd() {
        this.addComplexTypeEnd(this.typeEnd);
    }

    public ToString append(Object value) {
        this.sb.append(value);
        return this;
    }

    public ToString add(String name, Object value) {
        this.preAddItem();
        this.sb.append(name);
        this.sb.append(this.equalsString);
        this.addValue(value);
        this.postAddItem();
        return this;
    }

    public ToString addIfNotNull(String name, Object value) {
        return this.addIf(name, value, null != value);
    }

    public ToString addIf(String name, Object value, boolean condition) {
        if (condition) {
            this.add(name, value);
        }
        return this;
    }

    public ToString add(String name, Date value, DateFormat format) {
        return this.add(name, format.format(value));
    }

    public ToString add(String name, byte value) {
        this.preAddItem();
        this.sb.append(name);
        this.sb.append(this.equalsString);
        this.sb.append(value);
        this.postAddItem();
        return this;
    }

    public ToString add(String name, boolean value) {
        this.preAddItem();
        this.sb.append(name);
        this.sb.append(this.equalsString);
        this.sb.append(value);
        this.postAddItem();
        return this;
    }

    public ToString add(String name, char value) {
        this.preAddItem();
        this.sb.append(name);
        this.sb.append(this.equalsString);
        this.sb.append(value);
        this.postAddItem();
        return this;
    }

    public ToString add(String name, double value) {
        this.preAddItem();
        this.sb.append(name);
        this.sb.append(this.equalsString);
        this.sb.append(value);
        this.postAddItem();
        return this;
    }

    public ToString add(String name, float value) {
        this.preAddItem();
        this.sb.append(name);
        this.sb.append(this.equalsString);
        this.sb.append(value);
        this.postAddItem();
        return this;
    }

    public ToString add(String name, int value) {
        this.preAddItem();
        this.sb.append(name);
        this.sb.append(this.equalsString);
        this.sb.append(value);
        this.postAddItem();
        return this;
    }

    public ToString add(String name, long value) {
        this.preAddItem();
        this.sb.append(name);
        this.sb.append(this.equalsString);
        this.sb.append(value);
        this.postAddItem();
        return this;
    }

    public ToString add(String name, short value) {
        this.preAddItem();
        this.sb.append(name);
        this.sb.append(this.equalsString);
        this.sb.append(value);
        this.postAddItem();
        return this;
    }

    public ToString add(Object o) {
        this.preAddItem();
        this.addValue(o);
        this.postAddItem();
        return this;
    }

    public ToString addIfNotNull(Object o) {
        if (null != o) {
            this.add(o);
        }
        return this;
    }

    public ToString add(byte o) {
        this.preAddItem();
        this.sb.append(o);
        this.postAddItem();
        return this;
    }

    public ToString add(boolean o) {
        this.preAddItem();
        this.sb.append(o);
        this.postAddItem();
        return this;
    }

    public ToString add(char o) {
        this.preAddItem();
        this.sb.append(o);
        this.postAddItem();
        return this;
    }

    public ToString add(double o) {
        this.preAddItem();
        this.sb.append(o);
        this.postAddItem();
        return this;
    }

    public ToString add(float o) {
        this.preAddItem();
        this.sb.append(o);
        this.postAddItem();
        return this;
    }

    public ToString add(int o) {
        this.preAddItem();
        this.sb.append(o);
        this.postAddItem();
        return this;
    }

    public ToString add(long o) {
        this.preAddItem();
        this.sb.append(o);
        this.postAddItem();
        return this;
    }

    public ToString add(short o) {
        this.preAddItem();
        this.sb.append(o);
        this.postAddItem();
        return this;
    }

    private void addStringValue(String s) {
        if (this.stringQuoted) {
            this.sb.append(this.stringQuote);
        }
        this.sb.append(s);
        if (this.stringQuoted) {
            this.sb.append(this.stringQuote);
        }
    }

    private void addToStringAwareProviderValue(Object o, IToStringAwareProvider provider) {
        this.addTypeStart(o.getClass());
        this.increaseNestLevel();
        provider.toStringAware(o, this);
        this.decreaseNestLevel();
        this.addTypeEnd();
    }

    private void addToStringAwareValue(IToStringAware o) {
        ToString save = null;
        if (o instanceof IPrepareToStringAware) {
            save = this.save();
            ((IPrepareToStringAware)o).prepareToStringAware(this);
        }
        this.addTypeStart(o.getClass());
        this.increaseNestLevel();
        o.toStringAware(this);
        this.decreaseNestLevel();
        this.addTypeEnd();
        if (o instanceof IPrepareToStringAware) {
            this.restore(save);
        }
    }

    public ToString addNotNullReflectiveProperties(Object obj, String[] exclude) {
        return this.addReflectiveProperties(obj, exclude, false);
    }

    public ToString addReflectiveProperties(Object obj, String[] exclude) {
        return this.addReflectiveProperties(obj, exclude, true);
    }

    public ToString addReflectiveProperties(Object obj, String[] exclude, boolean includeNullValues) {
        if (null == obj) {
            return this;
        }
        exclude = Util.safe(exclude);
        IL _ex = new L(new HashSet(2 * exclude.length)).addAll(exclude).addAll(defaultExludedProperties);
        try {
            Class<?> c = obj.getClass();
            BeanInfo bi = Introspector.getBeanInfo(c);
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            for (int i = 0; i < pds.length; ++i) {
                IReflectiveAccessor acc;
                Object value;
                PropertyDescriptor pd = pds[i];
                String name = pd.getName();
                if (_ex.contains(name) || null == (value = (acc = ReflectUtil.getPropertyAccessor(c, name)).get(obj)) && !includeNullValues) continue;
                this.addKeyValueItem(name, value);
            }
        }
        catch (IntrospectionException e) {
            this.add("!!ERROR addReflectiveProperties !!", e.getMessage());
        }
        return this;
    }

    public ToString addReflectiveProperties(Object obj) {
        return this.addReflectiveProperties(obj, defaultExludedProperties, true);
    }

    public ToString addReflectiveProperties() {
        return this.addReflectiveProperties(this.theObject, defaultExludedProperties, true);
    }

    public ToString addNotNullReflectiveProperties(Object obj) {
        return this.addReflectiveProperties(obj, defaultExludedProperties, false);
    }

    public ToString addNotNullReflectiveProperties() {
        return this.addReflectiveProperties(this.theObject, defaultExludedProperties, false);
    }

    public ToString addValue(Object o) {
        if (null == o) {
            this.addNullValue();
        } else if (this.isVisited(o)) {
            this.addCircularValue(o);
        } else if (o instanceof String) {
            this.addStringValue((String)o);
        } else {
            this.setVisited(o);
            IToStringAwareProvider provider = ToString.getProvider(o.getClass());
            if (null != provider) {
                this.addToStringAwareProviderValue(o, provider);
            } else if (o.getClass().isArray()) {
                this.addArrayValue(o);
            } else if (o instanceof IToStringAware) {
                this.addToStringAwareValue((IToStringAware)o);
            } else if (o instanceof Collection) {
                this.addCollectionValue((Collection)o);
            } else if (o instanceof Map) {
                this.addMapValue((Map)o);
            } else {
                this.addObjectValue(o);
            }
            this.setUnvisited(o);
        }
        return this;
    }

    private void addKeyValueItem(Object key, Object value) {
        this.preAddItem();
        this.sb.append(key);
        this.sb.append(this.keyValueSeparator);
        this.addValue(value);
        this.postAddItem();
    }

    private void addIndexedItem(int index, Object item) {
        this.preAddItem();
        if (this.usingIndices) {
            this.sb.append(index);
            this.sb.append(this.equalsString);
        }
        this.addValue(item);
        this.postAddItem();
    }

    private void addObjectValue(Object o) {
        this.sb.append(String.valueOf(o));
    }

    private void addMapValue(Map o) {
        Class<?> c = o.getClass();
        this.addMapStart(c);
        this.increaseNestLevel();
        Iterator iter = o.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Object value = o.get(key);
            this.addKeyValueItem(key, value);
        }
        this.decreaseNestLevel();
        this.addMapEnd();
    }

    private void addCollectionValue(Collection o) {
        Class<?> c = o.getClass();
        this.addArrayStart(c);
        this.increaseNestLevel();
        Iterator iter = o.iterator();
        int i = 0;
        while (iter.hasNext()) {
            this.addIndexedItem(i, iter.next());
            ++i;
        }
        this.decreaseNestLevel();
        this.addArrayEnd();
    }

    private void addArrayValue(Object o) {
        Class<?> c = o.getClass();
        int length = Array.getLength(o);
        this.addArrayStart(c.getComponentType());
        this.increaseNestLevel();
        for (int i = 0; i < length; ++i) {
            this.addIndexedItem(i, Array.get(o, i));
        }
        this.decreaseNestLevel();
        this.addArrayEnd();
    }

    private int getVisitedPosition(Object o) {
        Integer i = (Integer)this.visited.get(o);
        return i;
    }

    private void setVisited(Object o) {
        if (null != o) {
            this.visited.put(o, new Integer(this.sb.length()));
        }
    }

    private void setUnvisited(Object o) {
        if (null != o) {
            this.visited.remove(o);
        }
    }

    private boolean isVisited(Object o) {
        return this.visited.containsKey(o);
    }

    private void addNullValue() {
        this.sb.append(this.getNullValue());
    }

    private void addCircularValue(Object o) {
        int marker;
        int position = this.getVisitedPosition(o);
        boolean markedAgain = this.markedCircular.containsKey(o);
        if (!markedAgain) {
            marker = this.markedCircular.size() + 1;
            this.markedCircular.put(o, new Integer(marker));
        } else {
            marker = (Integer)this.markedCircular.get(o);
        }
        String label = "<" + this.circularRefString + ":" + marker + ">";
        int labelLen = label.length();
        if (!markedAgain) {
            this.sb.insert(position, label);
            Iterator iter = this.visited.keySet().iterator();
            while (iter.hasNext()) {
                Object other = iter.next();
                Integer otherPosI = (Integer)this.visited.get(other);
                int otherPos = otherPosI;
                if (otherPos <= position) continue;
                this.visited.put(other, new Integer(otherPos + labelLen));
            }
        }
        this.sb.append("<@" + this.circularRefString + ":" + marker + ">");
    }

    private static Integer i(int n) {
        return new Integer(n);
    }

    public static void main(String[] args) throws IntrospectionException {
        ToString ts = new ToString();
        ts.add(new int[]{1, 2, 3, 4});
        ts.add(new int[]{100, 200, 300, 400});
        StdLog.log(ts);
        StdLog.log("");
        ToString ts2 = new ToString();
        ts2.add(new Integer[]{ToString.i(1), ToString.i(2), ToString.i(3), ToString.i(4)});
        ts2.add(new Integer[]{ToString.i(100), ToString.i(200), ToString.i(300), ToString.i(400)});
        StdLog.log(JavaPlatform.LINE_SEPARATOR + ts2);
        StdLog.log("");
        Object[] arr1 = new Object[]{ToString.i(1), ToString.i(2), ToString.i(3), null, ToString.i(4)};
        List list1 = new L("one", "two", arr1, "three").toList();
        Object[] arr2 = new Object[]{ToString.i(2001), new Object[]{ToString.i(3001), arr1}, ToString.i(4001), "Hello World!", list1};
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("__one", arr1);
        map1.put("__two", list1);
        map1.put("__three", map1);
        list1.add(arr2);
        arr1[3] = list1;
        ToString ts3 = new ToString().setMultiline(false).setFullTypeNames(false).setEndIndented(true).setUsingIndices(true);
        ts3.add(arr2).add("hello", new Object()).add("world", map1);
        StdLog.log(JavaPlatform.LINE_SEPARATOR + ts3);
        StdLog.log("*************************");
        ToString ts4 = ts3.save().add(arr2).add("hello", new Object()).add("world", map1);
        StdLog.log(JavaPlatform.LINE_SEPARATOR + ts4);
        ToString tmp = new ToString();
        ToString aaa = new ToString(tmp, true);
        aaa.addReflectiveProperties();
        StdLog.log("aaa = " + aaa);
    }
}

